/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.licensing;

import com.mapinfo.mapmarker.cgge.licensing.CGGELicenseException;
import com.mapinfo.mapmarker.cgge.licensing.ICGGELicense;
import com.mapinfo.mapmarker.licensing.MMLicenseException;
import com.mapinfo.mapmarker.licensing.MMLicensing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.scp.spi.License;
import com.mapinfo.scp.spi.LicenseDefinition;
import com.mapinfo.scp.spi.LicenseRequest;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;

public class CGGELicensefilter
implements ICGGELicense {
    private static final String STANDARD_REQUEST = "STANDARD_TIME_REQUEST";
    private MMLicensing m_licenser;
    private String m_featurePrefix;
    private String m_country;

    @Override
    public boolean init(String factoryConfig, String providerConfig, String country) throws CGGELicenseException {
        boolean initializationSuccessful = false;
        if (!this.validateArguments(factoryConfig, providerConfig)) {
            throw new AssertionError((Object)"The parametes should be in order like FactoryConfig and Provider Config");
        }
        this.initializeProvider(factoryConfig, providerConfig);
        this.m_featurePrefix = "mapmarker.data." + country;
        this.m_country = country;
        initializationSuccessful = true;
        this.checkBasicLicenseRequest();
        return initializationSuccessful;
    }

    @Override
    public boolean isEngineLicensed() throws CGGELicenseException {
        LicenseRequest request = this.buildRequest();
        boolean isengineLicsned = false;
        boolean bl = isengineLicsned = this.m_licenser.checkout(request) != null;
        if (!isengineLicsned) {
            throw new CGGELicenseException(5203);
        }
        return isengineLicsned;
    }

    private void checkBasicLicenseRequest() throws CGGELicenseException {
        LicenseRequest basicRequest = this.m_licenser.createLicenseRequest("mapmarker.data.emea.basic", "1.0");
        License basicLicense = null;
        try {
            basicLicense = this.m_licenser.checkout(basicRequest);
            if (basicLicense == null) {
                throw new CGGELicenseException(5200);
            }
        }
        finally {
            if (basicLicense != null) {
                this.m_licenser.checkin(basicLicense);
            }
        }
    }

    private void initializeProvider(String factoryConfig, String providerConfig) throws CGGELicenseException {
        ClassLoader cl = this.getClass().getClassLoader();
        URL factoryUrl = cl.getResource(factoryConfig);
        URL providerURL = cl.getResource(providerConfig);
        try {
            this.m_licenser = factoryUrl == null || providerURL == null ? new MMLicensing() : new MMLicensing(factoryUrl.toExternalForm(), providerURL.toExternalForm());
        }
        catch (MMLicenseException e) {
            throw new CGGELicenseException(e.getErrorCode());
        }
    }

    private boolean validateArguments(String factoryConfig, String providerConfig) {
        return !StringUtilities.isEmpty((String)factoryConfig) && factoryConfig.endsWith("Factory.config") && !StringUtilities.isEmpty((String)providerConfig) && providerConfig.endsWith("Provider.config");
    }

    private LicenseRequest buildRequest() {
        LicenseRequest request = this.m_licenser.createLicenseRequest(STANDARD_REQUEST, "1.0");
        return request;
    }

    @Override
    public String[] getLicenseInformation() {
        StringBuffer streetLic = new StringBuffer(this.m_country + " street: ");
        StringBuffer postalLic = new StringBuffer(this.m_country + " postal: ");
        StringBuffer geographicLic = new StringBuffer(this.m_country + " geographic: ");
        LicenseDefinition[] defs = this.m_licenser.getAvailableLicenseDefinitions();
        if (defs.length > 0) {
            Arrays.sort(defs, new LicenseComparator());
            LicenseDefinition lastDef = null;
            for (int i = 0; i < defs.length; ++i) {
                LicenseDefinition def = defs[i];
                if (lastDef != null && lastDef.getLicenseFeature().getName().equals(def.getLicenseFeature().getName())) continue;
                String featureName = def.getLicenseFeature().getName();
                if (featureName.startsWith(this.m_featurePrefix)) {
                    if (featureName.endsWith(".ap.street")) {
                        streetLic.append(featureName.substring(this.m_featurePrefix.length(), featureName.length()));
                        streetLic.append(", ");
                    } else if (featureName.endsWith(".street")) {
                        streetLic.append(featureName.substring(this.m_featurePrefix.length(), featureName.length()));
                        streetLic.append(", ");
                    } else if (featureName.endsWith(".postal")) {
                        postalLic.append(featureName.substring(this.m_featurePrefix.length(), featureName.length()));
                        postalLic.append(", ");
                    } else if (featureName.endsWith(".geographic")) {
                        geographicLic.append(featureName.substring(this.m_featurePrefix.length(), featureName.length()));
                        geographicLic.append(", ");
                    }
                }
                lastDef = def;
            }
            streetLic.setLength(streetLic.length() - 2);
            postalLic.setLength(postalLic.length() - 2);
            geographicLic.setLength(geographicLic.length() - 2);
        }
        return new String[]{streetLic.toString(), postalLic.toString(), geographicLic.toString()};
    }

    private class LicenseComparator
    implements Comparator<LicenseDefinition> {
        private LicenseComparator() {
        }

        @Override
        public int compare(LicenseDefinition def1, LicenseDefinition def2) {
            int result = def1.getLicenseFeature().getName().compareTo(def2.getLicenseFeature().getName());
            if (result == 0) {
                result = def1.getLicenseFeature().getVersion().compareTo(def2.getLicenseFeature().getVersion());
            }
            return result;
        }
    }
}

