/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.matcher;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.DatasetInfoComponent;
import com.mapinfo.mapmarker.cgge.DictionaryUsage;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.ICGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.CGGEInternalScoringAddressComparator;
import com.mapinfo.mapmarker.cgge.matcher.CGGEInternalScoringRangeComparator;
import com.mapinfo.mapmarker.cgge.matcher.ICGGEMatcher;
import com.mapinfo.mapmarker.cgge.matcher.MatchedWordStats;
import com.mapinfo.mapmarker.cgge.matcher.ScoringCandFields;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class CGGEMatcher
extends DatasetInfoComponent
implements ICGGEMatcher {
    private static final String FIELD_WEIGHT_KEY_SUFFIX = "_weight";
    private static final String KEY_STREET_FIELD_CUTOFF = "street_name_min_quality";
    private static final String KEY_AREA_NAME_FIELD_CUTOFF = "area_name_min_quality";
    private static final String KEY_RANGE_FIELD_CUTOFF = "range_name_min_quality";
    private static final String KEY_CLOSE_MATCH_CUTOFF = "close_match_cutoff";
    private static final String KEY_MATCHED_FIELDS_WEIGHT = "matched_fields_weight";
    private static final String KEY_MATCHED_WORDS_WEIGHT = "matched_words_weight";
    private static final String KEY_POSTADDRESS_WEIGHT = "postal_address_weight";
    private static final String KEY_STREETADDRESS_WEIGHT = "street_address_weight";
    private static final String KEY_RANGEADDRESS_WEIGHT = "range_address_weight";
    private static final String KEY_MAX_ADDRESS_OFFSET_ALLOWED = "max_address_offset_allowed";
    private static final String KEY_SINGLE_LINE_COMPARE_FIELDS = "single_line_compare_fields";
    private static final String KEY_POSTADDRESS_COMPARE_FIELDS = "post_address_compare_fields";
    private static final String KEY_OPTIONAL_MATCH_FIELDS = "optional_match_fields";
    private static final String KEY_COMPARE_FIELDS = "_compare_fields";
    private static final String KEY_ADJUST_SCORE_FOR_MISSING_WORDS = "adjustScoresForMissingWords";
    private static final String KEY_ADJUST_MATCH_FOR_CANDS_WITHOUT_SIGNIFICANT_SEARCH_WORD = "adjustMatchForCandsWithoutSignificantSearchWord";
    private static final String KEY_MM_DEFAULT_MODE_FIELDS = "mm_default_mode_fields";
    private String m_country;
    private String m_language;
    ICGGECandidateFilter m_filter;
    protected static final double MISSING_FIELD_PENALITY = 0.01;
    private Map<Integer, MatchingOptions> m_matchingOptionsMap_deprecated;
    private Map<DataSetInfo, MatchingOptions> m_matchingOptionsMap;

    protected ICGGECandidateFilter getFilter() {
        if (this.m_filter == null) {
            this.m_filter = CGGEHandler.getInstance(this.getDataSetInfo(), this.m_country, this.m_language).getCandidateFilter();
        }
        return this.m_filter;
    }

    private synchronized MatchingOptions loadMatchingOptions(GeocodeOptions options, int geocodeType, String language, IDictionaryMetaData metaData) throws CGGEInternalException {
        MatchingOptions matchingOptions = null;
        if (this.m_matchingOptionsMap_deprecated.containsKey(geocodeType)) {
            matchingOptions = this.m_matchingOptionsMap_deprecated.get(geocodeType);
        } else {
            String typeName = GeocodeOptions.getGeocodeTypeName(geocodeType);
            Properties prop = null;
            prop = this.getConfiguration(this.m_country, language == null ? this.m_language : language, "_MatcherSettings", typeName, null);
            if (prop != null) {
                matchingOptions = this.getOptions(prop, metaData);
            }
            this.m_matchingOptionsMap_deprecated.put(geocodeType, matchingOptions);
        }
        return matchingOptions;
    }

    @Override
    public MatchingOptions getMatchingOptions(GeocodeOptions options, int geocodeType, String language, IDictionaryMetaData metaData) throws CGGERuntimeException, CGGEInternalException {
        MatchingOptions matchingOptions = null;
        matchingOptions = this.m_matchingOptionsMap_deprecated.containsKey(geocodeType) ? this.m_matchingOptionsMap_deprecated.get(geocodeType) : this.loadMatchingOptions(options, geocodeType, language, metaData);
        if (matchingOptions != null) {
            matchingOptions = new MatchingOptions(matchingOptions);
            options.setStandardMatchModeSettings(matchingOptions.getStandardMatchModeFields());
            matchingOptions.setGeocodeOptions(options);
        }
        return matchingOptions;
    }

    protected MatchingOptions getMatchingOptionsForAddress(GeocodeOptions options, InternalScoringAddress scoringAddr, IDataManager dataManager) throws CGGEInternalException {
        int geoType = scoringAddr.getAddressType();
        IDictionaryMetaData metaData = dataManager.getMetaData(scoringAddr.getDataSetInfo());
        return this.getMatchingOptions(options, geoType, scoringAddr.getLanguage(), metaData);
    }

    @Override
    public InternalCandidateList scoreCandidates(ParsedAddress parsedAddress, InternalCandidateList candList, GeocodeOptions options, IDataManager dataManager) throws CGGEInternalException {
        List<InternalScoringAddress> list = candList == null ? null : candList.getCandidateList();
        ICGGEScorer scorer = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                InternalScoringAddress scoringAddr = list.get(i);
                scorer = this.getScorer(parsedAddress.getLanguage(), scorer);
                MatchingOptions matchingOptions = this.getMatchingOptionsForAddress(options, scoringAddr, dataManager);
                this.scoreCandidate(parsedAddress, scoringAddr, matchingOptions, scorer, dataManager);
            }
        }
        return candList;
    }

    protected ICGGEScorer getScorer(String language, ICGGEScorer currentScorer) {
        String currentLang;
        if (currentScorer != null && (currentLang = currentScorer.getLanguage()) != null && currentLang.equals(language)) {
            return currentScorer;
        }
        return CGGEHandler.getInstance(this.getDataSetInfo(), this.m_country, language).getScorer();
    }

    @Override
    public int matchAndOrderCandidates(ParsedAddress parsedAddress, InternalCandidateList candList, GeocodeOptions options, IDataManager dataManager) throws CGGERuntimeException, CGGEInternalException {
        List<InternalScoringAddress> internalList = candList == null ? null : candList.getCandidateList();
        int candCount = internalList == null ? 0 : internalList.size();
        int closeMatchCount = 0;
        LinkedList<InternalScoringAddress> sortedCands = new LinkedList<InternalScoringAddress>();
        if (candCount > 0) {
            CGGEInternalScoringAddressComparator c = new CGGEInternalScoringAddressComparator();
            Comparator<InternalScoringAddress> reverseComparator = MMUtils.getReverseComparator(c);
            for (int i = 0; i < candCount; ++i) {
                MatchingOptions matchOptions;
                InternalScoringAddress scoringAddr = internalList.get(i);
                if (this.calculateCloseMatch(scoringAddr, parsedAddress, options, matchOptions = this.getMatchingOptionsForAddress(options, scoringAddr, dataManager))) {
                    ++closeMatchCount;
                }
                int ndx = MMUtils.nextInsertPosition(sortedCands, scoringAddr, reverseComparator);
                sortedCands.add(ndx, scoringAddr);
            }
            internalList.clear();
            internalList.addAll(sortedCands);
            candList.setNumberOfCloseMatches(closeMatchCount);
        }
        return closeMatchCount;
    }

    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        double streetCuttoff;
        double postalCutoff;
        boolean closeMatch = false;
        closeMatch = scoringAddr.getCombinedScore() >= matchOptions.getCloseMatchCutoff();
        ICGGECandidateFilter filter = this.getFilter();
        if (closeMatch && this.hasNonZeroValue(postalCutoff = filter.getPostalAddressCutoff(scoringAddr.getAddressType())) && scoringAddr.getCombinedPostalScore() < postalCutoff) {
            closeMatch = false;
        }
        if (closeMatch && this.hasNonZeroValue(streetCuttoff = filter.getStreetAddressCutoff(scoringAddr.getAddressType())) && scoringAddr.getCombinedStreetScore() < streetCuttoff) {
            closeMatch = false;
        }
        if (closeMatch) {
            closeMatch = this.passMustMatchContraints(scoringAddr, matchOptions);
        }
        if (closeMatch && matchOptions.getAdjustMatchForCandsWithoutSignificantSearchWord()) {
            List<AddressWord> searchWords = scoringAddr.getSearchWords();
            int searchWordCount = searchWords == null ? 0 : searchWords.size();
            boolean checkFieldScore = true;
            for (int wordNdx = 0; wordNdx < searchWordCount; ++wordNdx) {
                AddressWord word = searchWords.get(wordNdx);
                if (!AddressWord.isSignificantWord(word)) continue;
                checkFieldScore = false;
                break;
            }
            if (checkFieldScore) {
                boolean passMinScore = false;
                for (int wordNdx = 0; wordNdx < searchWordCount; ++wordNdx) {
                    AddressWord word = searchWords.get(wordNdx);
                    FieldScore score = scoringAddr.getFieldScore(word.m_wordType);
                    if (score == null || !(score.m_value >= 0.91)) continue;
                    passMinScore = true;
                    break;
                }
                closeMatch = passMinScore;
            }
        }
        if (closeMatch && scoringAddr.getSearchWords() != null && !this.streetNotSearched(scoringAddr.getSearchWords()) && scoringAddr.getRangeCount() > 0 && !scoringAddr.getRangeAt(0).isCloseMatch()) {
            boolean bPointHouse;
            boolean bl = bPointHouse = scoringAddr.getRangeAt(0).getFrom() != null && scoringAddr.getRangeAt(0).getTo() == null;
            if (bPointHouse && !this.hasInputHouse(parsedAddr)) {
                closeMatch = false;
            }
        }
        scoringAddr.setCloseMatch(closeMatch);
        return closeMatch;
    }

    private boolean hasInputHouse(ParsedAddress pa) {
        AddressNumber addrNum = pa.getAddressNumber();
        List<AddressNumber> probAddrNumList = pa.getProbableAddressNumbers();
        if (addrNum != null) {
            return true;
        }
        if (probAddrNumList != null && !probAddrNumList.isEmpty()) {
            for (AddressNumber num : probAddrNumList) {
                if (num.toString().equals("")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean streetNotSearched(List<AddressWord> searchWords) {
        for (AddressWord word : searchWords) {
            if (word.m_wordType != FieldType.STREET_NAME_FIELD_TYPE) continue;
            return false;
        }
        return true;
    }

    boolean hasNonZeroValue(double value) {
        return value > 1.0E-6;
    }

    protected boolean isFieldMatch(FieldScore score) {
        return score != null && score.m_matched;
    }

    protected boolean passMustMatchContraints(InternalScoringAddress scoringAddr, MatchingOptions matchOptions) {
        GeocodeOptions options = matchOptions.getGeocodeOptions();
        if (options != null) {
            FieldScore an4Score;
            FieldScore an3Score;
            FieldScore an2Score;
            FieldScore an1Score;
            if (options.isMustMatchStreetName() && matchOptions.getFieldWeight(FieldType.STREET_NAME_FIELD_TYPE) > 0.0 && !this.isFieldMatch(scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE))) {
                return false;
            }
            FieldScore pcScore = scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
            if (options.isMustMatchPostCode() && matchOptions.getFieldWeight(FieldType.POST_CODE_FIELD_TYPE) > 0.0 && this.inputFieldPresent(pcScore) && !this.isFieldMatch(pcScore)) {
                return false;
            }
            if (options.isMustMatchAreaName1() && this.inputFieldPresent(an1Score = scoringAddr.getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE)) && matchOptions.getFieldWeight(FieldType.AREA_NAME_1_FIELD_TYPE) > 0.0 && !this.isFieldMatch(an1Score)) {
                return false;
            }
            if (options.isMustMatchAreaName2() && this.inputFieldPresent(an2Score = scoringAddr.getFieldScore(FieldType.AREA_NAME_2_FIELD_TYPE)) && matchOptions.getFieldWeight(FieldType.AREA_NAME_2_FIELD_TYPE) > 0.0 && !this.isFieldMatch(an2Score)) {
                return false;
            }
            if (options.isMustMatchAreaName3() && this.inputFieldPresent(an3Score = scoringAddr.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE)) && matchOptions.getFieldWeight(FieldType.AREA_NAME_3_FIELD_TYPE) > 0.0 && !this.isFieldMatch(an3Score)) {
                return false;
            }
            if (options.isMustMatchAreaName4() && this.inputFieldPresent(an4Score = scoringAddr.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE)) && matchOptions.getFieldWeight(FieldType.AREA_NAME_4_FIELD_TYPE) > 0.0 && !this.isFieldMatch(an4Score)) {
                return false;
            }
            if (options.isMustMatchAddressNumber()) {
                AddressNumberScore numScore;
                InternalScoringRange range;
                InternalScoringRange internalScoringRange = range = scoringAddr.getRangeCount() > 0 ? scoringAddr.getRangeAt(0) : null;
                if (range != null && (numScore = (AddressNumberScore)range.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) != null && numScore.m_inputFieldPresent && matchOptions.getFieldWeight(FieldType.ADDRESS_NUMBER_FIELD_TYPE) > 0.0 && (numScore == null || !numScore.isMatched())) {
                    return false;
                }
            }
        }
        return true;
    }

    protected void reAdjustScoreForInsignificantWordMatches(Map<FieldType, FieldScore> fieldScores) {
        if (fieldScores != null) {
            for (Map.Entry<FieldType, FieldScore> scoreEntry : fieldScores.entrySet()) {
                int unmatchedWords;
                int lastMatchedWord;
                boolean reCheck;
                FieldScore score;
                FieldType type = scoreEntry.getKey();
                if (type == FieldType.POST_CODE_FIELD_TYPE || type == FieldType.ADDRESS_NUMBER_FIELD_TYPE || (score = scoreEntry.getValue()) == null || !(score.m_value > 0.7)) continue;
                AddressWord[] inputWords = score.m_inputWords;
                int inputWordCount = inputWords.length;
                IntArray perfectInputWords = score.m_perfectInputWords;
                int candWordCount = score.m_candWords.length;
                int totalWeightOfInSignificantWords = 0;
                boolean matchedOnSignificantWord = false;
                for (int candWordNdx = 0; candWordNdx < candWordCount; ++candWordNdx) {
                    AddressWord candWord = score.m_candWords[candWordNdx];
                    if (!AddressWord.isSignificantWord(candWord)) {
                        totalWeightOfInSignificantWords = (byte)(totalWeightOfInSignificantWords + candWord.m_weight);
                        continue;
                    }
                    if (!score.isPerfectCandWordMatch(candWordNdx)) continue;
                    matchedOnSignificantWord = true;
                }
                boolean bl = reCheck = totalWeightOfInSignificantWords > 50;
                if (!reCheck) {
                    if (score.m_matchedInputWords == null) {
                        reCheck = true;
                    } else {
                        reCheck = true;
                        int perfectMatches = 0;
                        for (int inputWordNdx = 0; inputWordNdx < inputWordCount; ++inputWordNdx) {
                            if (score.isPerfectInputWordMatch(inputWordNdx)) {
                                ++perfectMatches;
                            }
                            if (perfectMatches > 2) {
                                reCheck = false;
                                break;
                            }
                            if (!score.m_matchedInputWords.contains(inputWordNdx) || !AddressWord.isSignificantWord(inputWords[inputWordNdx])) continue;
                            reCheck = false;
                            break;
                        }
                    }
                }
                if (reCheck && score.m_value >= 1.0 && score.perfectCandidateWordCount() > 2 && matchedOnSignificantWord) {
                    reCheck = false;
                }
                if (!reCheck) continue;
                IntArray matchedInputWords = score.m_matchedInputWords;
                int firstWordPos = 0;
                int lastWordPos = inputWordCount - 1;
                for (FieldScore otherScore : fieldScores.values()) {
                    IntArray matchedWordNdxs;
                    if (otherScore == score || otherScore.m_inputWords != inputWords || (matchedWordNdxs = otherScore.m_matchedInputWords) == null || matchedWordNdxs.size() <= 0) continue;
                    int min = matchedWordNdxs.min();
                    int max = matchedWordNdxs.max();
                    if (min <= lastWordPos && min > firstWordPos) {
                        lastWordPos = min - 1;
                    }
                    if (max > firstWordPos) continue;
                    firstWordPos = max + 1;
                }
                int firstMatchedWord = matchedInputWords.min();
                if (firstMatchedWord > 0) {
                    for (int wordNdx = firstMatchedWord - 1; wordNdx >= firstWordPos; --wordNdx) {
                        AddressWord word = inputWords[wordNdx];
                        short wordAttribs = word.getAttributes();
                        if (!CodedWord.isNumber(wordAttribs) && !MMUtils.containsDigits(word.getWordChars())) continue;
                        firstWordPos = wordNdx + 1;
                        break;
                    }
                }
                if ((lastMatchedWord = matchedInputWords.max()) < inputWordCount - 1) {
                    for (int wordNdx = lastMatchedWord + 1; wordNdx <= lastWordPos; ++wordNdx) {
                        AddressWord word = inputWords[wordNdx];
                        short wordAttribs = word.getAttributes();
                        if (!CodedWord.isNumber(wordAttribs) && !MMUtils.containsDigits(word.getWordChars())) continue;
                        lastWordPos = wordNdx - 1;
                        break;
                    }
                }
                if ((unmatchedWords = inputWordCount - perfectInputWords.size()) <= 0 && !(score.m_value >= 1.0)) continue;
                double penality = 1.0;
                for (int n = firstWordPos; n <= lastWordPos; ++n) {
                    if (perfectInputWords.contains(n)) continue;
                    boolean matched = matchedInputWords.contains(n);
                    AddressWord unmatchedWord = inputWords[n];
                    short wordAttribs = unmatchedWord.getAttributes();
                    if (CodedWord.isDelimiter(wordAttribs)) continue;
                    if (CodedWord.isCommonWord(wordAttribs)) {
                        penality -= matched ? 0.05 : 0.1;
                        continue;
                    }
                    if (CodedWord.isArticleWord(wordAttribs)) {
                        penality -= matched ? 0.025 : 0.5;
                        continue;
                    }
                    if (CodedWord.isNumber(wordAttribs) || CodedWord.isNumeric(wordAttribs) || CodedWord.isProbableRomanNumeral(wordAttribs)) {
                        penality -= matched ? 0.03 : 0.06;
                        continue;
                    }
                    if (CodedWord.isThoroughfareTypeWord(wordAttribs)) {
                        penality -= matched ? 0.05 : 0.01;
                        continue;
                    }
                    penality -= matched ? 0.1 : 0.15;
                }
                score.m_value *= penality;
            }
        }
    }

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        this.m_matchingOptionsMap = new HashMap<DataSetInfo, MatchingOptions>();
        this.m_matchingOptionsMap_deprecated = new HashMap<Integer, MatchingOptions>();
        return false;
    }

    MatchingOptions getOptions(Properties prop, IDictionaryMetaData metaData) {
        MatchingOptions matchOptions = new MatchingOptions();
        matchOptions.setStreetFieldCutoff(PropertiesUtil.getDoublePropetyValue(prop, KEY_STREET_FIELD_CUTOFF));
        matchOptions.setAreaFieldCutoff(PropertiesUtil.getDoublePropetyValue(prop, KEY_AREA_NAME_FIELD_CUTOFF));
        matchOptions.setRangeFieldCutoff(PropertiesUtil.getDoublePropetyValue(prop, KEY_RANGE_FIELD_CUTOFF));
        matchOptions.setCloseMatchCutoff(PropertiesUtil.getDoublePropetyValue(prop, KEY_CLOSE_MATCH_CUTOFF));
        matchOptions.setMatchedWordWeight(PropertiesUtil.getDoublePropetyValue(prop, KEY_MATCHED_WORDS_WEIGHT));
        matchOptions.setMatchedFieldWeight(PropertiesUtil.getDoublePropetyValue(prop, KEY_MATCHED_FIELDS_WEIGHT));
        matchOptions.setPostAddressWeight(PropertiesUtil.getDoublePropetyValue(prop, KEY_POSTADDRESS_WEIGHT));
        matchOptions.setStreetAddressWeight(PropertiesUtil.getDoublePropetyValue(prop, KEY_STREETADDRESS_WEIGHT));
        matchOptions.setRangeAddressWeight(PropertiesUtil.getDoublePropetyValue(prop, KEY_RANGEADDRESS_WEIGHT));
        matchOptions.setAdjustScoresForMissingWords(PropertiesUtil.getBooleanPropertyValue(prop, KEY_ADJUST_SCORE_FOR_MISSING_WORDS));
        matchOptions.setAdjustMatchForCandsWithoutSignificantSearchWord(PropertiesUtil.getBooleanPropertyValue(prop, KEY_ADJUST_MATCH_FOR_CANDS_WITHOUT_SIGNIFICANT_SEARCH_WORD, false));
        matchOptions.setMaxAddressNumberOffsetAllowed(PropertiesUtil.getIntegerPropertyValue(prop, KEY_MAX_ADDRESS_OFFSET_ALLOWED, 50));
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            this.processMatchOptionsKeyValue(matchOptions, (String)key, (String)entry.getValue(), metaData);
        }
        return matchOptions;
    }

    void processMatchOptionsKeyValue(MatchingOptions matchOptions, String key, String value, IDictionaryMetaData metaData) {
        String fk;
        FieldType type;
        if (key.equals(KEY_SINGLE_LINE_COMPARE_FIELDS)) {
            matchOptions.setSingleLineCompareFields(this.getFields(value, metaData));
        } else if (key.equals(KEY_POSTADDRESS_COMPARE_FIELDS)) {
            matchOptions.setPostAddressCompareFields(this.getFields(value, metaData));
        } else if (key.equals(KEY_MM_DEFAULT_MODE_FIELDS)) {
            matchOptions.setStandardMatchModeFields(this.getFields(value, metaData));
        } else if (key.equals(KEY_OPTIONAL_MATCH_FIELDS)) {
            matchOptions.setOptionalFieldList(this.getFields(value, metaData));
        } else if (key.endsWith(FIELD_WEIGHT_KEY_SUFFIX)) {
            String fieldName = key.substring(0, key.length() - FIELD_WEIGHT_KEY_SUFFIX.length());
            FieldType type2 = metaData.getFieldForName(fieldName);
            if (type2 != null) {
                matchOptions.addFieldWeight(type2, this.getDoubleValue(value));
            }
        } else if (key.endsWith(KEY_COMPARE_FIELDS) && key.length() > KEY_COMPARE_FIELDS.length() && (type = metaData.getFieldForName(fk = key.substring(0, key.length() - KEY_COMPARE_FIELDS.length()))) != null) {
            matchOptions.setCompareFieldsForField(type, this.getFields(value, metaData));
        }
    }

    double getDoubleValue(String str) {
        double d = 0.0;
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    protected FieldScore scoreAddressWords(AddressWord[] parserWords, InternalFieldValue fieldValue, FieldType type, FieldScore score, ICGGEScorer scorer) {
        FieldScore fieldScore = null;
        if (fieldValue != null) {
            fieldScore = scorer.scoreAddressWords(parserWords, (AddressWord[])fieldValue.getFieldValue(), type, score);
            if (fieldScore != null && fieldScore.m_value < 1.0 && fieldValue.hasAlternates()) {
                AddressWord[][] altValues = (AddressWord[][])fieldValue.getAlternateValues();
                int altCount = altValues.length;
                FieldScore altScore = new FieldScore();
                for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                    AddressWord[] altValue = altValues[altNdx];
                    scorer.scoreAddressWords(parserWords, altValue, type, altScore);
                    if (!(altScore.m_value > fieldScore.m_value)) continue;
                    fieldScore.copy(altScore);
                    fieldScore.m_matchedAltIndex = altNdx;
                    if (fieldScore.m_value >= 1.0) break;
                }
            }
            if (fieldScore != null) {
                fieldScore.m_matched = fieldScore.m_value > 0.999999;
            }
        }
        return fieldScore;
    }

    private static boolean inputWordsMatchedInOrder(FieldScore score) {
        int size;
        IntArray a = score.m_matchedInputWords;
        int n = size = a == null ? 0 : a.size();
        if (size > 0) {
            int lastMatch = a.get(0);
            int ndx = 1;
            while (ndx < size) {
                int match = a.get(ndx);
                if (match < lastMatch) {
                    return false;
                }
                if (lastMatch + 1 != match && lastMatch + 1 < score.m_inputWords.length) {
                    if (score.m_inputWords[lastMatch + 1].getSoundex() != 0) {
                        return false;
                    }
                    ++lastMatch;
                    continue;
                }
                lastMatch = match;
                ++ndx;
            }
            return true;
        }
        return false;
    }

    protected int unmatchedWordCount(FieldScore score) {
        int matchedSize;
        IntArray a = score.m_matchedInputWords;
        int n = matchedSize = a == null ? 0 : a.size();
        if (matchedSize > 0) {
            if (matchedSize < score.m_inputWords.length) {
                int min = score.m_matchedInputWords.min();
                int max = score.m_matchedInputWords.max();
                int wordsUsed = max - min + 1;
                if (matchedSize < wordsUsed) {
                    int weightedWords = 0;
                    for (int wordNdx = min + 1; wordNdx < max; ++wordNdx) {
                        AddressWord word = score.m_inputWords[wordNdx];
                        if (CodedWord.isDelimiter(word.getAttributes())) continue;
                        ++weightedWords;
                    }
                    return weightedWords - matchedSize;
                }
                return 0;
            }
            return 0;
        }
        return -1;
    }

    private void adjustScoresForMissingWords(FieldScore fieldScore) {
        if (fieldScore != null && fieldScore.m_perfectCandWords != null && fieldScore.m_perfectCandWords.size() > 0) {
            int candWordCount;
            int n = candWordCount = fieldScore.m_candWords == null ? 0 : fieldScore.m_candWords.length;
            if (fieldScore.m_matchedCandWords.size() < candWordCount && this.haveSignificantWords(fieldScore.m_candWords) && CGGEMatcher.inputWordsMatchedInOrder(fieldScore)) {
                double score = fieldScore.m_value;
                double missingScore = 1.0 - score;
                double w1 = 0.5;
                double w2 = 0.5;
                for (int wordNdx = 0; wordNdx < candWordCount; ++wordNdx) {
                    AddressWord word = fieldScore.m_candWords[wordNdx];
                    double weight = (double)word.m_weight * 0.01;
                    if (!this.hasNonZeroValue(word.m_weight)) continue;
                    if (fieldScore.m_perfectCandWords.contains(wordNdx)) {
                        score += missingScore * weight * w1;
                        if (!(w1 < 1.0)) continue;
                        w1 += 0.05;
                        continue;
                    }
                    if (fieldScore.m_matchedCandWords.contains(wordNdx)) {
                        score -= missingScore * weight * (w2 * 0.5);
                        continue;
                    }
                    score -= missingScore * weight * w2;
                    if (!(w2 > 0.0)) continue;
                    w2 -= 0.05;
                }
                fieldScore.m_value = score;
            }
        }
    }

    private boolean haveSignificantWords(AddressWord[] words) {
        int n = words == null ? 0 : words.length;
        for (int i = 0; i < n; ++i) {
            if (!AddressWord.isSignificantWord(words[i])) continue;
            return true;
        }
        return false;
    }

    protected void scorePostalFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        this.scoreFieldsAtLevel(pAddr, scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchingOptions, scorer);
    }

    protected void scoreStreetFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        this.scoreFieldsAtLevel(pAddr, scoringAddr, FieldType.FieldLevel.LEVEL_STREET, matchingOptions, scorer);
        FieldScore score = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        if (score != null && score.m_value > 0.0 && matchingOptions.getAdjustScoresForMissingWords()) {
            this.adjustScoresForMissingWords(score);
        }
    }

    private boolean containsCommonMatchedWordsNdxs(FieldScore score1, FieldScore score2) {
        if (score1.m_inputWords == score2.m_inputWords && score1.m_matchedInputWords != null && score1.m_matchedInputWords.size() > 0 && score2.m_matchedInputWords != null && score2.m_matchedInputWords.size() > 0) {
            int min1 = score1.m_matchedInputWords.min();
            int max1 = score1.m_matchedInputWords.max();
            int min2 = score2.m_matchedInputWords.min();
            int max2 = score2.m_matchedInputWords.max();
            if (min2 >= min1 ? min2 <= max1 : max2 >= min1 && (max2 <= max1 || min2 <= min1)) {
                return true;
            }
        }
        return false;
    }

    public boolean isFirstABetterScore(FieldScore score1, FieldScore score2, FieldType inputType, FieldType candType1, FieldType candType2) {
        boolean firstIsBetter = score1.m_value >= score2.m_value;
        int wordsmatched1 = score1.m_matchedInputWords.size();
        int wordsmatched2 = score2.m_matchedInputWords.size();
        if (!firstIsBetter && wordsmatched1 > wordsmatched2) {
            if (score2.m_value >= 1.0) {
                if (score1.m_value >= 0.9 && CGGEMatcher.inputWordsMatchedInOrder(score2)) {
                    firstIsBetter = true;
                }
            } else if (score1.m_value >= score2.m_value * 0.85) {
                firstIsBetter = true;
            }
        } else if (firstIsBetter && wordsmatched1 < wordsmatched2) {
            if (score1.m_value >= 1.0) {
                if (score2.m_value >= 0.9 && CGGEMatcher.inputWordsMatchedInOrder(score2)) {
                    firstIsBetter = false;
                }
            } else if (score2.m_value >= score1.m_value * 0.85) {
                firstIsBetter = false;
            }
        } else if (firstIsBetter && score1.m_value == score2.m_value && wordsmatched1 == wordsmatched2) {
            int unmatchedWords2;
            int unmatchedWords1 = this.unmatchedWordCount(score1);
            if (unmatchedWords1 > (unmatchedWords2 = this.unmatchedWordCount(score2))) {
                firstIsBetter = false;
            } else if (inputType == candType2) {
                firstIsBetter = false;
            } else if (inputType != candType1 && score2.m_fieldWeight > score1.m_fieldWeight) {
                firstIsBetter = false;
            }
        } else {
            int unmatchedWords2;
            int unmatchedWords1 = this.unmatchedWordCount(score1);
            if (unmatchedWords1 != (unmatchedWords2 = this.unmatchedWordCount(score2)) && Math.max(score1.m_value, score2.m_value) * 0.9 < Math.min(score1.m_value, score2.m_value)) {
                firstIsBetter = unmatchedWords1 < unmatchedWords2;
            }
        }
        return firstIsBetter;
    }

    public void scoreRanges(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        int rangeCount = scoringAddr.getRangeCount();
        if (rangeCount > 0) {
            CGGEInternalScoringRangeComparator compartor = new CGGEInternalScoringRangeComparator();
            Comparator<InternalScoringRange> reverseComparator = MMUtils.getReverseComparator(compartor);
            LinkedList<InternalScoringRange> sortedRanges = new LinkedList<InternalScoringRange>();
            for (int i = 0; i < rangeCount; ++i) {
                InternalScoringRange range = scoringAddr.getRangeAt(i);
                this.scoreRange(scoringAddr, range, parsedAddr, matchingOptions, scorer);
                this.calculateCombinedRangeScore(range, parsedAddr, matchingOptions);
                this.calculateRangeCloseMatch(range, parsedAddr, matchingOptions);
                int ndx = MMUtils.nextInsertPosition(sortedRanges, range, reverseComparator);
                sortedRanges.add(ndx, range);
            }
            scoringAddr.setRanges(sortedRanges.toArray(new InternalScoringRange[rangeCount]));
        }
    }

    public void calculateRangeCloseMatch(InternalScoringRange range, ParsedAddress parsedAddr, MatchingOptions matchingOptions) {
        FieldScore placeNameScore;
        AddressNumberScore addrNum = (AddressNumberScore)range.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        boolean closeMatch = false;
        if (addrNum != null && addrNum.isMatched()) {
            closeMatch = true;
        }
        if (!closeMatch && (placeNameScore = range.getFieldScore(FieldType.RANGE_PLACE_NAME_FIELD_TYPE)) != null && placeNameScore.m_matched) {
            closeMatch = true;
        }
        range.setCloseMatch(closeMatch);
    }

    private static void scoreAddressNumberForRange(AddressNumber inputNumber, InternalRangeAddress range, AddressNumberScore addrNumScore) {
        int num1 = inputNumber.getHnrNumber1();
        int num2 = inputNumber.getHnrNumber2();
        boolean acceptNum1 = CGGEMatcher.acceptRangeType(range, num1);
        boolean acceptNum2 = CGGEMatcher.acceptRangeType(range, num2);
        AddressNumber fromNumber = range.getFrom();
        AddressNumber toNumber = range.getTo();
        if (fromNumber != null && toNumber != null && fromNumber.getHnrNumber1() > 0 && toNumber.getHnrNumber1() > 0) {
            int from = fromNumber.getHnrNumber1();
            int to = toNumber.getHnrNumber1();
            boolean numFlipped = false;
            if (from > to) {
                int t = to;
                to = from;
                from = t;
                numFlipped = true;
            }
            if (num1 > 0 && acceptNum1) {
                if (num1 >= from && num1 <= to) {
                    addrNumScore.setNumber1Matched(true);
                }
                addrNumScore.setTypeMatch(true);
            }
            if (num2 > 0 && acceptNum2) {
                if (num2 >= from && num2 <= to) {
                    addrNumScore.setNumber2Matched(true);
                }
                addrNumScore.setTypeMatch(true);
            }
            if (!addrNumScore.isNumber1Matched() && !addrNumScore.isNumber2Matched()) {
                int offset1 = -1;
                int offset2 = -1;
                boolean acceptSide = true;
                if (num1 > 0 && num2 > 0) {
                    int off2;
                    int off1 = Math.abs(num1 - from);
                    if (off1 <= (off2 = Math.abs(num2 - from))) {
                        offset1 = off1;
                        acceptSide = acceptNum1;
                    } else {
                        offset1 = off2;
                        acceptSide = acceptNum2;
                    }
                    off1 = Math.abs(num1 - to);
                    off2 = Math.abs(num2 - to);
                    if (off1 <= off2) {
                        offset2 = off1;
                        acceptSide = acceptNum1;
                    } else {
                        offset2 = off2;
                        acceptSide = acceptNum2;
                    }
                } else if (num1 > 0) {
                    offset1 = Math.abs(num1 - from);
                    offset2 = Math.abs(num1 - to);
                    acceptSide = acceptNum1;
                } else if (num2 > 0) {
                    offset1 = Math.abs(num2 - from);
                    offset2 = Math.abs(num2 - to);
                    acceptSide = acceptNum2;
                }
                if (offset1 > -1 && offset1 <= offset2) {
                    addrNumScore.setTypeMatch(acceptSide);
                    addrNumScore.setOffset(offset1);
                    addrNumScore.setOffsetPosition(numFlipped ? 2 : 1);
                } else if (offset2 > -1) {
                    addrNumScore.setTypeMatch(acceptSide);
                    addrNumScore.setOffset(offset2);
                    addrNumScore.setOffsetPosition(numFlipped ? 1 : 2);
                }
            }
        }
    }

    private static boolean acceptRangeType(InternalRangeAddress range, int number) {
        int rangeType = range.getOddEvenType();
        int numType = CGGEMatcher.getNumberType(number);
        switch (rangeType) {
            case 4: {
                return true;
            }
            case 2: {
                return numType == 2;
            }
            case 3: {
                return numType == 3;
            }
            case 5: {
                AddressNumber num1 = range.getFrom();
                AddressNumber num2 = range.getTo();
                if (num1 == null || num1.getHnrNumber1() <= 0 || num2 == null || num2.getHnrNumber1() <= 0) break;
                rangeType = CGGEMatcher.getNumberType(num1.getHnrNumber1());
                if (rangeType != CGGEMatcher.getNumberType(num2.getHnrNumber1())) {
                    return true;
                }
                return numType == rangeType;
            }
        }
        return false;
    }

    private static int getNumberType(int number) {
        return number % 2 == 0 ? 2 : 3;
    }

    protected static boolean acceptScore(FieldScore score, FieldType type, MatchingOptions options) {
        FieldType.FieldLevel level = type.getLevel();
        if (level == FieldType.FieldLevel.LEVEL_POSTAL) {
            return score.m_value >= options.getAreaFieldCutoff();
        }
        if (level == FieldType.FieldLevel.LEVEL_STREET) {
            return score.m_value >= options.getStreetFieldCutoff();
        }
        if (level == FieldType.FieldLevel.LEVEL_STREET) {
            return score.m_value >= options.getRangeFieldCutoff();
        }
        return true;
    }

    protected boolean inputFieldPresent(FieldScore score) {
        return score != null && (score.m_inputFieldPresent || this.hasNonZeroValue(score.m_value));
    }

    protected boolean hasSeparateStreetInput(ParsedAddress addr, FieldType type) {
        AddressWord[] fv = (AddressWord[])addr.getField(type);
        return fv != null && fv != addr.getField(FieldType.STREET_NAME_FIELD_TYPE);
    }

    protected boolean hasSeparateRangeInput(ParsedAddress addr, FieldType type) {
        AddressWord[] fv = (AddressWord[])addr.getField(type);
        return fv != null && fv != addr.getField(FieldType.STREET_NAME_FIELD_TYPE);
    }

    protected boolean hasSeperateAreaFields(ParsedAddress addr) {
        return addr.isSeperatePostAddressFields() && (addr.getField(FieldType.AREA_NAME_1_FIELD_TYPE) != null || addr.getField(FieldType.AREA_NAME_2_FIELD_TYPE) != null || addr.getField(FieldType.AREA_NAME_3_FIELD_TYPE) != null || addr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null);
    }

    protected int weightedFieldWeightsAtLevel(ScoringItem scoringItem, FieldType.FieldLevel level, MatchingOptions matchOptions) {
        int n = 0;
        Map fields = scoringItem.getFields();
        if (fields != null) {
            for (Map.Entry en : fields.entrySet()) {
                InternalFieldValue fv;
                FieldType type = en.getKey();
                if (type.getLevel() != level || (fv = (InternalFieldValue)en.getValue()) == null || !this.hasNonZeroValue(matchOptions.getFieldWeight(type))) continue;
                ++n;
            }
        }
        return n;
    }

    protected double combineFieldWeightsAtLevel(ScoringItem scoringItem, FieldType.FieldLevel level, MatchingOptions matchOptions) {
        double totalWeight = 0.0;
        Map fields = scoringItem.getFields();
        if (fields != null) {
            for (Map.Entry en : fields.entrySet()) {
                InternalFieldValue fv;
                FieldType type = en.getKey();
                if (type.getLevel() != level || matchOptions.isOptionalField(type) || (fv = (InternalFieldValue)en.getValue()) == null) continue;
                totalWeight += matchOptions.getFieldWeight(type);
            }
        }
        return totalWeight;
    }

    protected void calculateCombinedPostAddressScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchOptions) {
        double scorePossible = 0.0;
        double postScore = 0.0;
        int inputFieldsAvailable = 0;
        int inputFieldsMatched = 0;
        int candFieldsAvailable = this.weightedFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchOptions);
        int candFieldsScored = 0;
        double totalScoredFieldWeight = 0.0;
        int parsedFieldCount = parsedAddr.getFields() == null ? 0 : parsedAddr.getFields().size();
        ArrayList<AddressWord[]> matchedInputWords = new ArrayList<AddressWord[]>(parsedFieldCount);
        boolean hasSeperatePostalFields = this.hasSeperateAreaFields(parsedAddr);
        double missingFieldsWeight = 0.0;
        Map<FieldType, FieldScore> fieldScores = scoringAddr.getFieldScores();
        if (fieldScores != null && fieldScores.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldScores.entrySet()) {
                FieldType type = entry.getKey();
                FieldScore fieldScore = entry.getValue();
                if (type == FieldType.POST_ADDRESS_FIELD_TYPE) {
                    if (matchedInputWords.contains(fieldScore.m_inputWords)) continue;
                    matchedInputWords.add(fieldScore.m_inputWords);
                    ++inputFieldsAvailable;
                    continue;
                }
                if (fieldScore == null || type.getLevel() != FieldType.FieldLevel.LEVEL_POSTAL) continue;
                ++candFieldsScored;
                double fieldWeight = matchOptions.getFieldWeight(type);
                if (!(fieldWeight > 0.0)) continue;
                boolean acceptScore = CGGEMatcher.acceptScore(fieldScore, type, matchOptions);
                if (acceptScore || this.inputFieldPresent(fieldScore)) {
                    totalScoredFieldWeight += fieldWeight;
                    if (acceptScore) {
                        scorePossible += fieldWeight;
                        postScore += fieldScore.m_value * fieldWeight;
                    } else if (!matchOptions.isOptionalField(type)) {
                        missingFieldsWeight += fieldWeight;
                    }
                    if (hasSeperatePostalFields) {
                        ++inputFieldsAvailable;
                        if (fieldScore.m_matched && this.areNonPerfectWordsIgnorable(fieldScore)) {
                            ++inputFieldsMatched;
                        }
                    }
                }
                if (fieldScore.m_inputWords == null || matchedInputWords.contains(fieldScore.m_inputWords)) continue;
                matchedInputWords.add(fieldScore.m_inputWords);
            }
        }
        MatchedWordStats matchWordStats = this.getMatchedWordStats(matchedInputWords, scoringAddr);
        int inputWordCount = matchWordStats.getTotalWords();
        int matchedWordCount = matchWordStats.getMatchedWordCount();
        if (missingFieldsWeight > 0.0) {
            scorePossible = !hasSeperatePostalFields && matchedWordCount < inputWordCount && !this.areNonMatchedWordsIgnorable(matchedInputWords, scoringAddr) ? (scorePossible += missingFieldsWeight * 0.25) : (scorePossible += missingFieldsWeight * 0.1);
        } else if (candFieldsAvailable > candFieldsScored && !hasSeperatePostalFields) {
            double missingWeight = this.combineFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchOptions);
            if ((missingWeight -= totalScoredFieldWeight) > 0.0) {
                scorePossible *= 1.0 + missingWeight * 0.2;
            }
        }
        if (inputFieldsAvailable > 0 && inputFieldsMatched < inputFieldsAvailable) {
            double maxWeight = Math.min(matchOptions.getMatchedFieldWeight() * (double)inputFieldsAvailable, 0.15);
            scorePossible += maxWeight;
            postScore += (double)inputFieldsMatched / (double)inputFieldsAvailable * maxWeight;
        }
        if (inputWordCount > 0 && matchedWordCount < inputWordCount) {
            double maxWeight = Math.min(matchOptions.getMatchedWordWeight() * (double)inputWordCount, 0.1);
            scorePossible += maxWeight;
            postScore += (double)matchedWordCount / (double)inputWordCount * maxWeight;
        }
        if (candFieldsScored == 0) {
            double missingWeight = this.combineFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchOptions);
            if (!this.hasNonZeroValue(missingWeight)) {
                scoringAddr.setCombinedPostalScore(1.0);
            }
        } else if (scorePossible > 0.0) {
            scoringAddr.setCombinedPostalScore(postScore / scorePossible);
        } else {
            scoringAddr.setCombinedPostalScore(0.0);
        }
    }

    MatchedWordStats getMatchedWordStats(List<AddressWord[]> inputWordList, InternalScoringAddress addr) {
        MatchedWordStats matchedWordStats = new MatchedWordStats();
        matchedWordStats.process(inputWordList, addr);
        return matchedWordStats;
    }

    protected int[] getInputWordMatchStats(List<AddressWord[]> inputWordList, InternalScoringAddress addr) {
        MatchedWordStats mws = this.getMatchedWordStats(inputWordList, addr);
        int[] wordstats = new int[]{mws.getTotalWords(), mws.getMatchedWordCount(), mws.getMatchedSignificantWordCount(), mws.getUnMatchedNormalWordCount(), mws.getUnMatchedArticleOrNumericWordCount(), mws.getPartialMatchNonArticleOrNumericWordCount(), mws.getPartialMatchNormalWordCount(), mws.getUnmatchedSignificantWordCount(), mws.getWeightedCandidateWordCount(), mws.getPartialMatchCandidateWordCount()};
        return wordstats;
    }

    public double calculateCombinedAddressScore(InternalScoringAddress scoringAddr, MatchingOptions matchOptions) {
        double scorePossible = matchOptions.getPostAddressWeight();
        scorePossible += matchOptions.getStreetAddressWeight();
        scorePossible += matchOptions.getRangeAddressWeight();
        double score = scoringAddr.getCombinedPostalScore() * matchOptions.getPostAddressWeight();
        score += scoringAddr.getCombinedStreetScore() * matchOptions.getStreetAddressWeight();
        if (scoringAddr.getRangeCount() > 0) {
            score += scoringAddr.getRangeAt(0).getCombinedScore() * matchOptions.getRangeAddressWeight();
        }
        if (scorePossible > 0.0) {
            score /= scorePossible;
        }
        scoringAddr.setCombinedScore(score);
        return score;
    }

    protected void calculateCombinedStreetScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddress, MatchingOptions options) {
        MatchedWordStats matchWordStats;
        double scorePossible = 0.0;
        double streetScore = 0.0;
        int fieldsAvailable = 0;
        int fieldsMatched = 0;
        int candFieldsScored = 0;
        int parsedFieldCount = parsedAddress.getFields() == null ? 0 : parsedAddress.getFields().size();
        ArrayList<AddressWord[]> matchedInputWords = new ArrayList<AddressWord[]>(parsedFieldCount);
        Map<FieldType, FieldScore> fieldMap = scoringAddr.getFieldScores();
        if (fieldMap != null && fieldMap.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldMap.entrySet()) {
                FieldType type = entry.getKey();
                FieldScore fieldScore = entry.getValue();
                if (fieldScore == null || type.getLevel() != FieldType.FieldLevel.LEVEL_STREET) continue;
                ++candFieldsScored;
                double fieldWeight = options.getFieldWeight(type);
                if (!(fieldWeight > 0.0)) continue;
                boolean acceptScore = CGGEMatcher.acceptScore(fieldScore, type, options);
                boolean separateFieldinput = this.hasSeparateStreetInput(parsedAddress, type);
                if (!separateFieldinput && !acceptScore && !this.inputFieldPresent(fieldScore)) continue;
                scorePossible += fieldWeight;
                if (acceptScore) {
                    streetScore += fieldScore.m_value * fieldWeight;
                }
                ++fieldsAvailable;
                if (fieldScore.m_matched) {
                    ++fieldsMatched;
                }
                if (fieldScore.m_inputWords == null || matchedInputWords.contains(fieldScore.m_inputWords)) continue;
                matchedInputWords.add(fieldScore.m_inputWords);
            }
        }
        boolean fieldsMatchedOnSignificantWords = (matchWordStats = this.getMatchedWordStats(matchedInputWords, scoringAddr)).getMatchedSignificantWordCount() > 0 || matchWordStats.getUnMatchedNormalWordCount() == 0;
        int inputWordCount = matchWordStats.getTotalWords();
        int matchedWordCount = matchWordStats.getMatchedWordCount();
        if (!(fieldsAvailable <= 0 || fieldsMatched >= fieldsAvailable && fieldsMatchedOnSignificantWords)) {
            double maxWeight = Math.min(options.getMatchedFieldWeight() * (double)fieldsAvailable, 0.15);
            scorePossible += maxWeight;
            double s = (double)fieldsMatched / (double)fieldsAvailable * maxWeight;
            streetScore += fieldsMatchedOnSignificantWords ? s : s * 0.5;
        }
        if (inputWordCount > 0 && matchedWordCount < inputWordCount) {
            double matchWordWeight = options.getMatchedWordWeight();
            double maxWeight = Math.min(matchWordWeight * (double)inputWordCount, 0.1);
            scorePossible += maxWeight;
            if (fieldsMatchedOnSignificantWords) {
                double w = (double)matchWordStats.getUnMatchedNormalWordCount() * matchWordWeight;
                w += (double)matchWordStats.getUnMatchedArticleOrNumericWordCount() * (matchWordWeight / 2.0);
                w -= (double)matchWordStats.getPartialMatchNonArticleOrNumericWordCount() * (matchWordWeight / 2.0);
                if ((w = maxWeight - w) > 0.0) {
                    streetScore += w;
                }
            } else if (matchWordStats.getPartialMatchNormalWordCount() > 1) {
                double w = (double)matchWordStats.getPartialMatchNormalWordCount() * (matchWordWeight / 2.0);
                if (w > maxWeight) {
                    w = maxWeight;
                }
                streetScore += w;
            } else if (matchWordStats.getUnmatchedSignificantWordCount() == 0) {
                double w = (double)matchWordStats.getMatchedWordCount() * (matchWordWeight / 2.0);
                if (w > maxWeight) {
                    w = maxWeight;
                }
                streetScore += w;
            }
        }
        if (candFieldsScored == 0) {
            double missingWeight = this.combineFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_STREET, options);
            if (!this.hasNonZeroValue(missingWeight)) {
                scoringAddr.setCombinedStreetScore(1.0);
            }
        } else if (scorePossible > 0.0) {
            scoringAddr.setCombinedStreetScore(streetScore / scorePossible);
        } else {
            scoringAddr.setCombinedStreetScore(0.0);
        }
    }

    protected boolean areNonPerfectWordsIgnorable(FieldScore score) {
        if (score != null && score.perfectInputWordCount() > 0) {
            AddressWord[] words = score.m_inputWords;
            int wc = words == null ? 0 : words.length;
            for (int wordNdx = 0; wordNdx < wc; ++wordNdx) {
                AddressWord word;
                if (score.isPerfectInputWordMatch(wordNdx) || !AddressWord.isSignificantWord(word = words[wordNdx])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean areNonMatchedWordsIgnorable(List<AddressWord[]> inputList, InternalScoringAddress addr) {
        int inputListCount = inputList == null ? 0 : inputList.size();
        ArrayList<FieldScore> fieldScoreList = new ArrayList<FieldScore>(addr.getFieldScoreList());
        if (addr.getRangeCount() > 0) {
            Collection<FieldScore> unitFieldScores;
            InternalScoringRange range = addr.getRangeAt(0);
            Collection<FieldScore> rangeFieldScores = range.getFieldScoreList();
            if (rangeFieldScores != null) {
                fieldScoreList.addAll(rangeFieldScores);
            }
            if (range.getUnitCount() > 0 && (unitFieldScores = range.getUnitAt(0).getFieldScoreList()) != null) {
                fieldScoreList.addAll(unitFieldScores);
            }
        }
        IntArray matchedNdxs = new IntArray(10);
        int scoreCount = fieldScoreList == null ? 0 : fieldScoreList.size();
        for (int inputNdx = 0; inputNdx < inputListCount; ++inputNdx) {
            AddressWord[] inputWords = inputList.get(inputNdx);
            matchedNdxs.removeAll();
            for (int scoreNdx = 0; scoreNdx < scoreCount; ++scoreNdx) {
                FieldScore score = (FieldScore)fieldScoreList.get(scoreNdx);
                if (score.m_inputWords != inputWords || score.m_matchedInputWords == null) continue;
                matchedNdxs.add(score.m_matchedInputWords);
            }
            matchedNdxs.removeDuplicates();
            if (inputWords == null) continue;
            int c = inputWords.length;
            for (int wordNdx = 0; wordNdx < c; ++wordNdx) {
                AddressWord inputWord;
                if (matchedNdxs.contains(wordNdx) || !AddressWord.isSignificantWord(inputWord = inputWords[wordNdx])) continue;
                return false;
            }
        }
        return true;
    }

    public int totalWeightedWords(List<AddressWord[]> wordList) {
        int n = 0;
        int listSize = wordList == null ? 0 : wordList.size();
        for (int i = 0; i < listSize; ++i) {
            AddressWord[] words = wordList.get(i);
            n += CGGEMatcher.totalWeightedWords(words);
        }
        return n;
    }

    private static int totalWeightedWords(AddressWord[] words) {
        int n = 0;
        int l = words == null ? 0 : words.length;
        for (int wordNdx = 0; wordNdx < l; ++wordNdx) {
            AddressWord word = words[wordNdx];
            short attrbs = word.getAttributes();
            if (CodedWord.isDelimiter(attrbs)) continue;
            ++n;
        }
        return n;
    }

    private static void scoreAddressNumberForPoint(AddressNumber inputNumber, InternalRangeAddress range, AddressNumberScore addrNumScore) {
        boolean matched;
        int num1 = inputNumber.getHnrNumber1();
        int num2 = inputNumber.getHnrNumber2();
        AddressNumber fromNumber = range.getFrom();
        int from = fromNumber.getHnrNumber1();
        int to = fromNumber.getHnrNumber2();
        boolean fromMatchedOnSecondNumber = false;
        boolean fromMatchedOnFirstNumber = false;
        if (from > 0 || fromNumber.getHnrSuffix1() != null) {
            if (from == num1) {
                if (from != 0) {
                    addrNumScore.setNumber1Matched(true);
                    fromMatchedOnFirstNumber = true;
                }
                if (fromNumber.getHnrSuffix1() != null && inputNumber.getHnrSuffix1() != null) {
                    addrNumScore.setSuffix1Matched(fromNumber.getHnrSuffix1().equalsIgnoreCase(inputNumber.getHnrSuffix1()));
                }
            } else if (from == num2) {
                if (from != 0) {
                    addrNumScore.setNumber2Matched(true);
                    fromMatchedOnSecondNumber = true;
                }
                if (fromNumber.getHnrSuffix1() != null && inputNumber.getHnrSuffix2() != null) {
                    addrNumScore.setSuffix2Matched(fromNumber.getHnrSuffix1().equalsIgnoreCase(inputNumber.getHnrSuffix2()));
                }
            }
        }
        if (to > 0 || fromNumber.getHnrSuffix2() != null) {
            if (to == num2 && !fromMatchedOnSecondNumber) {
                if (to != 0) {
                    addrNumScore.setNumber2Matched(true);
                }
                if (fromNumber.getHnrSuffix2() != null && inputNumber.getHnrSuffix2() != null) {
                    addrNumScore.setSuffix2Matched(fromNumber.getHnrSuffix2().equalsIgnoreCase(inputNumber.getHnrSuffix2()));
                }
            } else if (to == num1 && !fromMatchedOnFirstNumber) {
                if (to != 0) {
                    addrNumScore.setNumber1Matched(true);
                }
                if (fromNumber.getHnrSuffix2() != null && inputNumber.getHnrSuffix1() != null) {
                    addrNumScore.setSuffix1Matched(fromNumber.getHnrSuffix2().equalsIgnoreCase(inputNumber.getHnrSuffix1()));
                }
                fromMatchedOnSecondNumber = true;
            }
        }
        boolean bl = matched = addrNumScore.isNumber1Matched() || addrNumScore.isNumber2Matched();
        if (!matched && (from | to | num1 | num2) == 0 && addrNumScore.isSuffix1Matched() || addrNumScore.isSuffix2Matched()) {
            matched = true;
        }
        addrNumScore.setMatched(matched);
        addrNumScore.setTypeMatch(true);
        addrNumScore.setCandidateAddressNumber(fromNumber);
        if (!matched) {
            int offset1 = 0;
            int offset2 = 0;
            if (from > 0) {
                if (num1 > 0 && num2 > 0) {
                    offset1 = Math.min(Math.abs(num1 - from), Math.abs(num2 - from));
                } else if (num1 > 0) {
                    offset1 = Math.abs(num1 - from);
                } else if (num2 > 0) {
                    offset1 = Math.abs(num2 - from);
                }
            }
            if (to > 0) {
                if (num1 > 0 && num2 > 0) {
                    offset2 = Math.min(Math.abs(num1 - to), Math.abs(num2 - to));
                } else if (num1 > 0) {
                    offset2 = Math.abs(num1 - to);
                } else if (num2 > 0) {
                    offset2 = Math.abs(num2 - to);
                }
            }
            if (offset1 > 0 && offset2 > 0) {
                addrNumScore.setOffset(Math.min(offset1, offset2));
            } else if (offset1 > 0) {
                addrNumScore.setOffset(offset1);
            } else if (offset2 > 0) {
                addrNumScore.setOffset(offset2);
            }
            addrNumScore.setOffsetPosition(1);
        }
    }

    private IntArray getAllMatchingWordIndex(Collection<FieldScore> fieldScores, AddressWord[] inputWords) {
        IntArray matchingWordNdxs = null;
        if (fieldScores != null) {
            Iterator<FieldScore> itr = fieldScores.iterator();
            FieldScore score = null;
            while (itr.hasNext()) {
                score = itr.next();
                if (score == null || !(score.m_value > 0.5) || score.m_inputWords != inputWords || score.m_matchedInputWords == null) continue;
                if (matchingWordNdxs == null) {
                    matchingWordNdxs = new IntArray(inputWords.length);
                }
                matchingWordNdxs.add(score.m_matchedInputWords);
            }
            if (matchingWordNdxs != null) {
                matchingWordNdxs.sort();
            }
        }
        return matchingWordNdxs;
    }

    private boolean containsMatchingWords(Collection<FieldScore> fieldScores, AddressWord[] words, int[] ndx) {
        if (fieldScores != null) {
            Iterator<FieldScore> itr = fieldScores.iterator();
            FieldScore score = null;
            while (itr.hasNext()) {
                score = itr.next();
                if (!(score.m_value > 0.5) || score.m_inputWords != words || score.m_matchedInputWords == null || !IntArray.containCommonItems(score.m_matchedInputWords.asArray(), ndx)) continue;
                return true;
            }
        }
        return false;
    }

    protected AddressNumber findFromProbables(List<AddressNumber> addNumList, int start, int end, boolean preferFirst) {
        int n = addNumList == null ? 0 : addNumList.size();
        AddressNumber num = null;
        for (int i = 0; i < n; ++i) {
            AddressNumber num1 = addNumList.get(i);
            int[] numStartEnd = num1.getPositionInInputStreet();
            if (numStartEnd[0] <= start || numStartEnd[1] > end) continue;
            num = num1;
            if (preferFirst) break;
        }
        return num;
    }

    protected void scoreRangeAddressNumber(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        AddressNumber addrNum = pAddr.getAddressNumber();
        AddressNumberScore addrNumScore = new AddressNumberScore();
        InternalRangeAddress internalRange = scoringRange.getRange();
        if (addrNum != null) {
            this.scoreAddressNumber(addrNum, internalRange, addrNumScore);
            addrNumScore.m_inputFieldPresent = true;
        } else {
            int probables;
            List<AddressNumber> list = pAddr.getProbableAddressNumbers();
            int n = probables = list == null ? 0 : list.size();
            if (probables > 0) {
                AddressWord[] inputWords = (AddressWord[])pAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
                IntArray matchedNdxs = this.getAllMatchingWordIndex(scoringAddr.getFieldScoreList(), inputWords);
                int matchedSize = matchedNdxs == null ? 0 : matchedNdxs.size();
                FieldScore streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                IntArray streetWordNdxs = streetScore == null ? null : streetScore.m_matchedInputWords;
                int streetStartNdx = -1;
                int streetEndNdx = -1;
                if (streetWordNdxs != null && streetWordNdxs.size() > 0) {
                    streetStartNdx = streetWordNdxs.min();
                    streetEndNdx = streetWordNdxs.max();
                }
                if (streetStartNdx == -1 || streetEndNdx == -1) {
                    for (int numNdx = 0; numNdx < probables; ++numNdx) {
                        AddressNumberScore secondAddrNumScore;
                        AddressNumber num = list.get(numNdx);
                        int[] wordNdxs = num.getPositionInInputStreet();
                        if (wordNdxs == null || wordNdxs.length <= 0) continue;
                        int startPos = wordNdxs[0];
                        int endPos = wordNdxs[wordNdxs.length - 1];
                        boolean check = true;
                        for (int x = startPos; matchedSize > 0 && x < endPos; ++x) {
                            if (!matchedNdxs.contains(x)) continue;
                            check = false;
                            break;
                        }
                        if (!check || (secondAddrNumScore = this.scoreProbableAddressNumber(addrNum = num, scoringRange, pAddr)).compare(addrNumScore, secondAddrNumScore) >= 0) continue;
                        addrNumScore = secondAddrNumScore;
                    }
                } else {
                    int ndx;
                    int lastMatchedBeforeStreet = -1;
                    for (int i = 0; i < matchedSize && (ndx = matchedNdxs.get(i)) < streetStartNdx; ++i) {
                        lastMatchedBeforeStreet = ndx;
                    }
                    int firstMatchedAfterStreet = inputWords.length;
                    for (int i = 0; i < matchedSize; ++i) {
                        int ndx2 = matchedNdxs.get(i);
                        if (ndx2 <= streetEndNdx) continue;
                        firstMatchedAfterStreet = ndx2;
                        break;
                    }
                    addrNumScore = null;
                    boolean first = true;
                    do {
                        int[] numStartEndPos;
                        int[] nArray = numStartEndPos = addrNum != null ? addrNum.getPositionInInputStreet() : null;
                        if (pAddr.preferHouseNumberAtStart()) {
                            int end = numStartEndPos == null ? streetStartNdx : numStartEndPos[0];
                            addrNum = this.findFromProbables(list, lastMatchedBeforeStreet, end, false);
                            if (first && addrNum == null && scoringAddr.getAdjustedEndValForHnr() > 0) {
                                end = scoringAddr.getAdjustedEndValForHnr();
                                lastMatchedBeforeStreet = -1;
                                addrNum = this.findFromProbables(list, lastMatchedBeforeStreet, end, false);
                                first = false;
                            }
                        } else {
                            int start = numStartEndPos == null ? streetEndNdx : numStartEndPos[1] - 1;
                            addrNum = this.findFromProbables(list, start, firstMatchedAfterStreet, true);
                        }
                        if (addrNum == null) continue;
                        AddressNumberScore currentScore = this.scoreProbableAddressNumber(addrNum, scoringRange, pAddr);
                        if (addrNumScore == null) {
                            addrNumScore = currentScore;
                        } else if (currentScore.compare(currentScore, addrNumScore) > 0) {
                            addrNumScore = currentScore;
                        }
                        addrNumScore.setMatchedWithPreferredInputNumber(true);
                    } while (addrNum != null && (addrNumScore == null || !addrNumScore.m_matched && addrNumScore.getOffset() == 0));
                    if (addrNum == null || addrNumScore == null || !addrNumScore.m_matched) {
                        boolean acceptMatchedOnly = addrNumScore != null;
                        addrNum = pAddr.preferHouseNumberAtStart() ? this.findFromProbables(list, streetEndNdx, firstMatchedAfterStreet, true) : this.findFromProbables(list, lastMatchedBeforeStreet, streetStartNdx, false);
                        if (addrNum != null) {
                            AddressNumberScore currentScore = this.scoreProbableAddressNumber(addrNum, scoringRange, pAddr);
                            if (!acceptMatchedOnly || currentScore.m_matched) {
                                if (addrNumScore == null) {
                                    addrNumScore = currentScore;
                                } else if (currentScore.compare(currentScore, addrNumScore) > 0) {
                                    addrNumScore = currentScore;
                                }
                                addrNumScore.setMatchedWithPreferredInputNumber(false);
                            }
                        }
                    }
                }
            }
        }
        if (addrNumScore != null && addrNumScore != null) {
            scoringRange.setFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE, addrNumScore);
        }
    }

    protected AddressNumberScore scoreProbableAddressNumber(AddressNumber addrNumber, InternalScoringRange scoringRange, ParsedAddress parsedAddress) {
        AddressNumberScore addrNumScore = new AddressNumberScore();
        this.scoreAddressNumber(addrNumber, scoringRange.getRange(), addrNumScore);
        int[] numStartEndPos = addrNumber.getPositionInInputStreet();
        IntArray wordNdxs = new IntArray();
        for (int x = numStartEndPos[0]; x < numStartEndPos[1]; ++x) {
            wordNdxs.add(x);
        }
        addrNumScore.m_matchedInputWords = wordNdxs;
        if (addrNumScore.m_matched) {
            addrNumScore.m_perfectInputWords = wordNdxs;
        }
        addrNumScore.m_inputFieldPresent = true;
        return addrNumScore;
    }

    protected void scoreAddressNumber(AddressNumber addrNum, InternalRangeAddress range, AddressNumberScore addrNumScore) {
        CGGEMatcher.privateScoreAddressNumber(addrNum, range, addrNumScore);
    }

    private static void privateScoreAddressNumber(AddressNumber addrNum, InternalRangeAddress range, AddressNumberScore addrNumScore) {
        addrNumScore.setInputAddressNumber(addrNum);
        AddressNumber fromNumber = range.getFrom();
        AddressNumber toNumber = range.getTo();
        if (fromNumber != null && toNumber != null) {
            CGGEMatcher.scoreAddressNumberForRange(addrNum, range, addrNumScore);
            addrNumScore.m_candidateFieldPresent = true;
        } else if (fromNumber != null) {
            CGGEMatcher.scoreAddressNumberForPoint(addrNum, range, addrNumScore);
            addrNumScore.m_candidateFieldPresent = true;
        }
        if (addrNumScore.isNumber1Matched() || addrNumScore.isNumber2Matched()) {
            addrNumScore.setMatched(true);
        }
    }

    protected void scoreRange(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        this.scoreFieldsAtLevel(pAddr, scoringRange, FieldType.FieldLevel.LEVEL_RANGE, matchingOptions, scorer);
        this.scoreRangeAddressNumber(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
    }

    protected void calculateCombinedRangeScore(InternalScoringRange scoringRange, ParsedAddress parsedAddr, MatchingOptions matchingOptions) {
        AddressNumberScore addrScore = (AddressNumberScore)scoringRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        double rangeScore = 0.0;
        double scorePossible = 0.0;
        int fieldsAvailable = 0;
        int fieldsMatched = 0;
        int totalWords = 0;
        int wordsMatched = 0;
        IntArray rangeWordsMatched = new IntArray(10);
        Map<FieldType, FieldScore> fieldMap = scoringRange.getFieldScores();
        if (fieldMap != null && fieldMap.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldMap.entrySet()) {
                double fieldWeight;
                FieldType type = entry.getKey();
                FieldScore fieldScore = entry.getValue();
                if (fieldScore == null || type.getLevel() != FieldType.FieldLevel.LEVEL_STREET || !((fieldWeight = matchingOptions.getFieldWeight(type)) > 0.0)) continue;
                boolean acceptScore = true;
                boolean hasSeparateInput = this.hasSeparateRangeInput(parsedAddr, type);
                if (acceptScore || this.inputFieldPresent(fieldScore) || hasSeparateInput) {
                    scorePossible += fieldWeight;
                    if (acceptScore) {
                        rangeScore += fieldScore.m_value * fieldWeight;
                    }
                    ++fieldsAvailable;
                    if (fieldScore.m_matched) {
                        ++fieldsMatched;
                    }
                    if (hasSeparateInput && fieldScore.m_inputWords != null) {
                        totalWords += fieldScore.m_inputWords.length;
                        if (fieldScore.m_matchedInputWords != null) {
                            wordsMatched += fieldScore.m_matchedInputWords.size();
                        }
                    } else if (fieldScore.m_inputWords != null) {
                        rangeWordsMatched.add(fieldScore.m_matchedInputWords);
                    }
                    fieldScore.m_inputFieldPresent = true;
                    continue;
                }
                if (fieldScore == null || !fieldScore.m_candidateFieldPresent || matchingOptions.isOptionalField(type)) continue;
                scorePossible += fieldWeight * 0.01;
            }
        }
        if (rangeWordsMatched.size() > 0) {
            AddressWord[] areaWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            totalWords += areaWords == null ? 0 : areaWords.length;
            rangeWordsMatched.removeDuplicates();
            wordsMatched += rangeWordsMatched.size();
        }
        if (fieldsAvailable > 0) {
            double maxWeight = Math.min(matchingOptions.getMatchedFieldWeight() * (double)fieldsAvailable, 0.15);
            scorePossible += maxWeight;
            rangeScore += (double)fieldsMatched / (double)fieldsAvailable * maxWeight;
        }
        if (totalWords > 0) {
            double maxWeight = Math.min(matchingOptions.getMatchedWordWeight() * (double)totalWords, 0.1);
            scorePossible += maxWeight;
            rangeScore += (double)wordsMatched / (double)totalWords * maxWeight;
        }
        double addrNumWeight = matchingOptions.getFieldWeight(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        if (addrScore != null && addrScore.m_inputFieldPresent && addrNumWeight > 0.0) {
            scorePossible = addrNumWeight;
            rangeScore = addrScore.calculateAndSetScoreValue(matchingOptions) * addrNumWeight;
        }
        if (scorePossible > 0.0) {
            scoringRange.setCombinedScore(rangeScore / scorePossible);
        } else {
            scoringRange.setCombinedScore(0.0);
        }
    }

    protected FieldScore scoreCandField(AddressWord[] inputWords, ScoringItem cand, FieldType type, FieldScore score, ICGGEScorer scorer) {
        InternalFieldValue fv = (InternalFieldValue)cand.getField(type);
        switch (type.getKey()) {
            case 4: {
                return null;
            }
            case 15: {
                return null;
            }
        }
        score = this.scoreAddressWords(inputWords, fv, type, score, scorer);
        return score;
    }

    public Map.Entry<FieldType, FieldScore> getScoreWithCommonMatchedWords(Map<FieldType, FieldScore> scores, FieldScore scoreToCompare) {
        if (scores != null) {
            for (Map.Entry<FieldType, FieldScore> entry : scores.entrySet()) {
                FieldScore score = entry.getValue();
                if (scoreToCompare == score || !this.containsCommonMatchedWordsNdxs(score, scoreToCompare)) continue;
                return entry;
            }
        }
        return null;
    }

    protected FieldScore scoreCandFieldWithIgnoredWords(AddressWord[] inputWords, IntArray ignoreWordsNdx, ScoringItem cand, FieldType candType, FieldScore score, ICGGEScorer scorer) {
        int wordNdx;
        AddressWord[] clonedInputWords = AddressWordArray.clone(inputWords);
        int wordCount = clonedInputWords.length;
        for (wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
            CodedWord codedWord = new CodedWord(clonedInputWords[wordNdx].getCodedWord());
            codedWord.setSoundex(0);
            codedWord.setAttributes((short)0);
            clonedInputWords[wordNdx].setCodedWord(codedWord);
        }
        wordNdx = 0;
        FieldScore bestScore = null;
        do {
            int startNdx = -1;
            int endNdx = -1;
            while (wordNdx < wordCount) {
                if (ignoreWordsNdx.contains(wordNdx)) {
                    if (startNdx > -1) {
                        endNdx = wordNdx;
                        break;
                    }
                } else if (startNdx == -1) {
                    startNdx = wordNdx;
                    endNdx = wordNdx + 1;
                } else {
                    endNdx = wordNdx + 1;
                }
                ++wordNdx;
            }
            if (startNdx <= -1) continue;
            for (int ndx = startNdx; ndx < endNdx; ++ndx) {
                clonedInputWords[ndx].setSoundex(inputWords[ndx].getSoundex());
            }
            FieldScore newScore = new FieldScore();
            if (score != null) {
                newScore.copy(score);
            }
            newScore = this.scoreCandField(clonedInputWords, cand, candType, newScore, scorer);
            for (int ndx = startNdx; ndx < endNdx; ++ndx) {
                clonedInputWords[ndx].setSoundex(0);
            }
            if (bestScore != null && bestScore.compare(bestScore, newScore) >= 0) continue;
            bestScore = newScore;
        } while (wordNdx < wordCount);
        if (score != null) {
            if (bestScore != null) {
                score.copy(bestScore);
                score.m_inputWords = inputWords;
            } else {
                score.m_value = 0.0;
                score.m_perfectCandWords = null;
                score.m_perfectInputWords = null;
                score.m_matchedCandWords = null;
                score.m_matchedInputWords = null;
                score.m_matched = false;
            }
        } else if (bestScore != null) {
            score = bestScore;
            score.m_inputWords = inputWords;
        }
        return score;
    }

    protected void scoreInputField(ParsedAddress parsedAddress, AddressWord[] inputWords, ScoringItem candItem, FieldType inputType, List<FieldType> candCompareFields, FieldType.FieldLevel level, ICGGEScorer scorer, MatchingOptions options) {
        if (DebugLevel.getDebugLevel((int)4) >= 2) {
            MMJLog.getLog().debug("CGGEMatcher1::scoreInputField");
            if (inputType.getLevel() != level) {
                MMJLog.getLog().debug("InputType level: " + (Object)((Object)inputType.getLevel()) + " not equal to level: " + (Object)((Object)level));
            } else {
                MMJLog.getLog().debug("inputType: " + inputType);
                MMJLog.getLog().debug("level: " + (Object)((Object)level));
                if (inputWords != null) {
                    MMJLog.getLog().debug("inputWords: ");
                    for (AddressWord word : inputWords) {
                        MMJLog.getLog().debug("\t" + word.toString());
                    }
                } else {
                    MMJLog.getLog().debug("inputWords: none");
                }
                if (candCompareFields != null && candCompareFields.size() > 0) {
                    MMJLog.getLog().debug("candCompareFields: ");
                    for (FieldType ft : candCompareFields) {
                        MMJLog.getLog().debug("\t" + ft);
                    }
                } else {
                    MMJLog.getLog().debug("candCompareFields: none");
                }
            }
        }
        if (candCompareFields != null && !candCompareFields.isEmpty()) {
            this.scoreInputWithMultipleCandidateFields(parsedAddress, inputWords, candItem, inputType, candCompareFields, level, options, scorer);
        } else {
            this.scoreInputWithSingleCandidateField(parsedAddress, inputWords, candItem, inputType, level, options, scorer);
        }
    }

    void fillCurrentScoresFromInputWords(ScoringCandFields scoringCandFields, AddressWord[] inputWords) {
        Map<FieldType, FieldScore> currentScores = scoringCandFields.getScoringCandItem().getFieldScores();
        if (currentScores != null) {
            for (Map.Entry<FieldType, FieldScore> currScoreEn : currentScores.entrySet()) {
                FieldScore score = currScoreEn.getValue();
                if (score.m_inputWords != inputWords) continue;
                scoringCandFields.addFieldScore(currScoreEn.getKey(), score);
            }
        }
    }

    ScoringCandFields prepareScoringCandFields(List<FieldType> candCompareFields, ScoringItem candItem, FieldType inputType, FieldType.FieldLevel level, MatchingOptions options) {
        ScoringCandFields scoringCandFields = new ScoringCandFields(inputType, candItem, options);
        for (FieldType scorableCandFieldType : candCompareFields) {
            double fieldWeight = options.getFieldWeight(scorableCandFieldType);
            if (scorableCandFieldType.getLevel() != level || candItem.getField(scorableCandFieldType) == null || !this.hasNonZeroValue(fieldWeight)) continue;
            ScoringCandFields.ScoringCandField scoringCandField = new ScoringCandFields.ScoringCandField(scorableCandFieldType, fieldWeight);
            scoringCandFields.add(scoringCandField);
        }
        return scoringCandFields;
    }

    protected void scoreInputWithMultipleCandidateFields(ParsedAddress parsedAddress, AddressWord[] inputWords, ScoringItem candItem, FieldType inputType, List<FieldType> candCompareFields, FieldType.FieldLevel level, MatchingOptions options, ICGGEScorer scorer) {
        ScoringCandFields scoringCandFields = this.prepareScoringCandFields(candCompareFields, candItem, inputType, level, options);
        this.fillCurrentScoresFromInputWords(scoringCandFields, inputWords);
        while (!scoringCandFields.isFieldQueueEmpty()) {
            ScoringCandFields.ScoringCandField scoringCandField = scoringCandFields.pop();
            FieldType candType = scoringCandField.getCandFieldType();
            FieldScore prevCandFieldScore = candItem.getFieldScore(candType);
            if (candType != inputType && prevCandFieldScore != null && prevCandFieldScore.m_inputWords != null && prevCandFieldScore.m_inputWords == parsedAddress.getField(candType) && prevCandFieldScore.m_value > 0.5) continue;
            scoringCandFields.incCandFieldMatchCount();
            FieldScore score = null;
            IntArray ignoreWords = scoringCandField.getIgnoredWords();
            if (candType == FieldType.POST_CODE_FIELD_TYPE) {
                if (ignoreWords.isEmpty()) {
                    score = this.scorePostCode(candItem, parsedAddress, scoringCandFields.getFieldScores(), options, scorer);
                }
            } else {
                FieldScore fieldScore = score = ignoreWords.isEmpty() ? this.scoreCandField(inputWords, candItem, candType, null, scorer) : this.scoreCandFieldWithIgnoredWords(inputWords, ignoreWords, candItem, candType, null, scorer);
            }
            if (score != null && this.hasNonZeroValue(score.m_value)) {
                score.m_fieldWeight = scoringCandField.getFieldWeight();
                if (candType != inputType || prevCandFieldScore == null || prevCandFieldScore.compare(prevCandFieldScore, score) < 0) {
                    score = this.removeMatchCollisions(scoringCandFields, scoringCandField, score);
                    if (prevCandFieldScore != null && score != null && prevCandFieldScore.compare(prevCandFieldScore, score) >= 0) {
                        score = null;
                    }
                } else {
                    score = null;
                }
            }
            if (!this.canAddScore(scoringCandFields, score, candType)) continue;
            this.addScore(scoringCandFields, score, candType);
        }
        this.assignScoresToCandItem(scoringCandFields);
    }

    private FieldScore removeMatchCollisions(ScoringCandFields scoringCandFields, ScoringCandFields.ScoringCandField scoringCandField, FieldScore score) {
        Map<FieldType, FieldScore> currentScores = scoringCandFields.getFieldScores();
        FieldType inputType = scoringCandFields.getInputFieldType();
        FieldType candType = scoringCandField.getCandFieldType();
        Map.Entry<FieldType, FieldScore> entry = null;
        while ((entry = this.getScoreWithCommonMatchedWords(currentScores, score)) != null) {
            FieldType otherType;
            FieldScore otherScore = entry.getValue();
            boolean recheckCurrentScore = this.isFirstABetterScore(otherScore, score, inputType, otherType = entry.getKey(), candType);
            if (recheckCurrentScore) {
                if (score.m_value > 0.4) {
                    scoringCandField.addMatchedToIgnoreWords(otherScore);
                    scoringCandFields.addFirst(scoringCandField);
                }
                score = new FieldScore();
                if (inputType == candType) {
                    this.addScore(scoringCandFields, score, candType);
                }
            } else {
                if (otherScore.m_value > 0.4 || otherScore.perfectInputWordCount() > 0) {
                    ScoringCandFields.ScoringCandField otherScoringCandField = scoringCandFields.get(otherType);
                    if (otherScoringCandField == null) {
                        otherScoringCandField = new ScoringCandFields.ScoringCandField(otherType, otherScore.m_fieldWeight);
                    }
                    otherScoringCandField.addMatchedToIgnoreWords(score);
                    scoringCandFields.add(otherScoringCandField);
                }
                scoringCandFields.removeFieldScore(otherType, true);
            }
            if (entry != null && score != null && this.hasNonZeroValue(score.m_value)) continue;
        }
        return score;
    }

    boolean canAddScore(ScoringCandFields scoringCandFields, FieldScore score, FieldType candFieldType) {
        if (score != null) {
            Map<FieldType, FieldScore> fieldScores = scoringCandFields.getFieldScores();
            if (this.hasNonZeroValue(score.m_value) || fieldScores.containsKey(candFieldType)) {
                return candFieldType == scoringCandFields.getInputFieldType() || score.m_value > 0.5;
            }
        }
        return false;
    }

    void addScore(ScoringCandFields scoringCandFields, FieldScore score, FieldType candFieldType) {
        score.m_candidateFieldPresent = true;
        score.m_inputFieldPresent = true;
        if (CGGEMatcher.acceptScore(score, candFieldType, scoringCandFields.getMatchOptions())) {
            scoringCandFields.setInputFieldScored(true);
        }
        scoringCandFields.addFieldScore(candFieldType, score);
    }

    void assignScoresToCandItem(ScoringCandFields scoringCandFields) {
        ScoringItem candItem = scoringCandFields.getScoringCandItem();
        for (Map.Entry<FieldType, FieldScore> scoreEn : scoringCandFields.getFieldScores().entrySet()) {
            candItem.setFieldScore(scoreEn.getKey(), scoreEn.getValue());
        }
        if (scoringCandFields.getCandFieldMatchCount() > 0 && !scoringCandFields.getInputFieldScored()) {
            FieldType inputType = scoringCandFields.getInputFieldType();
            FieldScore score = candItem.getFieldScore(inputType);
            if (score == null) {
                score = new FieldScore();
                candItem.setFieldScore(inputType, score);
            }
            score.m_inputFieldPresent = true;
        }
    }

    protected void scoreInputWithSingleCandidateField(ParsedAddress parsedAddress, AddressWord[] inputWords, ScoringItem candItem, FieldType inputType, FieldType.FieldLevel level, MatchingOptions options, ICGGEScorer scorer) {
        double fw;
        if (inputType.getLevel() == level && this.hasNonZeroValue(fw = options.getFieldWeight(inputType))) {
            FieldScore score = null;
            if (inputType == FieldType.POST_CODE_FIELD_TYPE) {
                if (DebugLevel.getDebugLevel((int)4) >= 2) {
                    MMJLog.getLog().debug("scorePostCode");
                }
                score = this.scorePostCode(candItem, parsedAddress, candItem.getFieldScores(), options, scorer);
            } else {
                if (DebugLevel.getDebugLevel((int)4) >= 2) {
                    MMJLog.getLog().debug("scoreCandField");
                }
                score = this.scoreCandField(inputWords, candItem, inputType, null, scorer);
            }
            if (DebugLevel.getDebugLevel((int)4) >= 2) {
                if (score != null) {
                    MMJLog.getLog().debug("score: " + score.toString());
                } else {
                    MMJLog.getLog().debug("score: none");
                }
            }
            if (score == null) {
                score = new FieldScore();
            }
            score.m_candidateFieldPresent = true;
            score.m_inputFieldPresent = true;
            candItem.setFieldScore(inputType, score);
        }
    }

    protected void scoreFieldsAtLevel(ParsedAddress parsedAddr, ScoringItem candItem, FieldType.FieldLevel level, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        List<FieldType> candCompareFields;
        AddressWord[] inputWords;
        boolean poBoxInSingleLine;
        IConstraints constraints = matchingOptions.getGeocodeOptions().getGeocodeConstraints();
        boolean poboxMatchInProgress = false;
        if (constraints != null && "true".equals(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS"))) {
            poboxMatchInProgress = true;
        }
        boolean bl = poBoxInSingleLine = parsedAddr.isPoBoxInSingleLine() && poboxMatchInProgress;
        if (!parsedAddr.isSeperatePostAddressFields() && !poBoxInSingleLine) {
            inputWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            if (inputWords != null) {
                candCompareFields = matchingOptions.getSingleLineCompareFields();
                this.scoreInputField(parsedAddr, inputWords, candItem, FieldType.STREET_NAME_FIELD_TYPE, candCompareFields, level, scorer, matchingOptions);
            }
        } else if (!parsedAddr.isSeparateAreaFields() && (inputWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE)) != null) {
            candCompareFields = matchingOptions.getPostAddressCompareFields();
            this.scoreInputField(parsedAddr, inputWords, candItem, FieldType.POST_ADDRESS_FIELD_TYPE, candCompareFields, level, scorer, matchingOptions);
        }
        Map inputFields = parsedAddr.getFields();
        if (inputFields != null) {
            for (Map.Entry entry : inputFields.entrySet()) {
                AddressWord[] inputWords2;
                FieldType inputType = entry.getKey();
                if (!parsedAddr.isSeperatePostAddressFields() && !poBoxInSingleLine && inputType == FieldType.STREET_NAME_FIELD_TYPE || inputType == FieldType.POST_ADDRESS_FIELD_TYPE || (inputWords2 = (AddressWord[])entry.getValue()) == null) continue;
                List<FieldType> candCompareFields2 = matchingOptions.getCompareFieldsForField(inputType);
                this.scoreInputField(parsedAddr, inputWords2, candItem, inputType, candCompareFields2, level, scorer, matchingOptions);
            }
        }
    }

    public void scoreCandidate(ParsedAddress parsedAddr, InternalScoringAddress addr, MatchingOptions matchingOptions, ICGGEScorer scorer, IDataManager dataManager) throws CGGEInternalException {
        this.scorePostalFields(addr, parsedAddr, matchingOptions, scorer);
        this.calculateCombinedPostAddressScore(addr, parsedAddr, matchingOptions);
        double combinedPostalScore = addr.getCombinedPostalScore() * 1.25;
        ICGGECandidateFilter filter = this.getFilter();
        double postalCutoff = filter.getPostalAddressCutoff(addr.getAddressType());
        if (this.hasNonZeroValue(postalCutoff) && combinedPostalScore < postalCutoff) {
            return;
        }
        this.scoreStreetFields(addr, parsedAddr, matchingOptions, scorer);
        this.calculateCombinedStreetScore(addr, parsedAddr, matchingOptions);
        this.calculateCombinedAddressScore(addr, matchingOptions);
        double combinedScore = addr.getCombinedScore() * 1.25 + matchingOptions.getRangeAddressWeight();
        if (combinedScore < filter.getCandidateCutoff(addr.getAddressType())) {
            return;
        }
        this.scoreRanges(addr, parsedAddr, matchingOptions, scorer);
        if (!parsedAddr.isIntersectionCase() && !parsedAddr.isNearByFeature()) {
            this.reAdjustScoreForInsignificantWordMatches(addr.getFieldScores());
        }
        this.calculateCombinedPostAddressScore(addr, parsedAddr, matchingOptions);
        this.calculateCombinedStreetScore(addr, parsedAddr, matchingOptions);
        this.calculateCombinedAddressScore(addr, matchingOptions);
        GeocodeOptions geocodeOptions = matchingOptions.getGeocodeOptions();
        DictionaryUsage du = geocodeOptions.getDictionaryUsageForDictionary(addr.getDictionaryNumber());
        if (du != null) {
            if (geocodeOptions.preferUserDictionaries() || geocodeOptions.preferAddressDictionaries()) {
                this.setDictionaryUsagePriority(geocodeOptions, dataManager, addr, du);
            } else {
                addr.setDictionaryUsagePriority(du.getSearchOrder());
            }
        } else {
            this.setDictionaryUsagePriority(geocodeOptions, dataManager, addr, du);
        }
    }

    void setDictionaryUsagePriority(GeocodeOptions geocodeOptions, IDataManager dataManager, InternalScoringAddress addr, DictionaryUsage du) {
        if (geocodeOptions.preferUserDictionaries() || geocodeOptions.preferAddressDictionaries()) {
            IDictionaryMetaData metaData = addr.getDataSetInfo().getMetaData();
            if (geocodeOptions.preferUserDictionaries() && metaData.isUserDictionary()) {
                addr.setDictionaryUsagePriority(addr.getDictionaryNumber() - dataManager.getDictionaryCount());
            } else if (geocodeOptions.preferAddressDictionaries() && !metaData.isUserDictionary()) {
                addr.setDictionaryUsagePriority(addr.getDictionaryNumber() - dataManager.getDictionaryCount());
            } else {
                addr.setDictionaryUsagePriority(addr.getDictionaryNumber());
            }
        } else {
            addr.setDictionaryUsagePriority(addr.getDictionaryNumber());
        }
    }

    protected FieldScore scorePostCode(ScoringItem addr, ParsedAddress parsedAddr, Map<FieldType, FieldScore> currentScores, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        AddressWord[] parsedPC = (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
        List<PostCode> probablePCList = parsedAddr.getProbablePostcodes();
        int probableCount = probablePCList == null ? 0 : probablePCList.size();
        FieldScore pcScore = new FieldScore();
        if (parsedPC != null || probableCount > 0) {
            InternalFieldValue scoringPCFieldValue;
            AddressWord[] pcWordsEx;
            InternalFieldValue pcField = (InternalFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE);
            InternalFieldValue pcFieldEx = (InternalFieldValue)addr.getField(FieldType.POST_CODE_EX_FIELD_TYPE);
            InternalFieldValue combinedPCField = null;
            if (pcField != null && pcFieldEx != null) {
                int minAlts;
                AddressWord[] pcWords = (AddressWord[])pcField.getFieldValue();
                pcWordsEx = (AddressWord[])pcFieldEx.getFieldValue();
                combinedPCField = new InternalFieldValue(AddressWordArray.combineArrays(pcWords, pcWordsEx));
                AddressWord[][] altPCs = (AddressWord[][])pcField.getAlternateValues();
                AddressWord[][] altPCExs = (AddressWord[][])pcFieldEx.getAlternateValues();
                if (altPCs != null && altPCExs != null && (minAlts = Math.min(altPCs.length, altPCExs.length)) > 0) {
                    ArrayList<AddressWord[]> alts = new ArrayList<AddressWord[]>(minAlts);
                    for (int altNdx = 0; altNdx < minAlts; ++altNdx) {
                        alts.add(AddressWordArray.combineArrays(altPCs[altNdx], altPCExs[altNdx]));
                    }
                    combinedPCField.setAlternateValues(alts.toArray((T[])new AddressWord[minAlts][]));
                }
            }
            if (parsedPC != null) {
                pcScore.m_inputFieldPresent = true;
            }
            InternalFieldValue internalFieldValue = scoringPCFieldValue = combinedPCField != null ? combinedPCField : pcField;
            if (scoringPCFieldValue != null) {
                if (parsedPC != null) {
                    this.scoreAddressWords(parsedPC, scoringPCFieldValue, FieldType.POST_CODE_FIELD_TYPE, pcScore, scorer);
                    pcScore.m_candidateFieldPresent = true;
                } else {
                    AddressWord[] inputWords = null;
                    inputWords = parsedAddr.isSeperatePostAddressFields() ? (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE) : (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    for (int pcNdx = 0; pcNdx < probableCount; ++pcNdx) {
                        PostCode probablePC = probablePCList.get(pcNdx);
                        parsedPC = probablePC.getWords();
                        int[] wordNdxs = probablePC.getPositionInInputStreet();
                        if (wordNdxs == null || wordNdxs.length <= 0) continue;
                        IntArray checkNdx = new IntArray(wordNdxs.length);
                        int startPos = wordNdxs[0];
                        int endPos = wordNdxs[wordNdxs.length - 1];
                        for (int x = startPos; x < endPos; ++x) {
                            checkNdx.add(x);
                        }
                        if (currentScores != null && this.containsMatchingWords(currentScores.values(), inputWords, checkNdx.asArray())) continue;
                        FieldScore probablePcScore = new FieldScore();
                        this.scoreAddressWords(parsedPC, scoringPCFieldValue, FieldType.POST_CODE_FIELD_TYPE, probablePcScore, scorer);
                        if (probablePcScore.compare(probablePcScore, pcScore) <= 0) continue;
                        pcScore = probablePcScore;
                        pcScore.m_inputFieldPresent = true;
                        pcScore.m_inputWords = inputWords;
                        pcScore.m_matchedInputWords = checkNdx;
                        if (pcScore.m_perfectInputWords == null) continue;
                        for (int i = 0; i < pcScore.m_perfectInputWords.size(); ++i) {
                            int ndx = pcScore.m_perfectInputWords.get(i);
                            if (ndx < checkNdx.size()) {
                                pcScore.m_perfectInputWords.set(i, checkNdx.get(ndx));
                                continue;
                            }
                            pcScore.m_perfectInputWords.removeAt(i--);
                        }
                    }
                    pcScore.m_candidateFieldPresent = true;
                }
            }
            if (combinedPCField != null) {
                if (pcScore.m_value >= 2.0) {
                    pcScore.m_value = 1.0;
                } else if (pcFieldEx != null && pcScore.m_value > 0.0) {
                    pcWordsEx = pcScore.m_matchedAltIndex > -1 ? ((AddressWord[][])pcFieldEx.getAlternateValues())[pcScore.m_matchedAltIndex] : (AddressWord[])pcFieldEx.getFieldValue();
                    int exPCWeight = 0;
                    for (int i = 0; i < pcWordsEx.length; ++i) {
                        if (!pcScore.isPerfectCandWordMatch(i) || pcWordsEx[i].getSoundex() <= 0) continue;
                        exPCWeight = (byte)(exPCWeight + pcWordsEx[i].m_weight);
                    }
                    if (exPCWeight > 0) {
                        AddressWord[] pcWords = pcScore.m_matchedAltIndex > -1 ? ((AddressWord[][])pcField.getAlternateValues())[pcScore.m_matchedAltIndex] : (AddressWord[])pcField.getFieldValue();
                        int pcWordCount = pcWords.length;
                        double fullScore = pcScore.m_value;
                        double partialPCScore = 0.0;
                        int matched = 0;
                        for (int i = 0; i < pcWordCount; ++i) {
                            if (pcScore.m_perfectCandWords != null && pcScore.m_perfectCandWords.contains(i)) {
                                partialPCScore += (double)pcWords[i].m_weight * 0.01;
                                ++matched;
                                continue;
                            }
                            if (pcScore.m_matchedCandWords == null || !pcScore.m_matchedCandWords.contains(i)) continue;
                            ++matched;
                        }
                        if (matched != pcScore.m_inputWords.length || !(pcScore.m_value <= 1.0)) {
                            pcScore.m_value = partialPCScore * 0.85 + (fullScore - partialPCScore) * 0.15;
                        }
                    } else if (pcScore.m_value >= 1.0) {
                        int weightedInputWords = 0;
                        for (int i = 0; i < parsedPC.length; ++i) {
                            if (parsedPC[i].getSoundex() <= 0) continue;
                            ++weightedInputWords;
                        }
                        pcScore.m_value = pcScore.perfectInputWordCount() < weightedInputWords ? 0.9 : 1.0;
                    }
                }
            }
        }
        pcScore.m_matched = pcScore.m_value >= 1.0;
        return pcScore;
    }

    @Override
    public void mergeCandidates(InternalCandidateList candList1, InternalCandidateList candList2) {
        if (candList2 == null) {
            return;
        }
        int candCount1 = candList1.getCandidateCount();
        int candCount2 = candList2.getCandidateCount();
        if (candCount1 == 0) {
            candList1.setCandidateList(candList2.getCandidateList());
            candList1.setNumberOfCloseMatches(candList2.getNumberOfCloseMatches());
        } else if (candCount2 > 0) {
            List<InternalScoringAddress> internalList1 = candList1.getCandidateList();
            List<InternalScoringAddress> internalList2 = candList2.getCandidateList();
            LinkedList<InternalScoringAddress> tempCombinedList = new LinkedList<InternalScoringAddress>(internalList1);
            Comparator<InternalScoringAddress> reverseComparator = MMUtils.getReverseComparator(new CGGEInternalScoringAddressComparator());
            for (int i = 0; i < candCount2; ++i) {
                InternalScoringAddress scoringAddr = internalList2.get(i);
                int ndx = MMUtils.nextInsertPosition(tempCombinedList, scoringAddr, reverseComparator);
                tempCombinedList.add(ndx, scoringAddr);
            }
            internalList1.clear();
            internalList1.addAll(tempCombinedList);
            candList1.setNumberOfCloseMatches(candList1.getNumberOfCloseMatches() + candList2.getNumberOfCloseMatches());
        }
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    List<FieldType> getFields(String fields, IDictionaryMetaData metadata) {
        ArrayList<FieldType> fieldList = null;
        if (fields != null && fields.trim().length() > 0) {
            fieldList = new ArrayList<FieldType>(5);
            StringTokenizer st = new StringTokenizer(fields, ",");
            while (st.hasMoreTokens()) {
                String fk = st.nextToken().trim();
                FieldType ft = metadata.getFieldForName(fk.toLowerCase());
                if (ft == null) {
                    ft = metadata.getFieldForName(fk);
                }
                if (ft == null) continue;
                fieldList.add(ft);
            }
        }
        return fieldList;
    }

    private synchronized MatchingOptions loadMatchingOptions(DataSetInfo dataSetInfo) throws CGGEInternalException {
        MatchingOptions matchingOptions = null;
        if (this.m_matchingOptionsMap.containsKey(dataSetInfo)) {
            matchingOptions = this.m_matchingOptionsMap.get(dataSetInfo);
        } else {
            String typeName = GeocodeOptions.getGeocodeTypeName(dataSetInfo.getGeocodeType());
            Properties prop = null;
            prop = this.getConfiguration(this.m_country, this.getLanguage(), "_MatcherSettings", typeName, dataSetInfo.getName());
            if (prop != null) {
                matchingOptions = this.getOptions(prop, dataSetInfo.getMetaData());
            }
            this.m_matchingOptionsMap.put(dataSetInfo, matchingOptions);
        }
        return matchingOptions;
    }

    @Override
    public MatchingOptions getMatchingOptions(GeocodeOptions options, DataSetInfo dataSetInfo) throws CGGERuntimeException, CGGEInternalException {
        MatchingOptions matchingOptions = null;
        matchingOptions = this.m_matchingOptionsMap.containsKey(dataSetInfo) ? this.m_matchingOptionsMap.get(dataSetInfo) : this.loadMatchingOptions(dataSetInfo);
        if (matchingOptions != null) {
            matchingOptions = new MatchingOptions(matchingOptions);
            options.setStandardMatchModeSettings(matchingOptions.getStandardMatchModeFields());
            matchingOptions.setGeocodeOptions(options);
        }
        return matchingOptions;
    }
}

