/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.matcher;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.DictionaryUsage;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.ICGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.matcher.CGGEInternalScoringRangeComparator;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher;
import com.mapinfo.mapmarker.cgge.matcher.FieldScoreAdjuster;
import com.mapinfo.mapmarker.cgge.matcher.MatchedWordStats;
import com.mapinfo.mapmarker.cgge.matcher.ScoringCandFields;
import com.mapinfo.mapmarker.cgge.matcher.TransientScoreObject;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CGGEMatcher1
extends CGGEMatcher {
    private static final String KEY_ADJUST_FIELD_SCORE_FOR_MISSING_WORDS = "_mimimumSignificantWordMatchScore";
    protected FieldScoreAdjuster m_fieldScoreAdjuster = new FieldScoreAdjuster();

    @Override
    protected MatchingOptions getMatchingOptionsForAddress(GeocodeOptions options, InternalScoringAddress scoringAddr, IDataManager dataManager) throws CGGEInternalException {
        return this.getMatchingOptions(options, scoringAddr.getDataSetInfo());
    }

    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        double streetCuttoff;
        double postalCutoff;
        boolean closeMatch = false;
        closeMatch = scoringAddr.getCombinedScore() >= matchOptions.getCloseMatchCutoff();
        ICGGECandidateFilter filter = this.getFilter();
        if (closeMatch && this.hasNonZeroValue(postalCutoff = filter.getPostalAddressCutoff(scoringAddr.getAddressType())) && scoringAddr.getCombinedPostalScore() < postalCutoff) {
            closeMatch = false;
        }
        if (closeMatch && this.hasNonZeroValue(streetCuttoff = filter.getStreetAddressCutoff(scoringAddr.getAddressType())) && scoringAddr.getCombinedStreetScore() < streetCuttoff) {
            closeMatch = false;
        }
        if (closeMatch && (closeMatch = this.passMustMatchContraints(scoringAddr, matchOptions)) && scoringAddr.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE) != null && !scoringAddr.getFieldScore((FieldType)FieldType.ADDRESS_NUMBER_FIELD_TYPE).m_matched && Boolean.valueOf(options.getGeocodeConstraints().getCustomString("POBOX_MATCH_IN_PROGRESS", "false")).booleanValue()) {
            closeMatch = false;
        }
        if (closeMatch && scoringAddr.getSearchWords() != null && !this.streetNotSearched(scoringAddr.getSearchWords()) && scoringAddr.getRangeCount() > 0 && !scoringAddr.getRangeAt(0).isCloseMatch()) {
            FieldScore score;
            boolean bPointHouse;
            boolean bl = bPointHouse = scoringAddr.getRangeAt(0).getFrom() != null && scoringAddr.getRangeAt(0).getTo() == null;
            if (bPointHouse && ((score = scoringAddr.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) == null || score.m_value == 0.0)) {
                closeMatch = false;
            }
        }
        scoringAddr.setCloseMatch(closeMatch);
        return closeMatch;
    }

    private boolean streetNotSearched(List<AddressWord> searchWords) {
        for (AddressWord word : searchWords) {
            if (word.m_wordType != FieldType.STREET_NAME_FIELD_TYPE) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean passMustMatchContraints(InternalScoringAddress scoringAddr, MatchingOptions matchOptions) {
        GeocodeOptions options = matchOptions.getGeocodeOptions();
        if (options != null) {
            FieldScore score;
            if (options.isMustMatchCountry() && this.inputFieldPresent(score = scoringAddr.getFieldScore(FieldType.COUNTRY_FIELD_TYPE)) && matchOptions.getFieldWeight(FieldType.COUNTRY_FIELD_TYPE) > 0.0 && !this.isFieldMatch(score)) {
                return false;
            }
            return super.passMustMatchContraints(scoringAddr, matchOptions);
        }
        return true;
    }

    @Override
    void processMatchOptionsKeyValue(MatchingOptions matchOptions, String key, String value, IDictionaryMetaData metaData) {
        if (key.endsWith(KEY_ADJUST_FIELD_SCORE_FOR_MISSING_WORDS) && key.length() > KEY_ADJUST_FIELD_SCORE_FOR_MISSING_WORDS.length()) {
            String fk = key.substring(0, key.length() - KEY_ADJUST_FIELD_SCORE_FOR_MISSING_WORDS.length());
            FieldType type = metaData.getFieldForName(fk);
            if (type != null) {
                matchOptions.setMinScoreForFieldWithMatchedSignificantWord(type, this.getDoubleValue(value));
            }
        } else {
            super.processMatchOptionsKeyValue(matchOptions, key, value, metaData);
        }
    }

    @Override
    protected int unmatchedWordCount(FieldScore score) {
        IntArray a;
        int r = super.unmatchedWordCount(score);
        if (r < 0 && (a = score.m_matchedInputWords) != null && a.size() > 0) {
            r = 0;
        }
        return r;
    }

    @Override
    public void scoreRanges(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        int rangeCount = scoringAddr.getRangeCount();
        if (rangeCount > 0) {
            CGGEInternalScoringRangeComparator compartor = new CGGEInternalScoringRangeComparator();
            Comparator<InternalScoringRange> reverseComparator = MMUtils.getReverseComparator(compartor);
            LinkedList<InternalScoringRange> sortedRanges = new LinkedList<InternalScoringRange>();
            this.scoreRangeList(rangeCount, sortedRanges, scoringAddr, parsedAddr, matchingOptions, scorer, reverseComparator);
            scoringAddr.setRanges(sortedRanges.toArray(new InternalScoringRange[sortedRanges.size()]));
            Map<FieldType, FieldScore> scores = scoringAddr.getRangeAt(0).getFieldScores();
            if (scores != null && scores.size() > 0) {
                scoringAddr.setFieldScores(scores);
            }
        }
    }

    protected void scoreRangeList(int rangeCount, LinkedList<InternalScoringRange> sortedRanges, InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchingOptions, ICGGEScorer scorer, Comparator<InternalScoringRange> reverseComparator) {
        for (int i = 0; i < rangeCount; ++i) {
            InternalScoringRange range = scoringAddr.getRangeAt(i);
            this.scoreRange(scoringAddr, range, parsedAddr, matchingOptions, scorer);
            this.calculateCombinedRangeScore(range, parsedAddr, matchingOptions);
            this.calculateRangeCloseMatch(range, parsedAddr, matchingOptions);
            int ndx = MMUtils.nextInsertPosition(sortedRanges, range, reverseComparator);
            sortedRanges.add(ndx, range);
        }
    }

    protected int weightedFieldWeightsAtLevel(ScoringItem scoringItem, FieldType.FieldLevel level, MatchingOptions matchOptions, boolean hasSeperatePostalFields) {
        return super.weightedFieldWeightsAtLevel(scoringItem, level, matchOptions);
    }

    protected double combineFieldWeightsAtLevel(ScoringItem scoringItem, FieldType.FieldLevel level, MatchingOptions matchOptions, boolean hasSeperatePostalFields) {
        double totalWeight = 0.0;
        Map fields = scoringItem.getFields();
        if (fields != null) {
            for (Map.Entry en : fields.entrySet()) {
                InternalFieldValue fv;
                FieldType type = en.getKey();
                if (type.getLevel() != level || matchOptions.isOptionalField(type) || (fv = (InternalFieldValue)en.getValue()) == null) continue;
                totalWeight += matchOptions.getFieldWeight(type);
            }
        }
        return totalWeight;
    }

    @Override
    protected void calculateCombinedPostAddressScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchOptions) {
        scoringAddr.setCombinedPostalScore(0.0);
        TransientScoreObject scoreObj = new TransientScoreObject(scoringAddr, matchOptions);
        int candFieldsScored = 0;
        double totalScoredFieldWeight = 0.0;
        int parsedFieldCount = parsedAddr.getFields() == null ? 0 : parsedAddr.getFields().size();
        ArrayList<AddressWord[]> matchedInputWords = new ArrayList<AddressWord[]>(parsedFieldCount);
        boolean hasSeperatePostalFields = this.hasSeperateAreaFields(parsedAddr);
        double missingFieldsWeight = 0.0;
        int candFieldsAvailable = this.weightedFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchOptions, hasSeperatePostalFields);
        Map<FieldType, FieldScore> fieldScores = scoringAddr.getFieldScores();
        if (fieldScores != null && fieldScores.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldScores.entrySet()) {
                FieldType type = entry.getKey();
                FieldScore fieldScore = entry.getValue();
                if (type == FieldType.POST_ADDRESS_FIELD_TYPE) {
                    if (matchedInputWords.contains(fieldScore.m_inputWords)) continue;
                    matchedInputWords.add(fieldScore.m_inputWords);
                    scoreObj.incFieldsAvailable();
                    continue;
                }
                if (fieldScore == null || type.getLevel() != FieldType.FieldLevel.LEVEL_POSTAL) continue;
                ++candFieldsScored;
                double fieldWeight = matchOptions.getFieldWeight(type);
                if (!(fieldWeight > 0.0)) continue;
                boolean acceptScore = CGGEMatcher1.acceptScore(fieldScore, type, matchOptions);
                if (acceptScore || this.inputFieldPresent(fieldScore)) {
                    totalScoredFieldWeight += fieldWeight;
                    if (acceptScore) {
                        scoreObj.incScorePossible(fieldWeight);
                        scoreObj.incScore(fieldScore.m_value * fieldWeight);
                    } else if (!matchOptions.isOptionalField(type)) {
                        missingFieldsWeight += fieldWeight;
                    }
                    if (hasSeperatePostalFields) {
                        scoreObj.setFieldsAvailable(this.incrementInputFieldsAvailable(scoringAddr, type, scoreObj.getFieldsAvailable()));
                        if (fieldScore.m_matched && this.areNonPerfectWordsIgnorable(fieldScore)) {
                            scoreObj.incFieldsMatched();
                        }
                    }
                }
                if (fieldScore.m_inputWords == null || matchedInputWords.contains(fieldScore.m_inputWords)) continue;
                matchedInputWords.add(fieldScore.m_inputWords);
            }
        }
        MatchedWordStats matchWordStats = this.getMatchedWordStats(matchedInputWords, scoringAddr);
        double missingWeight = this.combineFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchOptions, hasSeperatePostalFields);
        if ((missingFieldsWeight = this.moderateMissingFieldWeight(scoringAddr, missingFieldsWeight, missingWeight -= totalScoredFieldWeight, hasSeperatePostalFields)) > 0.0) {
            int inputWordCount = matchWordStats.getTotalWords();
            int matchedWordCount = matchWordStats.getMatchedWordCount();
            scoreObj.incScorePossible(this.adjustScoreOnMissingInputs(scoringAddr, hasSeperatePostalFields, matchedInputWords, missingFieldsWeight, matchedWordCount, inputWordCount));
        } else if (candFieldsAvailable > candFieldsScored && !hasSeperatePostalFields) {
            if (scoreObj.getScorePossible() == 0.0) {
                scoreObj.setScorePossible(missingWeight * 0.2);
            } else if (missingWeight > 0.0) {
                scoreObj.setScorePossible(scoreObj.getScorePossible() * (1.0 + missingWeight * 0.2));
            }
        }
        this.addPostalMatchedFieldsScore(scoreObj);
        this.addPostalMatchedWordsScore(scoreObj, matchWordStats);
        if (candFieldsScored == 0) {
            missingWeight = this.combineFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchOptions, hasSeperatePostalFields);
            if (!this.hasNonZeroValue(missingWeight)) {
                scoringAddr.setCombinedPostalScore(1.0);
            }
        } else {
            scoringAddr.setCombinedPostalScore(scoreObj.getWeightedScore());
        }
    }

    protected void addPostalMatchedWordsScore(TransientScoreObject transientScoreObject, MatchedWordStats matchWordStats) {
        boolean fieldsMatchedOnSignificantWords;
        int inputWordCount = matchWordStats.getTotalWords();
        int matchedWordCount = matchWordStats.getMatchedWordCount();
        if (inputWordCount == 0 || matchedWordCount >= inputWordCount) {
            return;
        }
        double matchWordWeight = transientScoreObject.getMatchOptions().getMatchedWordWeight();
        double maxRealWeight = matchWordWeight * (double)inputWordCount;
        double maxWeightAllowed = Math.min(maxRealWeight, 0.1);
        transientScoreObject.incScorePossible(maxWeightAllowed);
        boolean bl = fieldsMatchedOnSignificantWords = matchWordStats.getMatchedSignificantWordCount() > 0 || matchWordStats.getUnMatchedNormalWordCount() == 0 && matchWordStats.getWeightedCandidateWordCount() == matchWordStats.getPartialMatchCandidateWordCount();
        if (fieldsMatchedOnSignificantWords) {
            double score;
            double reduction = this.calculateUnmatchedWordWeight(matchWordStats, matchWordWeight, transientScoreObject.getScoringAddress());
            reduction -= (double)matchWordStats.getPartialMatchNonArticleOrNumericWordCount() * (matchWordWeight / 2.0);
            if (matchWordStats.getWeightedCandidateWordCount() == matchWordStats.getPartialMatchCandidateWordCount()) {
                reduction *= 0.5;
            }
            if ((score = this.matchedWordsScore(reduction, maxRealWeight, maxWeightAllowed)) > 0.0) {
                transientScoreObject.incScore(score);
            }
        } else if (matchWordStats.getPartialMatchNormalWordCount() > 1 || matchWordStats.getPartialMatchNormalWordCount() == inputWordCount) {
            double score = (double)matchWordStats.getPartialMatchNormalWordCount() * (matchWordWeight / 2.0);
            transientScoreObject.incScore(Math.min(score, maxWeightAllowed));
        } else if (matchWordStats.getUnmatchedSignificantWordCount() == 0) {
            double score = (double)matchWordStats.getMatchedWordCount() * (matchWordWeight / 2.0);
            transientScoreObject.incScore(Math.min(score, maxWeightAllowed));
        }
    }

    protected double matchedWordsScore(double unmatchedWordScore, double maxScore, double maxScoreAllowed) {
        return maxScoreAllowed - unmatchedWordScore;
    }

    private void addPostalMatchedFieldsScore(TransientScoreObject scoreObj) {
        int fieldsAvailable = scoreObj.getFieldsAvailable();
        int fieldsMatched = scoreObj.getFieldsMatched();
        if (fieldsAvailable > 0 && fieldsMatched < fieldsAvailable) {
            double maxWeight = Math.min(scoreObj.getMatchOptions().getMatchedFieldWeight() * (double)fieldsAvailable, 0.15);
            scoreObj.incScorePossible(maxWeight);
            scoreObj.incScore((double)fieldsMatched / (double)fieldsAvailable * maxWeight);
        }
    }

    protected double adjustScoreOnMissingInputs(InternalScoringAddress scoringAddr, boolean hasSeperatePostalFields, List<AddressWord[]> matchedInputWords, double missingFieldsWeight, int matchedWordCount, int inputWordCount) {
        if (!hasSeperatePostalFields && matchedWordCount < inputWordCount && !this.areNonMatchedWordsIgnorable(matchedInputWords, scoringAddr)) {
            return missingFieldsWeight * 0.25;
        }
        return missingFieldsWeight * 0.1;
    }

    protected int incrementInputFieldsAvailable(InternalScoringAddress scoringAddr, FieldType type, int inputFieldsAvailable) {
        return ++inputFieldsAvailable;
    }

    protected double moderateMissingFieldWeight(InternalScoringAddress scoringAddr, double calculatedMissingFieldWeight, double actualMissingWeight, boolean hasSeperatePostalFields) {
        return calculatedMissingFieldWeight;
    }

    protected double calculateUnmatchedWordWeight(MatchedWordStats matchWordStats, double matchWordWeight, InternalScoringAddress scoringAddr) {
        double w = (double)matchWordStats.getUnMatchedNormalWordCount() * matchWordWeight;
        return w += (double)matchWordStats.getUnMatchedArticleOrNumericWordCount() * (matchWordWeight / 2.0);
    }

    protected double calculateUnmatchedWordWeight(int[] inputWordMatchStat, double matchWordWeight, InternalScoringAddress scoringAddr) {
        double w = (double)inputWordMatchStat[3] * matchWordWeight;
        return w += (double)inputWordMatchStat[4] * (matchWordWeight / 2.0);
    }

    @Override
    protected void calculateCombinedStreetScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddress, MatchingOptions options) {
        scoringAddr.setCombinedStreetScore(0.0);
        TransientScoreObject scoreObj = new TransientScoreObject(scoringAddr, options);
        int candFieldsScored = 0;
        int parsedFieldCount = parsedAddress.getFields() == null ? 0 : parsedAddress.getFields().size();
        ArrayList<AddressWord[]> matchedInputWords = new ArrayList<AddressWord[]>(parsedFieldCount);
        Map<FieldType, FieldScore> fieldMap = scoringAddr.getFieldScores();
        if (fieldMap != null && fieldMap.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldMap.entrySet()) {
                FieldType type = entry.getKey();
                FieldScore fieldScore = entry.getValue();
                if (fieldScore == null || type.getLevel() != FieldType.FieldLevel.LEVEL_STREET) continue;
                ++candFieldsScored;
                double fieldWeight = options.getFieldWeight(type);
                if (!(fieldWeight > 0.0)) continue;
                boolean acceptScore = CGGEMatcher1.acceptScore(fieldScore, type, options);
                boolean separateFieldinput = this.hasSeparateStreetInput(parsedAddress, type);
                if (!separateFieldinput && !acceptScore && !this.inputFieldPresent(fieldScore)) continue;
                scoreObj.incScorePossible(fieldWeight);
                if (acceptScore) {
                    scoreObj.incScore(fieldScore.m_value * fieldWeight);
                }
                scoreObj.incFieldsAvailable();
                if (fieldScore.m_matched) {
                    scoreObj.incFieldsMatched();
                }
                if (fieldScore.m_inputWords == null || matchedInputWords.contains(fieldScore.m_inputWords)) continue;
                matchedInputWords.add(fieldScore.m_inputWords);
            }
        }
        MatchedWordStats matchWordStats = this.getMatchedWordStats(matchedInputWords, scoringAddr);
        this.addStreetMatchedFieldsScore(scoreObj, matchWordStats);
        if (!parsedAddress.isIntersectionCase()) {
            this.addStreetMatchedWordsScore(scoreObj, matchWordStats);
        }
        if (candFieldsScored == 0) {
            double missingWeight = this.combineFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_STREET, options, false);
            if (!this.hasNonZeroValue(missingWeight)) {
                scoringAddr.setCombinedStreetScore(1.0);
            }
        } else {
            scoringAddr.setCombinedStreetScore(scoreObj.getWeightedScore());
        }
    }

    private void addStreetMatchedFieldsScore(TransientScoreObject scoreObj, MatchedWordStats matchWordStats) {
        int fieldsAvailable = scoreObj.getFieldsAvailable();
        int fieldsMatched = scoreObj.getFieldsMatched();
        boolean fieldsMatchedOnSignificantWords = this.didFieldsMatchedOnSignificantWords(matchWordStats);
        if (!(fieldsAvailable <= 0 || fieldsMatched >= fieldsAvailable && fieldsMatchedOnSignificantWords)) {
            double maxWeight = Math.min(scoreObj.getMatchOptions().getMatchedFieldWeight() * (double)fieldsAvailable, 0.15);
            scoreObj.incScorePossible(maxWeight);
            double s = (double)fieldsMatched / (double)fieldsAvailable * maxWeight;
            if (s > 0.0) {
                scoreObj.incScore(fieldsMatchedOnSignificantWords ? s : s * 0.5);
            }
        }
    }

    protected void addStreetMatchedWordsScore(TransientScoreObject scoreObj, MatchedWordStats matchWordStats) {
        int inputWordCount = matchWordStats.getTotalWords();
        int matchedWordCount = matchWordStats.getMatchedWordCount();
        if (inputWordCount > 0 && matchedWordCount < inputWordCount) {
            double matchWordWeight = scoreObj.getMatchOptions().getMatchedWordWeight();
            double maxRealWeight = matchWordWeight * (double)inputWordCount;
            double maxWeightAllowed = Math.min(maxRealWeight, 0.1);
            scoreObj.incScorePossible(maxWeightAllowed);
            if (this.didFieldsMatchedOnSignificantWords(matchWordStats)) {
                double reduction = this.calculateUnmatchedWordWeight(matchWordStats, matchWordWeight, scoreObj.getScoringAddress());
                double score = this.matchedWordsScore(reduction -= (double)matchWordStats.getPartialMatchNonArticleOrNumericWordCount() * (matchWordWeight / 2.0), maxRealWeight, maxWeightAllowed);
                if (score > 0.0) {
                    scoreObj.incScore(score);
                }
            } else if (matchWordStats.getPartialMatchNormalWordCount() > 1 || matchWordStats.getPartialMatchNormalWordCount() == inputWordCount) {
                double score = (double)matchWordStats.getPartialMatchNormalWordCount() * (matchWordWeight / 2.0);
                scoreObj.incScore(Math.min(score, maxWeightAllowed));
            } else if (matchWordStats.getUnmatchedSignificantWordCount() == 0) {
                double score = (double)matchWordStats.getMatchedWordCount() * (matchWordWeight / 2.0);
                scoreObj.incScore(Math.min(score, maxWeightAllowed));
            }
        }
    }

    private boolean didFieldsMatchedOnSignificantWords(MatchedWordStats matchWordStats) {
        return matchWordStats.getMatchedSignificantWordCount() > 0 || matchWordStats.getUnMatchedNormalWordCount() == 0 && matchWordStats.getWeightedCandidateWordCount() == matchWordStats.getPartialMatchCandidateWordCount();
    }

    @Override
    protected void scoreRange(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        Map<FieldType, FieldScore> scores = scoringAddr.getFieldScores();
        if (scores != null && scores.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> scoreEntry : scores.entrySet()) {
                FieldScore score = scoreEntry.getValue();
                if (score == null) continue;
                FieldScore clonedScore = new FieldScore();
                clonedScore.copy(score);
                scoringRange.setFieldScore(scoreEntry.getKey(), clonedScore);
            }
        }
        super.scoreRange(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
    }

    @Override
    protected void calculateCombinedRangeScore(InternalScoringRange scoringRange, ParsedAddress parsedAddr, MatchingOptions matchingOptions) {
        AddressNumberScore addrScore = (AddressNumberScore)scoringRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        double rangeScore = 0.0;
        double scorePossible = 0.0;
        int fieldsAvailable = 0;
        int fieldsMatched = 0;
        int totalWords = 0;
        int wordsMatched = 0;
        IntArray rangeWordsMatched = new IntArray(10);
        Map<FieldType, FieldScore> fieldMap = scoringRange.getFieldScores();
        if (fieldMap != null && fieldMap.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldMap.entrySet()) {
                double fieldWeight;
                FieldType type = entry.getKey();
                FieldScore fieldScore = entry.getValue();
                if (fieldScore == null || type == FieldType.ADDRESS_NUMBER_FIELD_TYPE || type.getLevel() != FieldType.FieldLevel.LEVEL_RANGE || !((fieldWeight = matchingOptions.getFieldWeight(type)) > 0.0)) continue;
                boolean acceptScore = true;
                boolean hasSeparateInput = this.hasSeparateRangeInput(parsedAddr, type);
                if (acceptScore || this.inputFieldPresent(fieldScore) || hasSeparateInput) {
                    scorePossible += fieldWeight;
                    if (acceptScore) {
                        rangeScore += fieldScore.m_value * fieldWeight;
                    }
                    ++fieldsAvailable;
                    if (fieldScore.m_matched) {
                        ++fieldsMatched;
                    }
                    if (hasSeparateInput && fieldScore.m_inputWords != null) {
                        totalWords += fieldScore.m_inputWords.length;
                        if (fieldScore.m_matchedInputWords != null) {
                            wordsMatched += fieldScore.m_matchedInputWords.size();
                        }
                    } else if (fieldScore.m_inputWords != null) {
                        rangeWordsMatched.add(fieldScore.m_matchedInputWords);
                    }
                    fieldScore.m_inputFieldPresent = true;
                    continue;
                }
                if (fieldScore == null || !fieldScore.m_candidateFieldPresent || matchingOptions.isOptionalField(type)) continue;
                scorePossible += fieldWeight * 0.01;
            }
        }
        if (rangeWordsMatched.size() > 0) {
            AddressWord[] areaWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            totalWords += areaWords == null ? 0 : areaWords.length;
            rangeWordsMatched.removeDuplicates();
            wordsMatched += rangeWordsMatched.size();
        }
        if (fieldsAvailable > 0) {
            double maxWeight = Math.min(matchingOptions.getMatchedFieldWeight() * (double)fieldsAvailable, 0.15);
            scorePossible += maxWeight;
            rangeScore += (double)fieldsMatched / (double)fieldsAvailable * maxWeight;
        }
        if (totalWords > 0) {
            double maxWeight = Math.min(matchingOptions.getMatchedWordWeight() * (double)totalWords, 0.1);
            scorePossible += maxWeight;
            rangeScore += (double)wordsMatched / (double)totalWords * maxWeight;
        }
        double addrNumWeight = matchingOptions.getFieldWeight(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        if (addrScore != null && addrScore.m_inputFieldPresent && addrNumWeight > 0.0) {
            scorePossible += addrNumWeight;
            rangeScore += addrScore.calculateAndSetScoreValue(matchingOptions) * addrNumWeight;
        }
        if (scorePossible > 0.0) {
            scoringRange.setCombinedScore(rangeScore / scorePossible);
        } else {
            scoringRange.setCombinedScore(0.0);
        }
    }

    @Override
    protected FieldScore scoreCandFieldWithIgnoredWords(AddressWord[] inputWords, IntArray ignoreWordsNdx, ScoringItem cand, FieldType candType, FieldScore score, ICGGEScorer scorer) {
        int wordNdx;
        AddressWord[] clonedInputWords = AddressWordArray.clone(inputWords);
        int wordCount = clonedInputWords.length;
        for (wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
            CodedWord codedWord = new CodedWord(clonedInputWords[wordNdx].getCodedWord());
            codedWord.setSoundex(0);
            codedWord.setAttributes((short)0);
            clonedInputWords[wordNdx].setCodedWord(codedWord);
        }
        wordNdx = 0;
        FieldScore bestScore = null;
        do {
            int startNdx = -1;
            int endNdx = -1;
            while (wordNdx < wordCount) {
                if (ignoreWordsNdx.contains(wordNdx)) {
                    if (startNdx > -1) {
                        endNdx = wordNdx;
                        break;
                    }
                } else if (startNdx == -1) {
                    startNdx = wordNdx;
                    endNdx = wordNdx + 1;
                } else {
                    endNdx = wordNdx + 1;
                }
                ++wordNdx;
            }
            if (startNdx <= -1) continue;
            for (int ndx = startNdx; ndx < endNdx; ++ndx) {
                clonedInputWords[ndx].setSoundex(inputWords[ndx].getSoundex());
                clonedInputWords[ndx].setAttribute(inputWords[ndx].getAttributes());
            }
            FieldScore newScore = new FieldScore();
            if (score != null) {
                newScore.copy(score);
            }
            newScore = this.scoreCandField(clonedInputWords, cand, candType, newScore, scorer);
            for (int ndx = startNdx; ndx < endNdx; ++ndx) {
                clonedInputWords[ndx].setSoundex(0);
                clonedInputWords[ndx].setAttribute((short)0);
            }
            if (bestScore != null && bestScore.compare(bestScore, newScore) >= 0) continue;
            bestScore = newScore;
        } while (wordNdx < wordCount);
        if (score != null) {
            if (bestScore != null) {
                score.copy(bestScore);
                score.m_inputWords = inputWords;
            } else {
                score.m_value = 0.0;
                score.m_perfectCandWords = null;
                score.m_perfectInputWords = null;
                score.m_matchedCandWords = null;
                score.m_matchedInputWords = null;
                score.m_matched = false;
            }
        } else if (bestScore != null) {
            score = bestScore;
            score.m_inputWords = inputWords;
        }
        return score;
    }

    @Override
    ScoringCandFields prepareScoringCandFields(List<FieldType> candCompareFields, ScoringItem candItem, FieldType inputType, FieldType.FieldLevel level, MatchingOptions options) {
        ScoringCandFields scoringCandFields = new ScoringCandFields(inputType, candItem, options);
        for (FieldType scorableCandFieldType : candCompareFields) {
            double fieldWeight = options.getFieldWeight(scorableCandFieldType);
            if (scorableCandFieldType.getLevel() != level || candItem.getField(scorableCandFieldType) == null || !this.hasNonZeroValue(fieldWeight)) continue;
            ScoringCandFields.ScoringCandField scoringCandField = new ScoringCandFields.ScoringCandField(scorableCandFieldType, fieldWeight);
            if (scorableCandFieldType == inputType) {
                scoringCandFields.addFirst(scoringCandField);
                continue;
            }
            scoringCandFields.add(scoringCandField);
        }
        return scoringCandFields;
    }

    @Override
    void addScore(ScoringCandFields scoringCandFields, FieldScore score, FieldType candFieldType) {
        boolean currValue = score.m_inputFieldPresent;
        super.addScore(scoringCandFields, score, candFieldType);
        if (!currValue) {
            score.m_inputFieldPresent = CGGEMatcher1.acceptScore(score, candFieldType, scoringCandFields.getMatchOptions());
        }
    }

    @Override
    void assignScoresToCandItem(ScoringCandFields scoringCandFields) {
        FieldType inputType;
        ScoringItem candItem;
        FieldScore score;
        super.assignScoresToCandItem(scoringCandFields);
        if (scoringCandFields.getCandFieldMatchCount() > 0 && scoringCandFields.getInputFieldScored() && (score = (candItem = scoringCandFields.getScoringCandItem()).getFieldScore(inputType = scoringCandFields.getInputFieldType())) != null && !this.hasNonZeroValue(score.m_value) && !score.m_candidateFieldPresent) {
            candItem.removeFieldScore(inputType);
        }
    }

    @Override
    public void scoreCandidate(ParsedAddress parsedAddr, InternalScoringAddress addr, MatchingOptions matchingOptions, ICGGEScorer scorer, IDataManager dataManager) throws CGGEInternalException {
        this.scorePostalFields(addr, parsedAddr, matchingOptions, scorer);
        this.calculateCombinedPostAddressScore(addr, parsedAddr, matchingOptions);
        double combinedPostalScore = addr.getCombinedPostalScore() * 1.5;
        ICGGECandidateFilter filter = this.getFilter();
        double postalCutoff = filter.getPostalAddressCutoff(addr.getAddressType());
        if (this.hasNonZeroValue(postalCutoff) && combinedPostalScore < postalCutoff) {
            return;
        }
        this.scoreStreetFields(addr, parsedAddr, matchingOptions, scorer);
        this.calculateCombinedStreetScore(addr, parsedAddr, matchingOptions);
        this.calculateCombinedAddressScore(addr, matchingOptions);
        double combinedScore = addr.getCombinedScore() * 1.5 + matchingOptions.getRangeAddressWeight();
        if (combinedScore < filter.getCandidateCutoff(addr.getAddressType())) {
            return;
        }
        this.scoreRanges(addr, parsedAddr, matchingOptions, scorer);
        this.adjustScores(addr, parsedAddr, matchingOptions);
        this.calculateCombinedPostAddressScore(addr, parsedAddr, matchingOptions);
        this.calculateCombinedStreetScore(addr, parsedAddr, matchingOptions);
        this.calculateCombinedAddressScore(addr, matchingOptions);
        this.calculateDictionaryUsagePriority(addr, dataManager, matchingOptions);
    }

    protected void adjustScores(InternalScoringAddress cand, ParsedAddress pAddr, MatchingOptions matchingOptions) {
        this.m_fieldScoreAdjuster.adjustScores(cand, matchingOptions, !pAddr.isIntersectionCase());
    }

    protected void calculateDictionaryUsagePriority(InternalScoringAddress cand, IDataManager dataManager, MatchingOptions matchingOptions) {
        GeocodeOptions geocodeOptions = matchingOptions.getGeocodeOptions();
        DictionaryUsage du = geocodeOptions.getDictionaryUsageForDictionary(cand.getDictionaryNumber());
        if (du != null) {
            if (geocodeOptions.preferUserDictionaries() || geocodeOptions.preferAddressDictionaries()) {
                this.setDictionaryUsagePriority(geocodeOptions, dataManager, cand, du);
            } else {
                cand.setDictionaryUsagePriority(du.getSearchOrder());
            }
        } else {
            this.setDictionaryUsagePriority(geocodeOptions, dataManager, cand, du);
        }
    }

    protected FieldScoreAdjuster getFieldScoreAdjuster() {
        return this.m_fieldScoreAdjuster;
    }
}

