/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.matcher;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.List;
import java.util.Map;

public class FieldScoreAdjuster {
    private static final double MAX_FIELD_SCORE_THRESHOLD_FOR_MISSING_WORDS = 0.8;
    private static final double MIN_FIELD_SCORE_THRESHOLD_FOR_INSIGNIFICANT_WORDS_MATCHES = 0.7;

    protected boolean isSignificantWord(AddressWord word, InternalScoringAddress cand) {
        return AddressWord.isSignificantWord(word);
    }

    protected void adjustScores(InternalScoringAddress cand, MatchingOptions matchingOptions, boolean downgradeScore) {
        Map<FieldType, FieldScore> scores;
        if (cand != null && (scores = cand.getFieldScores()) != null) {
            boolean searchWordIsASignificantWord = false;
            boolean searchWordIsPerfectMatch = false;
            boolean toConsiderNumericSearchWord = true;
            if (downgradeScore && matchingOptions.getAdjustMatchForCandsWithoutSignificantSearchWord()) {
                List<AddressWord> searchWords = cand.getSearchWords();
                int searchWordCount = searchWords == null ? 0 : searchWords.size();
                for (int wordNdx = 0; wordNdx < searchWordCount; ++wordNdx) {
                    AddressWord word = searchWords.get(wordNdx);
                    searchWordIsASignificantWord = this.isSignificantWord(word, cand);
                    if (!searchWordIsASignificantWord) {
                        toConsiderNumericSearchWord = this.shouldConsiderNumericSearchWordForAdjustingScore(word, cand);
                    }
                    if (word.m_quality >= 1.0) {
                        searchWordIsPerfectMatch = true;
                    }
                    if (searchWordIsASignificantWord && searchWordIsPerfectMatch) break;
                }
            }
            for (Map.Entry<FieldType, FieldScore> en : scores.entrySet()) {
                FieldType type = en.getKey();
                FieldScore score = en.getValue();
                double minScore = matchingOptions.getMinScoreForFieldWithMatchedSignificantWord(type);
                boolean scoreAdjustedForMissingWord = false;
                if (minScore > 0.0 && score.m_value < 0.8) {
                    scoreAdjustedForMissingWord = this.adjustScoreForMissingWord(score, scores, minScore);
                }
                if (!downgradeScore) continue;
                boolean scoreAdjustedForInsignificantSearchWord = false;
                if (matchingOptions.getAdjustMatchForCandsWithoutSignificantSearchWord() && this.containsType(cand.getSearchWords(), type)) {
                    boolean isNumericSearchWord = toConsiderNumericSearchWord && this.containsNumberWords(cand.getSearchWords());
                    scoreAdjustedForInsignificantSearchWord = this.adjustScoreForInsignificantSearchWord(score, type, scores, searchWordIsASignificantWord, searchWordIsPerfectMatch, isNumericSearchWord);
                }
                if (scoreAdjustedForMissingWord || scoreAdjustedForInsignificantSearchWord || !(score.m_value > 0.7)) continue;
                boolean bl = this.adjustScoreForInsignificantWordMatches(score, type, scores);
            }
        }
    }

    protected boolean containsNumberWords(List<AddressWord> wordList) {
        if (wordList != null) {
            for (AddressWord word : wordList) {
                if (!word.isNumeral()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsType(List<AddressWord> wordList, FieldType type) {
        if (wordList != null) {
            for (AddressWord word : wordList) {
                if (word.m_wordType != type) continue;
                return true;
            }
        }
        return false;
    }

    public boolean adjustScoreForMissingWord(FieldScore score, Map<FieldType, FieldScore> scores, double minimum) {
        if (score.inputWordsMatchedInOrder() && this.containsMissingMatchableSignificantWord(score.m_candWords, score.m_perfectCandWords)) {
            boolean upgradeScore = this.containsPerfectSignificantWords(score.m_candWords, score.m_perfectCandWords) && this.containsPerfectSignificantWords(score.m_inputWords, score.m_perfectInputWords);
            boolean partialMatch = false;
            if (!upgradeScore && this.containsPerfectSignificantWords(score.m_candWords, score.m_matchedCandWords) && this.containsPerfectSignificantWords(score.m_inputWords, score.m_matchedInputWords)) {
                int wordCount = score.m_candWords.length;
                double checkScore = score.m_value;
                double checkWeight = 0.0;
                for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
                    if (!score.m_matchedCandWords.contains(wordNdx)) continue;
                    AddressWord matchedWord = score.m_candWords[wordNdx];
                    if (AddressWord.isSignificantWord(matchedWord)) {
                        checkWeight += (double)matchedWord.m_weight * 0.01;
                        continue;
                    }
                    checkScore -= (double)matchedWord.m_weight * 0.01;
                }
                if (checkWeight > 0.0 && checkScore > checkWeight * 0.9) {
                    upgradeScore = true;
                    partialMatch = true;
                }
            }
            if (upgradeScore) {
                int[] startEndPos = this.findPossibleInputFieldStartEnd(score, scores, false);
                upgradeScore = !this.containsMissingMatchableSignificantWord(score.m_inputWords, score.m_matchedInputWords, score.m_matchedInputWords.max(), startEndPos[1]);
                boolean bl = upgradeScore = upgradeScore && !this.containsMissingMatchableSignificantWord(score.m_inputWords, score.m_matchedInputWords, 0, score.m_matchedInputWords.max());
            }
            if (upgradeScore) {
                double newScore = minimum;
                double remaining = 1.0 - minimum;
                score.m_value = newScore += score.m_value * remaining * (partialMatch ? 0.25 : 0.5);
                return true;
            }
        }
        return false;
    }

    private byte totalInsignificantWordsWeight(AddressWord[] candWords) {
        byte totalWeightOfInSignificantWords = 0;
        int wordCount = candWords == null ? 0 : candWords.length;
        for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
            AddressWord candWord = candWords[wordNdx];
            if (AddressWord.isSignificantWord(candWord)) continue;
            totalWeightOfInSignificantWords = (byte)(totalWeightOfInSignificantWords + candWord.m_weight);
        }
        return totalWeightOfInSignificantWords;
    }

    private int[] findPossibleInputFieldStartEnd(FieldScore score, Map<FieldType, FieldScore> scores, boolean includeNumberWords) {
        if (score != null) {
            AddressWord[] inputWords = score.m_inputWords;
            int inputWordCount = inputWords.length;
            IntArray matchedInputWords = score.m_matchedInputWords;
            int startWordPos = 0;
            int endWordPos = inputWordCount - 1;
            if (matchedInputWords != null && matchedInputWords.size() > 0) {
                int matchedWordStartPos = matchedInputWords.min();
                int matchedWordEndPos = matchedInputWords.max();
                for (FieldScore otherScore : scores.values()) {
                    IntArray matchedWordNdxs;
                    if (otherScore == score || otherScore.m_inputWords != inputWords || (matchedWordNdxs = otherScore.m_matchedInputWords) == null || matchedWordNdxs.size() <= 0) continue;
                    int min = matchedWordNdxs.min();
                    int max = matchedWordNdxs.max();
                    if (max < matchedWordStartPos) {
                        if (max < startWordPos) continue;
                        startWordPos = max + 1;
                        continue;
                    }
                    if (min <= matchedWordEndPos || min > endWordPos) continue;
                    endWordPos = min - 1;
                }
                if (!includeNumberWords) {
                    int lastMatchedWord;
                    int firstMatchedWord = matchedInputWords.min();
                    if (firstMatchedWord > 0) {
                        for (int wordNdx = firstMatchedWord - 1; wordNdx >= startWordPos; --wordNdx) {
                            AddressWord word = inputWords[wordNdx];
                            short wordAttribs = word.getAttributes();
                            if (!CodedWord.isNumber(wordAttribs) && !MMUtils.containsDigits(word.getWordChars())) continue;
                            startWordPos = wordNdx + 1;
                            break;
                        }
                    }
                    if ((lastMatchedWord = matchedInputWords.max()) < inputWordCount - 1) {
                        for (int wordNdx = lastMatchedWord + 1; wordNdx <= endWordPos; ++wordNdx) {
                            AddressWord word = inputWords[wordNdx];
                            short wordAttribs = word.getAttributes();
                            if (!CodedWord.isNumber(wordAttribs) && !MMUtils.containsDigits(word.getWordChars())) continue;
                            endWordPos = wordNdx - 1;
                            break;
                        }
                    }
                }
            } else assert (false);
            return new int[]{startWordPos, endWordPos};
        }
        return null;
    }

    public boolean adjustScoreForInsignificantWordMatches(FieldScore score, FieldType type, Map<FieldType, FieldScore> scores) {
        if (score != null && type != FieldType.POST_CODE_FIELD_TYPE && type != FieldType.ADDRESS_NUMBER_FIELD_TYPE) {
            boolean downgradeScore = false;
            IntArray perfectInputWordNdx = score.m_perfectInputWords;
            int prefectInputWordSize = perfectInputWordNdx == null ? 0 : perfectInputWordNdx.size();
            int perfectCandWordSize = score.m_perfectCandWords == null ? 0 : score.m_perfectCandWords.size();
            int[] startEndPos = null;
            if (!(score.m_value >= 1.0 && perfectCandWordSize > 2 && this.containsPerfectSignificantWords(score.m_candWords, score.m_perfectCandWords) || prefectInputWordSize > 2)) {
                if (this.totalInsignificantWordsWeight(score.m_candWords) > 50) {
                    downgradeScore = true;
                } else if (!this.containsPerfectSignificantWords(score.m_inputWords, score.m_perfectInputWords)) {
                    downgradeScore = true;
                }
                if (downgradeScore) {
                    startEndPos = this.findPossibleInputFieldStartEnd(score, scores, false);
                    downgradeScore = this.containsMissingMatchableSignificantWord(score.m_inputWords, score.m_matchedInputWords, startEndPos[0], startEndPos[1]);
                }
            }
            if (downgradeScore) {
                AddressWord[] inputWords;
                int inputWordCount;
                int unmatchedWords;
                if (startEndPos == null) {
                    startEndPos = this.findPossibleInputFieldStartEnd(score, scores, false);
                }
                if ((unmatchedWords = (inputWordCount = (inputWords = score.m_inputWords).length) - prefectInputWordSize) > 0) {
                    double reduction = 0.0;
                    IntArray matchedInputWordNdx = score.m_matchedInputWords;
                    for (int n = startEndPos[0]; n <= startEndPos[1]; ++n) {
                        if (perfectInputWordNdx.contains(n)) continue;
                        boolean matched = matchedInputWordNdx.contains(n);
                        AddressWord unmatchedWord = inputWords[n];
                        short wordAttribs = unmatchedWord.getAttributes();
                        if (CodedWord.isDelimiter(wordAttribs)) continue;
                        if (CodedWord.isCommonWord(wordAttribs)) {
                            reduction += matched ? 0.05 : 0.1;
                            continue;
                        }
                        if (CodedWord.isArticleWord(wordAttribs)) {
                            reduction += matched ? 0.025 : 0.05;
                            continue;
                        }
                        if (CodedWord.isNumber(wordAttribs) || CodedWord.isNumeric(wordAttribs) || CodedWord.isProbableRomanNumeral(wordAttribs)) {
                            reduction += matched ? 0.035 : 0.07;
                            continue;
                        }
                        if (CodedWord.isThoroughfareTypeWord(wordAttribs)) {
                            reduction += matched ? 0.035 : 0.07;
                            continue;
                        }
                        reduction += matched ? 0.075 : 0.1;
                    }
                    score.m_value *= 1.0 - reduction;
                    score.m_matched = score.m_value > 0.99999;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean shouldConsiderNumericSearchWordForAdjustingScore(AddressWord word, InternalScoringAddress cand) {
        return true;
    }

    protected boolean adjustScoreForInsignificantSearchWord(FieldScore score, FieldType type, Map<FieldType, FieldScore> scores, boolean searchWordIsSignificantWord, boolean searchWordIsPrefectMatch, boolean searchWordIsNumber) {
        if (!(searchWordIsSignificantWord && searchWordIsPrefectMatch || score == null || !(score.m_value > 0.7))) {
            AddressWord[] inputWords = score.m_inputWords;
            int inputWordCount = inputWords.length;
            IntArray perfectInputWords = score.m_perfectInputWords;
            IntArray matchedInputWords = score.m_matchedInputWords;
            int unmatchedInputWords = inputWordCount - (perfectInputWords == null ? 0 : perfectInputWords.size());
            if (unmatchedInputWords > 0) {
                int[] startEndPos = this.findPossibleInputFieldStartEnd(score, scores, searchWordIsNumber);
                int penality = 0;
                boolean allMatctableWordsMatched = true;
                for (int n = startEndPos[0]; n <= startEndPos[1]; ++n) {
                    if (perfectInputWords != null && perfectInputWords.contains(n)) continue;
                    boolean matched = matchedInputWords.contains(n);
                    AddressWord unmatchedWord = inputWords[n];
                    if (AddressWord.isSignificantWord(unmatchedWord)) {
                        if (!matched) {
                            allMatctableWordsMatched = false;
                            penality += 4;
                            continue;
                        }
                        penality += 2;
                        continue;
                    }
                    if (CodedWord.isDelimiter(unmatchedWord.getAttributes())) continue;
                    if (!matched) {
                        allMatctableWordsMatched = false;
                        penality += 2;
                        continue;
                    }
                    ++penality;
                }
                double reduction = 0.0;
                if (!(allMatctableWordsMatched || searchWordIsSignificantWord && searchWordIsPrefectMatch)) {
                    reduction = 0.1;
                }
                if (penality > 10) {
                    reduction += 0.2;
                } else {
                    reduction += (double)penality * 0.01;
                    if (!(searchWordIsSignificantWord || perfectInputWords != null && perfectInputWords.size() != 0)) {
                        reduction += 0.1;
                    } else {
                        penality = 0;
                        IntArray perfectCandWords = score.m_perfectCandWords;
                        IntArray matchedCandWords = score.m_matchedCandWords;
                        if (perfectCandWords == null || perfectCandWords.size() < score.m_candWords.length) {
                            for (int i = 0; i < score.m_candWords.length; ++i) {
                                AddressWord candWord = score.m_candWords[i];
                                if (candWord.m_weight <= 0 || perfectCandWords != null && perfectCandWords.contains(i) || searchWordIsPrefectMatch && matchedCandWords != null && matchedCandWords.contains(i)) continue;
                                if (AddressWord.isSignificantWord(candWord)) {
                                    penality += 2;
                                    continue;
                                }
                                ++penality;
                            }
                        }
                        if (penality > 0) {
                            reduction += Math.min(0.1, (double)penality * 0.01);
                        }
                    }
                }
                if (reduction > 0.0) {
                    score.m_value *= 1.0 - reduction;
                    score.m_matched = score.m_value > 0.99999;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean containsPerfectSignificantWords(AddressWord[] words, IntArray matchedWordNdx) {
        if (words != null && matchedWordNdx != null) {
            int matchedWordCount = matchedWordNdx.size();
            for (int i = 0; i < matchedWordCount; ++i) {
                AddressWord matchedWord;
                int perfectWordNdx = matchedWordNdx.get(i);
                if (perfectWordNdx >= words.length || !AddressWord.isSignificantWord(matchedWord = words[perfectWordNdx])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsMissingMatchableSignificantWord(AddressWord[] words, IntArray matchedWordNdx) {
        if (words != null && matchedWordNdx != null) {
            return this.containsMissingMatchableSignificantWord(words, matchedWordNdx, 0, words.length - 1);
        }
        return false;
    }

    private boolean containsMissingMatchableSignificantWord(AddressWord[] words, IntArray matchedWordNdx, int start, int end) {
        for (int i = start; i <= end; ++i) {
            AddressWord matchedWord;
            if (matchedWordNdx.contains(i) || !AddressWord.isSignificantWord(matchedWord = words[i])) continue;
            return true;
        }
        return false;
    }
}

