/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.matcher;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

final class ScoringCandFields {
    private final Map<FieldType, ScoringCandField> scoringFields;
    private final Deque<ScoringCandField> scoringFieldQueque;
    private final FieldType inputType;
    private final MatchingOptions matchOptions;
    private final ScoringItem scoringCandItem;
    private final Map<FieldType, FieldScore> fieldScores;
    private int candFieldMatchedCount;
    private boolean inputFieldScored;

    ScoringCandFields(FieldType inputType, ScoringItem scoringCandItem, MatchingOptions matchOptions) {
        this.inputType = inputType;
        this.scoringCandItem = scoringCandItem;
        this.matchOptions = matchOptions;
        this.fieldScores = new HashMap<FieldType, FieldScore>();
        this.scoringFields = new HashMap<FieldType, ScoringCandField>();
        this.scoringFieldQueque = new ArrayDeque<ScoringCandField>();
        this.candFieldMatchedCount = 0;
        this.inputFieldScored = false;
    }

    boolean isFieldQueueEmpty() {
        return this.scoringFieldQueque.isEmpty();
    }

    ScoringCandField pop() {
        return this.scoringFieldQueque.pop();
    }

    void add(ScoringCandField scoringCandField) {
        this.scoringFieldQueque.add(scoringCandField);
        this.scoringFields.put(scoringCandField.candFieldType, scoringCandField);
    }

    void addFirst(ScoringCandField scoringCandField) {
        this.scoringFieldQueque.addFirst(scoringCandField);
        this.scoringFields.put(scoringCandField.candFieldType, scoringCandField);
    }

    ScoringCandField get(FieldType candFieldType) {
        return this.scoringFields.get(candFieldType);
    }

    void incCandFieldMatchCount() {
        ++this.candFieldMatchedCount;
    }

    int getCandFieldMatchCount() {
        return this.candFieldMatchedCount;
    }

    void setInputFieldScored(boolean b) {
        this.inputFieldScored = b;
    }

    boolean getInputFieldScored() {
        return this.inputFieldScored;
    }

    Map<FieldType, FieldScore> getFieldScores() {
        return this.fieldScores;
    }

    boolean containsScore(FieldType type) {
        return this.fieldScores.containsKey(type);
    }

    void addFieldScore(FieldType type, FieldScore score) {
        this.fieldScores.put(type, score);
    }

    void removeFieldScore(FieldType type) {
        this.fieldScores.remove(type);
    }

    void removeFieldScore(FieldType type, boolean removeFromCandItem) {
        this.fieldScores.remove(type);
        if (removeFromCandItem) {
            this.scoringCandItem.removeFieldScore(type);
        }
    }

    FieldType getInputFieldType() {
        return this.inputType;
    }

    MatchingOptions getMatchOptions() {
        return this.matchOptions;
    }

    ScoringItem getScoringCandItem() {
        return this.scoringCandItem;
    }

    static final class ScoringCandField {
        private final FieldType candFieldType;
        private final IntArray ignoredWords;
        private final double fieldWeight;

        ScoringCandField(FieldType candFieldType, double fieldWeight) {
            this.candFieldType = candFieldType;
            this.ignoredWords = new IntArray();
            this.fieldWeight = fieldWeight;
        }

        void addMatchedToIgnoreWords(FieldScore score) {
            IntArray matchedInputWords = score.m_matchedInputWords;
            if (matchedInputWords != null && !matchedInputWords.isEmpty()) {
                int max = score.m_matchedInputWords.max();
                for (int matchedNdx = matchedInputWords.min(); matchedNdx <= max; ++matchedNdx) {
                    this.ignoredWords.add(matchedNdx);
                }
            }
        }

        public FieldType getCandFieldType() {
            return this.candFieldType;
        }

        public IntArray getIgnoredWords() {
            return this.ignoredWords;
        }

        public double getFieldWeight() {
            return this.fieldWeight;
        }

        public int hashCode() {
            return this.candFieldType.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScoringCandField)) {
                return false;
            }
            return this.candFieldType == ((ScoringCandField)other).candFieldType;
        }
    }
}

