/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.nearbystreethandler;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.INearByStreet;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.INearByStreetIdentifier;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.InternalNearByStreetAddress;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.PostThoroughFareTypeStreets;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.PreThoroughFareTypeStreets;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.core.interpolator.Interpolator;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NearByStreetHandler
implements INearByStreet<InternalNearByStreetAddress> {
    private INearByStreetIdentifier _preThoroughFareIdentifier;
    private INearByStreetIdentifier _postThoroughFareIdentifier;
    private boolean isMustMatch;

    @Override
    public List<? extends InternalNearByStreetAddress> getNearByStreetSegmentList(InternalCandidateList candidateList, IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions internalOptions) throws CGGEInternalException, DataFetchException {
        List internalNearByStreetAddresses = Collections.emptyList();
        InternalScoringAddress scoringAddressFirst = null;
        InternalScoringAddress scoringAddressSecond = null;
        scoringAddressFirst = this.getPrimaryStreetCandidate(candidateList, parsedAddr);
        for (InternalScoringAddress otherScoringAddress : candidateList.getCandidateList()) {
            if (((InternalFieldValue)scoringAddressFirst.getField(FieldType.STREET_NAME_FIELD_TYPE)).equals(otherScoringAddress.getField(FieldType.STREET_NAME_FIELD_TYPE))) continue;
            scoringAddressSecond = otherScoringAddress;
            break;
        }
        if (scoringAddressFirst.isCloseMatch() && scoringAddressSecond != null && (!internalOptions.getGeocodeConstraints().isMustMatchAddressNumber() || parsedAddr.getProbableAddressNumbers() == null && parsedAddr.getAddressNumber() == null)) {
            DirectPosition point1 = null;
            DirectPosition point2 = null;
            this.setRangePoints(scoringAddressFirst, dataManager);
            this.setRangePoints(scoringAddressSecond, dataManager);
            internalNearByStreetAddresses = new ArrayList();
            for (InternalScoringRange range1 : scoringAddressFirst.getRanges()) {
                point1 = Interpolator.interpolateShapePath(range1.getRange().getPoints());
                for (InternalScoringRange range2 : scoringAddressSecond.getRanges()) {
                    point2 = Interpolator.interpolateShapePath(range2.getRange().getPoints());
                    double distance = ReverseGeocodeUtils.getDistance((DirectPosition)point1, (DirectPosition)point2);
                    InternalNearByStreetAddress nearByStreetAddress = new InternalNearByStreetAddress();
                    nearByStreetAddress.setFirstCandSegment(range1);
                    nearByStreetAddress.setDistance(distance);
                    internalNearByStreetAddresses.add(nearByStreetAddress);
                }
            }
            Collections.sort(internalNearByStreetAddresses);
            scoringAddressFirst.setSecondaryStreetAddress(scoringAddressSecond);
            InternalCandidateList candidateListLocal = new InternalCandidateList();
            candidateListLocal.addCandidate(scoringAddressFirst);
            candidateList.getCandidateList().removeAll(candidateListLocal.getCandidateList());
            candidateList.getCandidateList().add(0, scoringAddressFirst);
        }
        return internalNearByStreetAddresses;
    }

    @Override
    public void setModifiedRanges(List<? extends InternalNearByStreetAddress> list, InternalCandidateList candidateList) throws CGGEInternalException {
        if (!list.isEmpty() && !candidateList.getCandidateList().isEmpty()) {
            InternalScoringAddress firstCand = candidateList.getCandidateList().get(0);
            InternalScoringRange firstRangeAddress = list.get(0).getFirstCandSegment();
            InternalScoringRange[] scoringRange = firstCand.getRanges();
            InternalScoringRange[] modifiedRanges = new InternalScoringRange[scoringRange.length];
            modifiedRanges[0] = firstRangeAddress;
            System.arraycopy(scoringRange, 1, modifiedRanges, 1, scoringRange.length - 1);
            firstCand.setRanges(modifiedRanges);
        }
    }

    private void setRangePoints(InternalScoringAddress address, IDataManager dataManager) throws DataFetchException {
        List<InternalRangeAddress> rangeListAdd = address.getInternalStreetAddress().getRangeList();
        ArrayList<DirectPosition> nearByGeometry = new ArrayList<DirectPosition>();
        for (InternalRangeAddress range : rangeListAdd) {
            if (!range.arePointsAssigned()) {
                range.setPoints(dataManager.getGeometry(range));
            }
            this.addEndPoints(range.getPoints(), nearByGeometry);
        }
    }

    private void addEndPoints(List<DirectPosition> rangePoints, List<DirectPosition> nearByGeometryPoints) {
        if (!rangePoints.isEmpty()) {
            nearByGeometryPoints.add(rangePoints.get(0));
            if (rangePoints.size() > 1) {
                nearByGeometryPoints.add(rangePoints.get(rangePoints.size() - 1));
            }
        }
    }

    @Override
    public void setAdditionalFiledValuesRanges(CandidateAddress candidateAddress, InternalScoringAddress scoringAddress, ICGGEParser parser) throws CGGEInternalException {
        if (scoringAddress.getSecondaryStreetAddress() != null && scoringAddress.getSecondaryStreetAddress().getFieldScore(FieldType.STREET_NAME_FIELD_TYPE) != null) {
            AddressWord[] nearByAddressWords = scoringAddress.getSecondaryStreetAddress().getFieldScore((FieldType)FieldType.STREET_NAME_FIELD_TYPE).m_candWords;
            String nearByString = parser.reconstructFieldValue(nearByAddressWords);
            candidateAddress.addKeyValueToAdditionalFields("NEAR_BY_STREET", nearByString);
        }
    }

    private InternalScoringAddress getPrimaryStreetCandidate(InternalCandidateList candidateList, ParsedAddress parsedAddr) {
        InternalScoringAddress scoringAddressFirst = null;
        scoringAddressFirst = candidateList.getCandidateList().get(0);
        String probablePrimaryStreet = parsedAddr.getProbablePrimaryStreet();
        if (!StringUtilities.isEmpty((String)parsedAddr.getNearByStreetHNR())) {
            probablePrimaryStreet = probablePrimaryStreet.replaceAll(parsedAddr.getNearByStreetHNR(), "").trim();
        }
        if (probablePrimaryStreet != null && probablePrimaryStreet.trim().length() > 0) {
            for (InternalScoringAddress otherScoringAddress : candidateList.getCandidateList()) {
                FieldScore score;
                String streetValue;
                if (otherScoringAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) == null || StringUtilities.isEmpty((String)(streetValue = this.getStreetValue(score = otherScoringAddress.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE)))) || StringUtilities.isEmpty((String)probablePrimaryStreet) || !probablePrimaryStreet.equalsIgnoreCase(streetValue) && !streetValue.toLowerCase().contains(probablePrimaryStreet.toLowerCase()) && !probablePrimaryStreet.replaceAll(" ", "").equalsIgnoreCase(streetValue.replaceAll(" ", ""))) continue;
                scoringAddressFirst = otherScoringAddress;
                break;
            }
        }
        return scoringAddressFirst;
    }

    private String getStreetValue(FieldScore score) {
        int[] matchedWords;
        String value = "";
        StringBuffer buf = new StringBuffer();
        if (null == score) {
            return value;
        }
        AddressWord[] addrWrds = score.m_inputWords;
        IntArray matchedInputWords = score.m_matchedInputWords;
        if (addrWrds != null && matchedInputWords != null && (matchedWords = matchedInputWords.asArray()) != null) {
            for (int i = 0; i < matchedWords.length; ++i) {
                AddressWord addrwrd = addrWrds[matchedWords[i]];
                buf = buf.append(addrwrd.getWord()).append(" ");
            }
        }
        value = buf.toString().trim();
        return value;
    }

    @Override
    public INearByStreetIdentifier getNearByTTStreetTypeIdentifier(String inputStreet, ICGGEParser parser) {
        if (parser.getThoroughfareTypeHandler().isThoroughfareTypeAtStart(inputStreet)) {
            if (null == this._preThoroughFareIdentifier) {
                this._preThoroughFareIdentifier = new PreThoroughFareTypeStreets();
            }
            return this._preThoroughFareIdentifier;
        }
        if (null == this._postThoroughFareIdentifier) {
            this._postThoroughFareIdentifier = new PostThoroughFareTypeStreets();
        }
        return this._postThoroughFareIdentifier;
    }

    @Override
    public boolean isMustMatchConstraintSet() {
        return this.isMustMatch;
    }

    @Override
    public void setMustMatchConstraint(boolean isMustMatch) {
        this.isMustMatch = isMustMatch;
    }
}

