/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.nearbystreethandler;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.AbstractThoroughFareTypeStreets;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.NearBy_ThoroughFareWordTags;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class PostThoroughFareTypeStreets
extends AbstractThoroughFareTypeStreets {
    @Override
    public String identifyPrimaryStreetInInput(ParsedAddress pAddrArray, ICGGEParser parser) {
        List<NearBy_ThoroughFareWordTags> thouroghFareTagsList;
        String primaryStreet = null;
        String inputStreet = null;
        if (pAddrArray != null) {
            inputStreet = (String)pAddrArray.getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE);
        }
        if (!StringUtilities.isEmpty(inputStreet) && (thouroghFareTagsList = super.getTaggedThoroughFaresfromInput(inputStreet, parser)) != null && thouroghFareTagsList.size() > 1) {
            boolean isSecondaryPresent = true;
            NearBy_ThoroughFareWordTags finaltag = thouroghFareTagsList.get(0);
            int positionDiff = 0;
            for (int i = 1; i < thouroghFareTagsList.size(); ++i) {
                positionDiff = thouroghFareTagsList.get(i).getThoroghFareIdx() - finaltag.getThoroghFareIdx();
                if (positionDiff != 1) continue;
                finaltag = thouroghFareTagsList.get(i);
                if (i != thouroghFareTagsList.size() - 1) continue;
                isSecondaryPresent = false;
            }
            if (isSecondaryPresent) {
                String intersetedThouroughFareType = finaltag.getThorughFare();
                int stringLen = inputStreet.indexOf(intersetedThouroughFareType);
                primaryStreet = super.removeDelimiters(parser, inputStreet.substring(0, stringLen + intersetedThouroughFareType.length()));
                String secondaryStreet = super.removeDelimiters(parser, inputStreet.substring(stringLen + intersetedThouroughFareType.length() + 1, inputStreet.length()));
                String probabaleHNRforPrimary = this.getHRNFromStreet(secondaryStreet, parser);
                if (!StringUtilities.isEmpty((String)probabaleHNRforPrimary)) {
                    primaryStreet = primaryStreet + " " + probabaleHNRforPrimary;
                    pAddrArray.setNearByStreetHNR(probabaleHNRforPrimary);
                }
            }
        }
        return primaryStreet;
    }

    private String getHRNFromStreet(String secondaryStreet, ICGGEParser parser) {
        ICGGEThoroughfareTypeHandler tftHandler;
        String token;
        StringTokenizer secondaryStreetTokens = new StringTokenizer(secondaryStreet, " ", false);
        LinkedList tokens = StringUtilities.tokensToList((StringTokenizer)secondaryStreetTokens);
        String probabaleHNRforPrimary = null;
        int isprobabaleHNRforPrimaryCount = 0;
        Iterator tokenIter = tokens.iterator();
        while (tokenIter.hasNext() && (StringUtilities.isNumeric((String)(token = (String)tokenIter.next())) || PostThoroughFareTypeStreets.isAlphanumeric(token))) {
            ++isprobabaleHNRforPrimaryCount;
        }
        if (isprobabaleHNRforPrimaryCount > 1) {
            probabaleHNRforPrimary = (String)tokens.get(0);
        } else if (isprobabaleHNRforPrimaryCount == 1 && !(tftHandler = parser.getThoroughfareTypeHandler()).isThoroughfareType((String)tokens.get(1))) {
            probabaleHNRforPrimary = (String)tokens.get(0);
        }
        return probabaleHNRforPrimary;
    }

    private static boolean isAlphanumeric(String str) {
        boolean isdigit = false;
        boolean isAlpha = false;
        if (str == null) {
            return false;
        }
        int strLength = str.length();
        for (int i = 0; i < strLength; ++i) {
            if (Character.isLetter(str.charAt(i))) {
                isAlpha = true;
            }
            if (!Character.isDigit(str.charAt(i))) continue;
            isdigit = true;
        }
        return isdigit && isAlpha;
    }
}

