/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.parser;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.DatasetInfoComponent;
import com.mapinfo.mapmarker.cgge.IDataSetComponent;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.address.UnitInfo;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.dp.DataTypes;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.INearByStreet;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.INearByStreetIdentifier;
import com.mapinfo.mapmarker.cgge.parser.CGGEParserTerms;
import com.mapinfo.mapmarker.cgge.parser.CGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import com.mapinfo.mapmarker.cgge.utils.RomanNumeral;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CGGEParser
extends DatasetInfoComponent
implements ICGGEParser {
    public static final String KEY_ADDRESS_NUMBER_PATTERN = "address_number_pattern";
    public static final String KEY_POSTCODE_PATTERN = "postcode_pattern";
    public static final String KEY_UNIT_PATTERN = "unit_pattern";
    public static final String KEY_REMOVAL_PATTERN = "removal_pattern";
    public static final String KEY_REPLACE_PATTERN = "replace_pattern";
    public static final String KEY_REPLACEMENT_PATTERN = "replacement_pattern";
    public static final String KEY_APPLY_REMOVAL_PATTERN_TO_FIELDS = "apply_removal_pattern_to_fields";
    public static final String KEY_THOROUGHFARETYPE_NON_DELIMITED = "thoroughfaretype_non_delimited";
    public static final String KEY_PREFER_PRE_THOROUGHFARETYPE = "prefer_pre_thoroughfaretype";
    public static final String KEY_PREFER_PRE_STREET_ADDRESS_NUMBER = "prefer_preStreet_address_number";
    public static final String KEY_DEFAULT_PRE_THOROUGHFARETYPE = "default_pre_thoroughfaretype";
    public static final String KEY_DEFAULT_POST_THOROUGHFARETYPE = "default_post_thoroughfaretype";
    private static final String KEY_STREET_INTERSECTION_PATTERN = "street_intersection_pattern";
    private static final String KEY_KEEP_ALL_DELIMITERS = "keep_all_delimiters";
    public static final String KEY_MAIN_ADDR = "mainAddr";
    public static final String KEY_POST_ADDR = "postAddr";
    public static final String KEY_POSTCODE = "postcode";
    public static final String KEY_PLACENAME = "placeName";
    public static final String KEY_AN1 = "areaName1";
    public static final String KEY_AN2 = "areaName2";
    public static final String KEY_AN3 = "areaName3";
    public static final String KEY_AN4 = "areaName4";
    public static final String KEY_HNR = "hnr";
    public static final String KEY_UNIT = "unit";
    public static final String KEY_DATATYPE_INFO = "dataTypeInfo";
    private List<FieldType> m_filterFields;
    private List<StringReplace> m_globalReplacePatternList;
    private Map<FieldType, List<StringReplace>> m_fieldReplacePatternList;
    private boolean m_nonDeimitedThroughfareTypes;
    private boolean m_preferPreThoroughfareTypes;
    private boolean m_preferPreStreetAddressNumber;
    private Map<CodedWord, List<WordAlternate>> m_altsForNormalWord;
    private Map<CodedWord, List<WordAlternate>> m_altsForThoroughfareTypeWord;
    private Pattern m_pcPattern;
    private Pattern m_hnrPattern;
    private Pattern m_unitAlphaPattern;
    private Pattern m_numericPattern;
    private Pattern m_unitPattern;
    private List<Pattern> m_streetIntersectionPatternList;
    private ArrayList<Pattern> m_cleanPattern;
    protected CGGEParserTerms m_parserTerms;
    private ICGGEThoroughfareTypeHandler m_tftHandler;
    private String m_country;
    private ICGGESoundex m_soundex;
    private ICGGEScorer m_scorer;
    private String m_language;
    private Locale m_locale;
    private boolean m_bKeepAllDelimiters = false;

    public CGGEParser() {
    }

    protected CGGEParser(CGGEParserTerms terms, ICGGESoundex soundex, ICGGEThoroughfareTypeHandler tftHandler) {
        this.m_parserTerms = terms;
        this.m_soundex = soundex;
        this.m_tftHandler = tftHandler;
        this.m_altsForThoroughfareTypeWord = new HashMap<CodedWord, List<WordAlternate>>();
        this.m_altsForNormalWord = new HashMap<CodedWord, List<WordAlternate>>();
    }

    @Override
    public ICGGEThoroughfareTypeHandler getThoroughfareTypeHandler() {
        return this.m_tftHandler;
    }

    protected InputAddress getCleanedInputAddress(InputAddress inAddr) {
        InputAddress cleanedAddress = new InputAddress();
        Map fields = inAddr.getFields();
        if (fields != null) {
            for (Map.Entry entry : fields.entrySet()) {
                FieldType type = entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                List<StringReplace> replacePatternList = this.m_fieldReplacePatternList.get(type);
                if (replacePatternList == null) {
                    replacePatternList = this.m_globalReplacePatternList;
                }
                if (replacePatternList != null) {
                    value = this.applyReplace(value, replacePatternList);
                }
                value = this.cleanString(value);
                if (this.m_filterFields == null || this.m_filterFields.contains(type)) {
                    value = this.removeUnwantedItems(value);
                }
                cleanedAddress.setField(type, value);
            }
        }
        return cleanedAddress;
    }

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        String completeStreet;
        INearByStreetIdentifier nearBystreetIdentifier;
        String primaryStreet;
        INearByStreet nearByStreetHandler;
        int i;
        ParsedAddress[] pAddrArray = new ParsedAddress[1];
        InputAddress cleanedInputAddress = this.getCleanedInputAddress(inputAddress);
        String mainAddr = (String)cleanedInputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        int intersectIndex = -1;
        pAddrArray[0] = new ParsedAddress(this.m_country, this.m_language);
        pAddrArray[0].setField(FieldType.COUNTRY_FIELD_TYPE, this.getAddressWords((String)cleanedInputAddress.getField(FieldType.COUNTRY_FIELD_TYPE)));
        pAddrArray[0].setInputAddress(inputAddress);
        if (this.m_preferPreStreetAddressNumber) {
            pAddrArray[0].setPreferHouseNumberAtStart();
        }
        pAddrArray[0].setIntersectionAddress(this.findIfIntersectionCase((String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)));
        String postAddr = (String)cleanedInputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        String areaName1 = (String)cleanedInputAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE);
        String areaName2 = (String)cleanedInputAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
        String areaName3 = (String)cleanedInputAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
        String areaName4 = (String)cleanedInputAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
        String postcode = (String)cleanedInputAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
        String placeName = (String)cleanedInputAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE);
        String hnr = (String)cleanedInputAddress.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        String unit = (String)cleanedInputAddress.getField(FieldType.UNIT_INFO_FIELD_TYPE);
        String genericField1 = (String)cleanedInputAddress.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        StringBuilder postAddrBuf = new StringBuilder();
        StringBuilder[] mainAddrBuf = null;
        if (postAddr != null) {
            postAddrBuf.append(postAddr);
        }
        if (mainAddr != null) {
            mainAddrBuf = new StringBuilder[pAddrArray.length];
            if (mainAddrBuf.length == 2) {
                mainAddrBuf[0] = new StringBuilder(mainAddr.substring(0, intersectIndex));
                mainAddrBuf[1] = intersectIndex + 2 < mainAddr.length() ? new StringBuilder(mainAddr.substring(intersectIndex + 2)) : new StringBuilder();
            } else {
                mainAddrBuf[0] = new StringBuilder(mainAddr);
            }
        } else {
            mainAddrBuf = new StringBuilder[]{new StringBuilder()};
        }
        int[] startEndNdxs = new int[2];
        for (ParsedAddress p : pAddrArray) {
            if (postcode != null || areaName3 != null || areaName4 != null || areaName1 != null || areaName2 != null) {
                p.setFlagSeperateAreaFields();
                p.setFlagSeparatePostAddressFields();
                p.setField(FieldType.POST_CODE_FIELD_TYPE, this.getAddressWords(postcode));
                p.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(areaName3));
                p.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(areaName4));
                p.setField(FieldType.AREA_NAME_2_FIELD_TYPE, this.getAddressWords(areaName2));
                p.setField(FieldType.AREA_NAME_1_FIELD_TYPE, this.getAddressWords(areaName1));
                p.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(placeName));
                continue;
            }
            if (postAddr == null) continue;
            p.setFlagSeparatePostAddressFields();
        }
        if (postcode == null && areaName3 == null && areaName4 == null && areaName2 == null && areaName1 == null && (postAddr != null || mainAddr != null || placeName != null)) {
            if (placeName != null) {
                for (ParsedAddress p : pAddrArray) {
                    p.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(placeName));
                }
            }
            if (postAddrBuf.length() > 0) {
                String pc = this.parsePostcode(postAddrBuf.toString(), startEndNdxs);
                if (pc != null) {
                    postAddrBuf.replace(startEndNdxs[0], startEndNdxs[1], "");
                    List<StringReplace> pcReplacePatternList = this.m_fieldReplacePatternList.get(FieldType.POST_CODE_FIELD_TYPE);
                    if (pcReplacePatternList != null) {
                        pc = this.applyReplace(pc, pcReplacePatternList);
                    }
                }
                for (ParsedAddress p : pAddrArray) {
                    p.setField(FieldType.POST_CODE_FIELD_TYPE, this.getAddressWords(pc));
                }
            }
        }
        if (mainAddrBuf.length > 0 && this.m_nonDeimitedThroughfareTypes) {
            for (int bufNdx = 0; bufNdx < mainAddrBuf.length; ++bufNdx) {
                this.addTypeSeparators(mainAddrBuf[bufNdx]);
            }
        }
        for (i = 0; i < pAddrArray.length; ++i) {
            List<PostCode> probablePcs;
            UnitInfo unitInfo;
            if (mainAddrBuf[i].length() <= 0) continue;
            String mainAddressStr = mainAddrBuf[i].toString();
            AddressWord[] words = this.getAddressWords(mainAddressStr, true, false);
            if (unit != null) {
                for (ParsedAddress p : pAddrArray) {
                    p.setUnitInfo(this.convertToUnitInfo(unit));
                }
            } else if (mainAddrBuf.length > 0 && (unitInfo = this.findProbableUnitInfo(words)) != null) {
                pAddrArray[i].setUnitInfo(unitInfo);
            }
            if (hnr != null) {
                pAddrArray[i].setAddressNumber(this.parserAddressNumber(hnr));
            } else if (words != null && words.length > 0) {
                unitInfo = pAddrArray[i].getUnitInfo();
                IntArray ignoreWordNdxs = null;
                if (unitInfo != null && unitInfo.getPositionInInputStreet() != null) {
                    int[] unitStartEndNdxs = unitInfo.getPositionInInputStreet();
                    ignoreWordNdxs = new IntArray(unitStartEndNdxs[1] - unitStartEndNdxs[0]);
                    for (int wordNdx = unitStartEndNdxs[0]; wordNdx < unitStartEndNdxs[1]; ++wordNdx) {
                        ignoreWordNdxs.add(wordNdx);
                    }
                }
                List<AddressNumber> addrNums = this.findProbableAddressNumbers(words, ignoreWordNdxs);
                pAddrArray[i].setProbableAddressNumbers(addrNums);
            }
            if (!pAddrArray[i].isSeperatePostAddressFields() && (probablePcs = this.findProbablePostCodes(words)) != null && probablePcs.size() > 0) {
                pAddrArray[i].setProbablePostcodes(probablePcs);
            }
            pAddrArray[i].setField(FieldType.STREET_NAME_FIELD_TYPE, words);
        }
        this.checkPostcodeAvailability(pAddrArray);
        if (postcode == null && areaName3 == null && areaName4 == null && areaName2 == null && areaName1 == null) {
            for (i = 0; i < pAddrArray.length; ++i) {
                if (postAddrBuf.length() > 0) {
                    pAddrArray[i].setField(FieldType.POST_ADDRESS_FIELD_TYPE, this.getAddressWords(postAddrBuf.toString()));
                    continue;
                }
                if (pAddrArray[i].getField(FieldType.STREET_NAME_FIELD_TYPE) != null) {
                    pAddrArray[i].setField(FieldType.POST_ADDRESS_FIELD_TYPE, pAddrArray[i].getField(FieldType.STREET_NAME_FIELD_TYPE));
                    continue;
                }
                if (mainAddrBuf[i].length() <= 0) continue;
                pAddrArray[i].setField(FieldType.POST_ADDRESS_FIELD_TYPE, this.getAddressWords(mainAddrBuf[i].toString()));
            }
        }
        if (null != (nearByStreetHandler = CGGEHandler.getInstance(this.getDataSetInfo(), this.m_country, this.m_language).getNearByStreetHandle()) && !this.isPointData() && !StringUtilities.isEmpty((String)(primaryStreet = (nearBystreetIdentifier = nearByStreetHandler.getNearByTTStreetTypeIdentifier(completeStreet = (String)pAddrArray[0].getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE), this)).identifyPrimaryStreetInInput(pAddrArray[0], this)))) {
            pAddrArray[0].setProbablePrimaryStreet(primaryStreet.trim());
            pAddrArray[0].setNearByFeature(true);
            List<AddressNumber> probableHNR = this.findProbableAddressNumbers(this.getAddressWords(primaryStreet.trim(), true, false), null);
            if (!nearByStreetHandler.isMustMatchConstraintSet() || probableHNR == null) {
                pAddrArray[0].setProbableAddressNumbers(probableHNR);
            }
        }
        return pAddrArray;
    }

    private boolean isPointData() {
        boolean isPointData = false;
        String dataTypeInfo = this.getDataSetInfo().getMetaData().getAdditionalInfo(KEY_DATATYPE_INFO);
        if (!StringUtilities.isEmpty((String)dataTypeInfo) && (dataTypeInfo.equals(DataTypes.AP.getDataType()) || dataTypeInfo.equals(DataTypes.POI.getDataType()))) {
            isPointData = true;
        }
        return isPointData;
    }

    protected boolean findIfIntersectionCase(String mainAddressString) {
        if (!StringUtilities.isEmpty((String)mainAddressString) && this.m_streetIntersectionPatternList.size() > 0) {
            Matcher matcher = null;
            for (Pattern intersectionPattern : this.m_streetIntersectionPatternList) {
                matcher = intersectionPattern.matcher(mainAddressString);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    protected void checkPostcodeAvailability(ParsedAddress[] pAddrArray) {
        if (pAddrArray.length == 2) {
            if (pAddrArray[0].getProbablePostcodes() != null && pAddrArray[1].getProbablePostcodes() == null) {
                pAddrArray[1].setProbablePostcodes(pAddrArray[0].getProbablePostcodes());
                pAddrArray[1].setField(FieldType.POST_CODE_FIELD_TYPE, this.getAddressWords(pAddrArray[0].getProbablePostcodesAsString()));
            } else if (pAddrArray[1].getProbablePostcodes() != null && pAddrArray[0].getProbablePostcodes() == null) {
                pAddrArray[0].setProbablePostcodes(pAddrArray[1].getProbablePostcodes());
                pAddrArray[0].setField(FieldType.POST_CODE_FIELD_TYPE, this.getAddressWords(pAddrArray[1].getProbablePostcodesAsString()));
            }
        }
    }

    protected String findWordAtPosition(StringBuilder buffer, int pos) {
        int i;
        int startPos = 0;
        int endPos = buffer.length();
        for (i = pos; i < endPos; ++i) {
            if (Character.isLetter(buffer.charAt(i))) continue;
            endPos = i;
            break;
        }
        for (i = pos - 1; i >= 0; --i) {
            if (Character.isLetter(buffer.charAt(i))) continue;
            startPos = i + 1;
            break;
        }
        return buffer.substring(startPos, endPos);
    }

    protected void addTypeSeparators(StringBuilder buffer) {
        int[] pos;
        int len = buffer.length();
        int startNdx = 0;
        boolean typeFound = false;
        while (len > 0 && (pos = this.m_tftHandler.findThoroughfareType(buffer.substring(startNdx, startNdx + len))) != null) {
            String chStr;
            int i;
            boolean canInsert;
            char ch;
            if (pos[0] > 0) {
                ch = buffer.charAt(startNdx + (pos[0] - 1));
                if (Character.isLetterOrDigit(ch)) {
                    String word;
                    boolean bl = canInsert = !typeFound;
                    if (!canInsert) {
                        canInsert = pos[1] == buffer.length();
                        for (i = pos[0]; i < buffer.length(); ++i) {
                            chStr = "" + buffer.charAt(i);
                            if (!this.m_parserTerms.isDelimiter(chStr)) continue;
                            if ("%".equals(chStr)) break;
                            canInsert = true;
                            break;
                        }
                    }
                    if (canInsert && (this.m_parserTerms.isAbbreviatableWord(word = this.findWordAtPosition(buffer, startNdx + pos[0])) || this.m_parserTerms.isCommonWord(word))) {
                        canInsert = false;
                    }
                    if (canInsert) {
                        buffer.insert(startNdx + pos[0], "%");
                        typeFound = true;
                    }
                }
                len = pos[1] - pos[0] > 1 ? pos[0] + 1 : pos[0];
                continue;
            }
            if (pos[0] != 0 || pos[1] >= len - 1) break;
            ch = buffer.charAt(startNdx + pos[1]);
            if (Character.isLetterOrDigit(ch)) {
                boolean bl = canInsert = !typeFound;
                if (!canInsert) {
                    canInsert = pos[1] == buffer.length();
                    for (i = pos[0]; i < buffer.length(); ++i) {
                        chStr = "" + buffer.charAt(i);
                        if (!"%".equals(chStr) && !this.m_parserTerms.isDelimiter(chStr)) continue;
                        canInsert = false;
                        break;
                    }
                }
                if (canInsert) {
                    buffer.insert(startNdx + pos[1], "%");
                    typeFound = true;
                }
                startNdx = pos[1] + 1;
            } else {
                startNdx = pos[1];
            }
            len -= startNdx;
        }
    }

    protected ICGGESoundex getSoundex() {
        if (this.m_soundex == null) {
            this.m_soundex = CGGEHandler.getInstance(this.getDataSetInfo(), this.m_country, this.m_language).getSoundex();
        }
        return this.m_soundex;
    }

    protected ICGGEScorer getScorer() {
        if (this.m_scorer == null) {
            this.m_scorer = CGGEHandler.getInstance(this.getDataSetInfo(), this.m_country, this.m_language).getScorer();
        }
        return this.m_scorer;
    }

    public final AddressWord[] getAddressWords(String str) {
        return this.getAddressWords(str, false, false);
    }

    @Override
    public AddressWord convertToAddressWord(String word, ICGGESoundex soundex) {
        AddressWord addrWord = null;
        if (word != null) {
            CodedWord codedWord = this.convertToCodedWord(word, soundex);
            addrWord = new AddressWord(codedWord);
            List<WordAlternate> alts = this.makeAlternateWords(addrWord, soundex);
            addrWord.setAlternates(alts);
        }
        return addrWord;
    }

    protected List<WordAlternate> makeAlternateWords(AddressWord addrWord, ICGGESoundex soundex) {
        String pn;
        CodedWord altCodedWord;
        short wordAttribs = addrWord.getAttributes();
        ArrayList<WordAlternate> alts = new ArrayList<WordAlternate>(10);
        List<String> altStrList = null;
        String str = addrWord.getWord();
        if (CodedWord.isAbbreviation(wordAttribs)) {
            altStrList = this.m_parserTerms.getFullWordsForAbbreviation(str);
        } else if (CodedWord.isAbbreviatable(wordAttribs)) {
            altStrList = this.m_parserTerms.getAbbreviations(str);
        }
        if (altStrList != null) {
            for (String fullWord : altStrList) {
                AddressWord[] words = this.getAddressWords(fullWord, true, true);
                WordAlternate wordAlt = null;
                wordAlt = words.length > 1 ? new WordAlternate(words) : new WordAlternate(words[0], WordAlternate.ALT_TYPE.SINGLE_WORD_ABBREVIATION);
                alts.add(wordAlt);
            }
        }
        if (CodedWord.isNumeric(wordAttribs) && !MMUtils.isNumber(str)) {
            String num = this.m_parserTerms.getNumberForNumeric(str);
            altCodedWord = this.convertToCodedWord(num, soundex);
            alts.add(new WordAlternate(new AddressWord(altCodedWord), WordAlternate.ALT_TYPE.TYPE_NUMER));
        }
        if (CodedWord.isProbableRomanNumeral(wordAttribs) && RomanNumeral.isValidRomanNumeral(str)) {
            CodedWord altCodedWord2 = this.convertToCodedWord(Integer.toString(RomanNumeral.getNumber(str)), soundex);
            alts.add(new WordAlternate(new AddressWord(altCodedWord2), WordAlternate.ALT_TYPE.TYPE_NUMER));
        }
        if (CodedWord.isThoroughfareTypeWord(wordAttribs) && (pn = this.m_tftHandler.getPreferedTypeName(str)) != null && !pn.equalsIgnoreCase(str)) {
            altCodedWord = this.convertToCodedWord(this.getUpperCase(pn), soundex);
            alts.add(new WordAlternate(new AddressWord(altCodedWord), WordAlternate.ALT_TYPE.THOROUGHFARE_TYPE));
        }
        if (alts.size() > 0) {
            return alts;
        }
        return null;
    }

    @Override
    public void assignAlternateWord(AddressWord addrWord, ICGGESoundex soundex) {
        if (addrWord != null && !addrWord.hasAlternates()) {
            short wordAttribs = addrWord.getAttributes();
            List<WordAlternate> alternates = null;
            alternates = CodedWord.isThoroughfareTypeWord(wordAttribs) ? this.m_altsForThoroughfareTypeWord.get(addrWord.getCodedWord()) : this.m_altsForNormalWord.get(addrWord.getCodedWord());
            if (alternates == null && (alternates = this.makeAlternateWords(addrWord, soundex)) != null) {
                if (CodedWord.isThoroughfareTypeWord(wordAttribs)) {
                    this.m_altsForThoroughfareTypeWord.put(addrWord.getCodedWord(), alternates);
                } else {
                    this.m_altsForNormalWord.put(addrWord.getCodedWord(), alternates);
                }
            }
            addrWord.setAlternates(alternates);
        }
    }

    @Override
    public CodedWord convertToCodedWord(String word, ICGGESoundex soundex) {
        CodedWord codedWord = null;
        if (word != null) {
            codedWord = new CodedWord(word, 0, -1);
            short wordAttribs = 0;
            if (this.m_parserTerms.isDelimiter(word)) {
                wordAttribs = (short)(wordAttribs | 0x10);
            } else {
                if (MMUtils.isNumber(word)) {
                    wordAttribs = (short)(wordAttribs | 4);
                } else if (this.m_parserTerms.isNumericWord(word)) {
                    wordAttribs = (short)(wordAttribs | 8);
                } else if (RomanNumeral.probableRomanNumeral(word)) {
                    wordAttribs = (short)(wordAttribs | 0x20);
                }
                if (this.m_parserTerms.isCommonWord(word)) {
                    wordAttribs = (short)(wordAttribs | 0x100);
                } else if (this.m_parserTerms.isArticle(word)) {
                    wordAttribs = (short)(wordAttribs | 0x400);
                }
                if (this.m_parserTerms.isDirectionalWord(word)) {
                    wordAttribs = (short)(wordAttribs | 0x800);
                }
                if (this.m_parserTerms.isAbbreviation(word)) {
                    wordAttribs = (short)(wordAttribs | 0x40);
                }
                if (this.m_parserTerms.isAbbreviatableWord(word)) {
                    wordAttribs = (short)(wordAttribs | 0x40);
                }
                if (this.m_tftHandler.isThoroughfareType(word)) {
                    wordAttribs = (short)(wordAttribs | 0x200);
                }
                if (soundex != null) {
                    codedWord.setNormalizedChars(soundex.normalizeChars(word));
                    codedWord.setSoundex(soundex.getSoundex(word));
                }
            }
            codedWord.setAttributes(wordAttribs);
        }
        return codedWord;
    }

    protected AddressWord[] getAddressWords(String str, boolean returnDelims, boolean makeAlternates) {
        int wordCount;
        AddressWord[] codedWords = null;
        String[] words = MMUtils.splitString(str, this.m_parserTerms.getDelimiters(), true);
        int n = wordCount = words == null ? 0 : words.length;
        if (wordCount > 0) {
            ArrayList<AddressWord> retWords = new ArrayList<AddressWord>(wordCount);
            ICGGESoundex soundex = this.getSoundex();
            String lastDelim = null;
            for (int i = 0; i < wordCount; ++i) {
                String word = this.getUpperCase(words[i]);
                boolean addWord = true;
                if (this.m_parserTerms.isDelimiter(word)) {
                    if (returnDelims) {
                        if (word.equals(lastDelim)) {
                            addWord = false;
                        } else if (lastDelim == null && " ".equals(word)) {
                            addWord = false;
                        }
                    } else if (!"%".equals(word)) {
                        addWord = false;
                    }
                    lastDelim = word;
                } else {
                    lastDelim = null;
                }
                if (!addWord) continue;
                AddressWord scoringWord = null;
                scoringWord = !makeAlternates ? this.convertToAddressWord(word, soundex) : new AddressWord(this.convertToCodedWord(word, soundex));
                retWords.add(scoringWord);
            }
            if (retWords.size() > 0) {
                return retWords.toArray(new AddressWord[retWords.size()]);
            }
        }
        return codedWords;
    }

    @Override
    public final String reconstructFieldValue(AddressWord[] words) {
        int wordCount;
        String fieldValue = null;
        int n = wordCount = words == null ? 0 : words.length;
        if (wordCount > 0) {
            StringBuilder buf = new StringBuilder();
            boolean lastWasDelimiter = true;
            for (int i = 0; i < wordCount; ++i) {
                AddressWord word = words[i];
                if (word == null) continue;
                String str = word.getWord();
                if (this.m_parserTerms.isDelimiter(str)) {
                    lastWasDelimiter = true;
                    if ("%".equals(str)) continue;
                    buf.append(str);
                    continue;
                }
                if (!lastWasDelimiter) {
                    buf.append(' ');
                }
                lastWasDelimiter = false;
                buf.append(str);
            }
            if (buf.length() > 0) {
                if (buf.charAt(0) == ' ') {
                    buf.deleteCharAt(0);
                }
                fieldValue = buf.toString();
            }
        }
        return fieldValue;
    }

    @Override
    public final AddressNumber parserAddressNumber(String hnrStr) {
        String delims;
        int hnrSize;
        int n;
        if (hnrStr == null) {
            n = 0;
        } else {
            hnrStr = hnrStr.trim();
            n = hnrSize = hnrStr.length();
        }
        if (hnrSize == 0) {
            return null;
        }
        int spacePos = 0;
        while ((spacePos = hnrStr.indexOf(32, spacePos)) > -1) {
            if (spacePos < hnrSize - 1 && !MMUtils.isDigit(hnrStr.charAt(spacePos + 1))) {
                hnrStr = hnrStr.substring(0, spacePos) + hnrStr.substring(spacePos + 1);
                continue;
            }
            if (spacePos > 0 && this.isDelimiter(hnrStr.charAt(spacePos - 1))) {
                hnrStr = hnrStr.substring(0, spacePos) + hnrStr.substring(spacePos + 1);
                continue;
            }
            ++spacePos;
        }
        String r1 = null;
        String r2 = null;
        int hyphenPos = hnrStr.indexOf(45);
        if (hyphenPos == -1) {
            hyphenPos = hnrStr.indexOf(32);
        }
        int delimCount = (delims = this.m_parserTerms.getDelimiters()) == null ? 0 : delims.length();
        for (int delimNdx = 0; delimNdx < delimCount; ++delimNdx) {
            int delimPos = hnrStr.indexOf(delims.charAt(delimNdx));
            if (delimPos <= 0 || hyphenPos >= 0 && delimPos >= hyphenPos) continue;
            hyphenPos = delimPos;
        }
        if (hyphenPos > 0) {
            r1 = hnrStr.substring(0, hyphenPos);
            if (hyphenPos + 1 < hnrSize) {
                r2 = hnrStr.substring(hyphenPos + 1);
            }
        } else {
            r1 = hnrStr.substring(hyphenPos + 1);
        }
        if (r1 != null) {
            AddressNumber hnr2;
            AddressNumber hnr = CGGEParser.parserAddressNumber1(r1);
            if (hnr != null && r2 != null && (hnr2 = CGGEParser.parserAddressNumber1(r2)) != null) {
                if (!hnr.isRange() && !hnr2.isRange()) {
                    hnr.setSeperatorType(0);
                    hnr.setHnrNumber2(hnr2.getHnrNumber1());
                    hnr.setHnrSuffix2(hnr2.getHnrSuffix1());
                } else {
                    hnr.setSecondHNR(hnr2);
                }
            }
            if (hnr != null) {
                return hnr;
            }
        }
        return null;
    }

    private static final AddressNumber parserAddressNumber1(String hnrStr) {
        int hnrSize = hnrStr.length();
        int slashPos = hnrStr.indexOf(47);
        if (slashPos == -1) {
            slashPos = hnrStr.indexOf(92);
        }
        String r1 = null;
        String r2 = null;
        if (slashPos > 0) {
            r1 = hnrStr.substring(0, slashPos);
            if (slashPos + 1 < hnrSize) {
                r2 = hnrStr.substring(slashPos + 1);
            }
        } else {
            r1 = hnrStr.substring(slashPos + 1);
        }
        int hnrNumber1 = 0;
        String hnrSuffix1 = null;
        int hnrNumber2 = 0;
        String hnrSuffix2 = null;
        StringBuilder specialHnr2 = new StringBuilder();
        if (r1 != null) {
            char[] chars = r1.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (MMUtils.isDigit(ch) && hnrSuffix1 == null) {
                    hnrNumber1 = hnrNumber1 * 10 + Character.digit(ch, 10);
                    continue;
                }
                if (Character.isDigit(ch) && hnrSuffix1 != null && hnrNumber1 == 0) {
                    specialHnr2.append(ch);
                    continue;
                }
                if (hnrSuffix1 == null) {
                    int delimiterChar = ch | '\u0001';
                    if (33 < delimiterChar && delimiterChar < 48) break;
                    hnrSuffix1 = "" + ch;
                    continue;
                }
                if (specialHnr2.length() > 0) {
                    if (hnrSuffix2 == null) {
                        hnrSuffix2 = "" + ch;
                        continue;
                    }
                    hnrSuffix2 = hnrSuffix2 + ch;
                    continue;
                }
                hnrSuffix1 = hnrSuffix1 + ch;
            }
        }
        boolean bSpecialHnr2 = false;
        if (specialHnr2.length() > 0) {
            hnrNumber2 = Integer.valueOf(specialHnr2.toString());
            bSpecialHnr2 = true;
        }
        if (r2 != null) {
            char[] chars = r2.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (MMUtils.isDigit(ch) && hnrSuffix2 == null) {
                    hnrNumber2 = hnrNumber2 * 10 + Character.digit(ch, 10);
                    continue;
                }
                if (hnrSuffix2 == null) {
                    int delimiterChar = ch | '\u0001';
                    if (33 < delimiterChar && delimiterChar < 48) break;
                    hnrSuffix2 = "" + ch;
                    continue;
                }
                hnrSuffix2 = hnrSuffix2 + ch;
            }
        }
        AddressNumber hnr = new AddressNumber();
        hnr.setHnrNumber1(hnrNumber1);
        hnr.setHnrSuffix1(hnrSuffix1);
        if (!(bSpecialHnr2 || hnrNumber2 <= 0 && hnrSuffix2 == null)) {
            hnr.setSeperatorType(1);
            hnr.setHnrNumber2(hnrNumber2);
            hnr.setHnrSuffix2(hnrSuffix2);
        } else if (bSpecialHnr2 && hnrNumber2 > 0) {
            hnr.setHnrNumber2(hnrNumber2);
            hnr.setHnrSuffix2(hnrSuffix2);
            hnr.setSeperatorType(2);
        }
        return hnr;
    }

    protected final String parsePostcode(String str, int[] startEndNdxs) {
        if (this.m_pcPattern == null || str == null || str.trim().length() == 0) {
            return null;
        }
        Matcher m = this.m_pcPattern.matcher(str);
        int startNdx = -1;
        int endNdx = -1;
        int lastCharCount = 0;
        while (m.find()) {
            int s = m.start();
            int e = m.end();
            int currentCharCount = e - s;
            if (currentCharCount < lastCharCount) continue;
            startNdx = s;
            endNdx = e;
            lastCharCount = currentCharCount;
        }
        if (startNdx > -1) {
            String pc = str.substring(startNdx, endNdx);
            if (startEndNdxs != null && startEndNdxs.length > 1) {
                startEndNdxs[0] = startNdx;
                startEndNdxs[1] = endNdx;
            }
            return pc;
        }
        return null;
    }

    private final boolean isDelimiter(char ch) {
        return this.m_parserTerms.getDelimiters().indexOf(ch) > -1;
    }

    @Override
    public UnitInfo convertToUnitInfo(String str) {
        return null;
    }

    protected List<AddressNumber> findProbableAddressNumbers(AddressWord[] words, IntArray ignoreWordNdxs) {
        ArrayList<AddressNumber> probableList = null;
        if (words != null && words.length > 0) {
            Matcher m;
            StringBuilder mainStr = new StringBuilder();
            int wordSize = words.length;
            boolean prevWordIsDelimiter = false;
            for (int wordNdx = 0; wordNdx < wordSize; ++wordNdx) {
                char[] chars = words[wordNdx].getWordChars();
                boolean wordIsDelimiter = CodedWord.isDelimiter(words[wordNdx].getAttributes());
                if (!(mainStr.length() <= 0 || wordIsDelimiter || prevWordIsDelimiter || chars.length == 1 && '%' == chars[0] || '%' == mainStr.charAt(mainStr.length() - 1))) {
                    mainStr.append(' ');
                }
                prevWordIsDelimiter = wordIsDelimiter;
                mainStr.append(chars);
            }
            int startNdx = 0;
            int[] startEndNdx = new int[2];
            if (this.m_hnrPattern != null && (m = this.m_hnrPattern.matcher(mainStr.substring(startNdx))) != null) {
                while (m.find()) {
                    int[] wordStartEndNdxs;
                    int start = m.start();
                    int end = m.end();
                    String found = mainStr.substring(start, end);
                    AddressNumber addNum = this.parserAddressNumber(found);
                    startEndNdx[0] = start;
                    startEndNdx[1] = end;
                    if (addNum != null && (wordStartEndNdxs = this.findWordNdxs(words, startEndNdx)) != null && wordStartEndNdxs[0] > -1) {
                        boolean ignore = false;
                        if (ignoreWordNdxs != null) {
                            for (int wordStartNdx = wordStartEndNdxs[0]; wordStartNdx < wordStartEndNdxs[1]; ++wordStartNdx) {
                                if (!ignoreWordNdxs.contains(wordStartNdx)) continue;
                                ignore = true;
                                break;
                            }
                        }
                        if (!ignore) {
                            addNum.setPositionInInputStreet(wordStartEndNdxs);
                            if (probableList == null) {
                                probableList = new ArrayList<AddressNumber>();
                            }
                            probableList.add(addNum);
                        }
                    }
                    StringTokenizer st = new StringTokenizer(found, this.m_parserTerms.getDelimiters(), true);
                    while (st.hasMoreTokens()) {
                        AddressNumber addNumNext;
                        String partial = st.nextToken();
                        end = start + partial.length();
                        if (!(this.m_parserTerms.isDelimiter(partial) || (addNumNext = this.parserAddressNumber(partial)) == null || addNum != null && addNum.equals(addNumNext))) {
                            startEndNdx[0] = start;
                            startEndNdx[1] = end;
                            int[] wordStartEndNdxs2 = this.findWordNdxs(words, startEndNdx);
                            if (wordStartEndNdxs2 != null && wordStartEndNdxs2[0] > -1) {
                                boolean ignore = false;
                                if (ignoreWordNdxs != null) {
                                    for (int wordStartNdx = wordStartEndNdxs2[0]; wordStartNdx < wordStartEndNdxs2[1]; ++wordStartNdx) {
                                        if (!ignoreWordNdxs.contains(wordStartNdx)) continue;
                                        ignore = true;
                                        break;
                                    }
                                }
                                if (!ignore) {
                                    addNumNext.setPositionInInputStreet(wordStartEndNdxs2);
                                    if (probableList == null) {
                                        probableList = new ArrayList();
                                    }
                                    probableList.add(addNumNext);
                                }
                            }
                        }
                        start = end;
                    }
                    startNdx = end;
                }
            }
        }
        return probableList;
    }

    protected List<PostCode> findProbablePostCodes(AddressWord[] words) {
        ArrayList<PostCode> probableList = null;
        if (words != null && words.length > 0) {
            StringBuilder mainStr = new StringBuilder();
            int wordSize = words.length;
            boolean prevWordIsDelimiter = false;
            for (int wordNdx = 0; wordNdx < wordSize; ++wordNdx) {
                char[] chars = words[wordNdx].getWordChars();
                boolean wordIsDelimiter = CodedWord.isDelimiter(words[wordNdx].getAttributes());
                if (!(mainStr.length() <= 0 || wordIsDelimiter || prevWordIsDelimiter || chars.length == 1 && '%' == chars[0] || '%' == mainStr.charAt(mainStr.length() - 1))) {
                    mainStr.append(' ');
                }
                prevWordIsDelimiter = wordIsDelimiter;
                mainStr.append(chars);
            }
            int startNdx = 0;
            if (this.m_pcPattern != null) {
                Matcher m = this.m_pcPattern.matcher(mainStr.substring(startNdx));
                List<StringReplace> replacePatterList = this.m_fieldReplacePatternList.get(FieldType.POST_CODE_FIELD_TYPE);
                StringBuilder pcStrBuilder = new StringBuilder(20);
                if (m != null) {
                    while (m.find()) {
                        int[] startEndNdx = new int[]{m.start(), m.end()};
                        PostCode pc = new PostCode();
                        int[] wordStartEndNdxs = this.findWordNdxs(words, startEndNdx);
                        if (wordStartEndNdxs != null && wordStartEndNdxs[0] > -1) {
                            int pcWordCount = wordStartEndNdxs[1] - wordStartEndNdxs[0];
                            int pcWordNdx = wordStartEndNdxs[0];
                            for (int wordAdded = 0; wordAdded < pcWordCount; ++wordAdded) {
                                pcStrBuilder.append(words[pcWordNdx].getWordChars());
                                if (!CodedWord.isDelimiter(words[pcWordNdx].getAttributes()) && wordAdded + 1 < pcWordCount) {
                                    pcStrBuilder.append(' ');
                                }
                                ++pcWordNdx;
                            }
                            String pcStr = replacePatterList == null ? pcStrBuilder.toString() : this.applyReplace(pcStrBuilder.toString(), replacePatterList);
                            pc.setWords(this.getAddressWords(pcStr, true, false));
                            pc.setPositionInInputStreet(wordStartEndNdxs);
                            if (probableList == null) {
                                probableList = new ArrayList<PostCode>();
                            }
                            probableList.add(pc);
                            pcStrBuilder.delete(0, pcStrBuilder.length());
                        }
                        startNdx = startEndNdx[1] + 1;
                    }
                }
            }
        }
        return probableList;
    }

    protected UnitInfo findProbableUnitInfo(AddressWord[] words) {
        UnitInfo unitInfo = null;
        if (this.m_unitPattern != null && words != null && words.length > 0) {
            StringBuilder mainStr = new StringBuilder();
            int wordSize = words.length;
            for (int wordNdx = 0; wordNdx < wordSize; ++wordNdx) {
                char[] chars = words[wordNdx].getWordChars();
                if (mainStr.length() > 0 && (chars.length != 1 || '%' != chars[0]) && '%' != mainStr.charAt(mainStr.length() - 1)) {
                    mainStr.append(' ');
                }
                mainStr.append(chars);
            }
            int startNdx = 0;
            Matcher m = this.m_unitPattern.matcher(mainStr.substring(startNdx));
            if (m != null && m.find()) {
                int[] startEndNdx = new int[]{m.start(), m.end()};
                String found = mainStr.substring(startEndNdx[0], startEndNdx[1]);
                int[] wordStartEndNdxs = this.findWordNdxs(words, startEndNdx);
                unitInfo = this.convertToUnitInfo(found);
                if (wordStartEndNdxs != null && wordStartEndNdxs[0] > -1) {
                    unitInfo.setPositionInInputStreet(wordStartEndNdxs);
                }
                startNdx = startEndNdx[1] + 1;
            }
        }
        return unitInfo;
    }

    private int[] findWordNdxs(AddressWord[] words, int[] startEndNdx) {
        int[] wordStartEndNdx = new int[]{-1, -1};
        int wordArraySize = words.length;
        if (words != null && startEndNdx != null) {
            int startPos = 0;
            boolean prevWordIsDelimiter = false;
            for (int wordNdx = 0; wordNdx < wordArraySize; ++wordNdx) {
                boolean wordIsDelimiter = CodedWord.isDelimiter(words[wordNdx].getAttributes());
                int endPos = startPos + words[wordNdx].getWordLength();
                char[] chars = words[wordNdx].getWordChars();
                if (!(wordNdx <= 0 || wordIsDelimiter || prevWordIsDelimiter || chars.length == 1 && '%' == chars[0] || "%" == words[wordNdx - 1].getWord())) {
                    ++endPos;
                }
                if (wordStartEndNdx[0] == -1 && startEndNdx[0] >= startPos && startEndNdx[0] < endPos) {
                    wordStartEndNdx[0] = wordNdx;
                }
                if (wordStartEndNdx[1] == -1 && startEndNdx[1] >= startPos && startEndNdx[1] < endPos) {
                    wordStartEndNdx[1] = wordNdx;
                    if (wordStartEndNdx[1] == wordStartEndNdx[0]) {
                        wordStartEndNdx[1] = wordStartEndNdx[1] + 1;
                    }
                }
                if (wordStartEndNdx[0] > -1 && wordStartEndNdx[1] > -1) break;
                startPos = endPos;
                prevWordIsDelimiter = wordIsDelimiter;
            }
        }
        if (wordStartEndNdx[0] > -1 && wordStartEndNdx[1] == -1) {
            wordStartEndNdx[1] = wordArraySize;
        }
        return wordStartEndNdx;
    }

    private String removeUnwantedItems(String str) {
        StringBuilder builder = null;
        if (this.m_cleanPattern != null && this.m_cleanPattern.size() > 0) {
            if (str != null) {
                builder = new StringBuilder(str);
                Matcher m = null;
                for (Pattern p : this.m_cleanPattern) {
                    m = p.matcher(builder);
                    while (m.find()) {
                        builder.delete(m.start(), m.end());
                        m = p.matcher(builder);
                    }
                }
            }
        } else {
            return str;
        }
        return builder != null ? builder.toString() : null;
    }

    protected String cleanString(String str) {
        ICGGEParserTerms parserTerms = this.getParserTerms();
        if (str != null && !parserTerms.isDelimiter(str)) {
            IntArray removeNdxs = new IntArray();
            IntArray insertNdxs = new IntArray();
            str = str.trim().toUpperCase();
            char[] chars = str.toCharArray();
            int len = chars.length;
            for (int i = 0; i < len; ++i) {
                char ch = chars[i];
                if (ch == '\"') {
                    removeNdxs.add(i);
                    continue;
                }
                if (ch == '\'' && (i == 0 || i == len - 1)) {
                    removeNdxs.add(i);
                    continue;
                }
                if (ch != ' ') continue;
                if (i > 0 && i < len - 1) {
                    char nextCh = chars[i + 1];
                    if (nextCh == '\'' || nextCh == '-') {
                        removeNdxs.add(i);
                        ++i;
                        continue;
                    }
                    if (nextCh == ' ') {
                        removeNdxs.add(i);
                        continue;
                    }
                    char prevCh = chars[i - 1];
                    if (prevCh != '\'' && prevCh != '-') continue;
                    removeNdxs.add(i);
                    continue;
                }
                removeNdxs.add(i);
            }
            int itemsToRemove = removeNdxs.size();
            int itemsToInsert = insertNdxs.size();
            if (itemsToRemove > 0 || itemsToInsert > 0) {
                int newSize = len - itemsToRemove + itemsToInsert;
                if (newSize > 0) {
                    int i;
                    if (itemsToRemove == len) {
                        return "";
                    }
                    char[] newChars = new char[newSize];
                    int lastRemoveAt = -1;
                    int added = 0;
                    if (itemsToRemove > 0) {
                        for (i = 0; i < itemsToRemove; ++i) {
                            int removeAt = removeNdxs.get(i);
                            if (removeAt > 0 && lastRemoveAt + 1 != removeAt) {
                                int itemsToCopy = lastRemoveAt > -1 ? removeAt - lastRemoveAt - 1 : removeAt;
                                CharArray.arraycopy(chars, lastRemoveAt + 1, newChars, added, itemsToCopy);
                                added += itemsToCopy;
                            }
                            lastRemoveAt = removeAt;
                        }
                        if (lastRemoveAt != -1 && lastRemoveAt < len - 1) {
                            CharArray.arraycopy(chars, lastRemoveAt + 1, newChars, added, len - lastRemoveAt - 1);
                        }
                    } else {
                        CharArray.arraycopy(chars, 0, newChars, 0, chars.length);
                    }
                    for (i = 0; i < itemsToInsert; ++i) {
                        int insertAt = insertNdxs.get(i);
                        if (insertAt < newSize - 1) {
                            CharArray.arraycopy(newChars, insertAt, newChars, insertAt + 1, newSize - insertAt - 1);
                        }
                        newChars[insertAt] = 32;
                    }
                    return new String(newChars);
                }
                return "";
            }
            if (chars.length > 0) {
                return new String(chars);
            }
            return "";
        }
        return null;
    }

    protected int thoroughfareTypeDelimiterPosition(String str) {
        int[] startEnd;
        int returnpos = -1;
        if (str.length() > 0 && (startEnd = this.m_tftHandler.findThoroughfareType(str)) != null) {
            char ch;
            if (startEnd[0] > 0) {
                char ch2 = str.charAt(startEnd[0] - 1);
                if (Character.isLetterOrDigit(ch2)) {
                    returnpos = startEnd[0];
                }
            } else if (startEnd[1] < str.length() && Character.isLetterOrDigit(ch = str.charAt(startEnd[1]))) {
                returnpos = startEnd[1];
            }
        }
        return returnpos;
    }

    protected String getWordWithCharacterNdx(String str, int pos) {
        int startNdx = 0;
        for (int i = 0; i < pos; ++i) {
            if (!this.m_parserTerms.isDelimiter(str.substring(i, i + 1))) continue;
            startNdx = i + 1;
        }
        int endNdx = pos + 1;
        for (int i = pos + 1; i < str.length() && !this.m_parserTerms.isDelimiter(str.substring(i, i + 1)); ++i) {
            ++endNdx;
        }
        return str.substring(startNdx, endNdx);
    }

    @Override
    public AddressWord[] splitIntoWeightedWords(String str, FieldType type) {
        if (str != null) {
            AddressWord[] addrWords;
            int wordCount;
            String word;
            int delimPos;
            str = this.getUpperCase(str.trim());
            if (!(type != FieldType.STREET_NAME_FIELD_TYPE || !this.m_nonDeimitedThroughfareTypes || (delimPos = this.thoroughfareTypeDelimiterPosition(str)) <= -1 || this.m_tftHandler.isThoroughfareType(word = this.getWordWithCharacterNdx(str, delimPos)) || this.m_parserTerms.isAbbreviatableWord(word) || this.m_parserTerms.isNumericWord(word) || RomanNumeral.probableRomanNumeral(word) || this.m_parserTerms.isDirectionalWord(word))) {
                str = str.substring(0, delimPos) + "%" + str.substring(delimPos);
            }
            int n = wordCount = (addrWords = this.getAddressWords(str, true, false)) == null ? 0 : addrWords.length;
            if (wordCount > 0) {
                int i;
                IntArray delimiterNdx = new IntArray(wordCount);
                IntArray commonWordNdx = new IntArray(wordCount);
                IntArray streetTypeWordNdx = new IntArray(wordCount);
                IntArray buildingWordsNdx = new IntArray(wordCount);
                IntArray firmWordsNdx = new IntArray(wordCount);
                IntArray directionalWordsNdx = new IntArray(wordCount);
                IntArray normalWordsNdx = new IntArray(wordCount);
                IntArray articleNdx = new IntArray(wordCount);
                for (i = 0; i < wordCount; ++i) {
                    AddressWord addrWord = addrWords[i];
                    String word2 = addrWord.getWord();
                    addrWord.m_wordType = type;
                    if (word2.length() == 1 && this.m_parserTerms.getDelimiters().indexOf(word2) > -1) {
                        delimiterNdx.add(i);
                        continue;
                    }
                    if (type == FieldType.STREET_NAME_FIELD_TYPE && this.m_tftHandler.isThoroughfareType(word2)) {
                        streetTypeWordNdx.add(i);
                        continue;
                    }
                    if (type == FieldType.STREET_NAME_FIELD_TYPE && (i == 0 || i < wordCount - 1) && this.m_parserTerms.isDirectionalWord(word2)) {
                        directionalWordsNdx.add(i);
                        continue;
                    }
                    if (this.m_parserTerms.isArticle(word2)) {
                        articleNdx.add(i);
                        continue;
                    }
                    if (this.m_parserTerms.isCommonWord(word2)) {
                        commonWordNdx.add(i);
                        continue;
                    }
                    if (type == FieldType.RANGE_PLACE_NAME_FIELD_TYPE && this.m_parserTerms.isBuildingIdentifier(word2)) {
                        buildingWordsNdx.add(i);
                        continue;
                    }
                    if (type == FieldType.UNIT_PLACE_NAME_FIELD_TYPE && this.m_parserTerms.isFirmIdentifier(word2)) {
                        firmWordsNdx.add(i);
                        continue;
                    }
                    normalWordsNdx.add(i);
                }
                if (type == FieldType.STREET_NAME_FIELD_TYPE && streetTypeWordNdx.size() > 0) {
                    for (i = 0; i < streetTypeWordNdx.size(); ++i) {
                        int pos = streetTypeWordNdx.get(i);
                        boolean remove = false;
                        if (pos == wordCount - 1) {
                            if (normalWordsNdx.size() <= 0 && commonWordNdx.size() <= 0 && streetTypeWordNdx.size() <= 1 && directionalWordsNdx.size() <= 0 && articleNdx.size() <= 0) {
                                remove = true;
                            }
                        } else if (pos == 0) {
                            if (normalWordsNdx.size() <= 0 && commonWordNdx.size() <= 0 && streetTypeWordNdx.size() <= 1 && articleNdx.size() <= 0 && directionalWordsNdx.size() <= 0 && articleNdx.size() <= 0) {
                                remove = true;
                            }
                        } else if (delimiterNdx.size() > 0 || directionalWordsNdx.size() > 0) {
                            int j;
                            boolean isType = true;
                            for (j = 0; j < pos; ++j) {
                                if (directionalWordsNdx.contains(j) || delimiterNdx.contains(j)) continue;
                                isType = false;
                            }
                            isType = false;
                            if (false) {
                                isType = true;
                                for (j = pos; j < wordCount; ++j) {
                                    if (directionalWordsNdx.contains(j) || delimiterNdx.contains(j)) continue;
                                    isType = false;
                                }
                            }
                            if (!isType) {
                                remove = true;
                            }
                        } else {
                            remove = true;
                        }
                        if (!remove) continue;
                        streetTypeWordNdx.removeAt(i--);
                        AddressWord addrWord = addrWords[pos];
                        addrWord.setAttribute((short)(addrWord.getAttributes() ^ 0x200));
                        String word3 = addrWord.getWord();
                        if (type == FieldType.STREET_NAME_FIELD_TYPE && (pos == 0 || pos < wordCount - 1) && this.m_parserTerms.isDirectionalWord(word3)) {
                            directionalWordsNdx.add(pos);
                            continue;
                        }
                        if (this.m_parserTerms.isArticle(word3)) {
                            articleNdx.add(pos);
                            continue;
                        }
                        if (this.m_parserTerms.isCommonWord(word3)) {
                            commonWordNdx.add(pos);
                            continue;
                        }
                        if (type == FieldType.RANGE_PLACE_NAME_FIELD_TYPE && this.m_parserTerms.isBuildingIdentifier(word3)) {
                            buildingWordsNdx.add(pos);
                            continue;
                        }
                        if (type == FieldType.UNIT_PLACE_NAME_FIELD_TYPE && this.m_parserTerms.isFirmIdentifier(word3)) {
                            firmWordsNdx.add(i);
                            continue;
                        }
                        normalWordsNdx.add(pos);
                    }
                    if (streetTypeWordNdx.size() == 2 && normalWordsNdx.size() == 0 && commonWordNdx.size() == 0) {
                        if (this.m_preferPreThoroughfareTypes) {
                            streetTypeWordNdx.removeAt(1);
                        } else {
                            streetTypeWordNdx.removeAt(0);
                        }
                    }
                }
                if (streetTypeWordNdx.size() > 0 && (normalWordsNdx.size() > 0 || commonWordNdx.size() > 0 || directionalWordsNdx.size() > 0 || buildingWordsNdx.size() > 0 || firmWordsNdx.size() > 0 || articleNdx.size() > 0)) {
                    for (i = 0; i < streetTypeWordNdx.size(); ++i) {
                        AddressWord word4 = addrWords[streetTypeWordNdx.get(i)];
                        word4.m_wordType = FieldType.POST_THOROUGHFARE_FIELD_TYPE;
                        String preferedName = this.m_tftHandler.getPreferedTypeName(word4.getWord());
                        WordAlternate altWord = new WordAlternate(this.convertToAddressWord(preferedName, this.getSoundex()), WordAlternate.ALT_TYPE.THOROUGHFARE_TYPE);
                        word4.addAlternate(altWord);
                    }
                }
                for (i = 0; i < directionalWordsNdx.size(); ++i) {
                    commonWordNdx.add(directionalWordsNdx.get(i));
                }
                this.calculateWordsWeight(addrWords, delimiterNdx, articleNdx, commonWordNdx, streetTypeWordNdx, buildingWordsNdx, firmWordsNdx);
                return addrWords;
            }
        }
        return null;
    }

    private void calculateWordsWeight(AddressWord[] scoringWords, IntArray delimiterNdxList, IntArray articleNdxList, IntArray commonWordNdxList, IntArray streetTypeNdxList, IntArray buildingWordNdxList, IntArray firmWordNdxList) {
        int wordCount = scoringWords.length;
        if (wordCount > 0) {
            byte checkWeight;
            byte currentWeight;
            int ndx;
            int i;
            this.getScorer().addWeights(scoringWords);
            int size = delimiterNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = delimiterNdxList.get(i);
                scoringWords[ndx].m_weight = 0;
            }
            size = streetTypeNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = streetTypeNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                if (currentWeight > this.m_parserTerms.getThoroughfareTypeWeight()) {
                    currentWeight = this.m_parserTerms.getThoroughfareTypeWeight();
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            size = articleNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = articleNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                if (currentWeight > this.m_parserTerms.getArticleWeight()) {
                    currentWeight = this.m_parserTerms.getArticleWeight();
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            size = commonWordNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = commonWordNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                if (currentWeight > this.m_parserTerms.getCommonWordWeight()) {
                    currentWeight = this.m_parserTerms.getCommonWordWeight();
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            size = buildingWordNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = buildingWordNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                checkWeight = this.m_parserTerms.getBuildingIdentiferWeight();
                if (currentWeight > checkWeight) {
                    currentWeight = checkWeight;
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            size = firmWordNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = firmWordNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                checkWeight = this.m_parserTerms.getFirmIdentiferWeight();
                if (currentWeight > checkWeight) {
                    currentWeight = checkWeight;
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            int totalWeight = 0;
            for (int i2 = 0; i2 < scoringWords.length; ++i2) {
                totalWeight = (byte)(totalWeight + scoringWords[i2].m_weight);
            }
            if (totalWeight < 100) {
                int combined;
                int i3;
                int perWordWeight;
                int i4;
                int remaining = 100 - totalWeight;
                IntArray mainWordsNdx = new IntArray(5);
                for (i4 = 0; i4 < wordCount; ++i4) {
                    if (commonWordNdxList.contains(i4) || streetTypeNdxList.contains(i4) || buildingWordNdxList.contains(i4) || delimiterNdxList.contains(i4) || firmWordNdxList.contains(i4) || articleNdxList.contains(i4)) continue;
                    mainWordsNdx.add(i4);
                }
                if (mainWordsNdx.size() > 0) {
                    while (remaining > 0) {
                        perWordWeight = mainWordsNdx.size() < remaining ? remaining / mainWordsNdx.size() : remaining;
                        for (i3 = 0; i3 < wordCount && remaining > 0; ++i3) {
                            if (!mainWordsNdx.contains(i3)) continue;
                            scoringWords[i3].m_weight = (byte)(scoringWords[i3].m_weight + perWordWeight);
                            remaining -= perWordWeight;
                        }
                    }
                }
                if (remaining > 0 && commonWordNdxList.size() > 0) {
                    while (remaining > 0) {
                        perWordWeight = commonWordNdxList.size() < remaining ? remaining / commonWordNdxList.size() : remaining;
                        for (i3 = 0; i3 < wordCount && remaining > 0; ++i3) {
                            if (!commonWordNdxList.contains(i3)) continue;
                            scoringWords[i3].m_weight = (byte)(scoringWords[i3].m_weight + perWordWeight);
                            remaining -= perWordWeight;
                        }
                    }
                }
                if (remaining > 0 && mainWordsNdx.size() < 1 && commonWordNdxList.size() < 1 && articleNdxList.size() > 0 && streetTypeNdxList.size() > 0 && (combined = this.m_parserTerms.getArticleWeight() + this.m_parserTerms.getThoroughfareTypeWeight()) > 0) {
                    int i5;
                    int perWordWeight2;
                    int articleWeight = (int)(this.m_parserTerms.getArticleWeight() == 0 ? 0.0 : (double)remaining * ((double)this.m_parserTerms.getArticleWeight() / (double)combined));
                    int typeWeight = (int)(this.m_parserTerms.getThoroughfareTypeWeight() == 0 ? 0.0 : (double)remaining * ((double)this.m_parserTerms.getThoroughfareTypeWeight() / (double)combined));
                    if (articleWeight > 0) {
                        perWordWeight2 = articleNdxList.size() < remaining ? articleWeight / articleNdxList.size() : articleWeight;
                        for (i5 = 0; i5 < wordCount && remaining > 0; ++i5) {
                            if (!articleNdxList.contains(i5)) continue;
                            scoringWords[i5].m_weight = (byte)(scoringWords[i5].m_weight + perWordWeight2);
                            remaining -= perWordWeight2;
                        }
                    }
                    if (typeWeight > 0) {
                        perWordWeight2 = streetTypeNdxList.size() < remaining ? typeWeight / streetTypeNdxList.size() : typeWeight;
                        for (i5 = 0; i5 < wordCount && remaining > 0; ++i5) {
                            if (!streetTypeNdxList.contains(i5)) continue;
                            scoringWords[i5].m_weight = (byte)(scoringWords[i5].m_weight + perWordWeight2);
                            remaining -= perWordWeight2;
                        }
                    }
                }
                if (remaining > 0 && wordCount != delimiterNdxList.size()) {
                    while (remaining > 0) {
                        for (i4 = 0; i4 < wordCount && remaining > 0; ++i4) {
                            if (delimiterNdxList.contains(i4)) continue;
                            scoringWords[i4].m_weight = (byte)(scoringWords[i4].m_weight + 1);
                            --remaining;
                        }
                    }
                }
            }
        }
    }

    @Override
    public ICGGEParserTerms getParserTerms() {
        return this.m_parserTerms;
    }

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        this.m_locale = StringUtilities.isEmpty((String)language) ? null : new Locale(language, country);
        this.m_altsForThoroughfareTypeWord = new HashMap<CodedWord, List<WordAlternate>>();
        this.m_altsForNormalWord = new HashMap<CodedWord, List<WordAlternate>>();
        Properties prop = null;
        prop = this.getConfiguration(country, language, "_Parser");
        this.initializeParserTerms();
        this.m_nonDeimitedThroughfareTypes = PropertiesUtil.getBooleanPropertyValue(prop, KEY_THOROUGHFARETYPE_NON_DELIMITED, false);
        this.m_preferPreThoroughfareTypes = PropertiesUtil.getBooleanPropertyValue(prop, KEY_PREFER_PRE_THOROUGHFARETYPE, false);
        this.m_preferPreStreetAddressNumber = PropertiesUtil.getBooleanPropertyValue(prop, KEY_PREFER_PRE_STREET_ADDRESS_NUMBER, false);
        this.m_bKeepAllDelimiters = PropertiesUtil.getBooleanPropertyValue(prop, KEY_KEEP_ALL_DELIMITERS, false);
        String temp = prop.getProperty(KEY_DEFAULT_PRE_THOROUGHFARETYPE);
        if (temp == null || temp.trim().length() > 0) {
            // empty if block
        }
        if ((temp = prop.getProperty(KEY_DEFAULT_POST_THOROUGHFARETYPE)) == null || temp.trim().length() > 0) {
            // empty if block
        }
        try {
            this.m_tftHandler = new CGGEThoroughfareTypeHandler(this.m_country, this.m_language, this.m_nonDeimitedThroughfareTypes, this.m_preferPreThoroughfareTypes);
            ((IDataSetComponent)((Object)this.m_tftHandler)).setDataSetInfo(this.getDataSetInfo());
            this.m_tftHandler.init(country, language);
        }
        catch (CGGEInternalException e) {
            throw new CGGERuntimeException(e);
        }
        String pattern = null;
        pattern = prop.getProperty(KEY_ADDRESS_NUMBER_PATTERN);
        if (pattern != null && pattern.trim().length() > 0) {
            this.m_hnrPattern = Pattern.compile(pattern, 2);
        }
        if ((pattern = prop.getProperty(KEY_POSTCODE_PATTERN)) != null && pattern.trim().length() > 0) {
            this.m_pcPattern = Pattern.compile(pattern, 2);
        }
        if ((pattern = prop.getProperty(KEY_UNIT_PATTERN)) != null && pattern.trim().length() > 0) {
            this.m_unitPattern = Pattern.compile(pattern, 2);
        }
        Iterator<Object> keyItr = prop.keySet().iterator();
        String key = null;
        while (keyItr.hasNext()) {
            key = (String)keyItr.next();
            if (!key.startsWith(KEY_REMOVAL_PATTERN)) continue;
            ArrayList<Pattern> arrayList = this.m_cleanPattern = this.m_cleanPattern == null ? new ArrayList<Pattern>() : this.m_cleanPattern;
            pattern = prop.getProperty(key);
            if (pattern == null || pattern.trim().length() <= 0) continue;
            this.m_cleanPattern.add(Pattern.compile(pattern, 2));
        }
        temp = prop.getProperty(KEY_APPLY_REMOVAL_PATTERN_TO_FIELDS);
        if (temp != null && temp.trim().length() > 0) {
            String[] tokens = temp.split(",");
            this.m_filterFields = new ArrayList<FieldType>();
            for (String t : tokens) {
                if (t.trim().length() <= 0) continue;
                if (KEY_MAIN_ADDR.equals(t)) {
                    this.m_filterFields.add(FieldType.STREET_NAME_FIELD_TYPE);
                    continue;
                }
                if (KEY_POST_ADDR.equals(t)) {
                    this.m_filterFields.add(FieldType.POST_ADDRESS_FIELD_TYPE);
                    continue;
                }
                if (KEY_POSTCODE.equals(t)) {
                    this.m_filterFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    continue;
                }
                if (KEY_PLACENAME.equals(t)) {
                    this.m_filterFields.add(FieldType.PLACE_NAME_FIELD_TYPE);
                    continue;
                }
                if (KEY_AN1.equals(t)) {
                    this.m_filterFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    continue;
                }
                if (KEY_AN2.equals(t)) {
                    this.m_filterFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    continue;
                }
                if (KEY_AN3.equals(t)) {
                    this.m_filterFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    continue;
                }
                if (KEY_AN4.equals(t)) {
                    this.m_filterFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    continue;
                }
                if (KEY_HNR.equals(t)) {
                    this.m_filterFields.add(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                    continue;
                }
                if (!KEY_UNIT.equals(t)) continue;
                this.m_filterFields.add(FieldType.UNIT_INFO_FIELD_TYPE);
            }
        }
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            Object keyObj = entry.getKey();
            Object valueObj = entry.getValue();
            if (!(keyObj instanceof String) || valueObj == null || !(key = (String)keyObj).startsWith(KEY_REPLACE_PATTERN)) continue;
            String value = (String)valueObj;
            StringReplace strReplace = new StringReplace();
            strReplace.m_replace = value;
            key = KEY_REPLACEMENT_PATTERN + key.substring(KEY_REPLACE_PATTERN.length());
            String replacement = prop.getProperty(key);
            String string = strReplace.m_replacement = replacement == null ? "" : replacement;
            if (this.m_globalReplacePatternList == null) {
                this.m_globalReplacePatternList = new ArrayList<StringReplace>(5);
            }
            this.m_globalReplacePatternList.add(strReplace);
        }
        this.m_fieldReplacePatternList = new HashMap<FieldType, List<StringReplace>>();
        FieldType[] fieldTypes = FieldType.getPredefinedFieldTypes();
        StringBuilder builder = new StringBuilder(25);
        StringBuilder builder1 = new StringBuilder(25);
        for (int fieldNdx = 0; fieldNdx < fieldTypes.length; ++fieldNdx) {
            FieldType fieldType = fieldTypes[fieldNdx];
            String fieldName = fieldType.getName();
            builder.append(fieldName);
            builder.append("_");
            builder.append(KEY_REPLACE_PATTERN);
            builder.append("_");
            builder1.append(fieldName);
            builder1.append("_");
            builder1.append(KEY_REPLACEMENT_PATTERN);
            builder1.append("_");
            int n = builder.length();
            int key1Size = builder1.length();
            ArrayList<StringReplace> replaceList = new ArrayList<StringReplace>(5);
            for (int i = 1; i <= 100; ++i) {
                builder.append(i);
                String replace = prop.getProperty(builder.toString());
                if (replace == null) break;
                builder1.append(i);
                String replacement = prop.getProperty(builder1.toString());
                if (replacement != null) {
                    StringReplace strReplace = new StringReplace(replace, replacement);
                    replaceList.add(strReplace);
                }
                builder.delete(n, builder.length());
                builder1.delete(key1Size, builder1.length());
            }
            if (replaceList != null && replaceList.size() > 0) {
                this.m_fieldReplacePatternList.put(fieldType, replaceList);
            }
            builder.delete(0, builder.length());
            builder1.delete(0, builder1.length());
        }
        Set<Object> keySet = prop.keySet();
        String intersectionPattern = null;
        this.m_streetIntersectionPatternList = new ArrayList<Pattern>();
        for (Object t : keySet) {
            if (!((String)t).startsWith(KEY_STREET_INTERSECTION_PATTERN) || StringUtilities.isEmpty((String)(intersectionPattern = prop.getProperty((String)t)))) continue;
            this.m_streetIntersectionPatternList.add(Pattern.compile(intersectionPattern, 2));
        }
        return true;
    }

    protected void initializeParserTerms() {
        this.m_parserTerms = new CGGEParserTerms();
        this.m_parserTerms.setDataSetInfo(this.getDataSetInfo());
        this.m_parserTerms.init(this.m_country, this.m_language);
    }

    protected String getUpperCase(String value) {
        if (!StringUtilities.isEmpty((String)value)) {
            return this.m_locale != null ? value.toUpperCase(this.m_locale) : value.toUpperCase();
        }
        return value;
    }

    @Override
    public String getPostDirectional(AddressWord[] words) {
        int wordLen = words == null ? 0 : words.length;
        String postDir = null;
        for (int i = 0; i < wordLen; ++i) {
            AddressWord word = words[i];
            if (word.m_wordType != FieldType.PRE_DIRECTIONAL_FIELD_TYPE) continue;
            postDir = word.getWord();
            break;
        }
        return postDir;
    }

    protected String applyReplace(String str, List<StringReplace> replaceList) {
        String retString = str;
        if (replaceList != null && retString != null) {
            for (StringReplace sr : replaceList) {
                retString = retString.replaceAll(sr.m_replace, sr.m_replacement);
            }
        }
        return retString;
    }

    @Override
    public String getPostThoroughFareName(AddressWord[] words) {
        int wordLen = words == null ? 0 : words.length;
        int postTypeNdx = -1;
        for (int i = wordLen - 1; i > 0; --i) {
            if (words[i].m_wordType != FieldType.POST_THOROUGHFARE_FIELD_TYPE) continue;
            postTypeNdx = i;
        }
        if (postTypeNdx > -1) {
            AddressWord preTypeWord;
            String postType = this.m_tftHandler.getProperTypeName(words[postTypeNdx].getWord());
            if (this.m_nonDeimitedThroughfareTypes && !CodedWord.isDelimiter((preTypeWord = words[postTypeNdx - 1]).getAttributes()) && !"%".equals(preTypeWord.getWord())) {
                postType = " " + postType;
            }
            return postType;
        }
        return null;
    }

    @Override
    public String getPreDirectional(AddressWord[] words) {
        int wordLen = words == null ? 0 : words.length;
        String preDir = null;
        for (int i = 0; i < wordLen; ++i) {
            AddressWord word = words[i];
            if (word.m_wordType != FieldType.PRE_DIRECTIONAL_FIELD_TYPE) continue;
            preDir = word.getWord();
            break;
        }
        return preDir;
    }

    @Override
    public String getPreThoroughFareName(AddressWord[] words) {
        int wordLen = words == null ? 0 : words.length;
        AddressWord nextWord = null;
        String preType = null;
        for (int i = 0; i < wordLen; ++i) {
            AddressWord word = words[i];
            if (i != 0 || word.m_wordType != FieldType.POST_THOROUGHFARE_FIELD_TYPE) continue;
            preType = word.getWord();
            if (preType.equalsIgnoreCase("ST")) {
                word.m_wordType = FieldType.STREET_NAME_FIELD_TYPE;
                return null;
            }
            nextWord = i < wordLen - 1 ? words[i + 1] : null;
            break;
        }
        preType = this.m_tftHandler.getProperTypeName(preType);
        if (this.m_nonDeimitedThroughfareTypes && nextWord != null && !CodedWord.isDelimiter(nextWord.getAttributes())) {
            preType = preType + " ";
        }
        return preType;
    }

    @Override
    public String getStreetNamePartOnly(AddressWord[] words) {
        int wordLen;
        String strName = null;
        int n = wordLen = words == null ? 0 : words.length;
        if (wordLen > 0) {
            StringBuilder builder = new StringBuilder();
            AddressWord lastWord = null;
            for (int i = 0; i < wordLen; ++i) {
                AddressWord word = words[i];
                if (word.m_wordType != FieldType.STREET_NAME_FIELD_TYPE) continue;
                if (!CodedWord.isDelimiter(word.getAttributes()) && lastWord != null && !CodedWord.isDelimiter(lastWord.getAttributes())) {
                    builder.append(' ');
                }
                if (this.m_nonDeimitedThroughfareTypes) {
                    if (!"%".equals(word.getWord())) {
                        builder.append(word.getWord());
                    }
                } else {
                    builder.append(word.getWord());
                }
                lastWord = word;
            }
            strName = builder.toString().trim();
        }
        return strName;
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    public int compareTo(Object o) {
        int diff;
        if (this == o) {
            return 0;
        }
        CGGEParser anotherParser = (CGGEParser)o;
        if (this.getCountry() != null && anotherParser.getCountry() != null) {
            diff = this.getCountry().compareTo(anotherParser.getCountry());
            if (diff != 0) {
                return diff;
            }
        } else {
            if (this.getCountry() != null) {
                return 1;
            }
            if (anotherParser.getCountry() != null) {
                return -1;
            }
        }
        if (this.getLanguage() != null && anotherParser.getLanguage() != null) {
            diff = this.getLanguage().compareTo(anotherParser.getLanguage());
            if (diff != 0) {
                return diff;
            }
        } else {
            if (this.getLanguage() != null) {
                return 1;
            }
            if (anotherParser.getLanguage() != null) {
                return -1;
            }
        }
        if (this.getDataSetInfo() != null && anotherParser.getDataSetInfo() != null) {
            diff = this.getDataSetInfo().getDataSetInfoKey().compareTo(anotherParser.getDataSetInfo().getDataSetInfoKey());
            if (diff != 0) {
                return diff;
            }
        } else {
            if (this.getDataSetInfo() != null) {
                return 1;
            }
            if (anotherParser.getDataSetInfo() != null) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public boolean preferPreThroughfareType() {
        return this.m_preferPreThoroughfareTypes;
    }

    @Override
    public boolean isThroughFareAttachedtoStreetName() {
        return this.m_nonDeimitedThroughfareTypes;
    }

    protected String getDelimiters() {
        String delimiters = "";
        if (this.m_parserTerms != null) {
            delimiters = this.m_parserTerms.getDelimiters();
        }
        return delimiters;
    }

    public boolean isKeepAllDelimiters() {
        return this.m_bKeepAllDelimiters;
    }

    public void setKeepAllDelimiters(boolean m_bKeepAllDelimiters) {
        this.m_bKeepAllDelimiters = m_bKeepAllDelimiters;
    }

    protected static class StringReplace {
        String m_replace;
        String m_replacement;

        StringReplace() {
        }

        StringReplace(String replace, String replacement) {
            this.m_replace = replace;
            this.m_replacement = replacement;
        }
    }
}

