/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.parser;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser;
import com.mapinfo.mapmarker.cgge.parser.CGGEParserTerms;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.RomanNumeral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CGGEParser1
extends CGGEParser {
    private Map<CodedWord, List<WordAlternate>> m_savedAlts;

    public CGGEParser1() {
    }

    protected CGGEParser1(CGGEParserTerms terms, ICGGESoundex soundex, ICGGEThoroughfareTypeHandler tftHandler) {
        super(terms, soundex, tftHandler);
        this.m_savedAlts = new HashMap<CodedWord, List<WordAlternate>>();
    }

    @Override
    public boolean init(String country, String language) {
        boolean flag = super.init(country, language);
        this.m_savedAlts = new HashMap<CodedWord, List<WordAlternate>>();
        return flag;
    }

    private static boolean hasAlternate(AddressWord addrWord) {
        short wordAttribs = addrWord.getAttributes();
        return CodedWord.isAbbreviatable(wordAttribs) || CodedWord.isAbbreviation(wordAttribs) || CodedWord.isProbableRomanNumeral(wordAttribs) || CodedWord.isNumeric(wordAttribs) || CodedWord.isThoroughfareTypeWord(wordAttribs);
    }

    @Override
    public void assignAlternateWord(AddressWord addrWord, ICGGESoundex soundex) {
        if (addrWord != null && !addrWord.hasAlternates()) {
            List<WordAlternate> alternates = null;
            alternates = this.m_savedAlts.get(addrWord.getCodedWord());
            if (alternates == null && CGGEParser1.hasAlternate(addrWord) && (alternates = this.makeAlternateWords(addrWord, soundex)) != null) {
                this.m_savedAlts.put(addrWord.getCodedWord(), alternates);
            }
            addrWord.setAlternates(alternates);
        }
    }

    protected short getNumericAttributes(String word, short wordAttribs) {
        if (MMUtils.isNumber(word)) {
            wordAttribs = (short)(wordAttribs | 4);
        } else if (this.getParserTerms().isNumericWord(word)) {
            wordAttribs = (short)(wordAttribs | 8);
        } else if (RomanNumeral.probableRomanNumeral(word)) {
            wordAttribs = (short)(wordAttribs | 0x20);
        }
        return wordAttribs;
    }

    @Override
    public CodedWord convertToCodedWord(String word, ICGGESoundex soundex) {
        CodedWord codedWord = null;
        if (word != null) {
            codedWord = new CodedWord(word, 0, -1);
            short wordAttribs = 0;
            if (this.getParserTerms().isDelimiter(word)) {
                wordAttribs = (short)(wordAttribs | 0x10);
            } else {
                wordAttribs = this.getNumericAttributes(word, wordAttribs);
                if (this.getParserTerms().isArticle(word)) {
                    wordAttribs = (short)(wordAttribs | 0x400);
                } else if (this.getParserTerms().isCommonWord(word)) {
                    wordAttribs = (short)(wordAttribs | 0x100);
                }
                if (this.getParserTerms().isDirectionalWord(word)) {
                    wordAttribs = (short)(wordAttribs | 0x800);
                }
                if (this.getParserTerms().isAbbreviation(word)) {
                    wordAttribs = (short)(wordAttribs | 0x40);
                }
                if (((CGGEParserTerms)this.getParserTerms()).isAbbreviatableWord(word)) {
                    wordAttribs = (short)(wordAttribs | 2);
                }
                if (this.getThoroughfareTypeHandler().isThoroughfareType(word)) {
                    wordAttribs = (short)(wordAttribs | 0x200);
                }
                if (soundex != null) {
                    codedWord.setNormalizedChars(soundex.normalizeChars(word));
                    codedWord.setSoundex(soundex.getSoundex(word));
                }
            }
            codedWord.setAttributes(wordAttribs);
        }
        return codedWord;
    }

    @Override
    protected AddressWord[] getAddressWords(String str, boolean returnDelims, boolean makeAlternates) {
        int wordCount;
        String[] words = MMUtils.splitString(str, this.getParserTerms().getDelimiters(), true);
        int n = wordCount = words == null ? 0 : words.length;
        if (wordCount > 0) {
            ArrayList<AddressWord> retWords = new ArrayList<AddressWord>(wordCount);
            ICGGESoundex soundex = this.getSoundex();
            String lastDelim = null;
            for (int i = 0; i < wordCount; ++i) {
                String word = this.getUpperCase(words[i]);
                boolean addWord = true;
                if (this.getParserTerms().isDelimiter(word)) {
                    if (returnDelims) {
                        if (word.equals(lastDelim) && !this.isKeepAllDelimiters()) {
                            addWord = false;
                        } else if (lastDelim == null && " ".equals(word) && !this.isKeepAllDelimiters()) {
                            addWord = false;
                        }
                    } else if (!"%".equals(word)) {
                        addWord = false;
                    }
                    lastDelim = word;
                } else {
                    lastDelim = null;
                }
                if (!addWord) continue;
                AddressWord scoringWord = null;
                scoringWord = !makeAlternates ? this.convertToAddressWord(word, soundex) : new AddressWord(this.convertToCodedWord(word, soundex));
                retWords.add(scoringWord);
            }
            if (retWords.size() > 0) {
                if (this.isKeepAllDelimiters()) {
                    return this.adjustAddressWordDelimiters(retWords);
                }
                return retWords.toArray(new AddressWord[retWords.size()]);
            }
        }
        return null;
    }

    private AddressWord[] adjustAddressWordDelimiters(List<AddressWord> words) {
        boolean bPrevIsDelimiter = false;
        for (int i = 0; i < words.size() - 1; ++i) {
            String currentWord = words.get(i).getWord();
            if (!this.getParserTerms().isDelimiter(currentWord)) {
                bPrevIsDelimiter = false;
                continue;
            }
            if (" ".equals(currentWord) && !this.getParserTerms().isDelimiter(words.get(i + 1).getWord()) && !bPrevIsDelimiter) {
                words.remove(i);
                --i;
                continue;
            }
            bPrevIsDelimiter = true;
        }
        return words.toArray(new AddressWord[words.size()]);
    }

    protected int[] findWordNdxs(AddressWord[] words, int[] startEndNdx) {
        int[] wordStartEndNdx = new int[]{-1, -1};
        int wordArraySize = words.length;
        if (words != null && startEndNdx != null) {
            int startPos = 0;
            boolean prevWordIsDelimiter = false;
            for (int wordNdx = 0; wordNdx < wordArraySize; ++wordNdx) {
                boolean wordIsDelimiter = CodedWord.isDelimiter(words[wordNdx].getAttributes());
                int endPos = startPos + words[wordNdx].getWordLength();
                char[] chars = words[wordNdx].getWordChars();
                if (!(wordNdx <= 0 || wordIsDelimiter || prevWordIsDelimiter || chars.length == 1 && '%' == chars[0] || "%" == words[wordNdx - 1].getWord())) {
                    ++endPos;
                }
                if (wordStartEndNdx[0] == -1 && startEndNdx[0] >= startPos && startEndNdx[0] < endPos) {
                    wordStartEndNdx[0] = wordNdx;
                }
                if (wordStartEndNdx[1] == -1 && startEndNdx[1] >= startPos && startEndNdx[1] < endPos) {
                    wordStartEndNdx[1] = wordNdx;
                    if (wordStartEndNdx[1] == wordStartEndNdx[0]) {
                        wordStartEndNdx[1] = wordStartEndNdx[1] + 1;
                    }
                }
                if (wordStartEndNdx[0] > -1 && wordStartEndNdx[1] > -1) break;
                startPos = endPos;
                prevWordIsDelimiter = wordIsDelimiter;
            }
        }
        if (wordStartEndNdx[0] > -1 && wordStartEndNdx[1] == -1) {
            wordStartEndNdx[1] = wordArraySize;
        }
        return wordStartEndNdx;
    }

    @Override
    protected String cleanString(String str) {
        ICGGEParserTerms parserTerms = this.getParserTerms();
        if ((str = this.getUpperCase(str)) != null && !parserTerms.isDelimiter(str)) {
            char[] originalCharacters = str.trim().toCharArray();
            char[] newCharacters = new char[originalCharacters.length];
            int insertNdx = -1;
            for (int i = 0; i < originalCharacters.length; ++i) {
                ++insertNdx;
                if (!(!Character.isWhitespace(originalCharacters[i]) || Character.isLetterOrDigit(originalCharacters[i - 1]) && Character.isLetterOrDigit(originalCharacters[i + 1]) || Character.isWhitespace(originalCharacters[i - 1]) || '&' == originalCharacters[i - 1])) {
                    --insertNdx;
                    continue;
                }
                newCharacters[insertNdx] = originalCharacters[i];
            }
            return new String(newCharacters).trim();
        }
        return null;
    }

    @Override
    public AddressWord[] splitIntoWeightedWords(String str, FieldType type) {
        if (str != null) {
            AddressWord[] addrWords;
            int wordCount;
            int delimPos;
            str = this.getUpperCase(str.trim());
            if (type == FieldType.STREET_NAME_FIELD_TYPE && this.isThroughFareAttachedtoStreetName() && (delimPos = this.thoroughfareTypeDelimiterPosition(str)) > -1) {
                String word = this.getWordWithCharacterNdx(str, delimPos);
                if (!(this.getThoroughfareTypeHandler().isThoroughfareType(word) || ((CGGEParserTerms)this.getParserTerms()).isAbbreviatableWord(word) || this.getParserTerms().isNumericWord(word) || RomanNumeral.probableRomanNumeral(word) || this.getParserTerms().isDirectionalWord(word))) {
                    str = str.substring(0, delimPos) + "%" + str.substring(delimPos);
                }
            }
            int n = wordCount = (addrWords = this.getAddressWords(str, true, false)) == null ? 0 : addrWords.length;
            if (wordCount > 0) {
                int i;
                IntArray delimiterNdx = new IntArray(wordCount);
                IntArray commonWordNdx = new IntArray(wordCount);
                IntArray streetTypeWordNdx = new IntArray(wordCount);
                IntArray buildingWordsNdx = new IntArray(wordCount);
                IntArray firmWordsNdx = new IntArray(wordCount);
                IntArray directionalWordsNdx = new IntArray(wordCount);
                IntArray normalWordsNdx = new IntArray(wordCount);
                IntArray articleNdx = new IntArray(wordCount);
                for (i = 0; i < wordCount; ++i) {
                    AddressWord addrWord = addrWords[i];
                    String word = addrWord.getWord();
                    short attribs = addrWord.getAttributes();
                    addrWord.m_wordType = type;
                    if (CodedWord.isDelimiter(attribs)) {
                        delimiterNdx.add(i);
                        continue;
                    }
                    if (type == FieldType.STREET_NAME_FIELD_TYPE && CodedWord.isThoroughfareTypeWord(attribs)) {
                        streetTypeWordNdx.add(i);
                        continue;
                    }
                    if (type == FieldType.STREET_NAME_FIELD_TYPE && (i == 0 || i == wordCount - 1) && CodedWord.isDirectionalWord(attribs)) {
                        directionalWordsNdx.add(i);
                        continue;
                    }
                    if (CodedWord.isArticleWord(attribs)) {
                        articleNdx.add(i);
                        continue;
                    }
                    if (CodedWord.isCommonWord(attribs)) {
                        commonWordNdx.add(i);
                        continue;
                    }
                    if (type == FieldType.RANGE_PLACE_NAME_FIELD_TYPE && this.getParserTerms().isBuildingIdentifier(word)) {
                        buildingWordsNdx.add(i);
                        continue;
                    }
                    if (type == FieldType.UNIT_PLACE_NAME_FIELD_TYPE && this.getParserTerms().isFirmIdentifier(word)) {
                        firmWordsNdx.add(i);
                        continue;
                    }
                    normalWordsNdx.add(i);
                }
                if (type == FieldType.STREET_NAME_FIELD_TYPE && streetTypeWordNdx.size() > 0) {
                    for (i = 0; i < streetTypeWordNdx.size(); ++i) {
                        int pos = streetTypeWordNdx.get(i);
                        boolean remove = false;
                        if (pos == wordCount - 1) {
                            if (normalWordsNdx.size() <= 0 && commonWordNdx.size() <= 0 && streetTypeWordNdx.size() <= 1 && directionalWordsNdx.size() <= 0 && articleNdx.size() <= 0) {
                                remove = true;
                            }
                        } else if (pos == 0) {
                            if (normalWordsNdx.size() <= 0 && commonWordNdx.size() <= 0 && streetTypeWordNdx.size() <= 1 && articleNdx.size() <= 0 && directionalWordsNdx.size() <= 0 && articleNdx.size() <= 0) {
                                remove = true;
                            }
                        } else if (delimiterNdx.size() > 0 || directionalWordsNdx.size() > 0) {
                            int j;
                            for (j = 0; j < pos; ++j) {
                                if (directionalWordsNdx.contains(j) || delimiterNdx.contains(j)) continue;
                                remove = true;
                                break;
                            }
                            if (remove) {
                                remove = false;
                                for (j = pos + 1; j < wordCount; ++j) {
                                    if (directionalWordsNdx.contains(j) || delimiterNdx.contains(j)) continue;
                                    remove = true;
                                    break;
                                }
                            }
                        } else {
                            remove = true;
                        }
                        if (!remove) continue;
                        streetTypeWordNdx.removeAt(i--);
                        AddressWord addrWord = addrWords[pos];
                        addrWord.setAttribute((short)(addrWord.getAttributes() ^ 0x200));
                        String word = addrWord.getWord();
                        if (type == FieldType.STREET_NAME_FIELD_TYPE && (pos == 0 || pos < wordCount - 1) && this.getParserTerms().isDirectionalWord(word)) {
                            directionalWordsNdx.add(pos);
                            continue;
                        }
                        if (this.getParserTerms().isArticle(word)) {
                            articleNdx.add(pos);
                            continue;
                        }
                        if (this.getParserTerms().isCommonWord(word)) {
                            commonWordNdx.add(pos);
                            continue;
                        }
                        if (type == FieldType.RANGE_PLACE_NAME_FIELD_TYPE && this.getParserTerms().isBuildingIdentifier(word)) {
                            buildingWordsNdx.add(pos);
                            continue;
                        }
                        if (type == FieldType.UNIT_PLACE_NAME_FIELD_TYPE && this.getParserTerms().isFirmIdentifier(word)) {
                            firmWordsNdx.add(i);
                            continue;
                        }
                        normalWordsNdx.add(pos);
                    }
                    if (streetTypeWordNdx.size() == 2 && normalWordsNdx.size() == 0 && commonWordNdx.size() == 0) {
                        if (this.preferPreThroughfareType()) {
                            streetTypeWordNdx.removeAt(1);
                        } else {
                            streetTypeWordNdx.removeAt(0);
                        }
                    }
                }
                if (streetTypeWordNdx.size() > 0 && (normalWordsNdx.size() > 0 || commonWordNdx.size() > 0 || directionalWordsNdx.size() > 0 || buildingWordsNdx.size() > 0 || firmWordsNdx.size() > 0 || articleNdx.size() > 0)) {
                    for (i = 0; i < streetTypeWordNdx.size(); ++i) {
                        AddressWord word = addrWords[streetTypeWordNdx.get(i)];
                        word.m_wordType = FieldType.POST_THOROUGHFARE_FIELD_TYPE;
                        String preferedName = this.getThoroughfareTypeHandler().getPreferedTypeName(word.getWord());
                        WordAlternate altWord = new WordAlternate(this.convertToAddressWord(preferedName, this.getSoundex()), WordAlternate.ALT_TYPE.THOROUGHFARE_TYPE);
                        word.addAlternate(altWord);
                    }
                }
                for (i = 0; i < directionalWordsNdx.size(); ++i) {
                    commonWordNdx.add(directionalWordsNdx.get(i));
                }
                this.calculateWordsWeight(addrWords, delimiterNdx, articleNdx, commonWordNdx, streetTypeWordNdx, buildingWordsNdx, firmWordsNdx);
                return addrWords;
            }
        }
        return null;
    }

    private void calculateWordsWeight(AddressWord[] scoringWords, IntArray delimiterNdxList, IntArray articleNdxList, IntArray commonWordNdxList, IntArray streetTypeNdxList, IntArray buildingWordNdxList, IntArray firmWordNdxList) {
        int wordCount = scoringWords.length;
        if (wordCount > 0) {
            byte checkWeight;
            byte currentWeight;
            int ndx;
            int i;
            this.getScorer().addWeights(scoringWords);
            int size = delimiterNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = delimiterNdxList.get(i);
                scoringWords[ndx].m_weight = 0;
            }
            size = streetTypeNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = streetTypeNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                if (currentWeight > this.getParserTerms().getThoroughfareTypeWeight()) {
                    currentWeight = this.getParserTerms().getThoroughfareTypeWeight();
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            size = articleNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = articleNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                if (currentWeight > this.getParserTerms().getArticleWeight()) {
                    currentWeight = this.getParserTerms().getArticleWeight();
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            size = commonWordNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = commonWordNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                if (currentWeight > this.getParserTerms().getCommonWordWeight()) {
                    currentWeight = this.getParserTerms().getCommonWordWeight();
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            size = buildingWordNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = buildingWordNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                checkWeight = this.getParserTerms().getBuildingIdentiferWeight();
                if (currentWeight > checkWeight) {
                    currentWeight = checkWeight;
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            size = firmWordNdxList.size();
            for (i = 0; i < size; ++i) {
                ndx = firmWordNdxList.get(i);
                currentWeight = scoringWords[ndx].m_weight;
                checkWeight = this.getParserTerms().getFirmIdentiferWeight();
                if (currentWeight > checkWeight) {
                    currentWeight = checkWeight;
                }
                scoringWords[ndx].m_weight = currentWeight;
            }
            int totalWeight = 0;
            for (int i2 = 0; i2 < scoringWords.length; ++i2) {
                totalWeight = (byte)(totalWeight + scoringWords[i2].m_weight);
            }
            if (totalWeight < 100) {
                int combined;
                int i3;
                int perWordWeight;
                int i4;
                int remaining = 100 - totalWeight;
                IntArray mainWordsNdx = new IntArray(5);
                for (i4 = 0; i4 < wordCount; ++i4) {
                    if (commonWordNdxList.contains(i4) || streetTypeNdxList.contains(i4) || buildingWordNdxList.contains(i4) || delimiterNdxList.contains(i4) || firmWordNdxList.contains(i4) || articleNdxList.contains(i4)) continue;
                    mainWordsNdx.add(i4);
                }
                if (mainWordsNdx.size() > 0) {
                    while (remaining > 0) {
                        perWordWeight = mainWordsNdx.size() < remaining ? remaining / mainWordsNdx.size() : remaining;
                        for (i3 = 0; i3 < wordCount && remaining > 0; ++i3) {
                            if (!mainWordsNdx.contains(i3)) continue;
                            scoringWords[i3].m_weight = (byte)(scoringWords[i3].m_weight + perWordWeight);
                            remaining -= perWordWeight;
                        }
                    }
                }
                if (remaining > 0 && commonWordNdxList.size() > 0) {
                    while (remaining > 0) {
                        perWordWeight = commonWordNdxList.size() < remaining ? remaining / commonWordNdxList.size() : remaining;
                        for (i3 = 0; i3 < wordCount && remaining > 0; ++i3) {
                            if (!commonWordNdxList.contains(i3)) continue;
                            scoringWords[i3].m_weight = (byte)(scoringWords[i3].m_weight + perWordWeight);
                            remaining -= perWordWeight;
                        }
                    }
                }
                if (remaining > 0 && mainWordsNdx.size() < 1 && commonWordNdxList.size() < 1 && articleNdxList.size() > 0 && streetTypeNdxList.size() > 0 && (combined = this.getParserTerms().getCommonWordWeight() + this.getParserTerms().getThoroughfareTypeWeight()) > 0) {
                    int i5;
                    int perWordWeight2;
                    int articleWeight = (int)(this.getParserTerms().getCommonWordWeight() == 0 ? 0.0 : (double)remaining * ((double)this.getParserTerms().getCommonWordWeight() / (double)combined));
                    int typeWeight = (int)(this.getParserTerms().getThoroughfareTypeWeight() == 0 ? 0.0 : (double)remaining * ((double)this.getParserTerms().getThoroughfareTypeWeight() / (double)combined));
                    if (articleWeight > 0) {
                        perWordWeight2 = articleNdxList.size() < remaining ? articleWeight / articleNdxList.size() : articleWeight;
                        for (i5 = 0; i5 < wordCount && remaining > 0; ++i5) {
                            if (!articleNdxList.contains(i5)) continue;
                            scoringWords[i5].m_weight = (byte)(scoringWords[i5].m_weight + perWordWeight2);
                            remaining -= perWordWeight2;
                        }
                    }
                    if (typeWeight > 0) {
                        perWordWeight2 = streetTypeNdxList.size() < remaining ? typeWeight / streetTypeNdxList.size() : typeWeight;
                        for (i5 = 0; i5 < wordCount && remaining > 0; ++i5) {
                            if (!streetTypeNdxList.contains(i5)) continue;
                            scoringWords[i5].m_weight = (byte)(scoringWords[i5].m_weight + perWordWeight2);
                            remaining -= perWordWeight2;
                        }
                    }
                }
                if (remaining > 0 && wordCount != delimiterNdxList.size()) {
                    while (remaining > 0) {
                        for (i4 = 0; i4 < wordCount && remaining > 0; ++i4) {
                            if (delimiterNdxList.contains(i4)) continue;
                            scoringWords[i4].m_weight = (byte)(scoringWords[i4].m_weight + 1);
                            --remaining;
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getPostDirectional(AddressWord[] words) {
        int wordLen = words == null ? 0 : words.length;
        String postDir = null;
        for (int i = 0; i < wordLen; ++i) {
            AddressWord word = words[i];
            if (word.m_wordType != FieldType.POST_DIRECTIONAL_FIELD_TYPE) continue;
            postDir = word.getWord();
            break;
        }
        return postDir;
    }

    @Override
    public String getStreetNamePartOnly(AddressWord[] words) {
        int wordLen;
        String strName = null;
        int n = wordLen = words == null ? 0 : words.length;
        if (wordLen > 0) {
            StringBuilder builder = new StringBuilder();
            AddressWord lastWord = null;
            boolean lastWordWasType = false;
            for (int i = 0; i < wordLen; ++i) {
                AddressWord word = words[i];
                if (word.m_wordType == FieldType.STREET_NAME_FIELD_TYPE) {
                    if (lastWordWasType && CodedWord.isDirectionalWord(word.getAttributes())) {
                        word.m_wordType = FieldType.POST_DIRECTIONAL_FIELD_TYPE;
                    } else {
                        if (!CodedWord.isDelimiter(word.getAttributes()) && lastWord != null && !CodedWord.isDelimiter(lastWord.getAttributes())) {
                            builder.append(' ');
                        }
                        if (this.isThroughFareAttachedtoStreetName()) {
                            if (!"%".equals(word.getWord())) {
                                builder.append(word.getWord());
                            }
                        } else {
                            builder.append(word.getWord());
                        }
                    }
                    lastWord = word;
                    continue;
                }
                if (word.m_wordType != FieldType.POST_THOROUGHFARE_FIELD_TYPE) continue;
                lastWordWasType = true;
            }
            strName = builder.toString().trim();
        }
        return strName;
    }
}

