/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.parser;

import com.mapinfo.mapmarker.cgge.DatasetInfoComponent;
import com.mapinfo.mapmarker.cgge.parser.CGGEParserTermsPropertiesLoader;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.parser.ISettableCGGEParserTerms;
import com.mapinfo.mapmarker.cgge.utils.RomanNumeral;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CGGEParserTerms
extends DatasetInfoComponent
implements ICGGEParserTerms,
ISettableCGGEParserTerms {
    private Map<String, Integer> m_numericWordMap;
    private Map<String, List<String>> m_wordToAbbreviations;
    private Map<String, List<String>> m_abbrToWords;
    private String m_delimiters = " ";
    private Map<String, String> m_extendedCharMap;
    private Set<String> m_commonWordSet;
    private Set<String> m_buildingIdentifierSet;
    private Set<String> m_firmIdentifierSet;
    private Set<String> m_directionalWordSet;
    private Set<String> m_countryCodeSet;
    private Set<String> m_articleSet;
    private List<String> m_unitWordList;
    private List<String> m_unitPrefixWordList;
    private byte m_streetTypeWeight;
    private byte m_buildingIdentifierWeight;
    private byte m_commonWordsWeight;
    private byte m_firmIdentifierWeight;
    private byte m_buildingWeight;
    private byte m_firmWeight;
    private byte m_articleWeight;
    protected String m_country;
    protected String m_language;

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        CGGEParserTermsPropertiesLoader loader = new CGGEParserTermsPropertiesLoader("/com/mapinfo/mapmarker/" + country + "/config/" + country + "_ParserTerms");
        loader.init(country, language, this, this.getConfiguration(this.m_country, this.m_language, "_ParserTerms"));
        return true;
    }

    protected String cleanseWord(String word) {
        if (word == null) {
            return "";
        }
        return word.trim().toUpperCase();
    }

    private boolean hasWord(Set<String> set, String uncleansedWord) {
        return set != null && uncleansedWord != null && set.contains(this.cleanseWord(uncleansedWord));
    }

    @Override
    public final String getDelimiters() {
        return this.m_delimiters;
    }

    @Override
    public final boolean isCountryCode(String word) {
        return this.hasWord(this.m_countryCodeSet, word);
    }

    @Override
    public final boolean isCommonWord(String word) {
        if (word == null || this.m_commonWordSet == null) {
            return false;
        }
        if ((word = this.cleanseWord(word)).length() == 1 && !Character.isDigit(word.charAt(0))) {
            return true;
        }
        return this.m_commonWordSet.contains(word);
    }

    @Override
    public final boolean isBuildingIdentifier(String word) {
        return this.hasWord(this.m_buildingIdentifierSet, word);
    }

    @Override
    public final boolean isUnitWord(String word) {
        return word != null && this.m_unitWordList.contains(this.cleanseWord(word));
    }

    @Override
    public final boolean isFirmIdentifier(String word) {
        return this.hasWord(this.m_firmIdentifierSet, word);
    }

    @Override
    public final boolean isDirectionalWord(String word) {
        return this.hasWord(this.m_directionalWordSet, word);
    }

    @Override
    public final List<String> getUnitTypeList() {
        return this.m_unitWordList;
    }

    @Override
    public final boolean isAbbreviation(String word) {
        return word != null && this.m_abbrToWords.containsKey(this.cleanseWord(word));
    }

    public final boolean isAbbreviatableWord(String word) {
        return word != null && this.m_wordToAbbreviations.containsKey(this.cleanseWord(word));
    }

    @Override
    public final boolean isNumericWord(String word) {
        if (StringUtilities.isEmpty((String)word)) {
            return false;
        }
        if ((word = this.cleanseWord(word)).length() == 0) {
            return false;
        }
        return this.m_numericWordMap.containsKey(word);
    }

    @Override
    public final boolean isDelimiter(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return false;
        }
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (this.isDelimiter(c.charValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isDelimiter(char ch) {
        return this.m_delimiters.indexOf(ch) > -1;
    }

    @Override
    public final String getNumberForNumeric(String word) {
        if (StringUtilities.isEmpty((String)word)) {
            return null;
        }
        if (StringUtilities.isNumeric((String)(word = this.cleanseWord(word)))) {
            return word;
        }
        Integer n = this.m_numericWordMap.get(word);
        if (n != null) {
            return n.toString();
        }
        return null;
    }

    public final int getNumberForRomanNumeric(String word) {
        if (word == null) {
            return 0;
        }
        if (RomanNumeral.probableRomanNumeral(word = word.toUpperCase())) {
            return RomanNumeral.getNumber(word);
        }
        return 0;
    }

    @Override
    public final List<String> getFullWordsForAbbreviation(String abbr) {
        if (abbr != null) {
            return this.m_abbrToWords.get(abbr.toUpperCase());
        }
        return null;
    }

    @Override
    public final List<String> getAbbreviations(String word) {
        if (word != null) {
            return this.m_wordToAbbreviations.get(word.toUpperCase());
        }
        return null;
    }

    @Override
    public byte getThoroughfareTypeWeight() {
        return this.m_streetTypeWeight;
    }

    @Override
    public byte getBuildingIdentiferWeight() {
        return this.m_buildingIdentifierWeight;
    }

    @Override
    public byte getCommonWordWeight() {
        return this.m_commonWordsWeight;
    }

    @Override
    public byte getFirmIdentiferWeight() {
        return this.m_firmIdentifierWeight;
    }

    @Override
    public byte getArticleWeight() {
        return this.m_articleWeight;
    }

    protected List<String> getUnitWords() {
        return this.m_unitWordList;
    }

    protected List<String> getUnitPrefixWords() {
        return this.m_unitPrefixWordList;
    }

    @Override
    public int getUnitPrefixWordIndex(String word) {
        if (!StringUtilities.isEmpty((String)word)) {
            String searchWord = this.cleanseWord(word);
            return this.m_unitPrefixWordList.indexOf(searchWord);
        }
        return -1;
    }

    @Override
    public String getUnitPrefixWord(int ndx) {
        if (ndx >= 0 && ndx < this.m_unitPrefixWordList.size()) {
            return this.m_unitPrefixWordList.get(ndx);
        }
        return null;
    }

    @Override
    public int getUnitWordIndex(String word) {
        if (!StringUtilities.isEmpty((String)word)) {
            return this.m_unitWordList.indexOf(this.cleanseWord(word));
        }
        return -1;
    }

    @Override
    public String getUnitWord(int ndx) {
        if (ndx >= 0 && ndx < this.m_unitWordList.size()) {
            return this.m_unitWordList.get(ndx);
        }
        return null;
    }

    @Override
    public boolean isArticle(String word) {
        return !StringUtilities.isEmpty((String)word) && this.m_articleSet.contains(this.cleanseWord(word));
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    @Override
    public void setUnitPrefixWords(List<String> list) {
        this.m_unitPrefixWordList = list;
    }

    @Override
    public void setNumericWordMap(Map<String, Integer> map) {
        this.m_numericWordMap = map;
    }

    @Override
    public void setWordToAbbreviations(Map<String, List<String>> map) {
        this.m_wordToAbbreviations = map;
    }

    @Override
    public void setAbbrToWords(Map<String, List<String>> map) {
        this.m_abbrToWords = map;
    }

    @Override
    public void setDelimiters(String str) {
        this.m_delimiters = str;
    }

    @Override
    public void setExtendedCharMap(Map<String, String> map) {
        this.m_extendedCharMap = map;
    }

    @Override
    public void setCommonWords(Set<String> set) {
        this.m_commonWordSet = set;
    }

    @Override
    public void setBuildingIdentifier(Set<String> set) {
        this.m_buildingIdentifierSet = set;
    }

    @Override
    public void setUnitWordList(List<String> list) {
        this.m_unitWordList = list;
    }

    @Override
    public void setFirmIdentifier(Set<String> set) {
        this.m_firmIdentifierSet = set;
    }

    @Override
    public void setDirectionalWords(Set<String> set) {
        this.m_directionalWordSet = set;
    }

    @Override
    public void setCountryCodes(Set<String> set) {
        this.m_countryCodeSet = set;
    }

    @Override
    public void setArticles(Set<String> set) {
        this.m_articleSet = set;
    }

    @Override
    public void setThoroughfareTypeWeight(byte weight) {
        this.m_streetTypeWeight = weight;
    }

    @Override
    public void setBuildingIdentifierWeight(byte weight) {
        this.m_buildingIdentifierWeight = weight;
    }

    @Override
    public void setCommonWordWeight(byte weight) {
        this.m_commonWordsWeight = weight;
    }

    @Override
    public void setFirmIdentifierWeight(byte weight) {
        this.m_firmIdentifierWeight = weight;
    }

    @Override
    public void setBuildingWeight(byte weight) {
        this.m_buildingWeight = weight;
    }

    @Override
    public void setFirmWeight(byte weight) {
        this.m_firmWeight = weight;
    }

    @Override
    public void setArticleWeight(byte weight) {
        this.m_articleWeight = weight;
    }

    @Override
    public Set<String> getBuildingIdentifiers() {
        return Collections.unmodifiableSet(this.m_buildingIdentifierSet);
    }
}

