/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.parser;

import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTermsLoader;
import com.mapinfo.mapmarker.cgge.parser.ISettableCGGEParserTerms;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class CGGEParserTermsPropertiesLoader
implements ICGGEParserTermsLoader {
    public static final String KEY_EXTENDED_CHARS = "extended_chars";
    public static final String KEY_COMMON_WORDS = "commonWords";
    public static final String KEY_BUILDING_WORDS = "buildingWords";
    public static final String KEY_UNIT_WORDS = "unitWords";
    public static final String KEY_ARTICLES = "articles";
    public static final String KEY_DIRECTIONAL_WORDS = "directionalWords";
    public static final String KEY_FIRM_WORDS = "firmWords";
    public static final String KEY_UNIT_PREFIX_WORDS = "unitPrefixWords";
    public static final String KEY_NUMERIC_WORDS = "number_";
    public static final String KEY_DELIMITERS = "delimiters";
    public static final String KEY_WEIGHT_STREET_TYPE = "weight.streettype";
    public static final String KEY_WEIGHT_BUILDING_IDENTIFIER = "weight.buildingIdentifier";
    public static final String KEY_WEIGHT_COMMON_WORDS = "weight.commonWords";
    public static final String KEY_WEIGHT_FIRM_IDENTIFIERS = "weight.firmIdentifiers";
    public static final String KEY_WEIGHT_FIRM_WORDS = "weight.firmWords";
    public static final String KEY_WEIGHT_BUILDING_WORDS = "weight.buildingWords";
    public static final String KEY_WEIGHT_ARTICLES = "weight.articles";
    public static final String KEY_COUNTRY_CODES = "country_codes";
    public static final String KEY_IMPORT_ISO_COUNTRY_ABBREVS = "country_iso_abbrevs_flag";
    public static final char CONCATENATOR_CHAR = '+';
    protected Map<String, List<String>> m_wordToAbbreviations = new HashMap<String, List<String>>(50);
    protected Map<String, List<String>> m_abbrToWords = new HashMap<String, List<String>>(50);
    private boolean m_bImportISOCountryAbbrevs = false;
    private String m_propFileName;

    public CGGEParserTermsPropertiesLoader(String propFileName) {
        if (StringUtilities.isEmpty((String)propFileName)) {
            throw new RuntimeException("Properties file name cannot be empty");
        }
        this.m_propFileName = propFileName;
    }

    @Override
    public boolean init(String country, String language, ISettableCGGEParserTerms myTermsObject, Properties properties) {
        Enumeration<Object> e = properties.keys();
        HashSet<String> commonWords = new HashSet<String>();
        HashSet<String> buildingWords = new HashSet<String>();
        HashSet<String> firmWords = new HashSet<String>();
        HashSet<String> directionalWords = new HashSet<String>();
        HashSet<String> countryCodes = new HashSet<String>();
        HashSet<String> articles = new HashSet<String>();
        HashMap<String, Integer> numericWordMap = new HashMap<String, Integer>();
        HashMap<String, String> extendedCharMap = new HashMap<String, String>();
        ArrayList<String> unitPrefixWordList = new ArrayList<String>();
        ArrayList<String> unitWordList = new ArrayList<String>();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            if (key.equals(KEY_WEIGHT_STREET_TYPE)) {
                myTermsObject.setThoroughfareTypeWeight(this.stringToWeight(value));
                continue;
            }
            if (key.equals(KEY_WEIGHT_COMMON_WORDS)) {
                myTermsObject.setCommonWordWeight(this.stringToWeight(value));
                continue;
            }
            if (key.equals(KEY_WEIGHT_BUILDING_IDENTIFIER)) {
                myTermsObject.setBuildingIdentifierWeight(this.stringToWeight(value));
                continue;
            }
            if (key.equals(KEY_WEIGHT_FIRM_IDENTIFIERS)) {
                myTermsObject.setFirmIdentifierWeight(this.stringToWeight(value));
                continue;
            }
            if (key.equals(KEY_WEIGHT_FIRM_WORDS)) {
                myTermsObject.setFirmWeight(this.stringToWeight(value));
                continue;
            }
            if (key.equals(KEY_WEIGHT_BUILDING_WORDS)) {
                myTermsObject.setBuildingWeight(this.stringToWeight(value));
                continue;
            }
            if (key.equals(KEY_WEIGHT_ARTICLES)) {
                myTermsObject.setArticleWeight(this.stringToWeight(value));
                continue;
            }
            if (key.equals(KEY_DELIMITERS)) {
                myTermsObject.setDelimiters(value);
                continue;
            }
            if (key.equals(KEY_IMPORT_ISO_COUNTRY_ABBREVS)) {
                this.m_bImportISOCountryAbbrevs = Boolean.valueOf(value);
                continue;
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            if (key.startsWith(KEY_EXTENDED_CHARS) && st.hasMoreTokens()) {
                String str = st.nextToken();
                while (st.hasMoreTokens()) {
                    extendedCharMap.put(st.nextToken(), str);
                }
            }
            if (key.startsWith(KEY_COMMON_WORDS)) {
                while (st.hasMoreTokens()) {
                    commonWords.add(this.cleanseWord(st.nextToken()));
                }
                continue;
            }
            if (key.startsWith(KEY_BUILDING_WORDS)) {
                while (st.hasMoreTokens()) {
                    buildingWords.add(this.cleanseWord(st.nextToken()));
                }
                continue;
            }
            if (key.startsWith(KEY_FIRM_WORDS)) {
                while (st.hasMoreTokens()) {
                    firmWords.add(this.cleanseWord(st.nextToken()));
                }
                continue;
            }
            if (key.startsWith(KEY_ARTICLES)) {
                while (st.hasMoreTokens()) {
                    articles.add(this.cleanseWord(st.nextToken()));
                }
                continue;
            }
            if (key.startsWith(KEY_DIRECTIONAL_WORDS)) {
                while (st.hasMoreTokens()) {
                    directionalWords.add(this.cleanseWord(st.nextToken()));
                }
                continue;
            }
            if (key.startsWith(KEY_UNIT_WORDS)) {
                while (st.hasMoreTokens()) {
                    unitWordList.add(this.cleanseWord(st.nextToken()));
                }
                continue;
            }
            if (key.startsWith(KEY_UNIT_PREFIX_WORDS)) {
                while (st.hasMoreTokens()) {
                    unitPrefixWordList.add(this.cleanseWord(st.nextToken()));
                }
                continue;
            }
            if (key.startsWith(KEY_NUMERIC_WORDS)) {
                String numberStr = key.substring(KEY_NUMERIC_WORDS.length());
                Integer number = new Integer(numberStr);
                numericWordMap.put(numberStr, number);
                while (st.hasMoreTokens()) {
                    String numericWord = this.cleanseWord(st.nextToken());
                    numericWordMap.put(numericWord, number);
                }
                continue;
            }
            if (key.equals(KEY_COUNTRY_CODES)) {
                while (st.hasMoreTokens()) {
                    countryCodes.add(this.cleanseWord(st.nextToken()));
                }
                continue;
            }
            String abbreviatedWord = key.toUpperCase().replace('+', ' ');
            List<String> abbreviations = this.m_wordToAbbreviations.get(abbreviatedWord);
            if (abbreviations == null) {
                abbreviations = new ArrayList<String>(1);
            }
            while (st.hasMoreTokens()) {
                String abbr = this.cleanseWord(st.nextToken());
                abbreviations.add(abbr);
                List<String> fullWords = this.m_abbrToWords.get(abbr);
                if (fullWords == null) {
                    fullWords = new ArrayList<String>(1);
                }
                fullWords.add(abbreviatedWord);
                this.m_abbrToWords.put(abbr, fullWords);
            }
            this.m_wordToAbbreviations.put(abbreviatedWord, abbreviations);
        }
        if (!numericWordMap.isEmpty()) {
            for (Map.Entry en : numericWordMap.entrySet()) {
                String numeric = (String)en.getKey();
                String number = ((Integer)en.getValue()).toString();
                if (numeric.indexOf(32) <= -1) continue;
                List<String> abbrs = this.m_wordToAbbreviations.get(numeric);
                if (abbrs == null) {
                    abbrs = new ArrayList<String>(1);
                }
                abbrs.add(numeric);
                this.m_wordToAbbreviations.put(number, abbrs);
                List<String> fullWords = this.m_abbrToWords.get(number);
                if (fullWords == null) {
                    fullWords = new ArrayList<String>(1);
                }
                fullWords.add(number);
                this.m_abbrToWords.put(numeric, fullWords);
            }
        }
        if (this.m_bImportISOCountryAbbrevs) {
            this.addISOCountryAbbrevs();
        }
        Collections.sort(unitWordList);
        Collections.reverse(unitWordList);
        myTermsObject.setAbbrToWords(this.m_abbrToWords);
        myTermsObject.setArticles(articles);
        myTermsObject.setBuildingIdentifier(buildingWords);
        myTermsObject.setCommonWords(commonWords);
        myTermsObject.setCountryCodes(countryCodes);
        myTermsObject.setDirectionalWords(directionalWords);
        myTermsObject.setExtendedCharMap(extendedCharMap);
        myTermsObject.setFirmIdentifier(firmWords);
        myTermsObject.setNumericWordMap(numericWordMap);
        myTermsObject.setUnitPrefixWords(unitPrefixWordList);
        myTermsObject.setUnitWordList(unitWordList);
        myTermsObject.setWordToAbbreviations(this.m_wordToAbbreviations);
        return true;
    }

    private byte stringToWeight(String value) {
        return (byte)(Double.parseDouble(value) * 100.0);
    }

    private void addISOCountryAbbrevs() {
        ISO3166[] isos;
        for (ISO3166 iso : isos = ISO3166.getISOCountries()) {
            List<String> words;
            String abbreviation = iso.getISO3Country();
            ArrayList<String> entries = new ArrayList<String>();
            this.add(entries, iso.getDisplayCountry());
            this.add(entries, iso.getISO2Country());
            String[] langs = ISO3166.getLanguagesForCountry((ISO3166)iso);
            if (langs != null) {
                for (String lang : langs) {
                    this.add(entries, iso.getDisplayCountry(new Locale(lang)));
                }
            }
            if ((words = this.m_abbrToWords.get(abbreviation)) == null) {
                this.m_abbrToWords.put(abbreviation, entries);
            } else {
                for (String e : entries) {
                    this.add(words, e);
                }
            }
            for (String e : entries) {
                List<String> abbreviations = this.m_wordToAbbreviations.get(e);
                if (abbreviations != null) {
                    this.add(abbreviations, abbreviation);
                    continue;
                }
                abbreviations = new ArrayList<String>();
                this.add(abbreviations, abbreviation);
                this.m_wordToAbbreviations.put(e, abbreviations);
            }
        }
    }

    private void add(List<String> contents, String s) {
        if (s == null) {
            return;
        }
        if (!contents.contains(s = s.toUpperCase())) {
            contents.add(s);
        }
    }

    protected String cleanseWord(String word) {
        if (word == null) {
            return "";
        }
        return word.trim().toUpperCase();
    }
}

