/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.soundex;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.DatasetInfoComponent;
import com.mapinfo.mapmarker.cgge.soundex.CGGESoundexPropertiesLoader;
import com.mapinfo.mapmarker.cgge.soundex.CGGESoundexPropertiesLoaderFactory;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.soundex.ISettableCGGESoundex;
import com.mapinfo.mapmarker.cgge.soundex.KeyedPattern;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CGGEAltSoundex
extends DatasetInfoComponent
implements ICGGESoundex,
ISettableCGGESoundex {
    public static final String KEY_CHARS_REPLACE = "chars_replace";
    private LocalReplacementPair[] m_charReplacements;
    private String m_country;
    private String m_language;

    @Override
    public final int getSoundex(String word) {
        if (word != null) {
            if (MMUtils.isNumber(word)) {
                try {
                    long n = Long.parseLong(word);
                    return (int)MMUtils.trimDigits(n, 3);
                }
                catch (NumberFormatException n) {}
            } else {
                int len;
                char[] chars = this.normalizeChars(word);
                int n = len = chars == null ? 0 : chars.length;
                if (len > 0) {
                    int soundex = chars[0];
                    soundex *= 10;
                    soundex += len % 3;
                    int checkChars = Math.min(4, len);
                    for (int i = 1; i < checkChars; ++i) {
                        char s = chars[i];
                        soundex *= 10;
                        soundex += s % 5;
                    }
                    return soundex;
                }
                return 0;
            }
        }
        return 0;
    }

    @Override
    public char[] normalizeChars(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return null;
        }
        char[] normalizedString = str.toCharArray();
        for (int i = 0; i < this.m_charReplacements.length; ++i) {
            int startAtIdx;
            LocalReplacementPair kp = this.m_charReplacements[i];
            int ndx = CharArray.indexOf(normalizedString, kp.toBeReplacedChars);
            if (ndx <= -1) continue;
            do {
                normalizedString = this.replace(normalizedString, kp.replacementChars, ndx, kp.toBeReplacedChars.length);
            } while ((startAtIdx = ndx + kp.replacementChars.length) >= 0 && (ndx = CharArray.indexOf(normalizedString, kp.toBeReplacedChars, startAtIdx)) > -1);
        }
        char[] retChars = new char[normalizedString.length];
        for (int i = 0; i < normalizedString.length; ++i) {
            retChars[i] = normalizedString[i];
        }
        return retChars;
    }

    private char[] replace(char[] chars, char[] charsReplace, int offset, int n) {
        int newSize = 0;
        newSize = charsReplace.length == 0 ? chars.length - n : (n > charsReplace.length ? chars.length - (n - charsReplace.length) : chars.length + (charsReplace.length - n));
        char[] charsToRet = new char[newSize];
        if (offset > 0) {
            CharArray.arraycopy(chars, 0, charsToRet, 0, offset);
        }
        if (charsReplace.length == 0) {
            CharArray.arraycopy(chars, offset + n, charsToRet, offset, chars.length - (offset + n));
        } else {
            CharArray.arraycopy(charsReplace, 0, charsToRet, offset, charsReplace.length);
            CharArray.arraycopy(chars, offset + n, charsToRet, offset + charsReplace.length, chars.length - (offset + n));
        }
        return charsToRet;
    }

    @Override
    public final int[] getAlternateSoundexes(String str, int altMask) {
        return null;
    }

    @Override
    public boolean startsWithSoundex(int soundex1, int soundex2) {
        return ("" + soundex1).startsWith("" + soundex2);
    }

    @Override
    public final int addSoundex(int soundex1, int soundex2) {
        return soundex1 + soundex2;
    }

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        String baseName = "/com/mapinfo/mapmarker/" + country + "/config/" + country + "_AltSoundex";
        CGGESoundexPropertiesLoader loader = CGGESoundexPropertiesLoaderFactory.getInstance(baseName, language);
        try {
            loader.init(country, language, this, this.getConfiguration(this.m_country, this.m_language, "_AltSoundex"));
        }
        catch (CGGEInternalException e1) {
            throw new CGGERuntimeException(e1);
        }
        return true;
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    @Override
    public void setCharReplacements(List<KeyedPattern> charReplacements) {
        ArrayList<LocalReplacementPair> temp = new ArrayList<LocalReplacementPair>();
        Iterator<KeyedPattern> it = charReplacements.iterator();
        while (it.hasNext()) {
            this.createLocalReplacementPairsFromKeyedPattern(temp, it.next());
        }
        this.m_charReplacements = new LocalReplacementPair[temp.size()];
        temp.toArray(this.m_charReplacements);
    }

    private void createLocalReplacementPairsFromKeyedPattern(List<LocalReplacementPair> list, KeyedPattern kp) {
        char[] replacement = kp.getKey().toCharArray();
        String replacementTokens = kp.getRegex();
        if (replacementTokens.indexOf(124) > 0) {
            StringTokenizer st = new StringTokenizer(replacementTokens, "|()+");
            while (st.hasMoreTokens()) {
                list.add(new LocalReplacementPair(replacement, st.nextToken().toCharArray()));
            }
        } else {
            char[] toBeReplaced = replacementTokens.toCharArray();
            if (Arrays.equals(toBeReplaced, replacement)) {
                return;
            }
            list.add(new LocalReplacementPair(replacement, toBeReplaced));
        }
    }

    @Override
    public void setSoundexMap(Map<Character, Byte> soundexMapping) {
    }

    @Override
    public void setSoundexFilterPattern(Pattern m_soundexFilterPattern) {
    }

    @Override
    public void setUniqueSounds(Set<Byte> uniqueSounds) {
    }

    @Override
    public void setMaxSoundexLen(int m_maxSoundexLen) {
    }

    @Override
    public void setSoundexReplacements(List<KeyedPattern> soundexReplacements) {
    }

    @Override
    public void setNumeralSoundexLen(short numeralSoundexLen) {
    }

    private class LocalReplacementPair {
        public char[] toBeReplacedChars;
        public char[] replacementChars;

        public LocalReplacementPair(char[] replacement, char[] toReplace) {
            this.toBeReplacedChars = toReplace;
            this.replacementChars = replacement;
        }
    }
}

