/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.soundex;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.soundex.CGGESoundexPropertiesLoader;
import com.mapinfo.mapmarker.cgge.soundex.KeyedPattern;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CGGESoundexPropertiesLoaderFactory {
    public static CGGESoundexPropertiesLoader getInstance(String baseName, String language) {
        Properties prop;
        try {
            prop = CGGEResourceBundle.getBundle(baseName, language);
        }
        catch (CGGEInternalException e1) {
            throw new CGGERuntimeException(e1);
        }
        if (Boolean.valueOf(prop.getProperty("updated_property_behavior", "false")).booleanValue()) {
            return new CGGESoundexPropertiesLoader(baseName);
        }
        if (baseName.endsWith("_AltSoundex")) {
            return new LegacyAltSoundexPropertiesLoader(baseName);
        }
        return new LegacySoundexPropertiesLoader(baseName);
    }

    static class LegacyAltComparator
    implements Comparator<KeyedPattern> {
        LegacyAltComparator() {
        }

        @Override
        public int compare(KeyedPattern cr1, KeyedPattern cr2) {
            String pat1 = cr1.getRegex();
            String pat2 = cr2.getRegex();
            int comp = pat2.length() - pat1.length();
            if (comp == 0) {
                comp = pat1.compareTo(pat2);
            }
            return comp;
        }
    }

    static class LegacyAltSoundexPropertiesLoader
    extends LegacySoundexPropertiesLoader {
        public LegacyAltSoundexPropertiesLoader(String baseName) {
            super(baseName);
        }

        @Override
        protected void addReplaceItem(String key, String value, List<KeyedPattern> items) {
            block3: {
                int tokenCount;
                StringTokenizer st;
                block2: {
                    st = new StringTokenizer(value, ",");
                    tokenCount = st.countTokens();
                    if (!value.startsWith(",")) break block2;
                    while (st.hasMoreTokens()) {
                        items.add(new KeyedPattern("", st.nextToken()));
                    }
                    break block3;
                }
                if (tokenCount <= 1) break block3;
                String replaceToString = st.nextToken();
                while (st.hasMoreTokens()) {
                    items.add(new KeyedPattern(replaceToString, st.nextToken().trim()));
                }
            }
        }

        @Override
        protected List<KeyedPattern> sortFinalPropertyList(List<KeyedPattern> list) {
            if (list == null || list.isEmpty()) {
                return list;
            }
            KeyedPattern[] keys = new KeyedPattern[list.size()];
            list.toArray(keys);
            Arrays.sort(keys, new LegacyAltComparator());
            ArrayList<KeyedPattern> sorted = new ArrayList<KeyedPattern>(list.size());
            sorted.addAll(Arrays.asList(keys));
            return sorted;
        }
    }

    static class LegacyComparator
    implements Comparator<KeyedPattern> {
        LegacyComparator() {
        }

        @Override
        public int compare(KeyedPattern cr1, KeyedPattern cr2) {
            String pat1 = cr1.getRegex();
            String pat2 = cr2.getRegex();
            int comp = pat1.length() - pat2.length();
            if (comp == 0) {
                comp = pat1.compareTo(pat2);
            }
            return comp;
        }
    }

    static class LegacySoundexPropertiesLoader
    extends CGGESoundexPropertiesLoader {
        public LegacySoundexPropertiesLoader(String baseName) {
            super(baseName);
        }

        @Override
        protected void addReplaceItem(String key, String value, List<KeyedPattern> items) {
            StringTokenizer st = new StringTokenizer(value, ",");
            int tokenCount = st.countTokens();
            if (tokenCount > 1) {
                String replaceToString = st.nextToken();
                while (st.hasMoreTokens()) {
                    String regex = st.nextToken().trim();
                    items.add(new KeyedPattern(replaceToString, this.buildPattern(regex), regex));
                }
            }
        }

        private Pattern buildPattern(String regex) {
            if (regex.length() == 1) {
                return Pattern.compile(regex);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(regex);
            sb.append(")+");
            return Pattern.compile(sb.toString());
        }

        @Override
        protected List<String> sortInitialPropertyKeys(Properties props) {
            Set<Object> keySet = props.keySet();
            String[] tempKeys = new String[keySet.size()];
            keySet.toArray(tempKeys);
            return Arrays.asList(tempKeys);
        }

        @Override
        protected List<KeyedPattern> sortFinalPropertyList(List<KeyedPattern> list) {
            if (list == null || list.isEmpty()) {
                return list;
            }
            KeyedPattern[] keys = new KeyedPattern[list.size()];
            list.toArray(keys);
            Arrays.sort(keys, new LegacyComparator());
            ArrayList<KeyedPattern> sorted = new ArrayList<KeyedPattern>(list.size());
            sorted.addAll(Arrays.asList(keys));
            return sorted;
        }
    }
}

