/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import java.util.ArrayList;
import java.util.List;

public final class AddressWordArray {
    public static final AddressWord[] EMPTY_ARRAY = new AddressWord[0];
    private static int CALL_NATIVE_COPY_LIMIT = 8;

    public static final void arraycopy(AddressWord[] src, int srcPos, AddressWord[] dest, int destPos, int length) {
        if (length < CALL_NATIVE_COPY_LIMIT && src != dest) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos + i];
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static final AddressWord[] combineArrays(AddressWord[] array1, AddressWord[] array2) {
        if (array1 == null || array2 == null) {
            throw new NullPointerException("array is null");
        }
        int len1 = array1.length;
        int len2 = array2.length;
        int newLen = len1 + len2;
        AddressWord[] combinedArray = new AddressWord[newLen];
        AddressWordArray.arraycopy(array1, 0, combinedArray, 0, len1);
        AddressWordArray.arraycopy(array2, 0, combinedArray, len1, len2);
        return combinedArray;
    }

    public static final AddressWord[] clone(AddressWord[] src) {
        int l = src.length;
        AddressWord[] srcCopy = new AddressWord[l];
        while (--l >= 0) {
            srcCopy[l] = new AddressWord(src[l]);
        }
        return srcCopy;
    }

    public static final List<AddressWord> arrayAsList(AddressWord[] array) {
        int arrayLen = array == null ? 0 : array.length;
        ArrayList<AddressWord> list = null;
        if (arrayLen > 0) {
            list = new ArrayList<AddressWord>(arrayLen);
            for (int i = 0; i < arrayLen; ++i) {
                list.add(array[i]);
            }
        }
        return list;
    }

    public static int size(AddressWord[] words) {
        return words == null ? 0 : words.length;
    }
}

