/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ArrayUtils {
    public static <T> void insert(T[] array, int ndx, T e) {
        int size = array.length;
        if (ndx < 0 || ndx >= size) {
            throw new IndexOutOfBoundsException();
        }
        ArrayUtils.insert1(array, ndx, e, size);
    }

    private static <T> void insert1(T[] array, int ndx, T e, int size) {
        if (ndx != size - 1) {
            System.arraycopy(array, ndx, array, ndx + 1, size - (ndx + 1));
        }
        array[ndx] = e;
    }

    public static <T> void insertIntoSortedArray(T[] array, Comparable<? super T> e, int size) {
        Comparator comp = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        };
        ArrayUtils.insertIntoSortedArray(array, e, comp, size);
    }

    public static <T> void insertIntoSortedArray(T[] array, T e, Comparator<? super T> c, int size) {
        if (size == 0) {
            throw new IllegalArgumentException("Cannot insert into array of size 0");
        }
        if (array == null || size > array.length) {
            throw new IllegalArgumentException("Array size less than specified");
        }
        int pos = ArrayUtils.insertPos_withoutChecks(array, e, c, 0, size - 1);
        ArrayUtils.insert1(array, pos, e, size);
    }

    public static <T> int insertPos(T[] array, T e, int start, int end) {
        Comparator comp = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        };
        return ArrayUtils.insertPos(array, e, comp, start, end);
    }

    public static <T> int insertPos(T[] keys, T key, Comparator<? super T> comparator, int start, int end) {
        int size = keys.length;
        if (start < 0 || start >= size) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0 || end > size) {
            throw new IndexOutOfBoundsException();
        }
        if (end <= start) {
            throw new IllegalArgumentException("end should be greater than start");
        }
        return ArrayUtils.insertPos_withoutChecks(keys, key, comparator, start, end);
    }

    public static <T> int insertPos_withoutChecks(T[] array, T e, Comparator<? super T> comp, int start, int end) {
        int low = start;
        int high = end - 1;
        int midDiffVal = 0;
        while (low <= high) {
            int mid = low + high >> 1;
            midDiffVal = comp.compare(e, array[mid]);
            if (midDiffVal > 0) {
                low = mid + 1;
                continue;
            }
            if (midDiffVal < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    public static int[] asArray(Collection<Integer> values) {
        if (values == null || values.isEmpty()) {
            return new int[0];
        }
        int[] array = new int[values.size()];
        int added = 0;
        for (int v : values) {
            array[added++] = v;
        }
        return array;
    }

    public static List<Integer> asList(int[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(values.length);
        for (int v : values) {
            list.add(v);
        }
        return list;
    }

    public static <T> T[] combineArrays(T[] array1, T[] array2) {
        if (array1 == null) {
            return array2;
        }
        if (array2 == null) {
            return array1;
        }
        int len1 = array1.length;
        int len2 = array2.length;
        T[] newArray = Arrays.copyOf(array1, len1 + len2);
        System.arraycopy(array2, 0, newArray, len1, len2);
        return newArray;
    }
}

