/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import com.mapinfo.mapmarker.cgge.utils.ReadOnlyIterator;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class BitArray {
    private static final int BITS_PER_WORD = 8;
    private int m_size;
    private byte[] m_words;

    public BitArray() {
        this.m_size = 0;
    }

    public BitArray(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be at least 1");
        }
        this.m_size = size;
        this.ensureCapacity(this.m_size);
    }

    private final void ensureCapacity(int capacity) {
        int bytes = this.caculateBytesRequired(capacity);
        if (this.m_words == null) {
            this.m_words = new byte[bytes];
        } else if (this.m_words.length < bytes) {
            this.m_words = Arrays.copyOf(this.m_words, bytes);
        }
    }

    public int append(boolean bit) {
        int ndx = this.m_size;
        this.increaseSizeBy(1);
        if (bit) {
            this.setBit(ndx);
        }
        return this.m_size;
    }

    private final int caculateBytesRequired(int size) {
        return (int)Math.ceil((double)size / 8.0);
    }

    public void increaseSizeBy(int s) {
        this.m_size += s;
        this.ensureCapacity(this.m_size);
    }

    public void setBit(int ndx) {
        this.checkIndex(ndx);
        int wordNdx = BitArray.wordIndex(ndx);
        int bitNdx = ndx % 8;
        int n = wordNdx;
        this.m_words[n] = (byte)(this.m_words[n] | 1 << bitNdx);
    }

    public boolean isSet(int ndx) {
        this.checkIndex(ndx);
        int bitNdx = ndx % 8;
        return (this.m_words[BitArray.wordIndex(ndx)] & 1 << bitNdx) > 0;
    }

    private static final int wordIndex(int ndx) {
        return ndx >> 3;
    }

    public void write(DataOutput out) throws IOException {
        IOUtil.writeVUnsignedNumber(out, this.m_size);
        int wordLen = this.caculateBytesRequired(this.m_size);
        for (int i = 0; i < wordLen; ++i) {
            out.writeByte(this.m_words[i]);
        }
    }

    public void read(DataInput in) throws IOException {
        this.m_size = (int)IOUtil.readVUnsignedNumber(in);
        int wordLen = this.caculateBytesRequired(this.m_size);
        this.m_words = new byte[wordLen];
        in.readFully(this.m_words);
    }

    public int size() {
        return this.m_size;
    }

    public int sizeInBytes() {
        return this.caculateBytesRequired(this.m_size);
    }

    private final void checkIndex(int ndx) {
        if (ndx < 0 || ndx >= this.m_size) {
            throw new ArrayIndexOutOfBoundsException("Invalid index " + ndx);
        }
    }

    public BitArray subArray(int startNdx, int endNdx) {
        this.checkIndex(startNdx);
        if (startNdx >= endNdx || endNdx > this.size()) {
            throw new IllegalArgumentException("invalid endNdx");
        }
        int size = endNdx - startNdx;
        BitArray subArray = new BitArray(size);
        for (int i = startNdx; i < endNdx; ++i) {
            if (!this.isSet(i)) continue;
            subArray.setBit(i - startNdx);
        }
        return subArray;
    }

    public int append(BitArray array) {
        int s = array.size();
        int nextNdx = this.size();
        this.increaseSizeBy(s);
        int i = 0;
        while (i < s) {
            if (array.isSet(i)) {
                this.setBit(nextNdx);
            }
            ++i;
            ++nextNdx;
        }
        return s;
    }

    public String toString() {
        int s = this.size();
        StringBuilder sb = new StringBuilder(s);
        for (int i = s - 1; i >= 0; --i) {
            sb.append(this.isSet(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }

    public static BitArray parseBitArray(String str) {
        int n = str.length();
        BitArray bitArray = n > 0 ? new BitArray(n) : new BitArray();
        for (int i = 0; i < n; ++i) {
            char bit = str.charAt(n - i - 1);
            if (bit == '1') {
                bitArray.setBit(i);
                continue;
            }
            if (bit == '0') continue;
            throw new NumberFormatException("String is not fully made up ot binary bit characters");
        }
        return bitArray;
    }

    public byte toByte() {
        if (this.m_size > 0) {
            return this.m_words[0];
        }
        return 0;
    }

    public static BitArray fromByte(byte b) {
        BitArray array = new BitArray(8);
        array.m_words[0] = b;
        return array;
    }

    public BitIterator getBitIterator() {
        return new BitIterator(this.m_words, this.size());
    }

    public static final class BitIterator
    extends ReadOnlyIterator<Integer> {
        private final byte[] m_words;
        private final int m_size;
        private int m_currNdx;
        private byte m_currWord;

        BitIterator(byte[] words, int size) {
            this(words, size, 0);
        }

        BitIterator(byte[] words, int size, int startNdx) {
            this.m_words = words;
            this.m_size = size;
            this.m_currNdx = startNdx;
        }

        @Override
        public boolean hasNext() {
            return this.m_currNdx < this.m_size;
        }

        @Override
        public Integer next() {
            return this.isNextSet() ? 1 : 0;
        }

        public boolean isNextSet() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int bitNdx = this.m_currNdx % 8;
            if (bitNdx == 0) {
                this.setNextWord();
            }
            ++this.m_currNdx;
            return (this.m_currWord & 1 << bitNdx++) > 0;
        }

        private void setNextWord() {
            this.m_currWord = this.m_words[BitArray.wordIndex(this.m_currNdx)];
        }
    }
}

