/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class CGGEResourceBundle {
    public static final String CONFIG_PACKAGE_PREFIX = "/com/mapinfo/mapmarker/";
    public static final String CONFIG_PACKAGE = "/config/";

    public static Properties getBundle(String baseName, String language, String type) throws CGGEInternalException {
        return CGGEResourceBundle.getBundle(baseName, null, language, type);
    }

    public static Properties getBundle(String country, String componentName, String dataSetName, String language, String typeName) throws CGGEInternalException {
        return CGGEResourceBundle.getBundle(CGGEResourceBundle.buildBaseConfigName(country, componentName), dataSetName, language, typeName);
    }

    public static Properties getBundle(String baseName, String dataSetName, String language, String type) throws CGGEInternalException {
        CGGEResourceBundle.checkResourceName(baseName);
        boolean hasDataSetName = !MMUtils.isEmpty(dataSetName);
        boolean hasLanguage = !MMUtils.isEmpty(language);
        boolean hasType = !MMUtils.isEmpty(type);
        Properties prop = null;
        try {
            prop = CGGEResourceBundle.loadBundle(CGGEResourceBundle.checkExtension(baseName, dataSetName, language, type));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (prop == null && hasDataSetName) {
            if (hasType && hasLanguage) {
                try {
                    prop = CGGEResourceBundle.loadBundle(CGGEResourceBundle.checkExtension(baseName, dataSetName, null, type));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (prop == null) {
                    try {
                        prop = CGGEResourceBundle.loadBundle(CGGEResourceBundle.checkExtension(baseName, dataSetName, language, null));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (prop == null) {
                try {
                    prop = CGGEResourceBundle.loadBundle(CGGEResourceBundle.checkExtension(baseName, dataSetName, null, null));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (prop == null) {
            try {
                prop = CGGEResourceBundle.loadBundle(CGGEResourceBundle.checkExtension(baseName, null, language, type));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (prop == null && hasLanguage) {
                try {
                    prop = CGGEResourceBundle.loadBundle(CGGEResourceBundle.checkExtension(baseName, null, null, type));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (prop == null && hasType) {
                try {
                    prop = CGGEResourceBundle.loadBundle(CGGEResourceBundle.checkExtension(baseName, null, language, null));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (prop == null) {
            try {
                prop = CGGEResourceBundle.loadBundle(CGGEResourceBundle.checkExtension(baseName, null, null, null));
            }
            catch (IOException io) {
                throw new CGGEInternalException("Failed to load resource " + baseName, io);
            }
        }
        if (prop == null) {
            throw new CGGEInternalException("Failed to load resource " + baseName);
        }
        return prop;
    }

    public static Properties getBundle(String baseName, String language) throws CGGEInternalException {
        return CGGEResourceBundle.getBundle(baseName, language, null);
    }

    public static Properties getBundle(String baseName) throws CGGEInternalException {
        return CGGEResourceBundle.getBundle(baseName, null, null);
    }

    private static Properties loadBundle(String baseName) throws IOException {
        Properties prop = null;
        InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(baseName);
        if (inStream == null) {
            inStream = CGGEResourceBundle.class.getResourceAsStream(baseName);
        }
        if (inStream != null) {
            prop = new Properties();
            prop.load(inStream);
        }
        return prop;
    }

    private static String checkExtension(String baseName, String dataSetName, String language, String type) {
        String ext = ".properties";
        StringBuilder builder = new StringBuilder(baseName);
        int insertPos = -1;
        boolean extFound = false;
        if (baseName.toLowerCase().endsWith(ext)) {
            insertPos = builder.lastIndexOf(ext);
            extFound = true;
        } else {
            insertPos = builder.length();
        }
        if (!MMUtils.isEmpty(language)) {
            builder.insert(insertPos, language);
            builder.insert(insertPos, '_');
        }
        if (!MMUtils.isEmpty(type)) {
            builder.insert(insertPos, type);
            builder.insert(insertPos, '_');
        }
        if (!MMUtils.isEmpty(dataSetName)) {
            builder.insert(insertPos, dataSetName);
            builder.insert(insertPos, '_');
        }
        if (!extFound) {
            builder.append(ext);
        }
        return builder.toString();
    }

    private static void checkResourceName(String baseName) throws CGGEInternalException {
        if (MMUtils.isEmpty(baseName)) {
            throw new CGGEInternalException("Resource name cannot be null or empty");
        }
    }

    public static String buildBaseConfigName(String cntry, String classSuffix) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(CONFIG_PACKAGE_PREFIX);
        sb.append(cntry);
        sb.append(CONFIG_PACKAGE);
        sb.append(cntry);
        sb.append(classSuffix);
        return sb.toString();
    }
}

