/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class ListUtils {
    public static final <K> List<K> combineLists(List<K> list1, List<K> list2) {
        if (list1 == null) {
            return list2;
        }
        if (list2 != null) {
            list1.addAll(list2);
        }
        return list1;
    }

    public static final <T> List<T> newList(T t) {
        ArrayList<T> list = null;
        if (t != null) {
            list = new ArrayList<T>();
            list.add(t);
        }
        return list;
    }

    public static final <T> List<T> newList(Collection<T> c) {
        ArrayList<T> list = null;
        if (c != null) {
            list = new ArrayList<T>(c);
        }
        return list;
    }

    public static final <T> boolean isEmpty(Collection<T> c) {
        return c == null ? true : c.isEmpty();
    }

    public static final <T> List<T> addToList(List<T> list, T t) {
        if (t != null) {
            if (list == null) {
                list = ListUtils.newList(t);
            } else {
                list.add(t);
            }
        }
        return list;
    }

    public static final <T> List<T> addToList(List<T> list, Iterator<T> iter) {
        if (iter != null && iter.hasNext()) {
            if (list == null) {
                list = new ArrayList<T>(5);
            }
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static final <T> Collection<T> addToCollection(Collection<T> list, T t) {
        if (t != null) {
            if (list == null) {
                list = ListUtils.newList(t);
            } else {
                list.add(t);
            }
        }
        return list;
    }

    public static final <T> List<T> addToList(List<T> list, Collection<T> c) {
        if (c != null) {
            if (list == null) {
                list = ListUtils.newList(c);
            } else {
                list.addAll(c);
            }
        }
        return list;
    }

    public static final <T> Collection<T> addToCollection(Collection<T> list, Collection<T> c) {
        if (c != null) {
            if (list == null) {
                list = ListUtils.newList(c);
            } else {
                list.addAll(c);
            }
        }
        return list;
    }

    public static final <T extends Comparable<? super T>> List<T> removeDuplicates(List<T> list) {
        if (list != null && list.size() > 1) {
            Collections.sort(list);
            int n = list.size();
            Comparable lastItem = (Comparable)list.get(0);
            for (int i = 1; i < n; ++i) {
                Comparable curItem = (Comparable)list.get(i);
                if (lastItem.compareTo(curItem) == 0) {
                    list.remove(i);
                    --n;
                    --i;
                    continue;
                }
                lastItem = curItem;
            }
        }
        return list;
    }

    public static final <T extends Comparable<T>> int positionInSortedList(List<T> list, T item) {
        int size = list.size();
        if (size > 0) {
            int low = 0;
            int high = list.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int midDiffVal = item.compareTo(list.get(mid));
                if (midDiffVal > 0) {
                    low = mid + 1;
                    continue;
                }
                if (midDiffVal < 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return low;
        }
        return 0;
    }

    public static final <T extends Comparable<T>> int insertToSortedList(List<T> list, T item) {
        int ndx = ListUtils.positionInSortedList(list, item);
        list.add(ndx, item);
        return ndx;
    }

    public static final <T> Iterable<T> getIterable(final Iterator<T> it) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return it;
            }
        };
    }
}

