/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.DictionaryUsage;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MMUtils {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static final boolean isDigit(int ch) {
        return Character.isDigit(ch);
    }

    public static final String appendToPath(String path, String name) {
        if (name == null) {
            return path;
        }
        if (path != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(path);
            if (!path.endsWith("\\") && !path.endsWith("/")) {
                builder.append(FILE_SEPARATOR);
            }
            builder.append(name);
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(".");
        builder.append(FILE_SEPARATOR);
        builder.append(name);
        return builder.toString();
    }

    public static final boolean containsDigits(String str) {
        if (str != null) {
            return MMUtils.containsDigits(str.toCharArray());
        }
        return false;
    }

    public static final int parseInteger(char[] chars) throws NumberFormatException {
        int charCount;
        int n = charCount = chars == null ? 0 : chars.length;
        if (charCount == 0) {
            throw new NumberFormatException("Not a number");
        }
        int r = 0;
        for (int i = 0; i < charCount; ++i) {
            int v = Character.digit(chars[i], 10);
            if (v < 0) {
                throw new NumberFormatException("Not a number");
            }
            r *= 10;
            r += v;
        }
        return r;
    }

    public static final boolean containsDigits(char[] chars) {
        return MMUtils.indexOfFirstDigit(chars) > -1;
    }

    private static final int indexOfFirstDigit(char[] chars) {
        if (chars != null) {
            for (int i = 0; i < chars.length; ++i) {
                if (!MMUtils.isDigit(chars[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static final char[] splitFromDigits(char[] chars) {
        int pos = MMUtils.indexOfFirstDigit(chars);
        if (pos > 0) {
            char[] subChars = new char[pos];
            CharArray.arraycopy(chars, 0, subChars, 0, pos);
            return subChars;
        }
        return null;
    }

    public static final boolean isNumber(String str) {
        return str == null ? false : MMUtils.isNumber(str.toCharArray());
    }

    public static final boolean isNumber(char[] chars) {
        int n;
        int n2 = n = chars == null ? 0 : chars.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                char ch = chars[i];
                if (Character.isDigit((int)ch) || i == 0 && n > 1 && ch == '-') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final long trimDigits(long number, int digits) {
        int d = MMUtils.getDigitCount(number);
        if (digits > 0 && d > digits) {
            long n = d - digits;
            n = (long)Math.pow(10.0, n);
            return number / n;
        }
        return number;
    }

    public static final int getDigitCount(long number) {
        number = Math.abs(number);
        int n = 0;
        do {
            ++n;
        } while ((number /= 10L) > 0L);
        return n;
    }

    public static final char[] getDigits(int number) {
        number = Math.abs(number);
        int len = MMUtils.getNumberOfDigits(number);
        char[] digits = new char[len];
        for (int i = 0; i < len; ++i) {
            digits[len - (i + 1)] = Character.forDigit(number % 10, 10);
            number /= 10;
        }
        return digits;
    }

    public static final boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static final String getStartingNumberPart(String str) {
        char[] chars;
        char[] cArray = chars = str == null || str.length() == 0 ? null : str.toCharArray();
        if (chars != null && MMUtils.startsWithDigits(chars)) {
            int pos = -1;
            int i = 0;
            while (i < chars.length && Character.isDigit(chars[i])) {
                pos = i++;
            }
            if (pos >= 0) {
                return str.substring(0, pos + 1);
            }
        }
        return null;
    }

    public static final String[] splitString(String str, String delim, boolean returnDelims) {
        return MMUtils.splitString(str, delim, returnDelims, false);
    }

    public static final String[] splitString(String str, String delim, boolean returnDelims, boolean trimSpaces) {
        StringTokenizer st;
        int nCount;
        if (str != null && delim != null && (nCount = (st = new StringTokenizer(str, delim, returnDelims)).countTokens()) > 0) {
            String[] words = new String[st.countTokens()];
            for (int i = 0; i < words.length; ++i) {
                words[i] = trimSpaces ? st.nextToken().trim() : st.nextToken();
            }
            return words;
        }
        return null;
    }

    public static final boolean startsWith(int n1, int n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == 0 || n2 == 0) {
            return false;
        }
        int n = n1;
        do {
            if (n != n2) continue;
            return true;
        } while ((n /= 10) > 0);
        return false;
    }

    public static final boolean startsWith(char[] c1, char[] c2) {
        int n2;
        int n1 = c1 == null ? 0 : c1.length;
        int n = n2 = c2 == null ? 0 : c2.length;
        if (n2 > 0 && n2 <= n1) {
            for (int i = 0; i < n2; ++i) {
                if (c1[i] == c2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean startsWithDigits(char[] chars) {
        return chars != null && chars.length > 0 && Character.isDigit(chars[0]);
    }

    public static final String[] splitString(String str, char delim) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        int delimCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != delim) continue;
            ++delimCount;
        }
        if (delimCount == 0) {
            return new String[]{str};
        }
        String[] retStrings = new String[delimCount + 1];
        int added = 0;
        int lastndx = 0;
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == delim) {
                if (i - lastndx > 0) {
                    retStrings[added++] = str.substring(lastndx, i);
                }
                lastndx = i + 1;
                continue;
            }
            if (i != len - 1) continue;
            retStrings[added++] = str.substring(lastndx, len);
        }
        if (added > 0) {
            if (added < retStrings.length) {
                String[] newStrings = new String[added];
                System.arraycopy(retStrings, 0, newStrings, 0, added);
                retStrings = newStrings;
            }
            return retStrings;
        }
        return null;
    }

    public static final int getNumberOfDigits(int n) {
        int nDigits = 0;
        do {
            ++nDigits;
        } while ((n /= 10) > 0);
        return nDigits;
    }

    public static int toPositiveInteger(byte b) {
        int n = 0;
        if (b < 0) {
            n |= 0x80;
            return n |= b & 0x7F;
        }
        return b;
    }

    public static int toPositiveInteger(short s) {
        int n = 0;
        if (s < 0) {
            n |= 0x8000;
            return n |= s & Short.MAX_VALUE;
        }
        return s;
    }

    public static final int nextInsertPosition(List list, Object item, Comparator comp) {
        int size = list.size();
        if (size > 0) {
            int midDiffVal = comp.compare(item, list.get(size - 1));
            if (midDiffVal >= 0) {
                return size;
            }
            midDiffVal = comp.compare(item, list.get(0));
            if (midDiffVal < 0) {
                return 0;
            }
            if (midDiffVal == 0) {
                return 1;
            }
            int low = 1;
            int high = list.size() - 2;
            while (low <= high) {
                int mid = low + high >> 1;
                midDiffVal = comp.compare(item, list.get(mid));
                if (midDiffVal > 0) {
                    low = mid + 1;
                    continue;
                }
                if (midDiffVal < 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return low;
        }
        return 0;
    }

    public static final <T extends Comparable<T>> int nextInsertPosition(List<T> list, T item) {
        int size = list.size();
        if (size > 0) {
            int low = 1;
            int high = list.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int d = item.compareTo(list.get(mid));
                if (d > 0) {
                    low = mid + 1;
                    continue;
                }
                if (d < 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return low;
        }
        return 0;
    }

    public static <T> Comparator<T> getReverseComparator(Comparator<T> c) {
        return Collections.reverseOrder(c);
    }

    public static int compareDoubleValues(double d1, double d2) {
        if (d1 > d2) {
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        return 0;
    }

    public static int compareLongValues(long l1, long l2) {
        if (l1 > l2) {
            return 1;
        }
        if (l1 < l2) {
            return -1;
        }
        return 0;
    }

    public static int convertToIntValue(String field) throws NumberFormatException {
        if (field != null && field.length() > 0) {
            return (int)Double.parseDouble(field);
        }
        throw new NumberFormatException("Field should not be empty");
    }

    public static final <T extends Comparable<T>> int compare(T t1, T t2) {
        if (t1 == t2) {
            return 0;
        }
        if (t1 != null && t2 != null) {
            return t1.compareTo(t2);
        }
        if (t1 != null) {
            return 1;
        }
        return -1;
    }

    public static AddressWord[] getSplitWords(AddressWord[] inWords, String country, String language) {
        if (inWords != null) {
            ICGGEParser parser = CGGEHandler.getInstance(null, country, language).getParser();
            ICGGESoundex soundex = CGGEHandler.getInstance(null, country, language).getSoundex();
            StringBuilder sb = new StringBuilder(15);
            ArrayList<AddressWord> splitWords = new ArrayList<AddressWord>(5);
            for (AddressWord addrWord : inWords) {
                AddressWord splitWord;
                int i;
                if (!AddressWord.isSignificantWord(addrWord)) continue;
                char[] ch = addrWord.getWordChars();
                int len = ch.length;
                sb.append(ch);
                for (i = 1; i < len - 1; ++i) {
                    sb.deleteCharAt(sb.length() - 1);
                    splitWord = parser.convertToAddressWord(sb.toString(), soundex);
                    if (!AddressWord.isSignificantWord(splitWord)) continue;
                    splitWords.add(splitWord);
                }
                sb.delete(0, sb.length());
                sb.append(ch);
                for (i = 1; i < len - 1; ++i) {
                    sb.deleteCharAt(0);
                    splitWord = parser.convertToAddressWord(sb.toString(), soundex);
                    if (!AddressWord.isSignificantWord(splitWord)) continue;
                    splitWords.add(splitWord);
                }
                sb.delete(0, sb.length());
            }
            if (splitWords.size() > 0) {
                AddressWord[] newSearchWords = new AddressWord[splitWords.size()];
                newSearchWords = splitWords.toArray(newSearchWords);
                return newSearchWords;
            }
        }
        return null;
    }

    public static void adjustDictionarySearchOrderForLanguage(String language, GeocodeOptions options, IDataManager dataManager, int dataType) {
        if (StringUtilities.isEmpty((String)language)) {
            return;
        }
        int c = dataManager.getDictionaryCount();
        for (int i = 0; i < c; ++i) {
            List<DataSetInfo> dataSetInfos = dataManager.getDataSetInfos(i + 1, dataType);
            String dataLang = dataSetInfos.get(0).getMetaData().getLanguage();
            if (language.equals(dataLang)) continue;
            DictionaryUsage usage = options.getDictionaryUsageForDictionary(i + 1);
            if (usage == null) {
                usage = new DictionaryUsage();
                usage.setDictionaryNumber(i + 1);
                usage.setSearchOrder(i + 1);
                usage.setUsed(false);
                options.setDictionaryUsageForDictionary(i + 1, usage);
                continue;
            }
            usage.setUsed(false);
        }
    }

    public static ClassLoader getCurrentClassLoader(String className) {
        ClassLoader currentClassLoader = null;
        try {
            if (!StringUtilities.isEmpty((String)className)) {
                Class<?> clazz = Class.forName(className);
            }
            currentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (ClassNotFoundException cnfe) {
            return Thread.currentThread().getContextClassLoader().getParent();
        }
        return currentClassLoader;
    }

    public static String getGeocodeTypeName(int geocodeType) {
        switch (geocodeType) {
            case 1: {
                return "street";
            }
            case 2: {
                return "postal";
            }
            case 3: {
                return "geographic";
            }
            case 4: {
                return "poi";
            }
        }
        return "";
    }

    public static boolean usingNonNumericCombinedWordScore(Map<FieldType, FieldScore> scores) {
        if (scores != null && scores.values() != null) {
            for (FieldScore fs : scores.values()) {
                if (!fs.m_nonNumericCombinedWordScoreUsed) continue;
                return true;
            }
        }
        return false;
    }

    public static Comparator<String> getStringLengthComparator() {
        return new StringLengthComparator();
    }

    private static class StringLengthComparator
    implements Comparator<String> {
        private StringLengthComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int c = s1.length() - s2.length();
            if (c == 0) {
                return s1.compareTo(s2);
            }
            return c;
        }
    }
}

