/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public final class PropertiesUtil {
    private static String DEFAULT_VALUE_DELIM = ",";

    public static double getDoublePropetyValue(Properties prop, String key, double defaultValue) {
        String value = prop.getProperty(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double getDoublePropetyValue(Properties prop, String key) {
        return PropertiesUtil.getDoublePropetyValue(prop, key, 0.0);
    }

    public static boolean getBooleanPropertyValue(Properties prop, String key, boolean defaultValue) {
        String value = prop.getProperty(key);
        if (value != null) {
            if ("TRUE".equalsIgnoreCase(value) || "YES".equalsIgnoreCase(value)) {
                return true;
            }
            if ("FALSE".equalsIgnoreCase(value) || "NO".equalsIgnoreCase(value)) {
                return false;
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanPropertyValue(Properties prop, String key) {
        return PropertiesUtil.getBooleanPropertyValue(prop, key, false);
    }

    public static int getIntegerPropertyValue(Properties prop, String key, int defaultValue) {
        String value = prop.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getIntegerPropertyValue(Properties prop, String key) {
        return PropertiesUtil.getIntegerPropertyValue(prop, key, 0);
    }

    public static short getShortPropertyValue(Properties prop, String key, short defaultValue) {
        String value = prop.getProperty(key);
        if (value != null) {
            try {
                return Short.parseShort(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static short getShortPropertyValue(Properties prop, String key) {
        return PropertiesUtil.getShortPropertyValue(prop, key, (short)0);
    }

    public static List<String> getKeysWithPrefix(Properties prop, String prefix) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            keys.add(key);
        }
        Collections.sort(keys);
        return keys;
    }

    public static List<String> getKeys(Properties prop, String prefix, String suffix) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith(prefix) || !key.endsWith(suffix)) continue;
            keys.add(key);
        }
        Collections.sort(keys);
        return keys;
    }

    public static List<String> splitValues(Properties prop, String key, String delim) {
        String value = prop.getProperty(key);
        if (value != null) {
            return Arrays.asList(value.split(delim));
        }
        return Collections.emptyList();
    }

    public static List<String> splitValues(Properties prop, String key) {
        return PropertiesUtil.splitValues(prop, key, DEFAULT_VALUE_DELIM);
    }
}

