/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RGUtils {
    private RGUtils() {
    }

    public static List<InternalStreetAddress> breakUpPointAddressRanges(List<InternalStreetAddress> streets) {
        ArrayList<InternalStreetAddress> results = new ArrayList<InternalStreetAddress>(streets.size());
        for (InternalStreetAddress street : streets) {
            results.addAll(RGUtils.breakUpPointAddressRanges(street));
        }
        return results;
    }

    private static List<InternalStreetAddress> breakUpPointAddressRanges(InternalStreetAddress street) {
        List<InternalRangeAddress> ranges = street.getRangeList();
        if (ranges.size() == 1) {
            return Collections.singletonList(street);
        }
        ArrayList<InternalStreetAddress> results = new ArrayList<InternalStreetAddress>();
        Iterator<InternalRangeAddress> rangeIterator = ranges.iterator();
        while (rangeIterator.hasNext()) {
            InternalRangeAddress range = rangeIterator.next();
            if (!range.isAddressPointData()) continue;
            rangeIterator.remove();
            results.add(RGUtils.createCopyWithRange(street, range));
        }
        if (!ranges.isEmpty()) {
            results.add(street);
        }
        return results;
    }

    private static InternalStreetAddress createCopyWithRange(InternalStreetAddress street, InternalRangeAddress range) {
        InternalStreetAddress copy = street.createCopyWithoutRanges();
        copy.addInternalRange(range);
        return copy;
    }
}

