/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.compress;

import com.mapinfo.mapmarker.cgge.utils.BitArray;
import com.mapinfo.mapmarker.cgge.utils.compress.CompTreeNode;
import com.mapinfo.mapmarker.cgge.utils.compress.NotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

class CompTree {
    private CompTreeNode m_root;
    List<CompTreeNode> m_leafNodes;
    private static final Comparator<CompTreeNode> m_symbolComparator = new Comparator<CompTreeNode>(){

        @Override
        public int compare(CompTreeNode o1, CompTreeNode o2) {
            return ((Comparable)o1.getSymbol()).compareTo(o2.getSymbol());
        }
    };

    private CompTree(CompTreeNode root) {
        this.m_root = root;
        this.m_leafNodes = new ArrayList<CompTreeNode>();
        this.setLeafNodes(this.m_root, this.m_leafNodes);
        Collections.sort(this.m_leafNodes, m_symbolComparator);
    }

    private void setLeafNodes(CompTreeNode node, List<CompTreeNode> leafNodes) {
        if (node.isLeaf()) {
            leafNodes.add(node);
        } else {
            this.setLeafNodes(node.getLeftChild(), leafNodes);
            this.setLeafNodes(node.getRightChild(), leafNodes);
        }
    }

    public static <K extends Comparable<K>> CompTree create(Map<K, Number> symbolMap) {
        if (symbolMap == null || symbolMap.isEmpty()) {
            throw new IllegalArgumentException("Null or empty map");
        }
        PriorityQueue<CompTreeNode> priorityQ = new PriorityQueue<CompTreeNode>(symbolMap.size());
        for (Map.Entry<K, Number> en : symbolMap.entrySet()) {
            CompTreeNode leafNode = new CompTreeNode(en.getKey(), en.getValue().intValue());
            priorityQ.add(leafNode);
        }
        CompTree compTree = CompTree.createTree(priorityQ);
        Iterator<Map.Entry<K, Number>> it = symbolMap.entrySet().iterator();
        compTree.convertTreeValuesToEncodedSymbol();
        return compTree;
    }

    private static CompTree createTree(PriorityQueue<CompTreeNode> priorityQ) {
        while (priorityQ.size() > 1) {
            CompTreeNode leftChild = priorityQ.poll();
            CompTreeNode rightChild = priorityQ.poll();
            CompTreeNode parentNode = new CompTreeNode(leftChild, rightChild);
            priorityQ.add(parentNode);
        }
        CompTreeNode root = priorityQ.peek();
        return new CompTree(root);
    }

    private void convertTreeValuesToEncodedSymbol() {
        for (CompTreeNode leafNode : this.m_leafNodes) {
            leafNode.setSymbol(this.getEncodedSymbolForNode(leafNode));
        }
    }

    private EncodedSymbol getEncodedSymbolForNode(CompTreeNode node) {
        BitArray bits = new BitArray();
        CompTreeNode treeNode = node;
        CompTreeNode parent = treeNode.getParent();
        while (parent != null) {
            bits.append(parent.getRightChild() == treeNode);
            treeNode = parent;
            parent = treeNode.getParent();
        }
        bits = this.reverse(bits);
        return new EncodedSymbol(node.getSymbol(), bits);
    }

    protected EncodedSymbol getNextSymbol(BitArray bitArray, int startNdx) {
        CompTreeNode node = this.m_root;
        int checkNdx = startNdx;
        int lastNdx = bitArray.size();
        while (!node.isLeaf() && checkNdx < lastNdx) {
            node = bitArray.isSet(checkNdx++) ? node.getRightChild() : node.getLeftChild();
        }
        if (!node.isLeaf()) {
            throw new NotFoundException();
        }
        return (EncodedSymbol)node.getSymbol();
    }

    protected EncodedSymbol getNextSymbol(BitArray.BitIterator bitIt) {
        CompTreeNode node = this.m_root;
        while (!node.isLeaf() && bitIt.hasNext()) {
            node = bitIt.isNextSet() ? node.getRightChild() : node.getLeftChild();
        }
        if (!node.isLeaf()) {
            throw new NotFoundException();
        }
        return (EncodedSymbol)node.getSymbol();
    }

    protected EncodedSymbol encodeSymbol(Object symbol) {
        CompTreeNode node = this.findNodeWithSymbol(symbol);
        if (node == null) {
            throw new NotFoundException();
        }
        return (EncodedSymbol)node.getSymbol();
    }

    private BitArray reverse(BitArray bits) {
        int s = bits.size();
        BitArray reversedBits = new BitArray(s);
        for (int i = 0; i < s; ++i) {
            if (!bits.isSet(s - i - 1)) continue;
            reversedBits.setBit(i);
        }
        return reversedBits;
    }

    private CompTreeNode findNodeWithSymbol(Object symbol) {
        CompTreeNode searchNode = new CompTreeNode(symbol, 0);
        int ndx = Collections.binarySearch(this.m_leafNodes, searchNode, m_symbolComparator);
        return ndx > -1 ? this.m_leafNodes.get(ndx) : null;
    }

    protected class EncodedSymbol
    implements Comparable<Object> {
        private Object m_symbol;
        private BitArray m_encodedBites;

        private EncodedSymbol(Object symbol, BitArray bites) {
            this.m_symbol = symbol;
            this.m_encodedBites = bites;
        }

        Object getSymbol() {
            return this.m_symbol;
        }

        BitArray getEncodedBytes() {
            return this.m_encodedBites;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof EncodedSymbol) {
                return ((Comparable)this.m_symbol).compareTo(((EncodedSymbol)o).getSymbol());
            }
            return ((Comparable)this.m_symbol).compareTo(o);
        }
    }
}

