/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.compress;

class CompTreeNode
implements Comparable<CompTreeNode> {
    private boolean m_leaf;
    private int m_priority;
    private CompTreeNode m_leftChild;
    private CompTreeNode m_rightChild;
    private Object m_symbol;
    private CompTreeNode m_parent;

    CompTreeNode(Object symbol, int priority) {
        this.m_symbol = symbol;
        this.m_priority = priority;
        this.m_leaf = true;
        this.m_leftChild = null;
        this.m_rightChild = null;
    }

    CompTreeNode(CompTreeNode leftChild, CompTreeNode rightChild) {
        if (leftChild == null || rightChild == null) {
            throw new NullPointerException();
        }
        this.m_symbol = null;
        this.m_leaf = false;
        this.m_leftChild = leftChild;
        this.m_rightChild = rightChild;
        this.m_leftChild.setParent(this);
        this.m_rightChild.setParent(this);
        this.m_priority = leftChild.getPriority() + rightChild.getPriority();
    }

    protected CompTreeNode getParent() {
        return this.m_parent;
    }

    protected void setParent(CompTreeNode parent) {
        this.m_parent = parent;
    }

    public int getPriority() {
        return this.m_priority;
    }

    void setPriority(int p) {
        this.m_priority = p;
    }

    public boolean isLeaf() {
        return this.m_leaf;
    }

    public Object getSymbol() {
        return this.m_symbol;
    }

    void setSymbol(Object symbol) {
        this.m_symbol = symbol;
    }

    @Override
    public int compareTo(CompTreeNode o) {
        int c = this.m_priority - o.m_priority;
        if (c == 0 && this.m_leaf != o.m_leaf) {
            c = this.m_leaf ? 1 : -1;
        }
        return c;
    }

    protected CompTreeNode getLeftChild() {
        return this.m_leftChild;
    }

    protected CompTreeNode getRightChild() {
        return this.m_rightChild;
    }
}

