/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.compress;

import com.mapinfo.mapmarker.cgge.utils.BitArray;
import com.mapinfo.mapmarker.cgge.utils.compress.CompHeader;
import com.mapinfo.mapmarker.cgge.utils.compress.CompTree;

public class StringCompressor {
    CompTree m_compTree;

    public StringCompressor(CompHeader compHeader) {
        this.m_compTree = compHeader.getCompressionTree();
    }

    public BitArray compress(String str) {
        int n = str.length();
        BitArray bits = new BitArray();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            CompTree.EncodedSymbol symbol = this.m_compTree.encodeSymbol(Character.valueOf(ch));
            bits.append(symbol.getEncodedBytes());
        }
        return bits;
    }

    public String decompress(BitArray array) {
        StringBuilder sb = new StringBuilder(50);
        BitArray.BitIterator bitIt = array.getBitIterator();
        while (bitIt.hasNext()) {
            CompTree.EncodedSymbol symbol = this.m_compTree.getNextSymbol(bitIt);
            sb.append(((Character)symbol.getSymbol()).charValue());
        }
        return sb.toString();
    }
}

