/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.index;

import com.mapinfo.mapmarker.cgge.utils.ArrayUtils;
import com.mapinfo.mapmarker.cgge.utils.index.BTree;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeDuplicateKeyException;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeNodeEntry;
import com.mapinfo.mapmarker.cgge.utils.index.IBTreeNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class BTreeNode<K>
implements IBTreeNode<K> {
    private Object[] m_keys;
    private Object[] m_values;
    private int m_size;
    private boolean m_leafNode;
    private BTree<K, ?> m_tree;

    protected <V> BTreeNode(boolean leafNode, BTree<K, V> tree) {
        this(leafNode, null, null, 0, tree);
    }

    protected BTreeNode(BTreeNode<K> copy) {
        this.m_size = copy.m_size;
        this.m_leafNode = copy.m_leafNode;
        this.m_tree = copy.m_tree;
        if (this.m_size > 0) {
            this.m_keys = (Object[])copy.m_keys.clone();
            this.m_values = (Object[])copy.m_values.clone();
        }
    }

    private BTreeNode(boolean leafNode, K[] keys, Object[] values, int size, BTree<K, ?> tree) {
        this.m_leafNode = leafNode;
        this.m_keys = keys;
        this.m_values = values;
        this.m_size = size;
        this.m_tree = tree;
    }

    @Override
    public Object replaceValue(int ndx, Object value) {
        int s = this.size();
        if (s == 0 || ndx < -1 || ndx > s) {
            throw new IndexOutOfBoundsException();
        }
        Object currentValue = this.m_values[ndx];
        this.m_values[ndx] = value;
        return currentValue;
    }

    @Override
    public Object getKey(int ndx) {
        return this.m_keys[ndx];
    }

    @Override
    public Object getValue(int ndx) {
        return this.m_values[ndx];
    }

    @Override
    public boolean isLeafNode() {
        return this.m_leafNode;
    }

    protected int maxEntries() {
        return this.getTree().getOrder();
    }

    public boolean isFull() {
        return this.m_size == this.getTree().getOrder();
    }

    protected K floorKey() {
        return (K)(this.size() > 0 ? this.getKeys()[0] : null);
    }

    protected K ceilKey() {
        return (K)(this.size() > 0 ? this.getKeys()[this.m_size - 1] : null);
    }

    protected Object floorKeyValue() {
        return this.size() > 0 ? this.getValues()[0] : null;
    }

    protected void initialiseKeysAndValues() {
        int max = this.maxEntries();
        this.m_keys = new Object[max + 1];
        this.m_values = new Object[max + 1];
    }

    private int add_noCheck(Object key, Object value) {
        int ndx = 0;
        Object[] keys = this.getKeys();
        if (this.m_size > 0) {
            ndx = ArrayUtils.insertPos(keys, key, this.m_tree.getComparator(), 0, this.m_size);
        }
        ArrayUtils.insert(keys, ndx, key);
        ArrayUtils.insert(this.getValues(), ndx, value);
        ++this.m_size;
        return ndx;
    }

    Object[] getKeys() {
        return this.m_keys;
    }

    public Object[] getValues() {
        return this.m_values;
    }

    @Override
    public void setKeyValues(K[] keys, Object[] values, int size) {
        this.m_keys = keys;
        this.m_values = values;
        this.m_size = size;
    }

    protected BTreeNode<K> add(K key, Object value) {
        if (this.size() == 0) {
            this.initialiseKeysAndValues();
        } else if (this.indexOf(key) > -1) {
            throw new BTreeDuplicateKeyException(key.toString());
        }
        boolean isFull = this.isFull();
        Object lastValue = null;
        if (isFull) {
            lastValue = this.getValues()[this.m_size];
        }
        this.add_noCheck(key, value);
        if (isFull) {
            int splitAt = (int)Math.ceil((double)this.m_size / 2.0);
            BTreeNode<K> newNode = this.m_tree.getNewNodeInstance(this.isLeafNode());
            newNode.initialiseKeysAndValues();
            newNode.setLeafNode(this.isLeafNode());
            this.shift(newNode, splitAt);
            newNode.getValues()[newNode.size()] = lastValue;
            return newNode;
        }
        return null;
    }

    protected void shift(BTreeNode<K> node, int shiftFrom) {
        int shiftItemsCount;
        node.m_size = shiftItemsCount = this.m_size - shiftFrom;
        this.m_size = shiftFrom;
        Object[] keys = this.getKeys();
        Object[] values = this.getValues();
        Object[] newKeys = node.getKeys();
        Object[] newValues = node.getValues();
        System.arraycopy(keys, shiftFrom, newKeys, 0, shiftItemsCount);
        if (shiftItemsCount + 1 < this.m_size) {
            ++shiftItemsCount;
        }
        System.arraycopy(this.getValues(), shiftFrom, newValues, 0, shiftItemsCount);
        this.clearUnused(this.m_size, keys);
        this.clearUnused(this.m_size + 1, values);
    }

    protected <V> Iterator<BTreeNodeEntry<K, V>> iterator() {
        Iterator it = null;
        if (this.size() > 0) {
            it = new Iterator<BTreeNodeEntry<K, V>>(){
                int m_current = 0;

                @Override
                public boolean hasNext() {
                    return this.m_current < BTreeNode.this.size();
                }

                @Override
                public BTreeNodeEntry<K, V> next() {
                    if (this.hasNext()) {
                        return new BTreeNodeEntry<Object, Object>(BTreeNode.this.getKeys()[this.m_current], BTreeNode.this.getValues()[this.m_current++]);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return it;
    }

    protected void clearUnused(int currentSize, Object[] array) {
        int s = array.length;
        for (int i = currentSize; i < s; ++i) {
            array[i] = null;
        }
    }

    public Object findKey(Object search) {
        int ndx = this.indexOf(search);
        return ndx > -1 ? this.m_keys[ndx] : null;
    }

    public Object findValue(K key) {
        int n = this.indexOf(key);
        return n > -1 ? this.getValues()[n] : null;
    }

    public int indexOfValue(Object value) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!BTree.valueEquals(this.m_values[i], value)) continue;
            return i;
        }
        return -1;
    }

    protected BTree<K, ?> getTree() {
        return this.m_tree;
    }

    public int indexOf(Object key) {
        int size = this.size();
        return size == 0 ? -1 : Arrays.binarySearch(this.getKeys(), 0, size, key, this.m_tree.getComparator());
    }

    @Override
    public int size() {
        return this.m_size;
    }

    protected void setLeafNode(boolean b) {
        this.m_leafNode = b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KEYS=");
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            sb.append(this.m_keys[i].toString());
            if (i == s - 1) continue;
            sb.append(" ; ");
        }
        return sb.toString();
    }
}

