/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.index;

import com.mapinfo.mapmarker.cgge.utils.BloomFilter;
import com.mapinfo.mapmarker.cgge.utils.index.BTree;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeInternalNode;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeLeafNode;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeNode;
import com.mapinfo.mapmarker.cgge.utils.index.Cache;
import com.mapinfo.mapmarker.cgge.utils.index.DiskInternalNode;
import com.mapinfo.mapmarker.cgge.utils.index.DiskLeafNode;
import com.mapinfo.mapmarker.cgge.utils.index.DiskNodeIOHandler;
import com.mapinfo.mapmarker.cgge.utils.index.DiskTreeWriteException;
import com.mapinfo.mapmarker.cgge.utils.index.IBTreeNode;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskNode;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskTreeKey;
import com.mapinfo.mapmarker.cgge.utils.index.InternalBTreeException;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiskBTree<K extends IDiskTreeKey, V extends IDataItem>
extends BTree<K, V> {
    static final Logger logger = LoggerFactory.getLogger(DiskBTree.class);
    private static final int MIN_CACHED_TEMP_NODES = 10;
    private static int BLOOM_BITS = 0xF00000;
    private DiskNodeIOHandler m_ioHandler;
    private int m_order;
    private IDiskTreeKey m_keyType;
    private IDataItem m_valueType;
    private int m_diskItemCount = -1;
    private boolean m_isTemp;
    private int m_cachedNodeCount = 0;
    private Cache<Long, IDiskNode<IDiskTreeKey>> m_cacheMap;
    private BloomFilter m_bloomFilter;
    public static int m_diskFetches = 0;

    protected DiskBTree() {
    }

    public static DiskBTree create(File file, IDiskTreeKey keyType, IDataItem valueType, int order) throws IOException {
        ICGGEDataStream dataAccess = DataStreamFactory.getDataStream(file, IOUtil.IO_MODE.READ_WRITE, false);
        return DiskBTree.create(dataAccess, keyType, valueType, order);
    }

    public static DiskBTree create(ICGGEDataStream dataAccess, IDiskTreeKey keyType, IDataItem valueType, int order, int cachedItems) throws IOException {
        ModifiableDiskBTree tree = new ModifiableDiskBTree(keyType, valueType);
        tree.m_order = order;
        dataAccess.write(tree.m_order);
        tree.m_ioHandler = new DiskNodeIOHandler(tree, dataAccess, true);
        tree.m_isTemp = true;
        tree.setCachedNodeCount(10);
        tree.m_bloomFilter = new BloomFilter(1000000);
        ((DiskBTree)tree).setCachedItemCount(cachedItems);
        dataAccess.writeInt(order);
        dataAccess.writeInt(0);
        dataAccess.writeLong(-1L);
        return tree;
    }

    public static <K extends IDiskTreeKey, V extends IDataItem> DiskBTree<K, V> create(ICGGEDataStream dataStream, IDiskTreeKey keyType, IDataItem valueType, int order) throws IOException {
        ModifiableDiskBTree tree = new ModifiableDiskBTree(keyType, valueType);
        tree.m_order = order;
        dataStream.write(tree.m_order);
        tree.m_ioHandler = new DiskNodeIOHandler(tree, dataStream, true);
        tree.m_isTemp = true;
        tree.setCachedNodeCount(10);
        tree.m_bloomFilter = new BloomFilter(0xF00000);
        dataStream.writeInt(order);
        dataStream.writeInt(0);
        dataStream.writeLong(-1L);
        return tree;
    }

    public static <K extends IDiskTreeKey, V extends IDataItem> DiskBTree<K, V> load(File file, K keyType, V valueType) throws IOException {
        ICGGEDataStream dataAccess = DataStreamFactory.getDataStream(file, IOUtil.IO_MODE.READ_ONLY, false);
        return DiskBTree.load(dataAccess, keyType, valueType);
    }

    public static <K extends IDiskTreeKey, V extends IDataItem> DiskBTree<K, V> loadFully(File file, K keyType, V valueType) throws IOException {
        DiskBTree<K, V> tree = DiskBTree.load(file, keyType, valueType);
        if (tree.size() > 0) {
            DiskBTree.loadNode(tree.getRootNode());
        }
        return tree;
    }

    public static <K extends IDiskTreeKey, V extends IDataItem> DiskBTree<K, V> load(ICGGEDataStream dataAccess, K keyType, V valueType) throws IOException {
        UnmodifiableDiskBTree tree = new UnmodifiableDiskBTree(keyType, valueType);
        tree.setKeyValueTypes(keyType, valueType);
        tree.init(dataAccess);
        return tree;
    }

    public static <K extends IDiskTreeKey, V extends IDataItem> DiskBTree<K, V> loadFully(ICGGEDataStream dataAccess, K keyType, V valueType) throws Exception {
        DiskBTree<K, V> tree = DiskBTree.load(dataAccess, keyType, valueType);
        DiskBTree.loadNode(tree.getRootNode());
        return tree;
    }

    private static <K extends IDiskTreeKey> void loadNode(BTreeNode<K> node) {
        int s = node.size();
        if (!node.isLeafNode()) {
            DiskInternalNode internalNode = (DiskInternalNode)node;
            for (int i = 0; i <= s; ++i) {
                if (i >= s && internalNode.getValues()[i] == null) continue;
                BTreeNode childNode = (BTreeNode)internalNode.getLeftChild(i);
                DiskBTree.loadNode(childNode);
                internalNode.getValues()[i] = childNode;
            }
        }
    }

    public static void write(BTree<IDiskTreeKey, IDataItem> tree, IDiskTreeKey keyType, IDataItem valueType, ICGGEDataStream dataAccess) throws IOException {
        UnmodifiableDiskBTree diskTree = new UnmodifiableDiskBTree(keyType, valueType);
        diskTree.setOrder(tree.getOrder());
        diskTree.setDiskItemCount(tree.size());
        long startOffset = dataAccess.offset();
        DiskBTree.writeHeader(diskTree, dataAccess, false);
        DiskNodeIOHandler handler = new DiskNodeIOHandler(diskTree, dataAccess, false);
        if (tree.size() > 0) {
            BTreeNode rootNode = (BTreeNode)((Object)DiskBTree.writeNode(tree.getRootNode(), 0, new HashMap<Integer, IDiskNode<IDiskTreeKey>>(), handler));
            diskTree.setRootNode(rootNode);
            dataAccess.seek(startOffset);
            DiskBTree.writeHeader(diskTree, dataAccess, false);
        }
        handler.flush();
    }

    public static void write(BTree<IDiskTreeKey, IDataItem> tree, IDiskTreeKey keyType, IDataItem valueType, File file) throws IOException {
        ICGGEDataStream dataAccess = DataStreamFactory.getDataStream(file, IOUtil.IO_MODE.READ_WRITE, false);
        DiskBTree.write(tree, keyType, valueType, dataAccess);
        dataAccess.close();
    }

    public static void write(DiskBTree tree, File file) throws IOException {
        DiskBTree.write((BTree<IDiskTreeKey, IDataItem>)tree, tree.getKeyType(), tree.getValueType(), file);
    }

    public static void write(DiskBTree tree, ICGGEDataStream dataAccess) throws IOException {
        DiskBTree.write((BTree<IDiskTreeKey, IDataItem>)tree, tree.getKeyType(), tree.getValueType(), dataAccess);
    }

    private static void writeHeader(DiskBTree diskTree, ICGGEDataStream dataAccess, boolean tempTree) throws IOException {
        dataAccess.writeInt(diskTree.getOrder());
        dataAccess.writeInt(diskTree.size());
        dataAccess.writeBoolean(tempTree);
        IDiskNode rootNode = (IDiskNode)((Object)diskTree.getRootNode());
        dataAccess.writeLong(rootNode == null ? -1L : rootNode.getOffset());
    }

    private static DiskNodeIOHandler readHeader(DiskBTree diskTree, ICGGEDataStream dataAccess) throws IOException {
        diskTree.setOrder(dataAccess.readInt());
        diskTree.setDiskItemCount(dataAccess.readInt());
        boolean temp = dataAccess.readBoolean();
        long rootOffset = dataAccess.readLong();
        DiskNodeIOHandler ioHandler = new DiskNodeIOHandler(diskTree, dataAccess, temp);
        if (rootOffset > 0L) {
            diskTree.setRootNode((BTreeNode)((Object)ioHandler.getNodeAt(rootOffset)));
        }
        return ioHandler;
    }

    public void setCachedNodeCount(int c) {
        int n = this.m_cachedNodeCount = this.m_isTemp ? 10 : c;
        if (this.m_cacheMap == null && this.m_cachedNodeCount > 0) {
            this.m_cacheMap = new Cache(this.m_cachedNodeCount);
        }
    }

    private void putInCache(long offset, IDiskNode<IDiskTreeKey> item) throws IOException {
        if (this.m_cacheMap != null) {
            IDiskNode<IDiskTreeKey> iDiskNode = this.m_cacheMap.put(offset, item);
        }
    }

    private IDiskNode<IDiskTreeKey> getFromCache(long offset) {
        if (this.m_cacheMap != null) {
            return this.m_cacheMap.get(offset);
        }
        return null;
    }

    public abstract void setCachedItemCount(int var1);

    protected void setKeyValueTypes(IDiskTreeKey keyType, IDataItem valueType) {
        if (keyType == null) {
            throw new NullPointerException("keyType cannot be null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType cannot be null");
        }
        this.m_keyType = keyType;
        this.m_valueType = valueType;
    }

    protected void setOrder(int order) {
        this.m_order = order;
    }

    @Override
    protected BTreeLeafNode<K> getNewLeafNodeInstance() {
        DiskLeafNode node = new DiskLeafNode(this);
        node.setModified(true);
        return node;
    }

    @Override
    protected BTreeInternalNode<K> getNewInternalNodeInstance() {
        DiskInternalNode node = new DiskInternalNode(this);
        node.setModified(true);
        return node;
    }

    boolean mayExist(Object key, boolean addChecked) {
        if (this.m_bloomFilter != null && !this.m_bloomFilter.isAvailable(key.hashCode())) {
            if (addChecked) {
                this.m_bloomFilter.addKey(key.hashCode());
            }
            return false;
        }
        return true;
    }

    protected DiskNodeIOHandler getIOHandler() {
        return this.m_ioHandler;
    }

    protected void setIOHandler(DiskNodeIOHandler handler) {
        this.m_ioHandler = handler;
    }

    public abstract void commit() throws IOException;

    protected abstract IOUtil.IO_MODE getMode();

    protected void setDiskItemCount(int n) {
        this.m_diskItemCount = n;
    }

    protected int getDiskItemCount() {
        return this.m_diskItemCount;
    }

    private static IDiskNode<IDiskTreeKey> writeInternalNode(BTreeInternalNode<IDiskTreeKey> node, int level, Map<Integer, IDiskNode<IDiskTreeKey>> rightSiblingMap, DiskNodeIOHandler handler) throws IOException {
        int s = node.size();
        DiskInternalNode diskNode = new DiskInternalNode(node);
        diskNode.setOffset(-1L);
        IDiskNode<IDiskTreeKey> lastRight = rightSiblingMap.get(++level);
        BTreeNode rightMostChild = (BTreeNode)node.getRightChild(s - 1);
        if (lastRight == null || !DiskBTree.compareNodes(lastRight, rightMostChild)) {
            IDiskNode<IDiskTreeKey> writtenNode = DiskBTree.writeNode(rightMostChild, level, rightSiblingMap, handler);
            diskNode.getValues()[s] = writtenNode.getOffset();
            rightSiblingMap.put(level, writtenNode);
        } else {
            diskNode.getValues()[s] = lastRight;
        }
        for (int i = s - 1; i >= 0; --i) {
            BTreeNode childNode = (BTreeNode)node.getLeftChild(i);
            IDiskNode<IDiskTreeKey> writtenNode = DiskBTree.writeNode(childNode, level, rightSiblingMap, handler);
            diskNode.getValues()[i] = writtenNode.getOffset();
            rightSiblingMap.put(level, writtenNode);
        }
        handler.write(diskNode);
        diskNode.setModified(false);
        return diskNode;
    }

    private static IDiskNode<IDiskTreeKey> writeNode(IBTreeNode<IDiskTreeKey> node, int level, Map<Integer, IDiskNode<IDiskTreeKey>> lastLeft, DiskNodeIOHandler handler) throws IOException {
        if (node.isLeafNode()) {
            return DiskBTree.writeLeafNode(node, lastLeft.get(level), handler);
        }
        return DiskBTree.writeInternalNode((BTreeInternalNode)node, level, lastLeft, handler);
    }

    protected static IDiskNode<IDiskTreeKey> writeLeafNode(IBTreeNode<IDiskTreeKey> node, IDiskNode<?> rightNode, DiskNodeIOHandler handler) throws IOException {
        DiskLeafNode writtenNode = new DiskLeafNode((BTreeLeafNode)node);
        writtenNode.setOffset(0L);
        if (rightNode != null) {
            writtenNode.getValues()[node.size()] = rightNode.getOffset();
        }
        writtenNode.setModified(false);
        handler.write(writtenNode);
        return writtenNode;
    }

    @Override
    protected int getOrder() {
        return this.m_order;
    }

    protected IDiskTreeKey getKeyType() {
        return this.m_keyType;
    }

    protected IDataItem getValueType() {
        return this.m_valueType;
    }

    private static boolean compareNodes(IDiskNode<IDiskTreeKey> node1, BTreeNode<IDiskTreeKey> node2) {
        if (node1.isLeafNode() != node2.isLeafNode()) {
            return false;
        }
        if (node1.size() != node2.size()) {
            return false;
        }
        int s = node1.size();
        for (int i = 0; i < s; ++i) {
            if (node1.getKey(i).equals(node2.getKey(i))) continue;
            return false;
        }
        return true;
    }

    private DiskNodeIOHandler getIODiskNodeIOHandler() {
        return this.m_ioHandler;
    }

    protected Object getNodeAt(Long offset) throws IOException {
        IDiskNode<IDiskTreeKey> item = null;
        if (item == null) {
            item = this.getFromCache(offset);
        }
        if (item == null) {
            ++m_diskFetches;
            try {
                item = this.getIODiskNodeIOHandler().getNodeAt(offset);
            }
            catch (Exception e) {
                throw new InternalBTreeException(e);
            }
            item.setOffset(offset);
            this.putInCache(offset, item);
        }
        return item;
    }

    public <K extends IDiskTreeKey, V extends IDataItem> Map<K, V> getMap() {
        return this;
    }

    private static class ModifiableDiskBTree<K, V>
    extends DiskBTree<IDiskTreeKey, IDataItem> {
        Map<IDiskTreeKey, IDataItem> m_cachedItems;
        int m_cachedWriteItems;
        boolean m_candUpdate;

        ModifiableDiskBTree(IDiskTreeKey keyType, IDataItem valueType) {
            this.setKeyValueTypes(keyType, valueType);
            this.m_cachedItems = new TreeMap<IDiskTreeKey, IDataItem>();
            this.m_cachedWriteItems = 0;
            this.m_candUpdate = true;
        }

        @Override
        public IDataItem get(Object key) {
            IDataItem value = null;
            if (this.m_cachedWriteItems > 0) {
                value = this.m_cachedItems.get(key);
            }
            if (value == null && this.mayExist(key, false)) {
                value = (IDataItem)super.get(key);
            }
            return value;
        }

        @Override
        public IDataItem put(IDiskTreeKey key, IDataItem value) {
            if (!this.m_candUpdate) {
                throw new IllegalStateException("Already commited, cannot update");
            }
            try {
                if (this.m_cachedWriteItems > 0) {
                    if (this.m_cachedItems.size() == this.m_cachedWriteItems) {
                        try {
                            this.writeCachedItems();
                        }
                        catch (Exception e) {
                            throw new DiskTreeWriteException(e);
                        }
                    }
                    return this.m_cachedItems.put(key, value);
                }
                IDataItem oldValue = null;
                oldValue = this.privatePut(key, value);
                IDiskNode root = (IDiskNode)((Object)this.getRootNode());
                return oldValue;
            }
            catch (IOException e) {
                throw new InternalBTreeException(e);
            }
        }

        private IDataItem privatePut(IDiskTreeKey key, IDataItem value) throws IOException {
            IDataItem v = null;
            if (this.mayExist(key, true)) {
                v = super.put(key, value);
            } else {
                super.put_NoDuplicateCheck(key, value);
            }
            return v;
        }

        private void writeCachedItems() throws Exception {
            if (this.m_cachedWriteItems > 0 && !this.m_cachedItems.isEmpty()) {
                for (Map.Entry<IDiskTreeKey, IDataItem> en : this.m_cachedItems.entrySet()) {
                    this.privatePut(en.getKey(), en.getValue());
                }
                this.m_cachedItems.clear();
                this.writeUpdatedTreeNodes();
            }
        }

        private void writeUpdatedTreeNodes() throws Exception {
            IDiskNode root = (IDiskNode)((Object)this.getRootNode());
            this.getIODiskNodeIOHandler(this).writeNodeUpdates(root);
        }

        private DiskNodeIOHandler getIODiskNodeIOHandler(DiskBTree diskBTree) {
            return diskBTree.getIODiskNodeIOHandler();
        }

        @Override
        public int size() {
            int size = super.size();
            if (this.m_cachedItems != null) {
                for (IDiskTreeKey k : this.m_cachedItems.keySet()) {
                    if (super.containsKey(k)) continue;
                    ++size;
                }
            }
            return size;
        }

        @Override
        public void setCachedItemCount(int c) {
            this.m_cachedWriteItems = c;
        }

        @Override
        public void commit() throws IOException {
            try {
                this.writeCachedItems();
                this.writeUpdatedTreeNodes();
                if (this.size() > 0) {
                    IDiskNode root = (IDiskNode)((Object)this.getRootNode());
                    DiskNodeIOHandler handler = this.getIOHandler();
                    handler.write(root);
                    ICGGEDataStream dataAccess = handler.getDataAccess();
                    dataAccess.seek(0L);
                    dataAccess.writeInt(this.getOrder());
                    dataAccess.writeInt(this.size());
                    dataAccess.writeBoolean(true);
                    dataAccess.writeLong(root.getOffset());
                    handler.flush();
                    logger.debug("Node fetch count:" + DiskNodeIOHandler.m_diskFetches);
                    logger.debug("Node write count:" + DiskNodeIOHandler.m_nodesWritten);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.m_candUpdate = false;
        }

        @Override
        protected IOUtil.IO_MODE getMode() {
            return this.m_candUpdate ? IOUtil.IO_MODE.READ_WRITE : IOUtil.IO_MODE.READ_ONLY;
        }

        @Override
        public void clear() {
            super.clear();
            this.m_cachedItems.clear();
        }

        @Override
        public Set<Map.Entry<IDiskTreeKey, IDataItem>> entrySet() {
            try {
                this.writeCachedItems();
            }
            catch (Exception e) {
                throw new InternalBTreeException(e);
            }
            return super.entrySet();
        }
    }

    private static class UnmodifiableDiskBTree
    extends DiskBTree<IDiskTreeKey, IDataItem> {
        Cache<IDiskTreeKey, IDataItem> m_cache;
        int cachedItemCount;

        UnmodifiableDiskBTree(IDiskTreeKey keyType, IDataItem valueType) {
            this.setKeyValueTypes(keyType, valueType);
            this.cachedItemCount = 0;
        }

        protected void init(ICGGEDataStream dataAccess) throws IOException {
            DiskNodeIOHandler ioHandler = DiskBTree.readHeader((DiskBTree)this, dataAccess);
            this.setIOHandler(ioHandler);
        }

        @Override
        public IDataItem put(IDiskTreeKey key, IDataItem value) {
            throw new UnsupportedOperationException("Tree not modifiable");
        }

        @Override
        public int size() {
            return this.getDiskItemCount();
        }

        @Override
        public void putAll(Map m) {
            throw new UnsupportedOperationException("Tree not modifiable");
        }

        @Override
        public void setCachedItemCount(int c) {
            this.cachedItemCount = c;
            if (c > 0) {
                this.m_cache = new Cache(c);
            }
        }

        @Override
        public void commit() throws IOException {
        }

        @Override
        protected IOUtil.IO_MODE getMode() {
            return IOUtil.IO_MODE.READ_ONLY;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IDataItem get(Object key) {
            IDataItem value = null;
            if (this.cachedItemCount > 0) {
                value = this.m_cache.get(key);
                if (value == null) {
                    value = (IDataItem)super.get(key);
                    this.m_cache.put((IDiskTreeKey)key, value);
                }
            } else {
                value = (IDataItem)super.get(key);
            }
            return value;
        }
    }
}

