/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.index;

import com.mapinfo.mapmarker.cgge.utils.index.BTreeLeafNode;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeNode;
import com.mapinfo.mapmarker.cgge.utils.index.DiskBTree;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskNode;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskTreeKey;
import com.mapinfo.mapmarker.cgge.utils.index.InternalBTreeException;

public class DiskLeafNode
extends BTreeLeafNode<IDiskTreeKey>
implements IDiskNode<IDiskTreeKey> {
    private boolean m_modified;
    private long m_offset;

    protected DiskLeafNode(BTreeLeafNode<IDiskTreeKey> copy) {
        super(copy);
        this.m_modified = true;
    }

    @Override
    public Object replaceValue(int ndx, Object value) {
        this.setModified(true);
        return super.replaceValue(ndx, value);
    }

    protected DiskLeafNode(DiskBTree tree) {
        super(tree);
    }

    @Override
    protected BTreeNode<IDiskTreeKey> add(IDiskTreeKey key, Object value) {
        DiskLeafNode newNode = (DiskLeafNode)super.add(key, value);
        this.m_modified = true;
        return newNode;
    }

    @Override
    public void setModified(boolean b) {
        this.m_modified = b;
    }

    @Override
    public boolean modified() {
        return this.m_modified;
    }

    @Override
    protected BTreeLeafNode<IDiskTreeKey> getNextNode() {
        Object next;
        int s = this.size();
        Object object = next = s > 0 ? this.getValues()[s] : null;
        if (next != null && !(next instanceof BTreeNode)) {
            try {
                next = ((DiskBTree)this.getTree()).getNodeAt((Long)next);
            }
            catch (Exception e) {
                throw new InternalBTreeException(e);
            }
        }
        return (BTreeLeafNode)next;
    }

    @Override
    public long getOffset() {
        return this.m_offset;
    }

    @Override
    public void setOffset(long offset) {
        this.m_offset = offset;
    }
}

