/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.io;

import com.mapinfo.mapmarker.cgge.utils.io.BufferedDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteArrayDataStream
extends BufferedDataStream {
    private byte[] m_bb;
    private int m_bufferLimit;
    private final long m_startOffset;
    private final boolean m_fixedBuffer;

    ByteArrayDataStream(byte[] bytes, long offset) throws IOException {
        super(null, IOUtil.IO_MODE.READ_ONLY, bytes.length);
        this.m_fixedBuffer = true;
        this.m_bufferLimit = bytes.length;
        this.m_bb = bytes;
        this.m_startOffset = offset;
        this.initialise(null, IOUtil.IO_MODE.READ_ONLY);
    }

    public ByteArrayDataStream(IOUtil.IO_MODE mode) throws IOException {
        super(null, mode, 1024);
        this.m_startOffset = 0L;
        this.m_fixedBuffer = false;
        this.initialise(null, IOUtil.IO_MODE.READ_ONLY);
    }

    @Override
    RandomAccessFile initialiseFile(File file, IOUtil.IO_MODE mode) throws FileNotFoundException {
        this.setOffset(this.m_startOffset);
        return null;
    }

    @Override
    ByteBuffer initNewBuffer(int bufferSize) throws IOException {
        int offset = (int)(this.offset() - this.m_startOffset);
        if (!this.m_fixedBuffer) {
            if (this.m_bb == null) {
                this.m_bb = new byte[bufferSize];
                this.m_bufferLimit = 0;
            } else {
                int newLen = offset + bufferSize;
                if (newLen > this.m_bb.length) {
                    this.m_bb = Arrays.copyOf(this.m_bb, newLen);
                }
            }
        }
        ByteBuffer buf = ByteBuffer.wrap(this.m_bb, offset, bufferSize);
        int limit = Math.min(this.m_bufferLimit - offset, bufferSize);
        buf = buf.slice();
        buf.limit(limit);
        buf.mark();
        return buf;
    }

    @Override
    void ensureWrite(int len) throws IOException {
        super.ensureWrite(len);
        int limit = (int)(this.offset() + (long)len);
        if (limit > this.m_bufferLimit) {
            this.m_bufferLimit = limit;
        }
    }

    @Override
    long getFileLength() throws IOException {
        return this.m_bufferLimit;
    }

    @Override
    void internalSeek(long offset) throws IOException {
    }

    @Override
    void internalFlush(ByteBuffer buf) throws IOException {
    }

    @Override
    void internalClose() throws IOException {
    }

    @Override
    byte[] getInternalArray(ByteBuffer buf) {
        return this.m_fixedBuffer ? this.m_bb : null;
    }

    public byte[] array() throws IOException {
        int c = (int)this.getFileLength();
        this.internalFlush(this.getBuf());
        return Arrays.copyOf(this.m_bb, c);
    }

    @Override
    long getInternalFileLen() throws IOException {
        return this.m_bufferLimit;
    }
}

