/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.io;

import com.mapinfo.mapmarker.cgge.utils.io.ByteArrayDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.FileHandler;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEConcurrentDataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentDataInputStream
extends ByteArrayDataInputStream
implements ICGGEConcurrentDataInputStream {
    private final ReentrantLock m_lock = new ReentrantLock(false);
    private final ConcurrentDataInputStream[] m_cacheStreams;
    private final int m_cacheItemSize;
    private final double blockPerCache;

    public ConcurrentDataInputStream(File file) throws IOException {
        this(file, 8192, 0);
    }

    public ConcurrentDataInputStream(File file, int bufferSize, int cachedBuffers) throws IOException {
        BlockingFileHandler fileHandler = new BlockingFileHandler(file);
        this.init(fileHandler, bufferSize, 0L);
        this.m_cacheItemSize = this.calculateCachedBufferItemCount(bufferSize, cachedBuffers);
        if (this.m_cacheItemSize > 0) {
            this.m_cacheStreams = new ConcurrentDataInputStream[this.m_cacheItemSize];
            this.blockPerCache = (double)this.getFileLength() / (double)this.m_cacheItemSize;
        } else {
            this.m_cacheStreams = null;
            this.blockPerCache = 0.0;
        }
    }

    private int calculateCachedBufferItemCount(int bufferSize, int maxBuffers) throws IOException {
        if (maxBuffers < 0) {
            throw new IllegalArgumentException("Number of buffers must be a positive integer");
        }
        if (maxBuffers > 0) {
            long fileLen = this.getFileLength();
            double bytesPerBuffer = (double)fileLen / (double)maxBuffers;
            if (bytesPerBuffer < (double)bufferSize) {
                return (int)(fileLen / (long)bufferSize) + 1;
            }
            return maxBuffers;
        }
        return 0;
    }

    ConcurrentDataInputStream(ConcurrentDataInputStream dataInputStream, long offset) {
        super(dataInputStream, offset);
        this.m_cacheItemSize = 0;
        this.m_cacheStreams = null;
        this.blockPerCache = 0.0;
    }

    ConcurrentDataInputStream(ConcurrentDataInputStream dataInputStream) {
        super(dataInputStream);
        this.m_cacheItemSize = 0;
        this.m_cacheStreams = null;
        this.blockPerCache = 0.0;
    }

    private ICGGEConcurrentDataInputStream checkCache(long offset) {
        ConcurrentDataInputStream stream;
        if (this.m_cacheItemSize > 0 && (stream = this.m_cacheStreams[this.getCacheNdx(offset)]) != null && stream.inBuffer(offset)) {
            return new ConcurrentDataInputStream(stream, offset);
        }
        return null;
    }

    private final int getCacheNdx(long offset) {
        return (int)((double)offset / this.blockPerCache);
    }

    private final void cacheStream(ICGGEConcurrentDataInputStream stream, long offset) {
        if (this.m_cacheItemSize > 0) {
            this.m_cacheStreams[this.getCacheNdx((long)offset)] = new ConcurrentDataInputStream((ConcurrentDataInputStream)stream);
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.inBuffer(pos)) {
            super.seek(pos);
        } else {
            ICGGEConcurrentDataInputStream newStream = this.duplicate(pos);
            this.copy((ByteArrayDataInputStream)((Object)newStream), pos);
        }
    }

    @Override
    public ICGGEConcurrentDataInputStream duplicate() {
        ConcurrentDataInputStream newStream = null;
        this.m_lock.lock();
        try {
            newStream = new ConcurrentDataInputStream(this);
        }
        finally {
            this.m_lock.unlock();
        }
        return newStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICGGEConcurrentDataInputStream duplicate(long offset) throws IOException {
        ICGGEConcurrentDataInputStream newStream = null;
        this.m_lock.lock();
        try {
            if (this.inBuffer(offset)) {
                newStream = new ConcurrentDataInputStream(this, offset);
            } else {
                newStream = this.checkCache(offset);
                if (newStream == null) {
                    this.seekInternal(offset);
                    newStream = new ConcurrentDataInputStream(this);
                    this.cacheStream(newStream, offset);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return newStream;
    }

    private final class BlockingFileHandler
    extends FileHandler {
        BlockingFileHandler(File file) throws FileNotFoundException {
            super(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int readBytes(long offset, byte[] bytes) throws IOException {
            int bytesRead = 0;
            ConcurrentDataInputStream.this.m_lock.lock();
            try {
                bytesRead = super.readBytes(offset, bytes);
            }
            finally {
                ConcurrentDataInputStream.this.m_lock.unlock();
            }
            return bytesRead;
        }
    }
}

