/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.parsedinput;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.InternalIntersectionScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.parser.CGGEParserTerms;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import com.mapinfo.mapmarker.common.ParsedInputAddressUtils;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericInputParserUtil {
    static final Logger logger = LoggerFactory.getLogger(GenericInputParserUtil.class);
    private ParsedInputAddress p_inputAddress;
    private ParsedAddress m_parsedAddres;
    private CGGEParserTerms m_parserTerms = null;
    private ICGGEThoroughfareTypeHandler m_tftHandler = null;
    private String tokenizer = " ";
    private String m_language;
    private Locale m_locale;
    private String m_country;
    private DataSetInfo m_dataSetInfo = null;
    private final String SET_FORMATTED_STREET = "set_formatted_street";
    private final String SET_CANDIDATE_CASE = "set_candidate_case";
    private String m_converterLanguage;
    private List<AddressNumber> m_probableAddressNumList;
    private HashSet<AddressNumber> m_probableHNSet = new HashSet();
    private static final Pattern HouseWithSlashPattern = Pattern.compile("(\\d+\\s*[/])(\\s*\\d+)");
    private static final Pattern HouseWithDashPattern = Pattern.compile("(\\d+\\s*[-])(\\s*\\d+)");
    private boolean m_doHnrOnly;

    public GenericInputParserUtil(ICGGEParser parser, ParsedAddress parsedAddress, String converterLanguage, List<AddressNumber> probableAddressNumList, boolean doHnrOnly) {
        this.m_parserTerms = (CGGEParserTerms)parser.getParserTerms();
        this.m_tftHandler = parser.getThoroughfareTypeHandler();
        this.m_language = parser.getLanguage();
        this.m_country = parser.getCountry();
        this.m_locale = StringUtilities.isEmpty((String)this.m_language) ? null : new Locale(this.m_language, this.m_country);
        this.m_doHnrOnly = doHnrOnly;
        this.m_converterLanguage = converterLanguage;
        this.m_probableAddressNumList = probableAddressNumList;
        if (this.m_probableAddressNumList != null && this.m_probableAddressNumList.size() > 0) {
            this.m_probableHNSet.addAll(probableAddressNumList);
        }
        if (parsedAddress != null) {
            this.m_parsedAddres = parsedAddress;
        }
    }

    public ParsedInputAddress parseInputAddress(InternalScoringAddress scoringAddress, InputAddress inputAddress) {
        boolean singleLine = inputAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) == null && inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE) == null && inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
        this.p_inputAddress = new ParsedInputAddress();
        try {
            if (scoringAddress != null && scoringAddress.getCombinedScore() > 0.0) {
                this.parseInputWithScoredCandidate(scoringAddress, inputAddress, singleLine);
                this.m_dataSetInfo = scoringAddress.getDataSetInfo();
                if (this.p_inputAddress.getPostCode1() != null && this.p_inputAddress.getPostCode1().equals(this.p_inputAddress.getAddressNumber()) && this.m_probableAddressNumList.size() > 1 && this.m_probableAddressNumList.get(1).toString().length() > 3) {
                    this.p_inputAddress.setPostCode1(this.m_probableAddressNumList.get(1).toString());
                }
            } else {
                this.parseInput(inputAddress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.populateBlankFieldsWithInputValue(inputAddress);
        if (scoringAddress != null && !scoringAddress.getParsedAddress().getParseAlwaysDeterminesHnr()) {
            this.checkHnrNotFromANForSingleLine(inputAddress, scoringAddress, singleLine);
            this.checkAndBlankHNRIfSameAsPC(this.p_inputAddress);
        }
        if (!StringUtilities.isEmpty((String)this.p_inputAddress.getAddressNumber()) && !StringUtilities.isEmpty((String)this.p_inputAddress.getMainAddress()) && this.isNumericStreet()) {
            this.compareNumericStreetWithHouseNumber(inputAddress);
        }
        if (StringUtilities.isEmpty((String)this.p_inputAddress.getPostCode1()) && !StringUtilities.isEmpty((String)((String)inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE)))) {
            this.p_inputAddress.setPostCode1((String)inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE));
        }
        boolean isCOL = false;
        if (scoringAddress != null && "COL".equals(scoringAddress.getCountry())) {
            isCOL = true;
        }
        if (!isCOL) {
            this.mergeGenericField1(inputAddress);
            this.clearGenericField1();
            this.checkGfld1ForHnr(singleLine, scoringAddress);
        }
        if (this.m_doHnrOnly) {
            this.convertProperDelimiterForHouseNumber();
        } else {
            if (StringUtilities.isEmpty((String)this.p_inputAddress.getMainAddress())) {
                this.parseStreetInformationFromGenericField1();
            }
            this.calculateDirectionalInformation();
            this.calculateUnitInformation();
            this.convertProperDelimiterForHouseNumber();
            this.handledHypenInParsedMainAdress();
            this.calculateFormattedStreet();
            this.removeDelimiter();
        }
        return this.p_inputAddress;
    }

    private void checkHnrNotFromANForSingleLine(InputAddress inputAddress, InternalScoringAddress scoringAddress, boolean singleLine) {
        StringWithTokens toks;
        if (!singleLine || this.m_probableAddressNumList == null || this.m_probableAddressNumList.size() != 1 || this.p_inputAddress.getAddressNumber() == null) {
            return;
        }
        AddressNumber num = this.m_probableAddressNumList.get(0);
        int[] pos = num.getPositionInInputStreet();
        if (pos[0] > 0 & (toks = new StringWithTokens((String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE))).size() >= pos[0] + 1) {
            String theTok = toks.getToken(pos[0] - 1);
            if (!StringUtilities.isEmpty((String)this.p_inputAddress.getAreaName1()) && this.p_inputAddress.getAreaName1().toUpperCase().startsWith(theTok.toUpperCase()) && this.p_inputAddress.getAreaName1().contains(this.p_inputAddress.getAddressNumber()) || !StringUtilities.isEmpty((String)this.p_inputAddress.getAreaName2()) && this.p_inputAddress.getAreaName2().toUpperCase().startsWith(theTok.toUpperCase()) && this.p_inputAddress.getAreaName2().contains(this.p_inputAddress.getAddressNumber()) || !StringUtilities.isEmpty((String)this.p_inputAddress.getAreaName3()) && this.p_inputAddress.getAreaName3().toUpperCase().startsWith(theTok.toUpperCase()) && this.p_inputAddress.getAreaName3().contains(this.p_inputAddress.getAddressNumber()) || !StringUtilities.isEmpty((String)this.p_inputAddress.getAreaName4()) && this.p_inputAddress.getAreaName4().toUpperCase().startsWith(theTok.toUpperCase()) && this.p_inputAddress.getAreaName4().contains(this.p_inputAddress.getAddressNumber())) {
                this.p_inputAddress.setAddressNumber((String)null);
            }
        }
    }

    private void checkGfld1ForHnr(boolean singleLine, InternalScoringAddress scoringAddress) {
        if (scoringAddress != null && scoringAddress.getParsedAddress().getParseAlwaysDeterminesHnr()) {
            return;
        }
        if (StringUtilities.isEmpty((String)this.p_inputAddress.getAddressNumber()) && !StringUtilities.isEmpty((String)this.p_inputAddress.getGenericField1()) && StringUtilities.hasNumeric((String)this.p_inputAddress.getGenericField1())) {
            StringWithTokens tokens = new StringWithTokens(this.p_inputAddress.getGenericField1(), "\\/-, ");
            if (tokens.size() == 1 || tokens.size() == 2 && !this.p_inputAddress.getGenericField1().contains(" ")) {
                int commapos = this.p_inputAddress.getGenericField1().indexOf(",");
                if (commapos > 0) {
                    String str = this.p_inputAddress.getGenericField1().substring(0, commapos - 1);
                    this.p_inputAddress.setAddressNumber(str);
                } else {
                    this.p_inputAddress.setAddressNumber(this.p_inputAddress.getGenericField1());
                }
                this.p_inputAddress.setGenericField1(null);
            }
        } else if (this.p_inputAddress.getGenericField1() != null && this.p_inputAddress.getGenericField1().startsWith("/") && this.p_inputAddress.getAddressNumber() != null && this.p_inputAddress.getGenericField1().length() > 1 && Character.isDigit(this.p_inputAddress.getGenericField1().charAt(1))) {
            boolean hasTrailerWithSlash;
            StringWithTokens toks = new StringWithTokens(this.p_inputAddress.getGenericField1(), "/");
            ParsedNumber pn = this.p_inputAddress.getParsedAddressNumber();
            boolean bl = hasTrailerWithSlash = pn.hasAddressTrailer() && pn.getAddressTrailer().contains("/");
            if (toks.size() > 0 && !hasTrailerWithSlash && !"/".equals(this.p_inputAddress.getParsedAddressNumber().getNumberSeparator())) {
                String hn = this.p_inputAddress.getAddressNumber() + "/" + toks.getToken(0);
                this.p_inputAddress.setAddressNumber(hn);
                toks.removeFirst();
                this.p_inputAddress.setGenericField1(toks.toString());
            }
        }
    }

    private void populateBlankFieldsWithInputValue(InputAddress m_inputAddress) {
        if (StringUtilities.isEmpty((String)this.p_inputAddress.getMainAddress())) {
            this.p_inputAddress.setGenericField1((String)m_inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
        }
        if (StringUtilities.isEmpty((String)this.p_inputAddress.getAreaName1())) {
            this.p_inputAddress.setAreaName1((String)m_inputAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE));
        }
        if (StringUtilities.isEmpty((String)this.p_inputAddress.getAreaName2())) {
            this.p_inputAddress.setAreaName2((String)m_inputAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE));
        }
        if (StringUtilities.isEmpty((String)this.p_inputAddress.getAreaName3())) {
            this.p_inputAddress.setAreaName3((String)m_inputAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE));
        }
        if (StringUtilities.isEmpty((String)this.p_inputAddress.getAreaName4())) {
            this.p_inputAddress.setAreaName4((String)m_inputAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE));
        }
        if (StringUtilities.isEmpty((String)this.p_inputAddress.getPlaceName())) {
            this.p_inputAddress.setPlaceName((String)m_inputAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE));
        }
    }

    private void parseInput(InputAddress m_inputAddress) {
        this.setParsedAddressNumber(this.p_inputAddress);
        this.p_inputAddress.setGenericField1((String)m_inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
        this.p_inputAddress.setAreaName1((String)m_inputAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE));
        this.p_inputAddress.setAreaName2((String)m_inputAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE));
        this.p_inputAddress.setAreaName3((String)m_inputAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE));
        this.p_inputAddress.setAreaName4((String)m_inputAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE));
        this.p_inputAddress.setPlaceName((String)m_inputAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE));
        this.p_inputAddress.setCountry((String)m_inputAddress.getField(FieldType.COUNTRY_FIELD_TYPE));
        this.setParsedPostCode(this.p_inputAddress);
    }

    private void parseInputWithScoredCandidate(InternalScoringAddress scoringAddress, InputAddress m_inputAddress, boolean singleLine) {
        this.startProcessing(scoringAddress, m_inputAddress, FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        this.startProcessing(scoringAddress, m_inputAddress, FieldType.STREET_NAME_FIELD_TYPE);
        this.startProcessing(scoringAddress, m_inputAddress, FieldType.POST_CODE_FIELD_TYPE);
        if (!this.m_doHnrOnly || singleLine) {
            this.startProcessing(scoringAddress, m_inputAddress, FieldType.AREA_NAME_1_FIELD_TYPE);
            this.startProcessing(scoringAddress, m_inputAddress, FieldType.AREA_NAME_2_FIELD_TYPE);
            this.startProcessing(scoringAddress, m_inputAddress, FieldType.AREA_NAME_3_FIELD_TYPE);
            this.startProcessing(scoringAddress, m_inputAddress, FieldType.AREA_NAME_4_FIELD_TYPE);
        }
        if (!this.m_doHnrOnly) {
            this.startProcessing(scoringAddress, m_inputAddress, FieldType.PLACE_NAME_FIELD_TYPE);
        }
        if (StringUtilities.isEmpty((String)this.p_inputAddress.getPostCode1())) {
            this.setParsedPostCode(this.p_inputAddress);
        }
        if (this.m_parsedAddres.isIntersectionCase()) {
            this.parsedIntersectionAddress(scoringAddress);
        }
        this.p_inputAddress.setCountry((String)m_inputAddress.getField(FieldType.COUNTRY_FIELD_TYPE));
    }

    private void startProcessing(InternalScoringAddress scoringAddress, InputAddress m_inputAddress, FieldType type) {
        String value = "";
        if (type.equals(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) {
            value = this.getFieldValueAddressNumber(scoringAddress.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE));
            this.p_inputAddress.setAddressNumber(value);
            if (StringUtilities.isEmpty((String)value)) {
                this.setParsedAddressNumber(this.p_inputAddress);
            }
        }
        if (type.equals(FieldType.STREET_NAME_FIELD_TYPE)) {
            value = this.getFieldValue(scoringAddress.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE), this.p_inputAddress);
            this.p_inputAddress.setMainAddress(value);
        }
        if (type.equals(FieldType.AREA_NAME_1_FIELD_TYPE)) {
            value = this.getFieldValue(scoringAddress.getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE));
            this.p_inputAddress.setAreaName1(value);
        }
        if (type.equals(FieldType.AREA_NAME_2_FIELD_TYPE)) {
            value = this.getFieldValue(scoringAddress.getFieldScore(FieldType.AREA_NAME_2_FIELD_TYPE));
            this.p_inputAddress.setAreaName2(value);
        }
        if (type.equals(FieldType.AREA_NAME_3_FIELD_TYPE)) {
            value = this.getFieldValue(scoringAddress.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE));
            this.p_inputAddress.setAreaName3(value);
        }
        if (type.equals(FieldType.AREA_NAME_4_FIELD_TYPE)) {
            value = this.getFieldValue(scoringAddress.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE));
            this.p_inputAddress.setAreaName4(value);
        }
        if (type.equals(FieldType.POST_CODE_FIELD_TYPE)) {
            value = this.getFieldValue(scoringAddress.getFieldScore(FieldType.POST_CODE_FIELD_TYPE));
            this.p_inputAddress.setPostCode1(value);
        }
        if (type.equals(FieldType.PLACE_NAME_FIELD_TYPE)) {
            value = this.getFieldValue(scoringAddress.getFieldScore(FieldType.PLACE_NAME_FIELD_TYPE));
            this.p_inputAddress.setPlaceName(value);
        }
    }

    private String getFieldValue(FieldScore score) {
        if (null == score) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        AddressWord[] addrWrds = score.m_inputWords;
        IntArray matchedInputWords = score.m_matchedInputWords;
        if (addrWrds != null && matchedInputWords != null) {
            int[] matchedWords = matchedInputWords.asArray();
            for (int i = 0; i < matchedWords.length; ++i) {
                AddressWord addrwrd = addrWrds[matchedWords[i]];
                buf = buf.append(addrwrd.getWord()).append(" ");
            }
        }
        return buf.toString().trim();
    }

    private String getFieldValueAddressNumber(FieldScore score) {
        if (null == score) {
            return "";
        }
        AddressNumberScore AddressNumber2 = (AddressNumberScore)score;
        StringBuffer buf = new StringBuffer();
        AddressNumber hnr = AddressNumber2.getInputAddressNumber();
        if (score.m_perfectInputWords != null) {
            buf = buf.append(hnr.toString());
        }
        return buf.toString().trim();
    }

    private String getFieldValue(FieldScore score, ParsedInputAddress p_inputAddress) {
        if (null == score) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        String postThoroughFareType = "";
        String preThoroughFareType = "";
        AddressWord[] addrWrds = score.m_inputWords;
        AddressWord[] canAddrWrds = score.m_candWords;
        if (canAddrWrds != null) {
            for (int j = 0; j < canAddrWrds.length; ++j) {
                AddressWord canAddrWrd = canAddrWrds[j];
                if (canAddrWrd.m_wordType.equals(FieldType.PRE_THOROUGHFARE_FIELD_TYPE)) {
                    preThoroughFareType = canAddrWrd.getWord();
                    continue;
                }
                if (!canAddrWrd.m_wordType.equals(FieldType.POST_THOROUGHFARE_FIELD_TYPE)) continue;
                postThoroughFareType = canAddrWrd.getWord();
            }
        }
        IntArray matchedInputWords = score.m_matchedInputWords;
        if (addrWrds != null && matchedInputWords != null) {
            int[] matchedWords = matchedInputWords.asArray();
            for (int i = 0; i < matchedWords.length; ++i) {
                AddressWord addrwrd = addrWrds[matchedWords[i]];
                String word = addrwrd.getWord();
                if (i == 0 && (word.trim().equalsIgnoreCase(preThoroughFareType.trim()) || this.m_tftHandler.isThoroughfareTypeAtStart(word))) {
                    p_inputAddress.setPreThoroughfareType(word);
                    continue;
                }
                if (i == matchedWords.length - 1 && (word.trim().equalsIgnoreCase(postThoroughFareType.trim()) || this.m_tftHandler.isThoroughfareTypeAtEnd(word))) {
                    p_inputAddress.setPostThoroughfareType(word);
                    continue;
                }
                buf = buf.append(addrwrd.getWord()).append(" ");
            }
        }
        return buf.toString().trim();
    }

    private void setParsedAddressNumber(ParsedInputAddress inputAddress) {
        if (this.m_parsedAddres == null) {
            return;
        }
        List<AddressNumber> probableHnr = this.m_parsedAddres.getProbableAddressNumbers();
        AddressNumber addrNumber = this.m_parsedAddres.getAddressNumber();
        if (null == probableHnr && null == addrNumber) {
            return;
        }
        if (addrNumber != null) {
            this.p_inputAddress.setAddressNumber(addrNumber.toString());
        } else if (probableHnr != null && probableHnr.size() > 0) {
            AddressNumber hnr = probableHnr.get(0);
            int hnrNumber1 = hnr.getHnrNumber1();
            int hnrNumber2 = hnr.getHnrNumber2();
            if (hnrNumber2 == 0) {
                this.p_inputAddress.setAddressNumber(hnr.toString());
            } else {
                int[] posInputStreet = hnr.getPositionInInputStreet();
                String street_name = (String)this.m_parsedAddres.getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE);
                String probableHnrNumber = street_name.substring(posInputStreet[0], posInputStreet[1]);
                if (probableHnrNumber.contains(",")) {
                    this.p_inputAddress.setAddressNumber(new Integer(hnrNumber1).toString());
                } else {
                    this.p_inputAddress.setAddressNumber(hnr.toString());
                }
            }
        } else {
            this.p_inputAddress.setAddressNumber("");
        }
    }

    private void setParsedPostCode(ParsedInputAddress p_inputAddress) {
        if (this.m_parsedAddres == null) {
            return;
        }
        List<PostCode> probablePC = this.m_parsedAddres.getProbablePostcodes();
        AddressWord[] addrWrds = (AddressWord[])this.m_parsedAddres.getField(FieldType.POST_CODE_FIELD_TYPE);
        if (null == probablePC && addrWrds == null) {
            return;
        }
        if (probablePC != null && probablePC.size() > 0) {
            PostCode pCode = probablePC.get(0);
            if (pCode != null) {
                p_inputAddress.setPostCode1(pCode.toString());
            }
        } else if (addrWrds != null && addrWrds.length > 0) {
            AddressWord wrd = addrWrds[0];
            p_inputAddress.setPostCode1(wrd.getWord());
        }
    }

    private void checkAndBlankHNRIfSameAsPC(ParsedInputAddress p_inputAddress) {
        String hnr = p_inputAddress.getAddressNumber();
        String pc = p_inputAddress.getPostCode1();
        if (!StringUtilities.isEmpty((String)hnr) && !StringUtilities.isEmpty((String)pc)) {
            if (hnr.trim().equalsIgnoreCase(pc.trim())) {
                p_inputAddress.setAddressNumber("");
            } else if (StringUtilities.isNumeric((String)hnr) && StringUtilities.isNumeric((String)pc)) {
                int pc1;
                int hnr1;
                try {
                    hnr1 = Integer.parseInt(hnr);
                    pc1 = Integer.parseInt(pc);
                }
                catch (NumberFormatException nfe) {
                    p_inputAddress.setPostCode1(null);
                    return;
                }
                String withLeadingZero = "0" + hnr;
                if (hnr1 == pc1 || hnr.length() > 1 && pc.startsWith(hnr) || pc.startsWith(withLeadingZero)) {
                    p_inputAddress.setAddressNumber("");
                }
            } else if (StringUtilities.isNumeric((String)hnr) && !StringUtilities.isNumeric((String)pc) && pc.contains(hnr)) {
                p_inputAddress.setAddressNumber("");
            }
        }
    }

    private boolean isNumericStreet() {
        String numericStreet = this.p_inputAddress.getMainAddress();
        StringTokenizer tokensOfinputtedStreet = new StringTokenizer(numericStreet, " ");
        while (tokensOfinputtedStreet.hasMoreTokens()) {
            String probableNumericStreet = tokensOfinputtedStreet.nextToken();
            if (!StringUtilities.isNumeric((String)probableNumericStreet)) continue;
            return true;
        }
        return false;
    }

    private void compareNumericStreetWithHouseNumber(InputAddress m_inputAddress) {
        String numericStreet = this.p_inputAddress.getMainAddress();
        String probableNumericStreet = "";
        String hnr = this.p_inputAddress.getAddressNumber();
        ParsedNumber hnrPN = this.p_inputAddress.getParsedAddressNumber();
        StringTokenizer tokensOfinputtedStreet = new StringTokenizer(numericStreet, " ");
        while (tokensOfinputtedStreet.hasMoreTokens() && !StringUtilities.isNumeric((String)(probableNumericStreet = tokensOfinputtedStreet.nextToken()))) {
        }
        boolean useSuffixAsHN = false;
        if (hnr != null && hnrPN.hasNumberSeparator() && hnrPN.getSuffixNumberExists() && hnrPN.getAddressNumberExists()) {
            try {
                String numBeforeSep = String.valueOf(hnrPN.getAddressNumber());
                if (numBeforeSep.equals(probableNumericStreet) && this.m_probableHNSet.contains(new AddressNumber((int)hnrPN.getSuffixNumber()))) {
                    useSuffixAsHN = true;
                }
            }
            catch (NumberFormatException numBeforeSep) {
                // empty catch block
            }
        }
        if (this.m_parsedAddres.getAddressNumber() != null) {
            return;
        }
        if (probableNumericStreet.equals(hnr) || useSuffixAsHN) {
            String probableHN2;
            int isHnrOrStreetPart = 0;
            boolean setTheHN = false;
            String singleLineInput = (String)m_inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
            StringTokenizer tokensOfSingleLineInput = new StringTokenizer(singleLineInput, " ");
            if (useSuffixAsHN) {
                this.p_inputAddress.setAddressNumber(hnrPN.getSuffixNumberAsString());
                setTheHN = true;
            } else {
                while (tokensOfSingleLineInput.hasMoreElements()) {
                    String inputWord = tokensOfSingleLineInput.nextToken();
                    if (probableNumericStreet.equalsIgnoreCase(inputWord)) {
                        ++isHnrOrStreetPart;
                        continue;
                    }
                    if (!StringUtilities.hasNumeric((String)inputWord) || !this.ShouldUseOtherProbableHouseAsHN(m_inputAddress)) continue;
                    this.p_inputAddress.setAddressNumber(ParsedInputAddressUtils.upperCase((String)inputWord));
                    setTheHN = true;
                }
            }
            boolean goodChange = false;
            if (setTheHN && this.m_probableAddressNumList.size() > 1 && (probableHN2 = this.m_probableAddressNumList.get(1).toString()).equals(this.p_inputAddress.getAddressNumber())) {
                goodChange = true;
            }
            if (isHnrOrStreetPart == 2 && !goodChange) {
                this.p_inputAddress.setAddressNumber(probableNumericStreet);
            } else if (isHnrOrStreetPart == 1 && !goodChange) {
                this.p_inputAddress.setAddressNumber("");
            }
        }
    }

    private boolean ShouldUseOtherProbableHouseAsHN(InputAddress inputAddress) {
        if (!(this.m_probableAddressNumList.size() <= 0 || this.p_inputAddress.getMainAddress() == null || !StringUtilities.isNumeric((String)this.p_inputAddress.getMainAddress()) || StringUtilities.isEmpty((String)this.p_inputAddress.getPreThoroughfareType()) && StringUtilities.isEmpty((String)this.p_inputAddress.getPostThoroughfareType()))) {
            boolean hasPreType = !StringUtilities.isEmpty((String)this.p_inputAddress.getPreThoroughfareType());
            StringWithTokens mainAddrToks = new StringWithTokens((String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
            StringWithTokens.TokenIterator iter = mainAddrToks.iterator();
            while (iter.hasNext()) {
                String str;
                String tok = iter.next();
                if (hasPreType && tok.equalsIgnoreCase(this.p_inputAddress.getPreThoroughfareType()) && iter.hasNext() && iter.next().equals(this.p_inputAddress.getMainAddress())) {
                    str = null;
                    if (!iter.hasNext()) continue;
                    str = iter.next();
                    for (AddressNumber num : this.m_probableAddressNumList) {
                        if (!num.toString().equalsIgnoreCase(str)) continue;
                        return true;
                    }
                    continue;
                }
                if (hasPreType || !tok.equals(this.p_inputAddress.getMainAddress()) || !iter.hasNext() || !iter.next().equalsIgnoreCase(this.p_inputAddress.getPostThoroughfareType())) continue;
                str = null;
                if (!iter.hasNext()) continue;
                str = iter.next();
                for (AddressNumber num : this.m_probableAddressNumList) {
                    if (!num.toString().equalsIgnoreCase(str)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void calculateDirectionalInformation() {
        String streetValue = this.p_inputAddress.getMainAddress();
        if (StringUtilities.isEmpty((String)streetValue)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokenizedStreet = new StringTokenizer(streetValue, this.tokenizer);
        int tokenCount = tokenizedStreet.countTokens();
        if (tokenCount < 2) {
            return;
        }
        int i = 0;
        while (tokenizedStreet.hasMoreTokens()) {
            String tokenValue = tokenizedStreet.nextToken();
            if (i == 0 && this.m_parserTerms.isDirectionalWord(tokenValue.trim())) {
                this.p_inputAddress.setPreDirectional(tokenValue);
            } else if (i > 0 && this.m_parserTerms.isDirectionalWord(tokenValue)) {
                this.p_inputAddress.setPostDirectional(tokenValue.trim());
            } else if (i != 1 || !this.m_parserTerms.isArticle(tokenValue) || StringUtilities.isEmpty((String)this.p_inputAddress.getPreDirectional())) {
                builder.append(tokenValue.trim()).append(this.tokenizer);
            }
            ++i;
        }
        this.p_inputAddress.setMainAddress(builder.toString().trim());
    }

    private void calculateUnitInformation() {
        String genericFieldValue = this.p_inputAddress.getGenericField1();
        if (StringUtilities.isEmpty((String)genericFieldValue)) {
            return;
        }
        String preWord = "";
        String postWord = "";
        boolean foundUnitWord = false;
        String[] tokenizedGF1 = genericFieldValue.split(this.tokenizer);
        int i = 0;
        int preWordIndx = -1;
        int postWordIndx = -1;
        for (String tokenValue : tokenizedGF1) {
            if (this.m_parserTerms.isBuildingIdentifier(tokenValue) || this.m_parserTerms.isUnitWord(tokenValue)) {
                this.p_inputAddress.setUnitType(tokenValue);
                foundUnitWord = true;
                preWordIndx = i - 1;
                postWordIndx = i + 1;
                break;
            }
            ++i;
        }
        if (foundUnitWord && preWordIndx > -1) {
            preWord = tokenizedGF1[preWordIndx];
            if (!this.p_inputAddress.getUnitType().equals(preWord) && this.m_parserTerms.isNumericWord(preWord)) {
                this.p_inputAddress.setUnitValue(preWord);
            }
        } else if (postWordIndx > -1 && postWordIndx < tokenizedGF1.length) {
            postWord = tokenizedGF1[postWordIndx];
            if (!this.p_inputAddress.getUnitType().equals(postWord) && this.m_parserTerms.isNumericWord(postWord)) {
                this.p_inputAddress.setUnitValue(postWord);
            }
        }
        genericFieldValue = StringUtilities.replaceWith((String)genericFieldValue, (String)this.p_inputAddress.getUnitType(), (String)"");
        genericFieldValue = StringUtilities.replaceWith((String)genericFieldValue, (String)this.p_inputAddress.getUnitValue(), (String)"");
        this.p_inputAddress.setGenericField1(genericFieldValue);
    }

    private void convertProperDelimiterForHouseNumber() {
        String hnrStr = this.p_inputAddress.getAddressNumber();
        String genericField1 = this.p_inputAddress.getGenericField1();
        if (!StringUtilities.isEmpty((String)hnrStr) && !StringUtilities.isEmpty((String)genericField1) && hnrStr.contains("-")) {
            if (genericField1.contains(hnrStr)) {
                this.p_inputAddress.setGenericField1(StringUtilities.replaceWith((String)genericField1, (String)hnrStr, (String)this.tokenizer));
                return;
            }
            String delims = this.m_parserTerms.getDelimiters();
            int delimCount = delims == null ? 0 : delims.length();
            for (int delimNdx = 0; delimNdx < delimCount; ++delimNdx) {
                String hnrStr2;
                if ("-".equals(String.valueOf(delims.charAt(delimNdx))) || !genericField1.contains(hnrStr2 = StringUtilities.replaceWith((String)hnrStr, (String)"-", (String)String.valueOf(delims.charAt(delimNdx))))) continue;
                this.p_inputAddress.setAddressNumber(hnrStr2);
                genericField1 = StringUtilities.replaceWith((String)genericField1, (String)hnrStr2, (String)this.tokenizer);
                this.p_inputAddress.setGenericField1(genericField1);
                break;
            }
        }
    }

    private void calculateFormattedStreet() {
        Properties props = null;
        String typeName = "";
        String dataSetName = "";
        int casing = 0;
        try {
            String baseName = "JPN".equals(this.m_country) && this.m_converterLanguage != null ? CGGEResourceBundle.buildBaseConfigName(this.m_country, "_CandidateConvertor_" + this.m_converterLanguage + ".properties") : CGGEResourceBundle.buildBaseConfigName(this.m_country, "_CandidateConvertor.properties");
            if (this.m_dataSetInfo != null) {
                typeName = GeocodeOptions.getGeocodeTypeName(this.m_dataSetInfo.getGeocodeType());
                dataSetName = this.m_dataSetInfo.getName();
            }
            props = CGGEResourceBundle.getBundle(baseName, dataSetName, this.m_language, typeName);
            String val = (String)props.get("set_formatted_street");
            String casingProperty = (String)props.get("set_candidate_case");
            if (!StringUtilities.isEmpty((String)casingProperty)) {
                if (casingProperty.equalsIgnoreCase("UPPERCASE")) {
                    casing = 1;
                } else if (casingProperty.equalsIgnoreCase("LOWERCASE")) {
                    casing = 2;
                } else if (casingProperty.equalsIgnoreCase("TITLECASE")) {
                    casing = 3;
                }
            }
            if (!StringUtilities.isEmpty((String)val)) {
                val = StringUtilities.replaceWith((String)val, (String)"additional:sub_building_name", (String)this.p_inputAddress.getGenericField1());
                val = StringUtilities.replaceWith((String)val, (String)"range_place_name", (String)this.p_inputAddress.getPlaceName());
                val = StringUtilities.replaceWith((String)val, (String)"place_name", (String)this.p_inputAddress.getPlaceName());
                val = StringUtilities.replaceWith((String)val, (String)"pre_directional", (String)this.p_inputAddress.getPreDirectional());
                val = StringUtilities.replaceWith((String)val, (String)"pre_thoroughfare", (String)this.p_inputAddress.getPreThoroughfareType());
                val = StringUtilities.replaceWith((String)val, (String)"pre_address", (String)this.p_inputAddress.getPreAddress());
                if (!StringUtilities.isEmpty((String)this.p_inputAddress.getGenericField2())) {
                    val = StringUtilities.replaceWith((String)val, (String)"street_name", (String)(this.p_inputAddress.getMainAddress() + " " + this.findIntersectionIndentifier(this.p_inputAddress.getGenericField1()) + " " + this.p_inputAddress.getGenericField2()));
                } else {
                    if ("JPN".equals(this.m_country)) {
                        val = StringUtilities.replaceWith((String)val, (String)"area_name_1", (String)this.p_inputAddress.getAreaName1());
                        val = StringUtilities.replaceWith((String)val, (String)"area_name_2", (String)this.p_inputAddress.getAreaName2());
                        val = StringUtilities.replaceWith((String)val, (String)"area_name_3", (String)this.p_inputAddress.getAreaName3());
                        val = StringUtilities.replaceWith((String)val, (String)"area_name_4", (String)this.p_inputAddress.getAreaName4());
                    }
                    val = StringUtilities.replaceWith((String)val, (String)"street_name", (String)this.p_inputAddress.getMainAddress());
                }
                val = StringUtilities.replaceWith((String)val, (String)"post_thoroughfare", (String)this.p_inputAddress.getPostThoroughfareType());
                val = StringUtilities.replaceWith((String)val, (String)"post_directional", (String)this.p_inputAddress.getPostDirectional());
                val = StringUtilities.replaceWith((String)val, (String)"address_number", (String)this.p_inputAddress.getAddressNumber());
                val = StringUtilities.replaceWith((String)val, (String)"unit_type", (String)this.p_inputAddress.getUnitType());
                val = StringUtilities.replaceWith((String)val, (String)"unit_value", (String)this.p_inputAddress.getUnitValue());
                val = StringUtilities.replaceWith((String)val, (String)"post_address", (String)this.tokenizer);
                int idx = val.indexOf("[additional:");
                if (idx >= 0) {
                    while (idx >= 0) {
                        StringBuilder sb = new StringBuilder(val);
                        int endIdx = val.indexOf(93, idx) + 1;
                        int prior = -1;
                        if (idx > 0 && val.charAt(idx - 1) == '}' && (prior = val.lastIndexOf(123, idx)) >= 0) {
                            sb.delete(prior, endIdx);
                        } else {
                            sb.delete(idx, endIdx);
                        }
                        val = sb.toString();
                        idx = val.indexOf("[additional:");
                    }
                }
                val = StringUtilities.replaceWith((String)val, (String)"[", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)"]", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)"{", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)"}", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)"(", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)")", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)"?", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)"%", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)"^", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)"*", (String)"");
                val = StringUtilities.replaceWith((String)val, (String)(this.tokenizer + this.tokenizer), (String)this.tokenizer);
                if ((val = this.formatCase(val, casing)) != null) {
                    val = val.trim();
                }
                if (val.startsWith(",")) {
                    val = val.replaceFirst(", ", "");
                }
                this.p_inputAddress.setFormattedInputStreet(val);
            }
        }
        catch (CGGEInternalException e) {
            e.printStackTrace();
        }
    }

    private String formatCase(String string, int casing) {
        String formatedValue = null;
        switch (casing) {
            case 1: {
                formatedValue = this.getUpperCase(string);
                break;
            }
            case 2: {
                formatedValue = this.getLowerCase(string);
                break;
            }
            case 3: {
                formatedValue = this.getTitleCase(string);
                break;
            }
            default: {
                formatedValue = string;
            }
        }
        return formatedValue;
    }

    private void mergeGenericField1(InputAddress m_inputAddress) {
        String singleLineInput = (String)m_inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (StringUtilities.isEmpty((String)singleLineInput)) {
            return;
        }
        String genericField1 = this.p_inputAddress.getGenericField1();
        StringBuilder builder = new StringBuilder();
        if (StringUtilities.isEmpty((String)genericField1)) {
            builder.append(singleLineInput);
        } else {
            builder.append(genericField1).append(this.tokenizer);
            StringTokenizer tokensOfSingleLineInput = new StringTokenizer(singleLineInput, this.tokenizer);
            while (tokensOfSingleLineInput.hasMoreElements()) {
                String tokenValue = tokensOfSingleLineInput.nextToken();
                if (genericField1.contains(tokenValue)) continue;
                builder.append(tokenValue).append(this.tokenizer);
            }
        }
        this.p_inputAddress.setGenericField1(builder.toString());
    }

    private void clearGenericField1() {
        String genericField1 = this.p_inputAddress.getGenericField1();
        if (StringUtilities.isEmpty((String)genericField1)) {
            return;
        }
        genericField1 = this.getUpperCase(genericField1);
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)(this.tokenizer + this.tokenizer), (String)this.tokenizer);
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getMainAddress(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getGenericField2(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getAddressNumber(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getPostCode1(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getAreaName1(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getAreaName2(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getAreaName3(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getAreaName4(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getPreThoroughfareType(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getPostThoroughfareType(), (String)"");
        this.p_inputAddress.setGenericField1(genericField1.trim());
    }

    private void parseStreetInformationFromGenericField1() {
        String genericField1 = this.p_inputAddress.getGenericField1();
        if (StringUtilities.isEmpty((String)genericField1)) {
            return;
        }
        StringTokenizer tokenizedGenericF1 = new StringTokenizer(genericField1, ",");
        if (!this.calculateStreetInformation(tokenizedGenericF1) && !this.calculateStreetInformation(tokenizedGenericF1 = new StringTokenizer(genericField1, ":"))) {
            tokenizedGenericF1 = new StringTokenizer(genericField1, ";");
            this.calculateStreetInformation(tokenizedGenericF1);
        }
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getMainAddress(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getPreThoroughfareType(), (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)this.p_inputAddress.getPostThoroughfareType(), (String)"");
        this.p_inputAddress.setGenericField1(genericField1);
    }

    private boolean calculateStreetInformation(StringTokenizer tokenizedGenericF1) {
        boolean foundStreetInfo = false;
        StringBuilder builder = null;
        String preThoroughFareType = "";
        String postThoroughFareType = "";
        while (tokenizedGenericF1.hasMoreTokens()) {
            builder = new StringBuilder();
            String tokenValue = tokenizedGenericF1.nextToken();
            StringTokenizer tokenWithinToken = new StringTokenizer(tokenValue, this.tokenizer);
            int i = tokenWithinToken.countTokens();
            int j = 1;
            if (i == 1) continue;
            while (tokenWithinToken.hasMoreTokens()) {
                String tokenValue2 = tokenWithinToken.nextToken();
                if (j == 1 && this.m_tftHandler.isThoroughfareTypeAtStart(tokenValue2)) {
                    preThoroughFareType = tokenValue2;
                    foundStreetInfo = true;
                } else if (j == i && this.m_tftHandler.isThoroughfareTypeAtEnd(tokenValue2)) {
                    postThoroughFareType = tokenValue2;
                    foundStreetInfo = true;
                } else {
                    builder.append(tokenValue2).append(this.tokenizer);
                }
                ++j;
            }
            if (!foundStreetInfo) continue;
            this.p_inputAddress.setMainAddress(builder.toString());
            this.p_inputAddress.setPreThoroughfareType(preThoroughFareType);
            this.p_inputAddress.setPostThoroughfareType(postThoroughFareType);
        }
        return foundStreetInfo;
    }

    private void removeDelimiter() {
        String genericField1 = this.p_inputAddress.getGenericField1();
        if (StringUtilities.isEmpty((String)genericField1)) {
            return;
        }
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)",", (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)":", (String)"");
        genericField1 = StringUtilities.replaceWith((String)genericField1, (String)";", (String)"");
        this.p_inputAddress.setGenericField1(genericField1.trim());
    }

    private String getUpperCase(String value) {
        if (!StringUtilities.isEmpty((String)value)) {
            return this.m_locale != null ? value.toUpperCase(this.m_locale) : value.toUpperCase();
        }
        return value;
    }

    private String getLowerCase(String value) {
        if (!StringUtilities.isEmpty((String)value)) {
            return this.m_locale != null ? value.toLowerCase(this.m_locale) : value.toLowerCase();
        }
        return value;
    }

    private String getTitleCase(String string) {
        if (string != null) {
            StringBuilder builder = new StringBuilder("");
            String delimiters = " .-\t\n\r\f";
            string = this.getLowerCase(string);
            StringTokenizer tokenizer = new StringTokenizer(string, delimiters, true);
            while (tokenizer.hasMoreElements()) {
                String temp = tokenizer.nextToken();
                builder.append(temp.substring(0, 1).toUpperCase());
                if (temp.length() <= 1) continue;
                builder.append(temp.substring(1));
            }
            return builder.toString();
        }
        return null;
    }

    private void parsedIntersectionAddress(InternalScoringAddress scoringAddress) {
        String value = "";
        if (scoringAddress instanceof InternalIntersectionScoringAddress) {
            InternalIntersectionScoringAddress intersectionScoringAddress = (InternalIntersectionScoringAddress)scoringAddress;
            value = this.getFieldValue(intersectionScoringAddress.getFirstCandidate().getFieldScore(FieldType.STREET_NAME_FIELD_TYPE));
            this.p_inputAddress.setMainAddress(value);
            value = this.getFieldValue(intersectionScoringAddress.getSecondCandidate().getFieldScore(FieldType.STREET_NAME_FIELD_TYPE));
            this.p_inputAddress.setGenericField2(value);
            value = this.getFieldValue(intersectionScoringAddress.getFirstCandidate().getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE));
            this.p_inputAddress.setAreaName1(value);
            value = this.getFieldValue(intersectionScoringAddress.getFirstCandidate().getFieldScore(FieldType.AREA_NAME_2_FIELD_TYPE));
            this.p_inputAddress.setAreaName2(value);
            value = this.getFieldValue(intersectionScoringAddress.getFirstCandidate().getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE));
            this.p_inputAddress.setAreaName3(value);
            value = this.getFieldValue(intersectionScoringAddress.getFirstCandidate().getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE));
            this.p_inputAddress.setAreaName4(value);
        }
    }

    private String findIntersectionIndentifier(String intersectionIdentifier) {
        String genericField1 = this.p_inputAddress.getGenericField1();
        String country_intersectionIdentifier = "";
        if (this.m_parsedAddres.isIntersectionCase() && genericField1 != null) {
            StringTokenizer tokenizedGenericField1 = new StringTokenizer(genericField1, this.tokenizer);
            if (tokenizedGenericField1.hasMoreTokens()) {
                country_intersectionIdentifier = tokenizedGenericField1.nextToken();
            }
            genericField1 = StringUtilities.replaceWith((String)genericField1, (String)country_intersectionIdentifier, (String)"");
            this.p_inputAddress.setGenericField1(genericField1);
        }
        return country_intersectionIdentifier;
    }

    private void handledHypenInParsedMainAdress() {
        String parsedMainAddress = this.p_inputAddress.getMainAddress();
        String genericField1 = this.p_inputAddress.getGenericField1();
        int firstToken = 0;
        StringBuilder builder = new StringBuilder();
        if (parsedMainAddress != null && genericField1 != null) {
            StringTokenizer tokenizedGenericF1 = new StringTokenizer(genericField1, this.tokenizer);
            StringTokenizer tokenizedParsedMainAddress = new StringTokenizer(parsedMainAddress, this.tokenizer);
            while (tokenizedParsedMainAddress.hasMoreTokens()) {
                builder.append(tokenizedParsedMainAddress.nextToken());
                if (++firstToken != 1) continue;
                builder.append("-");
            }
            while (tokenizedGenericF1.hasMoreTokens()) {
                if (!builder.toString().equalsIgnoreCase(tokenizedGenericF1.nextToken())) continue;
                this.p_inputAddress.setMainAddress(builder.toString());
                this.p_inputAddress.setGenericField1(genericField1.replace(builder.toString(), ""));
            }
        }
    }
}

