/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.jdbc;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.INamedFieldDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysOracleFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public abstract class JDBCDataSourceRecord
implements INamedFieldDataSourceRecord {
    public static final String KEY_GEOM = "geomColumn";
    private ResultSet m_rs;
    private Properties m_properties;

    public JDBCDataSourceRecord(JDBCDataSourceRecordObjects objects) {
        this.m_rs = objects.getResultSet();
        this.m_properties = objects.getProperties();
    }

    protected ResultSet getResultSet() {
        return this.m_rs;
    }

    protected Properties getProperties() {
        return this.m_properties;
    }

    public boolean hasField(String fieldKey) {
        if (fieldKey == null) {
            return false;
        }
        String fldValue = this.getFieldName(fieldKey);
        return fldValue != null && !"NONE".equals(fldValue);
    }

    public String getFieldName(String fieldKey) {
        if (fieldKey == null) {
            return null;
        }
        return this.m_properties.getProperty(fieldKey);
    }

    public String getFieldStringValue(String fldName) throws DataSourceException {
        try {
            return this.m_rs.getString(fldName);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(7, fldName, (Throwable)SQLEx);
        }
    }

    public int getFieldIntValue(String fldName) throws DataSourceException {
        try {
            return this.m_rs.getInt(fldName);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(5, fldName, (Throwable)SQLEx);
        }
    }

    public double getFieldDoubleValue(String fldName) throws DataSourceException {
        try {
            return this.m_rs.getDouble(fldName);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(3, fldName, (Throwable)SQLEx);
        }
    }

    public boolean getFieldBooleanValue(String fldName) throws DataSourceException {
        try {
            return this.m_rs.getBoolean(fldName);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(0, fldName, (Throwable)SQLEx);
        }
    }

    public short getFieldShortValue(String fldName) throws DataSourceException {
        try {
            return this.m_rs.getShort(fldName);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(6, fldName, (Throwable)SQLEx);
        }
    }

    public float getFieldFloatValue(String fldName) throws DataSourceException {
        try {
            return this.m_rs.getFloat(fldName);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(4, fldName, (Throwable)SQLEx);
        }
    }

    public abstract ArrayList<DirectPosition> getRecordPoints() throws DataSourceException;

    public abstract DirectPosition getRecordPoint() throws DataSourceException;

    protected DirectPosition createPoint(int SRID, double x, double y) {
        CoordSys coordsys = CoordSysOracleFactory.getOracleCoordSysFactory().getCoordSys(SRID);
        return CoordConvertor.transformPointToWGS84((CoordSys)coordsys, (DirectPosition)new DirectPosition(x, y));
    }
}

