/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.jdbc;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.TAIntermediateRecord;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JDBCIntermediateDataHandler
implements IIntermediateDataHandler {
    public static Logger logger = LoggerFactory.getLogger(JDBCIntermediateDataHandler.class);
    public static final String KEY_CONNECTION_URL = "intermediate_connectionURL";
    public static final String KEY_USER_NAME = "intermediate_user";
    public static final String KEY_PASSWORD = "intermediate_password";
    public static final String KEY_TABLE_NAME = "intermediate_tableName";
    public static final String KEY_NUMERIC_ONLY = "intermediate_numericOnly";
    private static final int SOL_LEFT = 1;
    private static final String COLUMN_SEGMENT_SIDE = "SOL";
    private static final String COLUMN_SEQUENCE_NUMBER = "SEQNR";
    private static final String COLUMN_ADDRESS_NUMBER_WITH_ALPHA = "F_ADD";
    private static final String COLUMN_ADDRESS_NUMBER = "ADD";
    public String SELECT_STATEMENT_START = "SELECT F_ADD, \"ADD\", SEQNR, SOL FROM ";
    public String SELECT_STATEMENT_END = " WHERE ID=?";
    private final Properties m_properties;
    private Connection m_conn;
    private PreparedStatement m_selectStatement;
    private final boolean m_bUseNumericOnly;

    public JDBCIntermediateDataHandler(Properties properties) {
        this.m_properties = properties;
        this.m_bUseNumericOnly = "TRUE".equalsIgnoreCase(this.m_properties.getProperty(KEY_NUMERIC_ONLY));
        if (this.m_bUseNumericOnly) {
            logger.error("WARNING: Using the non-alpha address column for intermediate data.");
        }
    }

    public void open(String[] args) throws DataSourceException {
        if (StringUtilities.isEmpty((String)args[3])) {
            throw new DataSourceException(11, "No intermediate table given given");
        }
        try {
            this.m_conn = this.getConnection(args[0], args[1], args[2]);
            this.m_selectStatement = this.createSelectStatement(args[3]);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(11, (Throwable)SQLEx);
        }
    }

    public void open() throws DataSourceException {
        String[] args = new String[]{this.m_properties.getProperty(KEY_CONNECTION_URL), this.m_properties.getProperty(KEY_USER_NAME), this.m_properties.getProperty(KEY_PASSWORD), this.m_properties.getProperty(KEY_TABLE_NAME)};
        this.open(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws DataSourceException {
        boolean bNoPreviousException = false;
        try {
            if (this.m_selectStatement != null) {
                this.m_selectStatement.close();
            }
            bNoPreviousException = true;
            return;
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(12, (Throwable)SQLEx);
        }
        finally {
            this.m_selectStatement = null;
            if (this.m_conn != null) {
                try {
                    this.m_conn.close();
                }
                catch (SQLException SQLEx) {
                    if (bNoPreviousException) {
                        throw new DataSourceException(12, (Throwable)SQLEx);
                    }
                }
                finally {
                    this.m_conn = null;
                }
            }
        }
    }

    public List getIntermediateRecords(String id) {
        ResultSet rs = null;
        try {
            this.m_selectStatement.setString(1, id);
            rs = this.m_selectStatement.executeQuery();
            ArrayList<TAIntermediateRecord> records = new ArrayList<TAIntermediateRecord>();
            while (rs.next()) {
                TAIntermediateRecord record = new TAIntermediateRecord();
                if (this.m_bUseNumericOnly) {
                    record.setHnr(rs.getString(COLUMN_ADDRESS_NUMBER));
                } else {
                    record.setHnr(rs.getString(COLUMN_ADDRESS_NUMBER_WITH_ALPHA));
                }
                record.setSeqNum(rs.getShort(COLUMN_SEQUENCE_NUMBER));
                record.setIsLeft(rs.getInt(COLUMN_SEGMENT_SIDE) == 1);
                records.add(record);
            }
            ArrayList<TAIntermediateRecord> arrayList = records;
            return arrayList;
        }
        catch (SQLException SQLEx) {
            throw new RuntimeException((Throwable)new DataSourceException(-1, (Throwable)SQLEx));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException SQLEx) {
                    throw new RuntimeException((Throwable)new DataSourceException(-1, (Throwable)SQLEx));
                }
            }
        }
    }

    protected abstract Connection getConnection(String var1, String var2, String var3) throws SQLException, DataSourceException;

    private PreparedStatement createSelectStatement(String tableName) throws SQLException {
        PreparedStatement statement = this.m_conn.prepareStatement(this.getSelectStatementStart() + tableName + this.getSelectStatementEnd(), 1003, 1007);
        statement.setFetchSize(100);
        return statement;
    }

    protected String getSelectStatementStart() {
        return this.SELECT_STATEMENT_START;
    }

    protected String getSelectStatementEnd() {
        return this.SELECT_STATEMENT_END;
    }
}

