/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.oracle;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.jdbc.OracleResultSet;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class OracleDataSourceRecord
extends JDBCDataSourceRecord {
    public OracleDataSourceRecord(JDBCDataSourceRecordObjects objects) {
        super(objects);
    }

    @Override
    public ArrayList<DirectPosition> getRecordPoints() throws DataSourceException {
        JGeometry geometry = this.getGeometry();
        if (geometry == null) {
            return null;
        }
        switch (geometry.getType()) {
            case 1: {
                ArrayList<DirectPosition> points = new ArrayList<DirectPosition>(1);
                points.add(this.createPoint(geometry.getSRID(), geometry.getPoint()[0], geometry.getPoint()[1]));
                return points;
            }
            case 2: {
                ArrayList<DirectPosition> points = new ArrayList<DirectPosition>(geometry.getNumPoints());
                double[] ordinates = geometry.getOrdinatesArray();
                for (int i = 0; i < geometry.getNumPoints(); ++i) {
                    int pos = i * 2;
                    points.add(this.createPoint(geometry.getSRID(), ordinates[pos], ordinates[pos + 1]));
                }
                return points;
            }
        }
        throw new DataSourceException(8, "Unknown geometry type: " + geometry.getType());
    }

    @Override
    public DirectPosition getRecordPoint() throws DataSourceException {
        JGeometry geometry = this.getGeometry();
        if (geometry == null) {
            return null;
        }
        if (geometry.getType() == 1) {
            return this.createPoint(geometry.getSRID(), geometry.getPoint()[0], geometry.getPoint()[1]);
        }
        return null;
    }

    private JGeometry getGeometry() throws DataSourceException {
        try {
            String geomFieldName = this.getFieldName("geomColumn");
            if (StringUtilities.isEmpty((String)geomFieldName)) {
                throw new DataSourceException(8, "No 'geomColumn' mapping present in data processing properties");
            }
            STRUCT rawGeometry = ((OracleResultSet)this.getResultSet()).getSTRUCT(this.getFieldName("geomColumn"));
            if (rawGeometry == null) {
                return null;
            }
            JGeometry geometry = JGeometry.load((STRUCT)rawGeometry);
            if (geometry == null) {
                throw new DataSourceException(8, "Unable to load JGeometry from STRUCT");
            }
            return geometry;
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(8, (Throwable)SQLEx);
        }
    }
}

