/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.postgresql;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.Arrays;

public class PostgreSQLDataSourceRecord
extends JDBCDataSourceRecord {
    public PostgreSQLDataSourceRecord(JDBCDataSourceRecordObjects objects) {
        super(objects);
    }

    @Override
    public ArrayList<DirectPosition> getRecordPoints() throws DataSourceException {
        DirectPosition[] geometry = this.getGeometry();
        if (geometry == null || geometry.length == 0) {
            return null;
        }
        ArrayList<DirectPosition> points = new ArrayList<DirectPosition>(geometry.length);
        points.addAll(Arrays.asList(geometry));
        return points;
    }

    @Override
    public DirectPosition getRecordPoint() throws DataSourceException {
        DirectPosition[] geometry = this.getGeometry();
        if (geometry == null || geometry.length != 1) {
            return null;
        }
        return geometry[0];
    }

    private DirectPosition[] getGeometry() throws DataSourceException {
        Geometry geometry;
        String geomFieldName = this.getFieldName("geomColumn");
        if (StringUtilities.isEmpty((String)geomFieldName)) {
            throw new DataSourceException(8, "No 'geomColumn' mapping present in data processing properties");
        }
        String geometryString = this.getFieldStringValue(this.getFieldName("geomColumn"));
        if (StringUtilities.isEmpty((String)geometryString)) {
            return null;
        }
        try {
            geometry = new WKBReader().read(WKBReader.hexToBytes((String)geometryString));
        }
        catch (ParseException pe) {
            try {
                geometry = new WKTReader().read(geometryString);
            }
            catch (ParseException peboth) {
                throw new DataSourceException(8, (Throwable)pe);
            }
        }
        Coordinate[] coords = geometry.getCoordinates();
        DirectPosition[] points = new DirectPosition[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            points[i] = new DirectPosition(coords[i].x, coords[i].y);
        }
        return points;
    }
}

