/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionMutator;
import com.mapinfo.midev.geometry.NonInvertibleAffineTransformException;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public final class AffineTransform
implements IDirectPositionMutator,
Serializable {
    public static final AffineTransform IDENTITY = new AffineTransform(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    private final double m_a;
    private final double m_b;
    private final double m_c;
    private final double m_d;
    private final double m_e;
    private final double m_f;
    private AffineTransform m_inverse;

    public static AffineTransform getInstance() {
        return IDENTITY;
    }

    private AffineTransform(double a, double b, double c, double d, double e, double f) {
        this.m_a = a;
        this.m_b = b;
        this.m_c = c;
        this.m_d = d;
        this.m_e = e;
        this.m_f = f;
    }

    public static AffineTransform getInstance(AffineTransform t1, AffineTransform t2) {
        return AffineTransform.getRowFirstInstance(t2.m_a * t1.m_a + t2.m_b * t1.m_d, t2.m_a * t1.m_b + t2.m_b * t1.m_e, t2.m_a * t1.m_c + t2.m_b * t1.m_f + t2.m_c, t2.m_d * t1.m_a + t2.m_e * t1.m_d, t2.m_d * t1.m_b + t2.m_e * t1.m_e, t2.m_d * t1.m_c + t2.m_e * t1.m_f + t2.m_f);
    }

    public static AffineTransform getColumnFirstInstance(double m00, double m10, double m01, double m11, double m02, double m12) {
        AffineTransform result = AffineTransform.isIdentity(m00, m01, m02, m10, m11, m12) ? IDENTITY : new AffineTransform(m00, m01, m02, m10, m11, m12);
        return result;
    }

    public static AffineTransform getRowFirstInstance(double a, double b, double c, double d, double e, double f) {
        AffineTransform result = AffineTransform.isIdentity(a, b, c, d, e, f) ? IDENTITY : new AffineTransform(a, b, c, d, e, f);
        return result;
    }

    public static AffineTransform getRowFirstInstance(double a, double c, double e, double f) {
        return AffineTransform.getRowFirstInstance(a, 0.0, c, 0.0, e, f);
    }

    public static AffineTransform getRotateInstanceCW(double theta) {
        double a;
        double e;
        double b;
        double d;
        double c = 0.0;
        double f = 0.0;
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        if (Math.abs(sin) < 1.0E-15) {
            d = 0.0;
            b = 0.0;
            if (cos < 0.0) {
                e = -1.0;
                a = -1.0;
            } else {
                e = 1.0;
                a = 1.0;
            }
        } else if (Math.abs(cos) < 1.0E-15) {
            e = 0.0;
            a = 0.0;
            if (sin < 0.0) {
                b = 1.0;
                d = -1.0;
            } else {
                b = -1.0;
                d = 1.0;
            }
        } else {
            a = cos;
            b = -sin;
            d = sin;
            e = cos;
        }
        return AffineTransform.getRowFirstInstance(a, b, 0.0, d, e, 0.0);
    }

    public static AffineTransform getRotateInstanceCCW(double theta) {
        return AffineTransform.getRotateInstanceCW(-theta);
    }

    public static AffineTransform getRotateInstanceCW(double theta, double x, double y) {
        double a;
        double e;
        double b;
        double d;
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        if (Math.abs(sin) < 1.0E-15) {
            d = 0.0;
            b = 0.0;
            if (cos < 0.0) {
                e = -1.0;
                a = -1.0;
            } else {
                e = 1.0;
                a = 1.0;
            }
        } else if (Math.abs(cos) < 1.0E-15) {
            e = 0.0;
            a = 0.0;
            if (sin < 0.0) {
                b = 1.0;
                d = -1.0;
            } else {
                b = -1.0;
                d = 1.0;
            }
        } else {
            a = cos;
            b = -sin;
            d = sin;
            e = cos;
        }
        double oneMinusCos = 1.0 - a;
        double c = x * oneMinusCos + y * d;
        double f = y * oneMinusCos - x * d;
        return AffineTransform.getRowFirstInstance(a, b, c, d, e, f);
    }

    public static AffineTransform getRotateInstanceCCW(double theta, double x, double y) {
        return AffineTransform.getRotateInstanceCW(-theta, x, y);
    }

    public static AffineTransform getScaleInstance(double sx, double sy) {
        return AffineTransform.getRowFirstInstance(sx, 0.0, 0.0, 0.0, sy, 0.0);
    }

    public static AffineTransform getShearInstance(double shx, double shy) {
        return AffineTransform.getRowFirstInstance(1.0, shx, 0.0, shy, 1.0, 0.0);
    }

    public static AffineTransform getTranslateInstance(double tx, double ty) {
        return AffineTransform.getRowFirstInstance(1.0, 0.0, tx, 0.0, 1.0, ty);
    }

    public AffineTransform rotateCW(double theta) {
        return AffineTransform.getInstance(AffineTransform.getRotateInstanceCW(theta), this);
    }

    public AffineTransform rotateCW(double theta, double x, double y) {
        return AffineTransform.getInstance(AffineTransform.getRotateInstanceCW(theta, x, y), this);
    }

    public AffineTransform rotateCCW(double theta) {
        return AffineTransform.getInstance(AffineTransform.getRotateInstanceCW(-theta), this);
    }

    public AffineTransform rotateCCW(double theta, double x, double y) {
        return AffineTransform.getInstance(AffineTransform.getRotateInstanceCW(-theta, x, y), this);
    }

    public AffineTransform scale(double sx, double sy) {
        return AffineTransform.getInstance(AffineTransform.getScaleInstance(sx, sy), this);
    }

    public AffineTransform shear(double shx, double shy) {
        return AffineTransform.getInstance(AffineTransform.getShearInstance(shx, shy), this);
    }

    public AffineTransform translate(double tx, double ty) {
        return AffineTransform.getInstance(AffineTransform.getTranslateInstance(tx, ty), this);
    }

    public double getScaleX() {
        return this.m_a;
    }

    public double getScaleY() {
        return this.m_e;
    }

    public double getShearX() {
        return this.m_b;
    }

    public double getShearY() {
        return this.m_d;
    }

    public double getTranslateX() {
        return this.m_c;
    }

    public double getTranslateY() {
        return this.m_f;
    }

    public boolean isIdentity() {
        return this == IDENTITY;
    }

    public boolean isLinear() {
        return this.m_b == 0.0 && this.m_d == 0.0;
    }

    public void getColumnFirstCoefficients(double[] coefficients) {
        ArgumentValidator.assertNotNullReference("coefficients", coefficients);
        if (coefficients.length != 6) {
            throw new IllegalArgumentException("Coefficient array must have a length of 6.");
        }
        coefficients[0] = this.m_a;
        coefficients[1] = this.m_d;
        coefficients[2] = this.m_b;
        coefficients[3] = this.m_e;
        coefficients[4] = this.m_c;
        coefficients[5] = this.m_f;
    }

    public void getRowFirstCoefficients(double[] coefficients) {
        ArgumentValidator.assertNotNullReference("coefficients", coefficients);
        if (coefficients.length != 6) {
            throw new IllegalArgumentException("Coefficient array must have a length of 6.");
        }
        coefficients[0] = this.m_a;
        coefficients[1] = this.m_b;
        coefficients[2] = this.m_c;
        coefficients[3] = this.m_d;
        coefficients[4] = this.m_e;
        coefficients[5] = this.m_f;
    }

    public AffineTransform createInverse() {
        if (this.m_inverse == null) {
            double det = this.m_a * this.m_e - this.m_b * this.m_d;
            if (det == 0.0) {
                throw new NonInvertibleAffineTransformException(this);
            }
            this.m_inverse = AffineTransform.getRowFirstInstance(this.m_e / det, -this.m_b / det, (this.m_b * this.m_f - this.m_c * this.m_e) / det, -this.m_d / det, this.m_a / det, (this.m_c * this.m_d - this.m_a * this.m_f) / det);
        }
        return this.m_inverse;
    }

    private static boolean isIdentity(double a, double b, double c, double d, double e, double f) {
        return a == 1.0 && b == 0.0 && c == 0.0 && d == 0.0 && e == 1.0 && f == 0.0;
    }

    @Override
    public DirectPosition transform(DirectPosition source, DirectPosition destination) {
        if (this == IDENTITY) {
            if (source != destination) {
                destination.set(source);
            }
        } else {
            destination.setXY(this.m_a * source.getX() + this.m_b * source.getY() + this.m_c, this.m_d * source.getX() + this.m_e * source.getY() + this.m_f);
            if (source != destination) {
                destination.setZ(source.getZ());
                destination.setM(source.getM());
            }
        }
        return destination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffineTransform that = (AffineTransform)o;
        if (Double.compare(that.m_a, this.m_a) != 0) {
            return false;
        }
        if (Double.compare(that.m_b, this.m_b) != 0) {
            return false;
        }
        if (Double.compare(that.m_c, this.m_c) != 0) {
            return false;
        }
        if (Double.compare(that.m_d, this.m_d) != 0) {
            return false;
        }
        if (Double.compare(that.m_e, this.m_e) != 0) {
            return false;
        }
        return Double.compare(that.m_f, this.m_f) == 0;
    }

    public int hashCode() {
        long temp = this.m_a != 0.0 ? Double.doubleToLongBits(this.m_a) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.m_b != 0.0 ? Double.doubleToLongBits(this.m_b) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = this.m_c != 0.0 ? Double.doubleToLongBits(this.m_c) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = this.m_d != 0.0 ? Double.doubleToLongBits(this.m_d) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = this.m_e != 0.0 ? Double.doubleToLongBits(this.m_e) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = this.m_f != 0.0 ? Double.doubleToLongBits(this.m_f) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

