/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.util.ArgumentValidator;
import java.io.Serializable;

public class PrecisionMode
implements Serializable {
    public static final String KEY_ENABLE = "com.pb.midev.service.output.geometry.useprecision";
    private static final boolean ENABLE = PrecisionMode.isEnabled();
    private final double m_factor;

    public PrecisionMode(double tolerance) {
        ArgumentValidator.assertNotOutOfRangeMinimum("Tolerance", tolerance, 0.0);
        double factor = 1.0;
        if (tolerance != 0.0) {
            if (tolerance < 1.0) {
                while (tolerance < 1.0) {
                    factor *= 10.0;
                    tolerance *= 10.0;
                }
            } else {
                while (tolerance >= 10.0) {
                    factor *= 10.0;
                    tolerance *= 0.1;
                }
                factor = 1.0 / factor;
            }
        }
        this.m_factor = factor;
    }

    public double round(double value) {
        if (ENABLE) {
            double roundHalfup = value > 0.0 ? 0.5 : -0.5;
            return (double)((long)(value * this.m_factor + roundHalfup)) / this.m_factor;
        }
        return value;
    }

    private static boolean isEnabled() {
        boolean isEnabled = false;
        String prop = System.getProperty(KEY_ENABLE);
        if (prop != null && !prop.isEmpty()) {
            isEnabled = "true".equalsIgnoreCase(prop.trim());
        }
        return isEnabled;
    }
}

