/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.io;

import com.mapinfo.midev.io.UnknownCharsetException;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.util.HashMap;
import java.util.Map;

@PublicAPI
public final class CharSet {
    private static final Map<String, CharSet> CHARSETS = new HashMap<String, CharSet>();
    public static final CharSet NEUTRAL = new CharSet(0, "Neutral", "ASCII", "US-ASCII");
    public static final CharSet ISO8859_1 = new CharSet(1, "ISO8859_1", "ISO8859_1", "ISO-8859-1");
    public static final CharSet ISO8859_2 = new CharSet(2, "ISO8859_2", "ISO8859_2", "ISO-8859-2");
    public static final CharSet ISO8859_3 = new CharSet(3, "ISO8859_3", "ISO8859_3", "ISO-8859-3");
    public static final CharSet ISO8859_4 = new CharSet(4, "ISO8859_4", "ISO8859_4", "ISO-8859-4");
    public static final CharSet ISO8859_5 = new CharSet(5, "ISO8859_5", "ISO8859_5", "ISO-8859-5");
    public static final CharSet ISO8859_6 = new CharSet(6, "ISO8859_6", "ISO8859_6", "ISO-8859-6");
    public static final CharSet ISO8859_7 = new CharSet(7, "ISO8859_7", "ISO8859_7", "ISO-8859-7");
    public static final CharSet ISO8859_8 = new CharSet(8, "ISO8859_8", "ISO8859_8", "ISO-8859-8");
    public static final CharSet ISO8859_9 = new CharSet(9, "ISO8859_9", "ISO8859_9", "ISO-8859-9");
    public static final CharSet WLATIN1 = new CharSet(10, "WindowsLatin1", "Cp1252", "windows-1252");
    public static final CharSet WLATIN2 = new CharSet(11, "WindowsLatin2", "Cp1250", "windows-1250");
    public static final CharSet WARABIC = new CharSet(12, "WindowsArabic", "Cp1256", "windows-1256");
    public static final CharSet WCYRILLIC = new CharSet(13, "WindowsCyrillic", "Cp1251", "windows-1251");
    public static final CharSet WGREEK = new CharSet(14, "WindowsGreek", "Cp1253", "windows-1253");
    public static final CharSet WHEBREW = new CharSet(15, "WindowsHebrew", "Cp1255", "windows-1255");
    public static final CharSet WTURKISH = new CharSet(16, "WindowsTurkish", "Cp1254", "windows-1254");
    public static final CharSet WTCHINESE = new CharSet(17, "WindowsTradChinese", "MS950", "windows-950");
    public static final CharSet WSCHINESE = new CharSet(18, "WindowsSimpChinese", "MS936", "windows-936");
    public static final CharSet WJAPANESE = new CharSet(19, "WindowsJapanese", "MS932", "windows-31j");
    public static final CharSet WKOREAN = new CharSet(20, "WindowsKorean", "MS949", "windows-949");
    public static final CharSet MROMAN = new CharSet(21, "MacRoman", "MacRoman", "x-MacRoman");
    public static final CharSet MARABIC = new CharSet(22, "MacArabic", "MacArabic", "x-MacArabic");
    public static final CharSet MGREEK = new CharSet(23, "MacGreek", "MacGreek", "x-MacGreek");
    public static final CharSet MHEBREW = new CharSet(24, "MacHebrew", "MacHebrew", "x-MacHebrew");
    public static final CharSet MCENTEURO = new CharSet(25, "MacCentralEuropean", "MacCentralEuropean", "x-MacCentralEurope");
    public static final CharSet MCROATIAN = new CharSet(26, "MacCroatian", "MacCroatian", "x-MacCroatian");
    public static final CharSet MCYRILLIC = new CharSet(27, "MacCyrillic", "MacCyrillic", "x-MacCyrillic");
    public static final CharSet MICELANDIC = new CharSet(28, "MacIcelandic", "MacIceland", "x-MacIceland");
    public static final CharSet MTHAI = new CharSet(29, "MacThai", "MacThai", "x-MacThai");
    public static final CharSet MTURKISH = new CharSet(30, "MacTurkish", "MacTurkish", "x-MacTurkish");
    public static final CharSet MTCHINESE = new CharSet(31, "MacTradChinese", "Big5", "Big5");
    public static final CharSet MJAPANESE = new CharSet(32, "MacJapanese", "SJIS", "Shift_JIS");
    public static final CharSet MKOREAN = new CharSet(33, "MacKorean", "EUC_KR", "EUC-KR");
    public static final CharSet CP437 = new CharSet(34, "CodePage437", "Cp437", "IBM437");
    public static final CharSet CP850 = new CharSet(35, "CodePage850", "Cp850", "IBM850");
    public static final CharSet CP852 = new CharSet(36, "CodePage852", "Cp852", "IBM855");
    public static final CharSet CP857 = new CharSet(37, "CodePage857", "Cp857", "IBM857");
    public static final CharSet CP860 = new CharSet(38, "CodePage860", "Cp860", "IBM860");
    public static final CharSet CP861 = new CharSet(39, "CodePage861", "Cp861", "IBM861");
    public static final CharSet CP863 = new CharSet(40, "CodePage863", "Cp863", "IBM863");
    public static final CharSet CP865 = new CharSet(41, "CodePage865", "Cp865", "IBM865");
    public static final CharSet CP855 = new CharSet(42, "CodePage855", "Cp855", "IBM855");
    public static final CharSet CP864 = new CharSet(43, "CodePage864", "Cp864", "IBM864");
    public static final CharSet CP869 = new CharSet(44, "CodePage869", "Cp869", "IBM869");
    public static final CharSet LICS = new CharSet(45, "LICS", "", "");
    public static final CharSet LMBCS = new CharSet(46, "LMBCS", "", "");
    public static final CharSet LMBCS1 = new CharSet(47, "LMBCS1", "", "");
    public static final CharSet LMBCS2 = new CharSet(48, "LMBCS2", "", "");
    public static final CharSet MSCHINESE = new CharSet(49, "MacSimpChinese", "EUC_CN", "EUC-CN");
    public static final CharSet UTCHINESE = new CharSet(50, "?PackedEUCTradChinese", "EUC_TW", "EUC-TW");
    public static final CharSet USCHINESE = new CharSet(51, "?PackedEUCSimpChinese", "EUC_CN", "EUC-CN");
    public static final CharSet UJAPANESE = new CharSet(52, "PackedEUCJapanese", "EUC_JP", "EUC-JP");
    public static final CharSet UKOREAN = new CharSet(53, "?PackedEUCKorean", "EUC_KR", "EUC-KR");
    public static final CharSet WTHAI = new CharSet(54, "WindowsThai", "MS874", "windows-874");
    public static final CharSet WBALTICRIM = new CharSet(55, "WindowsBalticRim", "Cp1257", "windows-1257");
    public static final CharSet WVIETNAMESE = new CharSet(56, "WindowsVietnamese", "Cp1258", "windows-1258");
    public static final CharSet UTF_8 = new CharSet(57, "UTF-8", "UTF-8", "UTF-8");
    public static final CharSet UTF_16 = new CharSet(58, "UTF-16", "UTF-16LE", "UTF-16LE");
    public static final CharSet windowsLatin1 = WLATIN1;
    private final int m_code;
    private final String m_mapinfo;
    private final String m_io;
    private final String m_nio;

    private CharSet(int code, String mapinfoName, String ioName, String nioName) {
        this.m_code = code;
        this.m_mapinfo = mapinfoName;
        this.m_io = ioName;
        this.m_nio = nioName;
        CHARSETS.put(this.m_mapinfo.toLowerCase(), this);
    }

    public static CharSet getCharSet(String name) {
        return CHARSETS.get(name.toLowerCase());
    }

    public static CharSet getCharSet(int id) {
        for (CharSet cs : CHARSETS.values()) {
            if (cs.getCode() != id) continue;
            return cs;
        }
        throw new UnknownCharsetException(Integer.toString(id));
    }

    public static CharSet valueOfNIOName(String nioName) {
        for (Map.Entry<String, CharSet> entry : CHARSETS.entrySet()) {
            if (!entry.getValue().getJavaNIOEncoding().equalsIgnoreCase(nioName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public int getCode() {
        return this.m_code;
    }

    public String getName() {
        return this.m_mapinfo;
    }

    public String getJavaIOEncoding() {
        return this.m_io;
    }

    public String getJavaNIOEncoding() {
        return this.m_nio;
    }

    @PrivateAPI
    public boolean isUTF() {
        return this.equals(UTF_8) || this.equals(UTF_16);
    }

    static {
        CHARSETS.put("ansi", WLATIN1);
    }
}

