/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.messages;

import com.mapinfo.midev.messages.ErrorMessageDetails;
import com.mapinfo.midev.messages.IMessage;
import com.mapinfo.midev.messages.IMessageDetails;
import com.mapinfo.midev.messages.MessageType;
import com.mapinfo.midev.messages.Warning;
import com.mapinfo.midev.messages.WarningMessageDetails;
import java.io.Serializable;

public class Message
implements IMessage,
Serializable {
    private final MessageType m_type;
    private final String m_code;
    private final IMessageDetails m_details;

    public Message(Exception ex) {
        this.m_type = MessageType.ERROR;
        this.m_code = ex.getClass().getSimpleName();
        this.m_details = new ErrorMessageDetails(ex);
    }

    public Message(Warning warning) {
        this.m_type = MessageType.WARNING;
        this.m_code = warning.getClass().getSimpleName();
        this.m_details = new WarningMessageDetails(warning);
    }

    @Override
    public MessageType getType() {
        return this.m_type;
    }

    @Override
    public String getCode() {
        return this.m_code;
    }

    @Override
    public IMessageDetails getDetails() {
        return this.m_details;
    }
}

