/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.type;

import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;

@PublicAPI
public final class MITimespan
implements Comparable<MITimespan>,
Serializable {
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final double SECONDS_PER_HOUR = 3600.0;
    private static final double SECONDS_PER_DAY = 86400.0;
    private final int m_days;
    private final int m_hours;
    private final int m_minutes;
    private final double m_seconds;
    private final long m_milliseconds;

    public MITimespan(int days, int hours, int minutes, double seconds) {
        this(MITimespan.getTimespanInMilliSeconds(days, hours, minutes, seconds));
    }

    public MITimespan(long milliseconds) {
        this.m_milliseconds = Math.abs(milliseconds);
        double seconds = (double)this.m_milliseconds / 1000.0;
        this.m_days = (int)Math.floor(seconds / 86400.0);
        this.m_hours = (int)Math.floor((seconds -= (double)this.m_days * 86400.0) / 3600.0);
        this.m_minutes = (int)Math.floor((seconds -= (double)this.m_hours * 3600.0) / 60.0);
        this.m_seconds = (double)((long)((seconds -= (double)this.m_minutes * 60.0) * 1000.0 + 0.5)) / 1000.0;
    }

    public long getTimespanInMilliSeconds() {
        return this.m_milliseconds;
    }

    private static long getTimespanInMilliSeconds(int days, int hours, int minutes, double seconds) {
        double sec = (double)days * 86400.0 + (double)hours * 3600.0 + (double)minutes * 60.0;
        return (long)((sec += seconds) * 1000.0);
    }

    public int getDays() {
        return this.m_days;
    }

    public int getHours() {
        return this.m_hours;
    }

    public int getMinutes() {
        return this.m_minutes;
    }

    public double getSeconds() {
        return this.m_seconds;
    }

    @Override
    public int compareTo(MITimespan timespan) {
        return (int)(this.getTimespanInMilliSeconds() - timespan.getTimespanInMilliSeconds());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MITimespan that = (MITimespan)o;
        return this.m_milliseconds == that.m_milliseconds;
    }

    public int hashCode() {
        return (int)(this.m_milliseconds ^ this.m_milliseconds >>> 32);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDays()).append(" Days, ");
        sb.append(this.getHours()).append(" Hours, ");
        sb.append(this.getMinutes()).append(" Minutes, ");
        sb.append(this.getSeconds()).append(" Seconds");
        return sb.toString();
    }

    @PrivateAPI
    public String toISO8601FormattedString() {
        int wholeSeconds = (int)Math.floor(this.m_seconds);
        int milliSeconds = (int)Math.round((this.m_seconds - (double)wholeSeconds) * 1000.0);
        Period period = new Period().withDays(this.m_days).withHours(this.m_hours).withMinutes(this.m_minutes).withSeconds(wholeSeconds).withMillis(milliSeconds);
        return ISOPeriodFormat.standard().print((ReadablePeriod)period);
    }

    @PrivateAPI
    public static MITimespan fromISO8601FormattedString(String isoPeriod) {
        Period Period2 = ISOPeriodFormat.standard().parsePeriod(isoPeriod);
        return new MITimespan(Period2.getDays(), Period2.getHours(), Period2.getMinutes(), (double)Period2.getSeconds() + (double)Period2.getMillis() / 1000.0);
    }
}

