/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.util;

import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public class DoubleRect
implements Serializable {
    private double m_minX;
    private double m_minY;
    private double m_maxX;
    private double m_maxY;

    @PrivateAPI
    public DoubleRect() {
    }

    public DoubleRect(double x1, double y1, double x2, double y2) {
        this.set(x1, y1, x2, y2);
    }

    public DoubleRect(DirectPosition p1, DirectPosition p2) {
        this.set(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public DoubleRect(DoubleRect r) {
        this.set(r);
    }

    public double getMinX() {
        return this.m_minX;
    }

    @PrivateAPI
    public void setMinX(double minX) {
        this.m_minX = minX;
    }

    public double getMinY() {
        return this.m_minY;
    }

    @PrivateAPI
    public void setMinY(double minY) {
        this.m_minY = minY;
    }

    public double getMaxX() {
        return this.m_maxX;
    }

    @PrivateAPI
    public void setMaxX(double maxX) {
        this.m_maxX = maxX;
    }

    public double getMaxY() {
        return this.m_maxY;
    }

    @PrivateAPI
    public void setMaxY(double maxY) {
        this.m_maxY = maxY;
    }

    @PrivateAPI
    public void set(double x1, double y1, double x2, double y2) {
        this.m_minX = Math.min(x1, x2);
        this.m_maxX = Math.max(x1, x2);
        this.m_minY = Math.min(y1, y2);
        this.m_maxY = Math.max(y1, y2);
    }

    @PrivateAPI
    public void set(DirectPosition p1, DirectPosition p2) {
        this.set(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    @PrivateAPI
    public void set(DirectPosition center, double width, double height) {
        this.set(center.getX() - width / 2.0, center.getY() - height / 2.0, center.getX() + width / 2.0, center.getY() + height / 2.0);
    }

    @PrivateAPI
    public void set(DoubleRect r) {
        this.m_minX = r.m_minX;
        this.m_minY = r.m_minY;
        this.m_maxX = r.m_maxX;
        this.m_maxY = r.m_maxY;
    }

    public void expand(double dx, double dy) {
        this.m_minX -= dx / 2.0;
        this.m_minY -= dy / 2.0;
        this.m_maxX += dx / 2.0;
        this.m_maxY += dy / 2.0;
    }

    public boolean isEmpty() {
        return this.m_minX >= this.m_maxX || this.m_minY >= this.m_maxY;
    }

    public boolean equals(DoubleRect r) {
        return this.m_minX == r.m_minX && this.m_minY == r.m_minY && this.m_maxX == r.m_maxX && this.m_maxY == r.m_maxY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleRect that = (DoubleRect)o;
        if (Double.compare(that.m_maxX, this.m_maxX) != 0) {
            return false;
        }
        if (Double.compare(that.m_minX, this.m_minX) != 0) {
            return false;
        }
        if (Double.compare(that.m_maxY, this.m_maxY) != 0) {
            return false;
        }
        return Double.compare(that.m_minY, this.m_minY) == 0;
    }

    public int hashCode() {
        long temp = this.m_minX != 0.0 ? Double.doubleToLongBits(this.m_minX) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.m_minY != 0.0 ? Double.doubleToLongBits(this.m_minY) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.m_maxX != 0.0 ? Double.doubleToLongBits(this.m_maxX) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.m_maxY != 0.0 ? Double.doubleToLongBits(this.m_maxY) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double width() {
        return this.m_maxX - this.m_minX;
    }

    public double height() {
        return this.m_maxY - this.m_minY;
    }

    public double area() {
        return this.width() * this.height();
    }

    public DirectPosition center() {
        return new DirectPosition((this.m_minX + this.m_maxX) / 2.0, (this.m_minY + this.m_maxY) / 2.0);
    }

    public boolean intersects(DoubleRect r) {
        return this.m_minX <= r.m_maxX && this.m_maxX >= r.m_minX && this.m_minY <= r.m_maxY && this.m_maxY >= r.m_minY;
    }

    public boolean intersects(DirectPosition p) {
        return this.intersects(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y) {
        return this.m_minX <= x && this.m_maxX >= x && this.m_minY <= y && this.m_maxY >= y;
    }

    public boolean contains(DoubleRect r) {
        return this.contains(r, true);
    }

    public boolean contains(DoubleRect r, boolean includeEdges) {
        if (includeEdges) {
            return this.m_minX <= r.m_minX && this.m_maxX >= r.m_maxX && this.m_minY <= r.m_minY && this.m_maxY >= r.m_maxY;
        }
        return this.m_minX < r.m_minX && this.m_maxX > r.m_maxX && this.m_minY < r.m_minY && this.m_maxY > r.m_maxY;
    }

    public boolean contains(DirectPosition p) {
        return this.contains(p.getX(), p.getY(), true);
    }

    public boolean contains(DirectPosition p, boolean includeEdges) {
        return this.contains(p.getX(), p.getY(), includeEdges);
    }

    public boolean contains(double x, double y) {
        return this.contains(x, y, true);
    }

    public boolean contains(double x, double y, boolean includeEdges) {
        if (includeEdges) {
            return this.m_minX <= x && this.m_maxX >= x && this.m_minY <= y && this.m_maxY >= y;
        }
        return this.m_minX < x && this.m_maxX > x && this.m_minY < y && this.m_maxY > y;
    }

    public boolean within(DoubleRect r) {
        return r.contains(this, true);
    }

    public boolean within(DoubleRect r, boolean includeEdges) {
        return r.contains(this, includeEdges);
    }

    public void merge(DirectPosition p) {
        this.merge(p.getX(), p.getY());
    }

    public void merge(double x, double y) {
        this.m_minX = Math.min(this.m_minX, x);
        this.m_minY = Math.min(this.m_minY, y);
        this.m_maxX = Math.max(this.m_maxX, x);
        this.m_maxY = Math.max(this.m_maxY, y);
    }

    public void merge(DoubleRect r) {
        this.m_minX = Math.min(this.m_minX, r.m_minX);
        this.m_minY = Math.min(this.m_minY, r.m_minY);
        this.m_maxX = Math.max(this.m_maxX, r.m_maxX);
        this.m_maxY = Math.max(this.m_maxY, r.m_maxY);
    }

    public void initBounds() {
        this.m_minY = Double.MAX_VALUE;
        this.m_minX = Double.MAX_VALUE;
        this.m_maxY = -1.7976931348623157E308;
        this.m_maxX = -1.7976931348623157E308;
    }

    public DoubleRect intersection(DoubleRect r) {
        DoubleRect result = new DoubleRect();
        result.m_minX = Math.max(this.m_minX, r.m_minX);
        result.m_minY = Math.max(this.m_minY, r.m_minY);
        result.m_maxX = Math.min(this.m_maxX, r.m_maxX);
        result.m_maxY = Math.min(this.m_maxY, r.m_maxY);
        return result;
    }

    public DoubleRect union(DoubleRect r) {
        DoubleRect result = new DoubleRect();
        result.m_minX = Math.min(this.m_minX, r.m_minX);
        result.m_minY = Math.min(this.m_minY, r.m_minY);
        result.m_maxX = Math.max(this.m_maxX, r.m_maxX);
        result.m_maxY = Math.max(this.m_maxY, r.m_maxY);
        return result;
    }

    public DoubleRect getCopy(AffineTransform affineTransform) {
        DoubleRect result;
        if (affineTransform == null || affineTransform.isIdentity()) {
            result = new DoubleRect(this);
        } else {
            result = new DoubleRect();
            result.initBounds();
            DirectPosition tmp = new DirectPosition();
            tmp.setXY(this.m_minX, this.m_minY);
            affineTransform.transform(tmp, tmp);
            result.merge(tmp);
            tmp.setXY(this.m_maxX, this.m_maxY);
            affineTransform.transform(tmp, tmp);
            result.merge(tmp);
            if (affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0) {
                tmp.setXY(this.m_minX, this.m_maxY);
                affineTransform.transform(tmp, tmp);
                result.merge(tmp);
                tmp.setXY(this.m_maxX, this.m_minY);
                affineTransform.transform(tmp, tmp);
                result.merge(tmp);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(");
        result.append(this.m_minX);
        result.append(", ");
        result.append(this.m_minY);
        result.append(", ");
        result.append(this.m_maxX);
        result.append(", ");
        result.append(this.m_maxY);
        result.append(")");
        return result.toString();
    }
}

