/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.xml;

import com.mapinfo.midev.type.MIDate;
import com.mapinfo.midev.type.MIDateTime;
import com.mapinfo.midev.type.MIDateTimeZone;
import com.mapinfo.midev.type.MITime;
import com.mapinfo.midev.type.MITimespan;
import java.util.TimeZone;

public class XmlConvert {
    private static final String NEGATIVE_INFINITY_STRING = "-INF";
    private static final String POSITIVE_INFINITY_STRING = "INF";
    private static final String NOT_A_NUMBER_STRING_STRING = "NaN";
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";
    private static final String ONE_STRING = "1";
    private static final String ZERO_STRING = "0";

    public static String toString(boolean b) {
        return b ? TRUE_STRING : FALSE_STRING;
    }

    public static String toString(byte b) {
        return Byte.toString(b);
    }

    public static String toString(short s) {
        return Short.toString(s);
    }

    public static String toString(int i) {
        return Integer.toString(i);
    }

    public static String toString(char c) {
        return Character.toString(c);
    }

    public static String toString(long l) {
        return Long.toString(l);
    }

    public static String toString(float f) {
        String result;
        if (f == Float.NEGATIVE_INFINITY) {
            result = NEGATIVE_INFINITY_STRING;
        } else if (f == Float.POSITIVE_INFINITY) {
            result = POSITIVE_INFINITY_STRING;
        } else if (Float.isNaN(f)) {
            result = NOT_A_NUMBER_STRING_STRING;
        } else {
            result = Float.toString(f);
            if (result.endsWith(".0")) {
                result = result.substring(0, result.length() - 2);
            }
        }
        return result;
    }

    public static String toString(double d) {
        String result;
        if (d == Double.NEGATIVE_INFINITY) {
            result = NEGATIVE_INFINITY_STRING;
        } else if (d == Double.POSITIVE_INFINITY) {
            result = POSITIVE_INFINITY_STRING;
        } else if (Double.isNaN(d)) {
            result = NOT_A_NUMBER_STRING_STRING;
        } else {
            result = Double.toString(d);
            if (result.endsWith(".0")) {
                result = result.substring(0, result.length() - 2);
            }
        }
        return result;
    }

    public static String toString(MIDate d) {
        StringBuilder sb = new StringBuilder(10);
        XmlConvert.formatFourDigits(d.getYear(), sb);
        sb.append('-');
        XmlConvert.formatTwoDigits(d.getMonth(), sb);
        sb.append('-');
        XmlConvert.formatTwoDigits(d.getDay(), sb);
        return sb.toString();
    }

    public static String toString(MITime d) {
        StringBuilder sb = new StringBuilder(8);
        double seconds = d.getSeconds();
        if (seconds > 60.0) {
            throw new IllegalArgumentException();
        }
        XmlConvert.formatTwoDigits(d.getHour(), sb);
        sb.append(':');
        XmlConvert.formatTwoDigits(d.getMinute(), sb);
        sb.append(':');
        XmlConvert.formatSeconds(d.getSeconds(), sb);
        return sb.toString();
    }

    public static String toString(MIDateTime d) {
        StringBuilder sb = new StringBuilder(19);
        XmlConvert.formatFourDigits(d.getYear(), sb);
        sb.append('-');
        XmlConvert.formatTwoDigits(d.getMonth(), sb);
        sb.append('-');
        XmlConvert.formatTwoDigits(d.getDay(), sb);
        sb.append('T');
        XmlConvert.formatTwoDigits(d.getHour(), sb);
        sb.append(':');
        XmlConvert.formatTwoDigits(d.getMinute(), sb);
        sb.append(':');
        XmlConvert.formatSeconds(d.getSeconds(), sb);
        return sb.toString();
    }

    public static String toString(MIDateTimeZone d) {
        StringBuilder sb = new StringBuilder(25);
        XmlConvert.formatFourDigits(d.getYear(), sb);
        sb.append('-');
        XmlConvert.formatTwoDigits(d.getMonth(), sb);
        sb.append('-');
        XmlConvert.formatTwoDigits(d.getDay(), sb);
        sb.append('T');
        XmlConvert.formatTwoDigits(d.getHour(), sb);
        sb.append(':');
        XmlConvert.formatTwoDigits(d.getMinute(), sb);
        sb.append(':');
        XmlConvert.formatSeconds(d.getSeconds(), sb);
        int tzOffset = d.getTimeZone().getRawOffset();
        if (tzOffset == 0) {
            sb.append('Z');
        } else {
            MITimespan ts = new MITimespan(tzOffset);
            if (tzOffset > 0) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            XmlConvert.formatTwoDigits(ts.getHours(), sb);
            sb.append(':');
            XmlConvert.formatTwoDigits(ts.getMinutes(), sb);
        }
        return sb.toString();
    }

    public static String toString(MITimespan d) {
        StringBuilder sb = new StringBuilder(25);
        sb.append('P');
        int tmp = d.getDays();
        if (tmp != 0) {
            sb.append(XmlConvert.toString(tmp));
            sb.append('D');
        }
        if (d.getHours() != 0 || d.getMinutes() != 0 || d.getSeconds() != 0.0) {
            double seconds;
            sb.append('T');
            tmp = d.getHours();
            if (tmp != 0) {
                sb.append(XmlConvert.toString(tmp));
                sb.append('H');
            }
            if ((tmp = d.getMinutes()) != 0) {
                sb.append(XmlConvert.toString(tmp));
                sb.append('M');
            }
            if ((seconds = d.getSeconds()) > 60.0) {
                throw new IllegalArgumentException();
            }
            if (seconds != 0.0) {
                sb.append(XmlConvert.toString((int)seconds));
                sb.append('S');
            }
        }
        return sb.toString();
    }

    private static void formatTwoDigits(int value, StringBuilder sb) {
        if (value < 10) {
            sb.append('0');
        }
        sb.append(value);
    }

    private static void formatFourDigits(int value, StringBuilder sb) {
        if (value < 1000) {
            sb.append('0');
        }
        if (value < 100) {
            sb.append('0');
        }
        if (value < 10) {
            sb.append('0');
        }
        sb.append(value);
    }

    private static void formatSeconds(double seconds, StringBuilder sb) {
        String s = String.valueOf(seconds = (double)Math.round(seconds * 1000.0) / 1000.0);
        int index = s.indexOf(46);
        if (index != -1) {
            if (index == 0) {
                s = "00" + s;
            } else if (index == 1) {
                s = ZERO_STRING + s;
            }
            if (s.endsWith(".0")) {
                s = s.substring(0, s.length() - 2);
            }
        }
        sb.append(s);
    }

    public static boolean parseBoolean(String s) {
        boolean result;
        if (TRUE_STRING.equals(s = s.toLowerCase()) || ONE_STRING.equals(s)) {
            result = true;
        } else if (FALSE_STRING.equals(s) || ZERO_STRING.equals(s)) {
            result = false;
        } else {
            throw new IllegalArgumentException(s);
        }
        return result;
    }

    public static byte parseByte(String s) {
        return Byte.parseByte(s);
    }

    public static char parseChar(String s) {
        if (s.length() != 1) {
            throw new IllegalArgumentException(s);
        }
        return s.charAt(0);
    }

    public static short parseShort(String s) {
        return Short.parseShort(s);
    }

    public static int parseInt(String s) {
        return Integer.parseInt(s);
    }

    public static long parseLong(String s) {
        return Long.parseLong(s);
    }

    public static float parseFloat(String s) {
        float result = NEGATIVE_INFINITY_STRING.equals(s) ? Float.NEGATIVE_INFINITY : (POSITIVE_INFINITY_STRING.equals(s) ? Float.POSITIVE_INFINITY : (NOT_A_NUMBER_STRING_STRING.equals(s) ? Float.NaN : Float.parseFloat(s)));
        return result;
    }

    public static double parseDouble(String s) {
        double result = NEGATIVE_INFINITY_STRING.equals(s) ? Double.NEGATIVE_INFINITY : (POSITIVE_INFINITY_STRING.equals(s) ? Double.POSITIVE_INFINITY : (NOT_A_NUMBER_STRING_STRING.equals(s) ? Double.NaN : Double.parseDouble(s)));
        return result;
    }

    public static MIDate parseDate(String s) {
        if (s.charAt(4) != '-') {
            throw new IllegalArgumentException(s);
        }
        if (s.charAt(7) != '-') {
            throw new IllegalArgumentException(s);
        }
        return new MIDate(Integer.parseInt(s.substring(0, 4)), Integer.parseInt(s.substring(5, 7)), Integer.parseInt(s.substring(8)));
    }

    public static MITime parseTime(String s) {
        if (s.charAt(2) != ':') {
            throw new IllegalArgumentException(s);
        }
        if (s.charAt(5) != ':') {
            throw new IllegalArgumentException(s);
        }
        return new MITime(Integer.parseInt(s.substring(0, 2)), Integer.parseInt(s.substring(3, 5)), Double.parseDouble(s.substring(6)));
    }

    public static MIDateTime parseDateTime(String s) {
        if (s.charAt(10) != 'T' && s.charAt(10) != ' ') {
            throw new IllegalArgumentException("Date Time Format should be either YYYY-MM-DDThh:mm:ss or YYYY-MM-DD hh:mm:ss. " + s);
        }
        MIDate date = XmlConvert.parseDate(s.substring(0, 10));
        MITime time = XmlConvert.parseTime(s.substring(11));
        return new MIDateTime(date, time);
    }

    public static MIDateTimeZone parseDateTimeZone(String s) {
        TimeZone tz;
        if (s.charAt(10) != 'T') {
            throw new IllegalArgumentException(s);
        }
        int tzStart = 19;
        if (s.length() != 19 && s.charAt(19) == '.') {
            ++tzStart;
            while (tzStart < s.length() && Character.isDigit(s.charAt(tzStart))) {
                ++tzStart;
            }
        }
        MIDateTime dt = XmlConvert.parseDateTime(s.substring(0, tzStart));
        if (s.length() == tzStart || s.charAt(tzStart) == 'Z') {
            tz = TimeZone.getTimeZone("UTC");
        } else {
            String tzOffset = s.substring(tzStart);
            char sign = tzOffset.charAt(0);
            String hours = tzOffset.substring(1, 3);
            String minutes = tzOffset.substring(4);
            tz = TimeZone.getTimeZone("UTC");
            int offset = (int)new MITimespan(0, Integer.parseInt(hours), Integer.parseInt(minutes), 0.0).getTimespanInMilliSeconds();
            if (sign == '-') {
                offset = -offset;
            }
            tz.setRawOffset(offset);
        }
        return new MIDateTimeZone(dt, tz);
    }

    public static MITimespan parseTimespan(String s) {
        int nextIndex;
        int prevIndex;
        String part2;
        String part1;
        if (s.charAt(0) != 'P') {
            throw new IllegalArgumentException(s);
        }
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int tIndex = s.indexOf(84);
        if (tIndex == -1) {
            part1 = s.substring(1);
            part2 = null;
        } else {
            part1 = s.substring(1, tIndex);
            part2 = s.substring(tIndex + 1);
        }
        if (part1.length() != 0) {
            prevIndex = 0;
            nextIndex = part1.indexOf(89);
            if (nextIndex != -1) {
                int years = Integer.parseInt(part1.substring(prevIndex, nextIndex));
                prevIndex = nextIndex + 1;
            }
            if ((nextIndex = part1.indexOf(77)) != -1) {
                int months = Integer.parseInt(part1.substring(prevIndex, nextIndex));
                prevIndex = nextIndex + 1;
            }
            if ((nextIndex = part1.indexOf(68)) != -1) {
                days = Integer.parseInt(part1.substring(prevIndex, nextIndex));
            }
        }
        if (part2 != null) {
            prevIndex = 0;
            nextIndex = part2.indexOf(72);
            if (nextIndex != -1) {
                hours = Integer.parseInt(part2.substring(prevIndex, nextIndex));
                prevIndex = nextIndex + 1;
            }
            if ((nextIndex = part2.indexOf(77)) != -1) {
                minutes = Integer.parseInt(part2.substring(prevIndex, nextIndex));
                prevIndex = nextIndex + 1;
            }
            if ((nextIndex = part2.indexOf(83)) != -1) {
                seconds = Integer.parseInt(part2.substring(prevIndex, nextIndex));
            }
        }
        return new MITimespan(days, hours, minutes, seconds);
    }
}

