/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.xml.read;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ClasspathEntityResolver
implements EntityResolver {
    private static final Map<String, byte[]> CACHE = Collections.synchronizedMap(new HashMap(20));

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        File file = new File(systemId);
        InputSource source = ClasspathEntityResolver.resolveName(file.getName());
        if (source == null) {
            throw new FileNotFoundException(systemId);
        }
        return source;
    }

    private static InputSource resolveName(String name) throws IOException {
        byte[] cache = CACHE.get(name);
        if (cache == null) {
            InputStream is = ClasspathEntityResolver.class.getResourceAsStream("/" + name);
            if (is == null) {
                return null;
            }
            cache = IOUtils.toByteArray((InputStream)is);
            CACHE.put(name, cache);
        }
        return new InputSource(new ByteArrayInputStream(cache));
    }
}

