/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.xml.read;

import com.mapinfo.midev.xml.XmlSpace;
import com.mapinfo.midev.xml.read.Attribute;
import com.mapinfo.midev.xml.read.IXmlReader;
import com.mapinfo.midev.xml.read.XmlReaderException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class XmlReaderImpl
implements IXmlReader {
    private final XMLStreamReader m_reader;
    private final XmlStack m_stack = new XmlStack();
    private boolean m_isDone = false;

    public XmlReaderImpl(InputStream in, boolean validate) throws XmlReaderException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            factory.setProperty("javax.xml.stream.isValidating", validate);
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            this.m_reader = factory.createXMLStreamReader(in);
            int eventType = this.m_reader.getEventType();
            while (eventType != 1) {
                eventType = this.m_reader.next();
            }
        }
        catch (Exception e) {
            throw new XmlReaderException("Error parsing XML from stream.", e);
        }
    }

    @Override
    public void close() throws XmlReaderException {
        try {
            this.m_reader.close();
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException("Error closing stream.", e);
        }
    }

    @Override
    public String getEncoding() {
        return this.m_reader.getCharacterEncodingScheme();
    }

    @Override
    public String getLocalName() {
        return this.m_reader.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        String result = this.m_reader.getNamespaceURI();
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getPrefix() {
        String result = this.m_reader.getName().getPrefix();
        return "".equals(result) ? null : result;
    }

    @Override
    public int getDepth() {
        return this.m_stack.getDepth();
    }

    @Override
    public XmlSpace getXmlSpace() {
        String xmlSpace = this.getXmlSpaceCurrentAttributeValue();
        XmlSpace result = xmlSpace == null ? this.m_stack.getXmlSpace() : XmlSpace.parse(xmlSpace);
        return result;
    }

    @Override
    public String getXmlLang() {
        String result = this.getXmlLangCurrentAttributeValue();
        if (result == null) {
            result = this.m_stack.getXmlLang();
        }
        return result;
    }

    @Override
    public int getAttributeCount() {
        return this.m_reader.getAttributeCount();
    }

    @Override
    public String getAttribute(String localName) {
        return this.getAttribute(localName, null);
    }

    @Override
    public String getAttribute(String localName, String namespaceURI) {
        for (int n = 0; n < this.m_reader.getAttributeCount(); ++n) {
            String ns;
            if (!this.m_reader.getAttributeLocalName(n).equals(localName) || !(StringUtils.isEmpty((CharSequence)(ns = this.m_reader.getAttributeNamespace(n))) ? namespaceURI == null : ns.equals(namespaceURI))) continue;
            return this.m_reader.getAttributeValue(n);
        }
        return null;
    }

    @Override
    public Iterator<Attribute> getAttributeIterator() {
        int attrCount = this.m_reader.getAttributeCount();
        ArrayList<Attribute> result = new ArrayList<Attribute>(attrCount);
        for (int n = 0; n < attrCount; ++n) {
            result.add(new Attribute(this.m_reader.getAttributeLocalName(n), this.m_reader.getAttributeNamespace(n), this.m_reader.getAttributePrefix(n), this.m_reader.getAttributeValue(n)));
        }
        return result.iterator();
    }

    @Override
    public boolean isEOF() {
        return this.m_isDone;
    }

    @Override
    public void skip() throws XmlReaderException {
        int depth = this.m_stack.getDepth();
        do {
            this.next();
        } while (depth < this.m_stack.getDepth() || this.m_reader.getEventType() == 4);
    }

    @Override
    public void readStartElement() throws XmlReaderException {
        this.readStartElement(null, null);
    }

    @Override
    public void readStartElement(String localName) throws XmlReaderException {
        this.readStartElement(localName, null);
    }

    @Override
    public void readStartElement(String localName, String ns) throws XmlReaderException {
        if (!this.m_reader.isStartElement()) {
            throw new XmlReaderException("Reader is not at the start of an element. " + this.m_stack.getStackTrace());
        }
        if (!this.checkLocalName(localName)) {
            throw new XmlReaderException("Invalid local name \"" + localName + "\" at " + this.m_stack.getStackTrace());
        }
        if (!this.checkNamespaceURI(ns)) {
            throw new XmlReaderException("Invalid namespace URI \"" + ns + "\" at " + this.m_stack.getStackTrace());
        }
        this.next();
    }

    @Override
    public String readElementString() throws XmlReaderException {
        return this.readElementString(null, null);
    }

    @Override
    public String readElementString(String localName) throws XmlReaderException {
        return this.readElementString(localName, null);
    }

    @Override
    public String readElementString(String localName, String ns) throws XmlReaderException {
        String result;
        if (!this.m_reader.isStartElement()) {
            throw new XmlReaderException("Reader is not at the start of an element. " + this.m_stack.getStackTrace());
        }
        if (!this.checkLocalName(localName)) {
            throw new XmlReaderException("Invalid local name \"" + localName + "\" at " + this.m_stack.getStackTrace());
        }
        if (!this.checkNamespaceURI(ns)) {
            throw new XmlReaderException("Invalid namespace URI \"" + ns + "\" at " + this.m_stack.getStackTrace());
        }
        try {
            result = this.m_reader.getElementText();
            this.m_reader.next();
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException("Error parsing XML from stream: " + this.m_stack.getStackTrace(), e);
        }
        this.moveToContent();
        return result;
    }

    @Override
    public String getText() {
        if (!this.m_reader.isCharacters()) {
            throw new XmlReaderException("Reader is not at the text of an element. " + this.m_stack.getStackTrace());
        }
        String text = this.m_reader.getText();
        try {
            this.m_reader.next();
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException("Error parsing XML from stream: " + this.m_stack.getStackTrace(), e);
        }
        return text;
    }

    @Override
    public void readEndElement() throws XmlReaderException {
        if (this.m_reader.getEventType() != 2) {
            throw new XmlReaderException("Reader is not at the end of an element. " + this.m_stack.getStackTrace());
        }
        this.next();
    }

    @Override
    public boolean isStartElement() {
        return this.m_reader.isStartElement();
    }

    @Override
    public boolean isStartElement(String localName) {
        return this.m_reader.isStartElement() && this.checkLocalName(localName);
    }

    @Override
    public boolean isStartElement(String localName, String ns) {
        if (!this.isStartElement(localName)) {
            return false;
        }
        return this.checkNamespaceURI(ns);
    }

    private boolean checkLocalName(String localName) {
        return localName == null || localName.equals(this.m_reader.getLocalName());
    }

    private boolean checkNamespaceURI(String namespaceURI) {
        return namespaceURI == null || namespaceURI.equals(this.m_reader.getNamespaceURI());
    }

    @Override
    public String readInnerXml() throws XmlReaderException {
        int oldLength;
        StringBuilder result = new StringBuilder();
        int depth = this.m_stack.getDepth();
        this.next();
        do {
            oldLength = result.length();
            XmlReaderImpl.appendText(this.m_reader, result);
            this.next();
        } while (depth != this.m_stack.getDepth());
        result.setLength(oldLength);
        return result.toString();
    }

    @Override
    public String readOuterXml() throws XmlReaderException {
        StringBuilder result = new StringBuilder();
        int depth = this.m_stack.getDepth();
        int eventType = this.m_reader.getEventType();
        do {
            XmlReaderImpl.appendText(this.m_reader, result);
            if (eventType == 8) continue;
            eventType = this.next();
        } while (depth < this.m_stack.getDepth() && eventType != 8);
        return result.toString();
    }

    private static void appendText(XMLStreamReader reader, StringBuilder sb) {
        int eventType = reader.getEventType();
        if (eventType == 1) {
            int attributeCount;
            String ns = reader.getNamespaceURI();
            sb.append('<');
            sb.append(reader.getLocalName());
            if (ns != null) {
                sb.append(" xmlns=\"");
                sb.append(ns);
                sb.append('\"');
            }
            if ((attributeCount = reader.getAttributeCount()) != 0) {
                HashMap<String, String> nsMaps = new HashMap<String, String>();
                for (int n = 0; n < attributeCount; ++n) {
                    String string = reader.getAttributePrefix(n);
                    sb.append(' ');
                    if (string != null && string.length() != 0) {
                        nsMaps.put(string, reader.getAttributeNamespace(n));
                        sb.append(string);
                        sb.append(':');
                    }
                    sb.append(reader.getAttributeLocalName(n));
                    sb.append('=');
                    sb.append('\"');
                    sb.append(StringEscapeUtils.escapeXml10((String)reader.getAttributeValue(n)));
                    sb.append('\"');
                }
                for (Map.Entry entry : nsMaps.entrySet()) {
                    sb.append(" xmlns:");
                    sb.append((String)entry.getKey());
                    sb.append('=');
                    sb.append('\"');
                    sb.append((String)entry.getValue());
                    sb.append('\"');
                }
            }
            sb.append('>');
        } else if (eventType == 2) {
            sb.append('<');
            sb.append('/');
            sb.append(reader.getLocalName());
            sb.append('>');
        } else if (eventType == 4 || eventType == 9) {
            sb.append(StringEscapeUtils.escapeXml10((String)reader.getText()));
        }
    }

    @Override
    public String lookupNamespace(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return null;
        }
        return this.m_reader.getNamespaceURI(prefix);
    }

    private String getXmlSpaceCurrentAttributeValue() {
        String result = this.m_reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "space");
        if (result == null) {
            result = this.m_reader.getAttributeValue("http://www.w3.org/2001/XMLSchema", "space");
        }
        return result;
    }

    private String getXmlLangCurrentAttributeValue() {
        String result = this.m_reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (result == null) {
            result = this.m_reader.getAttributeValue("http://www.w3.org/2001/XMLSchema", "lang");
        }
        return result;
    }

    private int moveToContent() throws XmlReaderException {
        int result = this.m_reader.getEventType();
        try {
            while (result == 5 || result == 4 && this.m_reader.getText().trim().length() == 0) {
                result = this.m_reader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException("Error parsing XML from stream: " + this.m_stack.getStackTrace(), e);
        }
        return result;
    }

    private int next() throws XmlReaderException {
        int result = this.m_reader.getEventType();
        if (result == 2) {
            if (this.m_stack.getDepth() == 1) {
                this.m_isDone = true;
            }
            this.m_stack.pop();
        } else if (result == 1) {
            String space = this.getXmlSpaceCurrentAttributeValue();
            String lang = this.getXmlLangCurrentAttributeValue();
            this.m_stack.push(new XmlStack.TagInfo(this.m_reader.getName(), space == null || space.length() == 0 ? XmlSpace.None : XmlSpace.parse(space), lang));
        }
        try {
            this.m_reader.next();
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException("Error parsing XML from stream: " + this.m_stack.getStackTrace(), e);
        }
        result = this.moveToContent();
        return result;
    }

    private static class XmlStack {
        private TagInfo[] m_stack = new TagInfo[10];
        private int m_top = 0;

        private XmlStack() {
        }

        private TagInfo pop() {
            return this.m_stack[this.m_top--];
        }

        private void push(TagInfo ti) {
            this.ensureCapacity();
            this.m_stack[++this.m_top] = ti;
        }

        private void ensureCapacity() {
            if (this.m_top == this.m_stack.length - 1) {
                TagInfo[] na = new TagInfo[this.m_stack.length + 10];
                if (this.m_top != 0) {
                    System.arraycopy(this.m_stack, 0, na, 0, this.m_top + 1);
                }
                this.m_stack = na;
            }
        }

        private XmlSpace getXmlSpace() {
            for (int i = this.m_top; i > 0; --i) {
                XmlSpace xs = this.m_stack[i].m_xmlSpace;
                if (xs.equals((Object)XmlSpace.None)) continue;
                return xs;
            }
            return XmlSpace.None;
        }

        private String getXmlLang() {
            for (int i = this.m_top; i > 0; --i) {
                String xlang = this.m_stack[i].m_xmlLang;
                if (xlang == null) continue;
                return xlang;
            }
            return null;
        }

        private int getDepth() {
            return this.m_top;
        }

        private String getStackTrace() {
            StringBuilder sb = new StringBuilder();
            for (int n = 1; n <= this.m_top; ++n) {
                sb.append('<');
                sb.append(this.m_stack[n].m_name.getLocalPart());
                sb.append('>');
                sb.append(':');
            }
            if (sb.length() != 0) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }

        private static class TagInfo {
            private final QName m_name;
            private final XmlSpace m_xmlSpace;
            private final String m_xmlLang;

            private TagInfo(QName name, XmlSpace xmlSpace, String xmlLang) {
                this.m_name = name;
                this.m_xmlSpace = xmlSpace;
                this.m_xmlLang = xmlLang;
            }
        }
    }
}

