/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.xml.read;

import com.mapinfo.midev.xml.XmlConvert;
import com.mapinfo.midev.xml.read.IXmlReader;
import com.mapinfo.midev.xml.read.XmlReaderException;
import com.mapinfo.midev.xml.read.XmlReaderImpl;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

public final class XmlReaderUtilities {
    private XmlReaderUtilities() {
    }

    public static boolean readBooleanElement(IXmlReader r, String elementName, boolean defaultValue) throws XmlReaderException {
        boolean result = defaultValue;
        if (r.isStartElement(elementName)) {
            result = XmlConvert.parseBoolean(r.readElementString(elementName));
        }
        return result;
    }

    public static String readAttribute(IXmlReader r, String attributeName, String defaultValue) throws XmlReaderException {
        String result = defaultValue;
        String val = r.getAttribute(attributeName);
        if (val != null) {
            result = val;
        }
        return result;
    }

    public static boolean readBooleanAttribute(IXmlReader r, String attributeName, boolean defaultValue) throws XmlReaderException {
        boolean result = defaultValue;
        String val = r.getAttribute(attributeName);
        if (val != null) {
            result = XmlConvert.parseBoolean(val);
        }
        return result;
    }

    public static double readDoubleAttribute(IXmlReader r, String attributeName, double defaultValue) throws XmlReaderException {
        double result = defaultValue;
        String val = r.getAttribute(attributeName);
        if (val != null) {
            result = XmlConvert.parseDouble(val);
        }
        return result;
    }

    public static IXmlReader getReader(String xmlFragment) throws XmlReaderException {
        return new XmlReaderImpl(new ByteArrayInputStream(xmlFragment.getBytes(StandardCharsets.UTF_8)), false);
    }
}

