/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.xml.write;

import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.xml.XmlSpace;
import com.mapinfo.midev.xml.write.IXmlWriter;
import com.mapinfo.midev.xml.write.PrefixGenerator;
import com.mapinfo.midev.xml.write.XmlWriterException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class XmlWriterImpl
implements IXmlWriter {
    private final Writer m_writer;
    private final ElementStack m_stack = new ElementStack();
    private final PrefixGenerator m_prefixGenerator = new PrefixGenerator();
    private boolean m_startElementTagClosed = true;

    public XmlWriterImpl(OutputStream out) throws XmlWriterException {
        this.m_writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), StandardCharsets.UTF_8);
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public void close() throws XmlWriterException {
        try {
            this.m_writer.flush();
            this.m_writer.close();
        }
        catch (IOException e) {
            throw new XmlWriterException("Error closing stream.", e);
        }
    }

    @Override
    public void flush() throws XmlWriterException {
        try {
            this.m_writer.flush();
        }
        catch (IOException e) {
            throw new XmlWriterException("Error flushing stream.", e);
        }
    }

    @Override
    public void writeStartDocument() throws XmlWriterException {
        try {
            this.m_writer.write("<?xml version=\"1.0\" encoding=\"");
            this.m_writer.write("UTF-8");
            this.m_writer.write("\"?>");
        }
        catch (IOException e) {
            throw new XmlWriterException("Error writing to stream.", e);
        }
    }

    @Override
    public void writeEndDocument() throws XmlWriterException {
        while (this.m_stack.getDepth() > 0) {
            this.writeEndElement();
        }
    }

    @Override
    public void writeDocType(String name, String pubid, String sysid, String subset) throws XmlWriterException {
        try {
            this.m_writer.write("<!DOCTYPE ");
            this.m_writer.write(name);
            if (pubid != null) {
                this.m_writer.write(" PUBLIC \"");
                this.m_writer.write(pubid);
                this.m_writer.write("\" \"");
                this.m_writer.write(sysid);
                this.m_writer.write(34);
            } else if (sysid != null) {
                this.m_writer.write(" SYSTEM \"");
                this.m_writer.write(sysid);
                this.m_writer.write(34);
            }
            if (subset != null) {
                this.m_writer.write(" [");
                this.m_writer.write(subset);
                this.m_writer.write(93);
            }
            this.m_writer.write(">");
        }
        catch (IOException e) {
            throw new XmlWriterException("Error writing to stream.", e);
        }
    }

    @Override
    public void writeStartElement(String localName, String ns) throws XmlWriterException {
        this.writeStartElement(null, localName, ns);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String ns) throws XmlWriterException {
        this.ensureStartElementTagClosed();
        ArgumentValidator.assertNotEmptyString("localName", localName);
        ElementInfo ti = new ElementInfo(localName, new NamepsaceContext(this.m_stack.peek().m_namespaceContext));
        if (ns != null && ns.length() != 0) {
            ti.m_namespaceURI = ns;
        }
        if (prefix == null || prefix.length() == 0) {
            if (!(ns == null || ns.length() == 0 || ns.equals(this.m_stack.peek().m_namespaceContext.m_defaultNamespace) || (prefix = (String)ti.m_namespaceContext.m_URIToPrefixMap.get(ns)) != null && prefix.length() != 0)) {
                prefix = this.m_prefixGenerator.getNextPrefix();
                ti.m_namespaceContext.set(prefix, ns);
            }
        } else if ("xmlns".equals(prefix)) {
            ti.m_namespaceContext.m_defaultNamespace = ns;
        } else if (ns != null && ns.length() != 0) {
            ti.m_namespaceContext.set(prefix, ns);
        } else {
            throw new IllegalArgumentException("Prefix is not allowed if namespace URI is not specified.");
        }
        this.m_stack.push(ti);
        this.m_startElementTagClosed = false;
    }

    @Override
    public void writeEndElement() throws XmlWriterException {
        this.ensureStartElementTagClosed();
        ElementInfo ti = this.m_stack.pop();
        try {
            this.m_writer.write("</");
            String prefix = (String)ti.m_namespaceContext.m_URIToPrefixMap.get(ti.m_namespaceURI);
            if (prefix != null) {
                this.m_writer.write(prefix);
                this.m_writer.write(58);
            }
            this.m_writer.write(ti.m_localName);
            this.m_writer.write(">");
        }
        catch (IOException e) {
            throw new XmlWriterException("Error writing to stream.", e);
        }
    }

    @Override
    public void writeElementString(String localName, String ns, String value) throws XmlWriterException {
        this.writeElementString(null, localName, ns, value);
    }

    @Override
    public void writeElementString(String prefix, String localName, String ns, String value) throws XmlWriterException {
        this.writeStartElement(prefix, localName, ns);
        this.writeString(value);
        this.writeEndElement();
    }

    @Override
    public void writeAttributeString(String localName, String value) throws XmlWriterException {
        this.writeAttributeString(null, localName, null, value);
    }

    @Override
    public void writeAttributeString(String localName, String ns, String value) throws XmlWriterException {
        this.writeAttributeString(null, localName, ns, value);
    }

    @Override
    public void writeAttributeString(String prefix, String localName, String ns, String value) throws XmlWriterException {
        ArgumentValidator.assertNotEmptyString("localName", localName);
        if ("xmlns".equals(localName)) {
            this.m_stack.peek().m_namespaceContext.m_defaultNamespace = value;
        } else if ("xmlns".equals(prefix) || "http://www.w3.org/2000/xmlns/".equals(ns)) {
            NamepsaceContext context = this.m_stack.peek().m_namespaceContext;
            String prevPrefix = (String)context.m_URIToPrefixMap.get(value);
            if (prevPrefix != null && prevPrefix.startsWith(this.m_prefixGenerator.getPrefixPrefix())) {
                context.m_prefixToURIMap.remove(prevPrefix);
            }
            this.m_stack.peek().m_namespaceContext.set(localName, value);
        } else if ("xml".equals(prefix) || "http://www.w3.org/XML/1998/namespace".equals(ns) || "http://www.w3.org/2001/XMLSchema".equals(ns)) {
            if ("space".equals(localName)) {
                this.m_stack.peek().m_namespaceContext.m_xmlSpace = XmlSpace.parse(value);
            } else if ("lang".equals(localName)) {
                this.m_stack.peek().m_namespaceContext.m_xmlLang = value;
            }
        } else {
            if (ns != null && ns.length() != 0) {
                if (prefix == null || prefix.length() == 0) {
                    prefix = this.m_prefixGenerator.getNextPrefix();
                }
                this.m_stack.peek().m_namespaceContext.set(prefix, ns);
            } else if (prefix != null && prefix.length() != 0) {
                throw new IllegalArgumentException("Prefix is not allowed if namespace URI is not specified.");
            }
            StringBuilder sb = this.m_stack.peek().m_attributeString;
            sb.append(' ');
            if (prefix != null && prefix.length() != 0) {
                sb.append(prefix);
                sb.append(':');
            }
            sb.append(localName);
            sb.append("=\"");
            sb.append(value == null ? "" : StringEscapeUtils.escapeXml10((String)value));
            sb.append("\"");
        }
    }

    @Override
    public void writeNamespacePrefixDefinition(String prefix, String ns) throws XmlWriterException {
        this.writeAttributeString("xmlns", prefix, "http://www.w3.org/2000/xmlns/", ns);
    }

    @Override
    public void writeString(String text) throws XmlWriterException {
        this.ensureStartElementTagClosed();
        try {
            this.m_writer.write(text == null ? "" : StringEscapeUtils.escapeXml10((String)text));
        }
        catch (IOException e) {
            throw new XmlWriterException("Error writing to stream.", e);
        }
    }

    @Override
    public void writeRaw(String data) throws XmlWriterException {
        this.ensureStartElementTagClosed();
        try {
            this.m_writer.write(data == null ? "" : data);
        }
        catch (IOException e) {
            throw new XmlWriterException("Error writing to stream.", e);
        }
    }

    @Override
    public XmlSpace getXmlSpace() {
        return this.m_stack.peek().m_namespaceContext.m_xmlSpace;
    }

    @Override
    public String getXmlLang() {
        return this.m_stack.peek().m_namespaceContext.m_xmlLang;
    }

    private void ensureStartElementTagClosed() throws XmlWriterException {
        if (!this.m_startElementTagClosed) {
            ElementInfo curElement = this.m_stack.pop();
            ElementInfo prevElement = this.m_stack.peek();
            try {
                this.m_writer.write(60);
                String prefix = (String)curElement.m_namespaceContext.m_URIToPrefixMap.get(curElement.m_namespaceURI);
                if (prefix != null) {
                    this.m_writer.write(prefix);
                    this.m_writer.write(58);
                }
                this.m_writer.write(curElement.m_localName);
                this.m_writer.write(curElement.m_attributeString.toString());
                String curDefaultNamespace = curElement.m_namespaceContext.m_defaultNamespace;
                String prevDefaultNamespace = prevElement.m_namespaceContext.m_defaultNamespace;
                if (prevElement == null || curDefaultNamespace != null && !curDefaultNamespace.equals(prevDefaultNamespace)) {
                    this.m_writer.write(32);
                    this.m_writer.write("xmlns");
                    this.m_writer.write("=\"");
                    this.m_writer.write(StringEscapeUtils.escapeXml10((String)curDefaultNamespace));
                    this.m_writer.write("\"");
                }
                Map curPrefixToURIMap = curElement.m_namespaceContext.m_prefixToURIMap;
                Map prevPrefixToURIMap = prevElement.m_namespaceContext.m_prefixToURIMap;
                if (prevElement == null || !curPrefixToURIMap.equals(prevPrefixToURIMap)) {
                    for (String curPrefix : curPrefixToURIMap.keySet()) {
                        String curNs = (String)curPrefixToURIMap.get(curPrefix);
                        if ((curNs.equals(curDefaultNamespace) || prevElement != null) && prevPrefixToURIMap.containsKey(curPrefix) && ((String)prevPrefixToURIMap.get(curPrefix)).equals(curNs)) continue;
                        this.m_writer.write(32);
                        this.m_writer.write("xmlns");
                        this.m_writer.write(58);
                        this.m_writer.write(curPrefix);
                        this.m_writer.write("=\"");
                        this.m_writer.write(StringEscapeUtils.escapeXml10((String)curNs));
                        this.m_writer.write("\"");
                    }
                }
                this.m_writer.write(62);
            }
            catch (IOException e) {
                throw new XmlWriterException("Error writing to stream.", e);
            }
            this.m_stack.push(curElement);
            this.m_startElementTagClosed = true;
        }
    }

    private static class NamepsaceContext {
        private final Map<String, String> m_prefixToURIMap;
        private final Map<String, String> m_URIToPrefixMap;
        private XmlSpace m_xmlSpace = XmlSpace.None;
        private String m_xmlLang = null;
        private String m_defaultNamespace = null;

        private NamepsaceContext() {
            this.m_prefixToURIMap = new HashMap<String, String>();
            this.m_URIToPrefixMap = new HashMap<String, String>();
        }

        private NamepsaceContext(NamepsaceContext copy) {
            this.m_xmlSpace = copy.m_xmlSpace;
            this.m_xmlLang = copy.m_xmlLang;
            this.m_prefixToURIMap = new HashMap<String, String>(copy.m_prefixToURIMap);
            this.m_URIToPrefixMap = new HashMap<String, String>(copy.m_URIToPrefixMap);
            this.m_defaultNamespace = copy.m_defaultNamespace;
        }

        private void set(String prefix, String namespaceURI) {
            this.m_prefixToURIMap.put(prefix, namespaceURI);
            this.m_URIToPrefixMap.put(namespaceURI, prefix);
        }
    }

    private static class ElementInfo {
        private final NamepsaceContext m_namespaceContext;
        private final String m_localName;
        private String m_namespaceURI;
        private final StringBuilder m_attributeString = new StringBuilder();

        private ElementInfo(String localName, NamepsaceContext namespaceContext) {
            this.m_localName = localName;
            this.m_namespaceContext = namespaceContext;
        }
    }

    private static class ElementStack {
        private ElementInfo[] m_stack = new ElementInfo[10];
        private int m_top = 0;

        private ElementStack() {
            this.m_stack[0] = new ElementInfo(null, new NamepsaceContext());
        }

        private ElementInfo peek() {
            return this.m_stack[this.m_top];
        }

        private ElementInfo pop() {
            return this.m_stack[this.m_top--];
        }

        private void push(ElementInfo ti) {
            this.ensureCapacity();
            this.m_stack[++this.m_top] = ti;
        }

        private int getDepth() {
            return this.m_top;
        }

        private void ensureCapacity() {
            if (this.m_top == this.m_stack.length - 1) {
                ElementInfo[] na = new ElementInfo[this.m_stack.length + 10];
                if (this.m_top != 0) {
                    System.arraycopy(this.m_stack, 0, na, 0, this.m_top + 1);
                }
                this.m_stack = na;
            }
        }
    }
}

