/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.user.GeocodeConstraints;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.unit.Distance;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;

public class Constraints
implements IConstraints {
    protected IGeocodeConstraints m_constraints;
    private IHandler m_handler;
    private boolean m_bMatcherRemoveMultipleSegments;
    private Distance m_cornerOffsetAsDistance;
    private Distance m_streetOffsetAsDistance;
    private Distance m_centerlineOffsetAsDistance;
    private Length m_cornerOffsetAsLength;
    private Length m_streetOffsetAsLength;
    private Length m_centerlineOffsetAsLength;

    public Constraints() {
        this.m_constraints = new GeocodeConstraints();
        this.m_handler = null;
        this.m_bMatcherRemoveMultipleSegments = false;
        this.m_cornerOffsetAsDistance = null;
        this.m_streetOffsetAsDistance = null;
        this.m_cornerOffsetAsLength = null;
        this.m_streetOffsetAsLength = null;
    }

    public Constraints(IConstraints settings) {
        if (settings != null) {
            this.m_constraints = settings;
            this.m_handler = settings.getHandler();
            this.m_bMatcherRemoveMultipleSegments = settings.isMatcherRemoveMultipleSegments();
            if (settings.getMatchMode() != null) {
                this.setSpecifiedMatchModeSettings(settings.getMatchMode());
            }
        } else {
            this.m_constraints = new GeocodeConstraints();
            this.m_handler = null;
            this.m_bMatcherRemoveMultipleSegments = false;
        }
    }

    public Constraints(IGeocodeConstraints settings) {
        if (settings != null) {
            this.m_constraints = new GeocodeConstraints(settings);
            if (this.m_constraints.getMatchMode() != null) {
                this.setSpecifiedMatchModeSettings(this.m_constraints.getMatchMode());
            }
        } else {
            this.m_constraints = new GeocodeConstraints();
        }
        this.m_handler = null;
        this.m_bMatcherRemoveMultipleSegments = false;
    }

    @Override
    public Locale getClientLocale() {
        return this.m_constraints.getClientLocale();
    }

    @Override
    public void setClientLocale(String localeString) {
        this.m_constraints.setClientLocale(localeString);
    }

    @Override
    public void setClientLocale(Locale locale) {
        this.m_constraints.setClientLocale(locale);
    }

    @Override
    public com.mapinfo.coordsys.CoordSys getClientCoordinateSystem() {
        return this.m_constraints.getClientCoordinateSystem();
    }

    @Override
    public CoordSys getClientCoordinateSystemObject() {
        return this.m_constraints.getClientCoordinateSystemObject();
    }

    @Override
    public void setClientCoordinateSystem(String crsString) {
        this.m_constraints.setClientCoordinateSystem(crsString);
    }

    @Override
    public void setClientCoordinateSystem(com.mapinfo.coordsys.CoordSys coordSys) {
        this.m_constraints.setClientCoordinateSystem(coordSys);
    }

    @Override
    public void setClientCoordinateSystem(CoordSys coordSys) {
        this.m_constraints.setClientCoordinateSystem(coordSys);
    }

    @Override
    public boolean isReturnParsedInputAddress() {
        return this.m_constraints.isReturnParsedInputAddress();
    }

    @Override
    public boolean isMustMatchArea1() {
        return this.m_constraints.isMustMatchArea1();
    }

    @Override
    public boolean isMustMatchArea2() {
        return this.m_constraints.isMustMatchArea2();
    }

    @Override
    public boolean isMustMatchArea3() {
        return this.m_constraints.isMustMatchArea3();
    }

    @Override
    public boolean isMustMatchArea4() {
        return this.m_constraints.isMustMatchArea4();
    }

    @Override
    public void setReturnParsedInputAddress(boolean bMatch) {
        this.m_constraints.setReturnParsedInputAddress(bMatch);
    }

    @Override
    public void setMustMatchArea1(boolean bMatch) {
        this.m_constraints.setMustMatchArea1(bMatch);
    }

    @Override
    public void setMustMatchArea2(boolean bMatch) {
        this.m_constraints.setMustMatchArea2(bMatch);
    }

    @Override
    public void setMustMatchArea3(boolean bMatch) {
        this.m_constraints.setMustMatchArea3(bMatch);
    }

    @Override
    public void setMustMatchArea4(boolean bMatch) {
        this.m_constraints.setMustMatchArea4(bMatch);
    }

    @Override
    public boolean isMustMatchAddressNumber() {
        return this.m_constraints.isMustMatchAddressNumber();
    }

    @Override
    public void setMustMatchAddressNumber(boolean bMatch) {
        this.m_constraints.setMustMatchAddressNumber(bMatch);
    }

    @Override
    public boolean isMustMatchMainAddress() {
        return this.m_constraints.isMustMatchMainAddress();
    }

    @Override
    public void setMustMatchMainAddress(boolean bMatch) {
        this.m_constraints.setMustMatchMainAddress(bMatch);
    }

    @Override
    public boolean isMustMatchPostalCode() {
        return this.m_constraints.isMustMatchPostalCode();
    }

    @Override
    public void setMustMatchPostalCode(boolean bMatch) {
        this.m_constraints.setMustMatchPostalCode(bMatch);
    }

    @Override
    public boolean isMustMatchInput() {
        return this.m_constraints.isMustMatchInput();
    }

    @Override
    public void setMustMatchInput(boolean bMatch) {
        this.m_constraints.setMustMatchInput(bMatch);
    }

    @Override
    public boolean isMustMatchCountry() {
        return this.m_constraints.isMustMatchCountry();
    }

    @Override
    public void setMustMatchCountry(boolean bMatch) {
        this.m_constraints.setMustMatchCountry(bMatch);
    }

    @Override
    public void setMatchMode(String MMString) {
        this.m_constraints.setMatchMode(MMString);
        this.setSpecifiedMatchModeSettings(MMString);
    }

    @Override
    public String getMatchMode() {
        return this.m_constraints.getMatchMode();
    }

    protected void setSpecifiedMatchModeSettings(String str) {
        if ("RelaxedMode".equals(str)) {
            this.setRelaxedMatchSettings(this.m_constraints);
        } else if ("ExactMode".equals(str)) {
            this.setExactMatchSettings(this.m_constraints);
        } else if ("DefaultMode".equals(str)) {
            this.setDefaultSettings(this.m_constraints);
        }
    }

    protected void setDefaultSettings(IGeocodeConstraints constraints) {
        constraints.setMustMatchArea1(false);
        constraints.setMustMatchArea2(false);
        constraints.setMustMatchArea3(false);
        constraints.setMustMatchArea4(false);
        constraints.setMustMatchAddressNumber(false);
        constraints.setMustMatchMainAddress(false);
        constraints.setMustMatchPostalCode(false);
        constraints.setMustMatchInput(false);
        constraints.setMustMatchCountry(true);
    }

    protected void setExactMatchSettings(IGeocodeConstraints constraints) {
        constraints.setMustMatchArea1(true);
        constraints.setMustMatchArea2(true);
        constraints.setMustMatchArea3(true);
        constraints.setMustMatchArea4(true);
        constraints.setMustMatchAddressNumber(true);
        constraints.setMustMatchMainAddress(true);
        constraints.setMustMatchPostalCode(true);
        constraints.setMustMatchInput(true);
        constraints.setMustMatchCountry(true);
    }

    protected void setRelaxedMatchSettings(IGeocodeConstraints constraints) {
        constraints.setMustMatchArea1(false);
        constraints.setMustMatchArea2(false);
        constraints.setMustMatchArea3(false);
        constraints.setMustMatchArea4(false);
        constraints.setMustMatchAddressNumber(false);
        constraints.setMustMatchMainAddress(false);
        constraints.setMustMatchPostalCode(false);
        constraints.setMustMatchInput(false);
        constraints.setMustMatchCountry(true);
    }

    @Override
    public int getMaxRanges() {
        return this.m_constraints.getMaxRanges();
    }

    @Override
    public void setMaxRanges(int maxRanges) {
        this.m_constraints.setMaxRanges(maxRanges);
    }

    @Override
    public int getMaxRangeUnits() {
        return this.m_constraints.getMaxRangeUnits();
    }

    @Override
    public void setMaxRangeUnits(int maxRangeUnits) {
        this.m_constraints.setMaxRangeUnits(maxRangeUnits);
    }

    @Override
    public int getMaxCandidates() {
        return this.m_constraints.getMaxCandidates();
    }

    @Override
    public void setMaxCandidates(int maxCandidates) {
        this.m_constraints.setMaxCandidates(maxCandidates);
    }

    @Override
    public boolean isReturnCloseCandidatesOnly() {
        return this.m_constraints.isReturnCloseCandidatesOnly();
    }

    @Override
    public void setReturnCloseCandidatesOnly(boolean bReturn) {
        this.m_constraints.setReturnCloseCandidatesOnly(bReturn);
    }

    @Override
    public double getStreetOffset() {
        return this.m_constraints.getStreetOffset();
    }

    @Override
    public void setStreetOffset(double offset) {
        this.m_constraints.setStreetOffset(offset);
    }

    @Override
    public double getCornerOffset() {
        return this.m_constraints.getCornerOffset();
    }

    @Override
    public void setCornerOffset(double offset) {
        this.m_constraints.setCornerOffset(offset);
    }

    @Override
    public String getCornerOffsetUnits() {
        return this.m_constraints.getCornerOffsetUnits();
    }

    @Override
    public void setCornerOffsetUnits(String units) {
        this.m_constraints.setCornerOffsetUnits(units);
    }

    @Override
    public String getStreetOffsetUnits() {
        return this.m_constraints.getStreetOffsetUnits();
    }

    @Override
    public void setStreetOffsetUnits(String units) {
        this.m_constraints.setStreetOffsetUnits(units);
    }

    @Override
    public int getGeocodeType() {
        return this.m_constraints.getGeocodeType();
    }

    @Override
    public void setGeocodeType(int type) {
        this.m_constraints.setGeocodeType(type);
    }

    @Override
    public boolean isFallbackToPostal() {
        return this.m_constraints.isFallbackToPostal();
    }

    @Override
    public void setFallbackToPostal(boolean bFallback) {
        this.m_constraints.setFallbackToPostal(bFallback);
    }

    @Override
    public boolean isFallbackToGeographic() {
        return this.m_constraints.isFallbackToGeographic();
    }

    @Override
    public void setFallbackToGeographic(boolean bFallback) {
        this.m_constraints.setFallbackToGeographic(bFallback);
    }

    @Override
    public DictionaryUsagePreference getDictionaryUsage() {
        return this.m_constraints.getDictionaryUsage();
    }

    @Override
    public void setDictionaryUsage(DictionaryUsagePreference pref) {
        this.m_constraints.setDictionaryUsage(pref);
    }

    @Override
    public void setUseAddressPointInterpolation(boolean flag) {
        this.m_constraints.setUseAddressPointInterpolation(flag);
    }

    @Override
    public boolean getUseAddressPointInterpolation() {
        return this.m_constraints.getUseAddressPointInterpolation();
    }

    @Override
    public String setCustomString(String key, String value) {
        return this.m_constraints.setCustomString(key, value);
    }

    @Override
    public String getCustomString(String key) {
        return this.m_constraints.getCustomString(key);
    }

    @Override
    public String getCustomString(String key, String defaultValue) {
        return this.m_constraints.getCustomString(key, defaultValue);
    }

    @Override
    public HashMap getCustomValues() {
        return this.m_constraints.getCustomValues();
    }

    @Override
    public void loadAsCustomStrings(InputStream file) throws IOException {
        this.m_constraints.loadAsCustomStrings(file);
    }

    @Override
    public Object setCustomObject(Object key, Object value) {
        return this.m_constraints.getCustomValues().put(key, value);
    }

    @Override
    public Object getCustomObject(Object key) {
        return this.m_constraints.getCustomValues().get(key);
    }

    @Override
    public Object removeCustomObject(Object key) {
        return this.m_constraints.getCustomValues().remove(key);
    }

    @Override
    public boolean containsCustomObjectKey(Object key) {
        return this.m_constraints.getCustomValues().containsKey(key);
    }

    @Override
    public IHandler getHandler() {
        return this.m_handler;
    }

    @Override
    public void setHandler(IHandler handler) {
        this.m_handler = handler;
    }

    @Override
    public boolean isMatcherRemoveMultipleSegments() {
        return this.m_bMatcherRemoveMultipleSegments;
    }

    @Override
    public void setMatcherRemoveMultipleSegments(boolean bRemove) {
        this.m_bMatcherRemoveMultipleSegments = bRemove;
    }

    @Override
    public Distance getCornerOffsetAsDistance() {
        com.mapinfo.unit.LinearUnit unit;
        if (this.m_cornerOffsetAsDistance == null && (unit = this.makeLinearUnit(this.getCornerOffsetUnits())) != null) {
            this.m_cornerOffsetAsDistance = new Distance(this.getCornerOffset(), unit);
        }
        return this.m_cornerOffsetAsDistance;
    }

    @Override
    public Length getCornerOffsetAsLength() {
        LinearUnit unit;
        if (this.m_cornerOffsetAsLength == null && (unit = this.parseLinearUnit(this.getCornerOffsetUnits())) != null) {
            this.m_cornerOffsetAsLength = new Length(this.getCornerOffset(), unit);
        }
        return this.m_cornerOffsetAsLength;
    }

    @Override
    public Distance getStreetOffsetAsDistance() {
        com.mapinfo.unit.LinearUnit unit;
        if (this.m_streetOffsetAsDistance == null && (unit = this.makeLinearUnit(this.getStreetOffsetUnits())) != null) {
            this.m_streetOffsetAsDistance = new Distance(this.getStreetOffset(), unit);
        }
        return this.m_streetOffsetAsDistance;
    }

    @Override
    public Length getStreetOffsetAsLength() {
        LinearUnit unit;
        if (this.m_streetOffsetAsLength == null && (unit = this.parseLinearUnit(this.getStreetOffsetUnits())) != null) {
            this.m_streetOffsetAsLength = new Length(this.getStreetOffset(), unit);
        }
        return this.m_streetOffsetAsLength;
    }

    protected com.mapinfo.unit.LinearUnit makeLinearUnit(String code) {
        if (code != null) {
            if (code.equals("in")) {
                return com.mapinfo.unit.LinearUnit.inch;
            }
            if (code.equals("ft")) {
                return com.mapinfo.unit.LinearUnit.foot;
            }
            if (code.equals("yd")) {
                return com.mapinfo.unit.LinearUnit.yard;
            }
            if (code.equals("mi")) {
                return com.mapinfo.unit.LinearUnit.mile;
            }
            if (code.equals("mm")) {
                return com.mapinfo.unit.LinearUnit.millimeter;
            }
            if (code.equals("cm")) {
                return com.mapinfo.unit.LinearUnit.centimeter;
            }
            if (code.equals("m")) {
                return com.mapinfo.unit.LinearUnit.meter;
            }
            if (code.equals("km")) {
                return com.mapinfo.unit.LinearUnit.kilometer;
            }
        }
        return null;
    }

    protected LinearUnit parseLinearUnit(String code) {
        if (code != null) {
            if (code.equals("in")) {
                return LinearUnit.INCH;
            }
            if (code.equals("ft")) {
                return LinearUnit.FOOT;
            }
            if (code.equals("yd")) {
                return LinearUnit.YARD;
            }
            if (code.equals("mi")) {
                return LinearUnit.MILE;
            }
            if (code.equals("mm")) {
                return LinearUnit.MILLIMETER;
            }
            if (code.equals("cm")) {
                return LinearUnit.CENTIMETER;
            }
            if (code.equals("m")) {
                return LinearUnit.METER;
            }
            if (code.equals("km")) {
                return LinearUnit.KILOMETER;
            }
        }
        return null;
    }

    public static IConstraints convertFromConstraints(IGeocodeConstraints inConstraints, IHandler handler) {
        if (inConstraints != null && inConstraints instanceof IConstraints) {
            return (IConstraints)inConstraints;
        }
        Constraints newConstraints = new Constraints(inConstraints);
        if (handler != null) {
            newConstraints.setHandler(handler);
        }
        return newConstraints;
    }

    @Override
    public void setDictionarySearchOrder(IDictionarySearchOrder newOrder) {
        this.m_constraints.setDictionarySearchOrder(newOrder);
    }

    @Override
    public IDictionarySearchOrder getDictionarySearchOrder() {
        return this.m_constraints.getDictionarySearchOrder();
    }

    @Override
    public void setUseCenterlineOffset(boolean flag) {
        this.m_constraints.setUseCenterlineOffset(flag);
    }

    @Override
    public boolean getUseCenterlineOffset() {
        return this.m_constraints.getUseCenterlineOffset();
    }

    @Override
    public void setCenterlineOffset(double value) {
        this.m_constraints.setCenterlineOffset(value);
    }

    @Override
    public double getCenterlineOffset() {
        return this.m_constraints.getCenterlineOffset();
    }

    @Override
    public void setCenterlineOffsetUnit(String unit) {
        this.m_constraints.setCenterlineOffsetUnit(unit);
    }

    @Override
    public String getCenterlineOffsetUnit() {
        return this.m_constraints.getCenterlineOffsetUnit();
    }

    @Override
    public Distance getCenterlineOffsetAsDistance() {
        com.mapinfo.unit.LinearUnit unit;
        if (this.m_centerlineOffsetAsDistance == null && (unit = this.makeLinearUnit(this.getCenterlineOffsetUnit())) != null) {
            this.m_centerlineOffsetAsDistance = new Distance(this.getCenterlineOffset(), unit);
        }
        return this.m_centerlineOffsetAsDistance;
    }

    @Override
    public Length getCenterlineOffsetAsLength() {
        LinearUnit unit;
        if (this.m_centerlineOffsetAsLength == null && (unit = this.parseLinearUnit(this.getCenterlineOffsetUnit())) != null) {
            this.m_centerlineOffsetAsLength = new Length(this.getCenterlineOffset(), unit);
        }
        return this.m_centerlineOffsetAsLength;
    }

    @Override
    public double getNearByStreetOffset() {
        return this.m_constraints.getNearByStreetOffset();
    }

    @Override
    public void setNearByStreetOffset(double nearByStreetOffset) {
        this.m_constraints.setNearByStreetOffset(nearByStreetOffset);
    }
}

