/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker;

import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.VersionInfo;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.multicountry.GeocodeInputFilterFactory;
import com.mapinfo.mapmarker.core.multicountry.IGeocodeInputFilter;
import com.mapinfo.mapmarker.core.multicountry.MultiCountryBasicSettings;
import com.mapinfo.mapmarker.core.multicountry.MultiCountryGeocodableAddressFactory;
import com.mapinfo.mapmarker.core.multicountry.MultiCountryGeocoderHelper;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.MapMarkerResourceLoader;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.VersionDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class GeocodableAddressFactory {
    public static final String localStrings = "com.mapinfo.mapmarker.GeocodableAddressStrings";
    private static final String LSETTING_FILE = "DataManagerSettings.properties";
    public static final String DEFAULT_GEOCODER_KEY = "DEFAULT_GEOCODER_COUNTRY_CODE";
    public static final String DEFAULT_GEOCODER_ANY_COUNTRY_KEY = "USE_DEFAULT_GEOCODER_FOR_ANY_UNAVAILABLE_COUNTRY";
    public static final String REPLACE_NULL_COUNTRY_WITH_DEFAULT = "REPLACE_NULL_COUNTRY_WITH_DEFAULT";
    protected static String EX_NO_SETTINGS;
    protected static String EX_INSTANTIATE_FACTORY;
    private static final Map<Locale, ResourceBundle> m_resourceBundleMap;
    protected static final Map<String, Class> m_geocodableAddressFactoryMap;
    private static final VersionDescriptor m_versionDescriptor;
    private static GeocodableAddressFactory m_cggeGeocodableAddressFactory;
    public static final String COUNTRY_FALLBACK_ENABLED = "COUNTRY_FALLBACK_ENABLED";
    public static final String COUNTRY_FALLBACK_ON_UNRECOGNIZED_INPUT_COUNTRY = "COUNTRY_FALLBACK_ON_UNRECOGNIZED_INPUT_COUNTRY";
    public static final String COUNTRY_FALLBACK_ON_NULL_INPUT_COUNTRY = "COUNTRY_FALLBACK_ON_NULL_INPUT_COUNTRY";
    public static final String COUNTRY_FALLBACK_INCLUDE_UNFILTERED_GEOCODERS = "COUNTRY_FALLBACK_INCLUDE_UNFILTERED_GEOCODERS";
    public static final String COUNTRY_FALLBACK_RETURN_ON_FIRST_CLOSE_STREET_CANDIDATES = "COUNTRY_FALLBACK_RETURN_ON_FIRST_CLOSE_STREET_CANDIDATES";
    public static final String COUNTRY_FALLBACK_EXCLUDED_COUNTRIES = "COUNTRY_FALLBACK_EXCLUDED_COUNTRIES";
    public static final String COUNTRY_FALLBACK_PREFERRED_COUNTRIES = "COUNTRY_FALLBACK_PREFERRED_COUNTRIES";
    public static final String COUNTRY_FALLBACK_PREFERRED_COUNTRIES_ONLY = "COUNTRY_FALLBACK_PREFERRED_COUNTRIES_ONLY";
    public static final String COUNTRY_FALLBACK_PRIMARY_GEOCODER = "COUNTRY_FALLBACK_PRIMARY_GEOCODER";
    public static final String COUNTRY_FALLBACK_WORLD_GEOCODER_SUGGESTIONS_ONLY = "COUNTRY_FALLBACK_WORLD_GEOCODER_SUGGESTIONS_ONLY";
    public static final String COUNTRY_FALLBACK_USE_WORLD_GEOCODER_TO_SUGGEST_COUNTRY = "COUNTRY_FALLBACK_USE_WORLD_GEOCODER_TO_SUGGEST_COUNTRY";
    public static final String COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_KEYWORD = "COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_KEYWORD";
    public static final String COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_PATTERN = "COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_PATTERN";
    public static final String COUNTRY_FALLBACK_OVERRIDE_ENABLED = "COUNTRY_FALLBACK_OVERRIDE_ENABLED";
    public static final String CHECK_SINGLELINE_FOR_COUNTRY_CODE = "CHECK_SINGLELINE_FOR_COUNTRY_CODE";
    public static final String CHECK_POSTADDRESS_FOR_COUNTRY_CODE = "CHECK_POSTADDRESS_FOR_COUNTRY_CODE";
    protected static Map<String, IGeocodeInputFilter> m_countryCodeToFilterClassMap;
    private static Set<String> m_exisitingLocalDataManagerSettingsCountryCodeSet;
    protected static final MultiCountryBasicSettings multiCountryStaticSettings;
    protected static boolean m_bNoCountryGeocodingInitialized;
    protected static List<String> m_availableLocalGeocodersCountryCodeList;
    private static Map<String, String> countryDataMgrFileMap;

    static void updateMapsForCountry(String countryCode, Class factoryClass) {
        IGeocodeInputFilter filterClass;
        if (factoryClass == null) {
            return;
        }
        m_geocodableAddressFactoryMap.put(countryCode, factoryClass);
        if (GeocodableAddressFactory.hasSettingsForCountry(countryCode)) {
            m_exisitingLocalDataManagerSettingsCountryCodeSet.add(countryCode);
        }
        if ((filterClass = GeocodableAddressFactory.createFilterClass(countryCode)) != null) {
            m_countryCodeToFilterClassMap.put(countryCode, filterClass);
        }
    }

    public static VersionDescriptor getVersionDescriptor() {
        return m_versionDescriptor;
    }

    protected String[] getLicenseInformation() {
        return new String[0];
    }

    public static String[] getAllLicenseInformation() {
        ArrayList<String> result = new ArrayList<String>();
        for (Class gafClass : m_geocodableAddressFactoryMap.values()) {
            try {
                GeocodableAddressFactory gaf = (GeocodableAddressFactory)gafClass.newInstance();
                String[] defs = gaf.getLicenseInformation();
                result.addAll(Arrays.asList(defs));
            }
            catch (InstantiationException e) {
                MMJLog.getLog().warn("Error building license information list.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                MMJLog.getLog().warn("Error building license information list.", (Throwable)e);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private static Class getFactoryClass(String countryCode) {
        Class<?> result;
        try {
            StringBuilder sb = new StringBuilder(56);
            sb.append("com.mapinfo.mapmarker.");
            sb.append(countryCode);
            sb.append('.');
            sb.append(countryCode);
            sb.append("GeocodableAddressFactory");
            result = Class.forName(sb.toString());
        }
        catch (Throwable t) {
            result = null;
        }
        if (result == null && m_cggeGeocodableAddressFactory != null && m_cggeGeocodableAddressFactory.isCountrySupported(countryCode)) {
            result = m_cggeGeocodableAddressFactory.getClass();
        }
        return result;
    }

    private static boolean hasSettingsForCountry(String countryCode) {
        StringBuilder sb = new StringBuilder(38);
        sb.append(countryCode);
        sb.append("_DataManagerSettings.properties");
        try {
            String fileName = Thread.currentThread().getContextClassLoader().getResource(sb.toString()).getFile();
            countryDataMgrFileMap.put(countryCode, fileName);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static IGeocodeInputFilter createFilterClass(String countryCode) {
        boolean bCggeVersionFilterRequired = m_cggeGeocodableAddressFactory != null && m_cggeGeocodableAddressFactory.isCountrySupported(countryCode);
        return GeocodeInputFilterFactory.createFilterClass(countryCode, bCggeVersionFilterRequired);
    }

    public static IGeocoder createGeocodableAddress(Address origAddress, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        int len;
        String countryName;
        Class geocodableAddressFactoryClass;
        AddressImpl address = new AddressImpl(origAddress);
        GeocodableAddressFactory geocodableAddressFactory = null;
        Locale loc = constraints.getClientLocale();
        ResourceBundle errorBundle = m_resourceBundleMap.get(loc);
        if (errorBundle == null) {
            try {
                errorBundle = MapMarkerResourceLoader.loadForLocale(loc, localStrings);
                if (errorBundle != null) {
                    m_resourceBundleMap.put(loc, errorBundle);
                }
            }
            catch (MissingResourceException e) {
                throw new GeocodableAddressCreationException(2300, (Throwable)e);
            }
        }
        if ((geocodableAddressFactoryClass = m_geocodableAddressFactoryMap.get(countryName = address.getCountry())) == null && countryName != null && (len = countryName.length()) > 1) {
            ISO3166 correctedCountry = null;
            correctedCountry = len == 2 ? ISO3166.findCountryByISO2(countryName) : ISO3166.findCountryByNumber(countryName);
            if (correctedCountry == null) {
                correctedCountry = ISO3166.findCountryByName(countryName);
            }
            if (correctedCountry != null && (geocodableAddressFactoryClass = m_geocodableAddressFactoryMap.get(countryName = correctedCountry.getISO3Country())) != null) {
                address.setCountry(countryName);
            }
        }
        if (geocodableAddressFactoryClass != null) {
            geocodableAddressFactory = GeocodableAddressFactory.constructGeocodableAddressFactory(geocodableAddressFactoryClass, countryName);
        }
        if (geocodableAddressFactoryClass == null) {
            geocodableAddressFactory = GeocodableAddressFactory.resolveUnknownCountry(address);
        }
        if (geocodableAddressFactory != null) {
            GeocodableAddressFactory.resolveAlternateCountryForWorldFallback(address, countryName);
        }
        IGeocoder geoAddress = geocodableAddressFactory.createSpecificGeocodableAddress(address, constraints);
        geoAddress.setErrorBundle(errorBundle);
        return geoAddress;
    }

    protected static GeocodableAddressFactory constructGeocodableAddressFactory(Class geocodableAddressFactoryClass, String countryName) throws GeocodableAddressCreationException {
        GeocodableAddressFactory geocodableAddressFactory = null;
        if (geocodableAddressFactoryClass != null) {
            try {
                geocodableAddressFactory = (GeocodableAddressFactory)geocodableAddressFactoryClass.newInstance();
            }
            catch (InstantiationException instantiationEx) {
                throw new GeocodableAddressCreationException(2301, new String[]{countryName}, instantiationEx);
            }
            catch (IllegalAccessException accessEx) {
                throw new GeocodableAddressCreationException(2301, new String[]{countryName}, accessEx);
            }
        }
        return geocodableAddressFactory;
    }

    protected static GeocodableAddressFactory resolveUnknownCountry(Address address) throws GeocodableAddressCreationException {
        boolean bUseDefaultGeocoder;
        String countryName;
        if (!m_bNoCountryGeocodingInitialized) {
            multiCountryStaticSettings.loadDefaultSettingsFromProvider();
            m_availableLocalGeocodersCountryCodeList = GeocodableAddressFactory.buildInitialPossibleGeocoderCountryCodeList();
            m_bNoCountryGeocodingInitialized = true;
        }
        boolean bInputCountryNull = (countryName = address.getCountry()) == null;
        boolean bTryPossibleGeocoders = bInputCountryNull ? multiCountryStaticSettings.isCountryFallbackOnNullInputCountry() : multiCountryStaticSettings.isCountryFallbackOnUnrecognizedInputCountry();
        boolean bl = bUseDefaultGeocoder = multiCountryStaticSettings.isUseDefaultForAnyUnavailableCountry() && multiCountryStaticSettings.getDefaultGeocoderCountryCode() != null;
        if (multiCountryStaticSettings.isCountryFallbackEnabled() || bUseDefaultGeocoder) {
            Class worldGafClass;
            Class defaultGafClass;
            boolean bValidCountryCode = GeocodableAddressFactory.isValidCountryCode(countryName);
            ArrayList<String> possibles = new ArrayList<String>(m_availableLocalGeocodersCountryCodeList);
            if (multiCountryStaticSettings.isCountryFallbackEnabled() && bTryPossibleGeocoders && !bValidCountryCode) {
                try {
                    MultiCountryGeocodableAddressFactory.filterCountries(address, possibles, m_countryCodeToFilterClassMap);
                }
                catch (Exception thrownException) {
                    throw new GeocodableAddressCreationException(2312, (Throwable)thrownException);
                }
            }
            GeocodableAddressFactory defaultGaf = null;
            if (bUseDefaultGeocoder && (defaultGafClass = m_geocodableAddressFactoryMap.get(multiCountryStaticSettings.getDefaultGeocoderCountryCode())) != null) {
                boolean defaultOverridePossible = multiCountryStaticSettings.isCountryFallbackEnabled() && multiCountryStaticSettings.isUseWorldGeocoderToDetermineCountry();
                try {
                    defaultGaf = (GeocodableAddressFactory)defaultGafClass.newInstance();
                    if (bInputCountryNull && multiCountryStaticSettings.isReplaceNullInputCountryWithDefault() && !defaultOverridePossible) {
                        address.setCountry(multiCountryStaticSettings.getDefaultGeocoderCountryCode());
                    }
                    if (countryName != null && !defaultOverridePossible) {
                        m_geocodableAddressFactoryMap.put(countryName, defaultGafClass);
                    }
                    if (!multiCountryStaticSettings.isCountryFallbackEnabled()) {
                        return defaultGaf;
                    }
                }
                catch (IllegalAccessException e) {
                    throw new GeocodableAddressCreationException(2301, new String[]{multiCountryStaticSettings.getDefaultGeocoderCountryCode()}, e);
                }
                catch (InstantiationException e) {
                    throw new GeocodableAddressCreationException(2301, new String[]{multiCountryStaticSettings.getDefaultGeocoderCountryCode()}, e);
                }
            }
            GeocodableAddressFactory worldGaf = null;
            if (multiCountryStaticSettings.isUseWorldGeocoderToDetermineCountry() && (worldGafClass = m_geocodableAddressFactoryMap.get("XWG")) != null) {
                try {
                    worldGaf = (GeocodableAddressFactory)worldGafClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new GeocodableAddressCreationException(2301, new String[]{"XWG"}, e);
                }
                catch (InstantiationException e) {
                    throw new GeocodableAddressCreationException(2301, new String[]{"XWG"}, e);
                }
            }
            MultiCountryGeocoderHelper helper = new MultiCountryGeocoderHelper(multiCountryStaticSettings);
            helper.setCountryList(possibles);
            helper.setInputCountryValid(bValidCountryCode);
            helper.setDefaultGeocoderFactory(defaultGaf);
            helper.setWorldGeocoderFactory(worldGaf);
            return new MultiCountryGeocodableAddressFactory(helper);
        }
        throw new GeocodableAddressCreationException(2301, new String[]{countryName});
    }

    protected static List<String> buildInitialPossibleGeocoderCountryCodeList() {
        ArrayList<String> possibles = new ArrayList<String>();
        if (multiCountryStaticSettings.isCountryFallbackIncludeUnfilteredCountries()) {
            possibles.addAll(m_exisitingLocalDataManagerSettingsCountryCodeSet);
        } else {
            possibles.addAll(m_countryCodeToFilterClassMap.keySet());
        }
        if (multiCountryStaticSettings.getDefaultGeocoderCountryCode() != null) {
            possibles.remove(multiCountryStaticSettings.getDefaultGeocoderCountryCode());
        }
        if (multiCountryStaticSettings.getExcludedCountriesSet() != null) {
            possibles.removeAll(multiCountryStaticSettings.getExcludedCountriesSet());
        }
        ArrayList<String> orderedList = new ArrayList<String>(possibles.size());
        if (multiCountryStaticSettings.getPreferredCountriesList() != null) {
            for (String country : multiCountryStaticSettings.getPreferredCountriesList()) {
                if (!possibles.contains(country)) continue;
                possibles.remove(country);
                orderedList.add(country);
            }
        }
        if (possibles.size() > 0) {
            orderedList.addAll(possibles);
        }
        return Collections.unmodifiableList(orderedList);
    }

    protected static boolean isValidCountryCode(String countryName) {
        if (StringUtilities.isEmpty(countryName)) {
            return false;
        }
        ISO3166 correctedCountry = null;
        int len = countryName.length();
        if (len == 2) {
            correctedCountry = ISO3166.findCountryByISO2(countryName);
        } else if (len == 3) {
            correctedCountry = ISO3166.findCountryByISO3(countryName);
        }
        if (correctedCountry != null) {
            return true;
        }
        correctedCountry = ISO3166.findCountryByNumber(countryName);
        if (correctedCountry != null) {
            return true;
        }
        correctedCountry = ISO3166.findCountryByName(countryName);
        if (correctedCountry != null) {
            return true;
        }
        return StringUtilities.equalStrings(countryName, multiCountryStaticSettings.getDefaultGeocoderCountryCode());
    }

    public abstract IGeocoder createSpecificGeocodableAddress(Address var1, IGeocodeConstraints var2) throws GeocodableAddressCreationException;

    public static void resetDataManager(String countryName, IGeocodeConstraints constraints) throws GeocodableAddressCreationException, MMInternalFatalException {
        boolean bUseDefault;
        Properties props;
        Class geocodableAddressFactoryClass;
        GeocodableAddressFactory geocodableAddressFactory = null;
        Locale loc = constraints.getClientLocale();
        ResourceBundle errorBundle = m_resourceBundleMap.get(loc);
        if (errorBundle == null) {
            try {
                errorBundle = MapMarkerResourceLoader.loadForLocale(loc, localStrings);
                if (errorBundle != null) {
                    m_resourceBundleMap.put(loc, errorBundle);
                }
            }
            catch (MissingResourceException e) {
                throw new GeocodableAddressCreationException(2300, (Throwable)e);
            }
        }
        if ((geocodableAddressFactoryClass = m_geocodableAddressFactoryMap.get(countryName)) == null) {
            geocodableAddressFactoryClass = GeocodableAddressFactory.getFactoryClass(countryName);
            GeocodableAddressFactory.updateMapsForCountry(countryName, geocodableAddressFactoryClass);
        }
        if (geocodableAddressFactoryClass != null) {
            try {
                geocodableAddressFactory = (GeocodableAddressFactory)geocodableAddressFactoryClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new GeocodableAddressCreationException(2301, new String[]{countryName}, e);
            }
            catch (InstantiationException e) {
                throw new GeocodableAddressCreationException(2301, new String[]{countryName}, e);
            }
        }
        try {
            props = FileUtilities.loadProperties(LSETTING_FILE);
        }
        catch (IOException e) {
            throw new GeocodableAddressCreationException(2301, new String[]{countryName}, e);
        }
        String defaultCountry = props.getProperty(DEFAULT_GEOCODER_KEY);
        boolean bl = bUseDefault = countryName == null && "true".equalsIgnoreCase(props.getProperty(DEFAULT_GEOCODER_ANY_COUNTRY_KEY));
        if (bUseDefault && defaultCountry != null) {
            geocodableAddressFactoryClass = GeocodableAddressFactory.getFactoryClass(defaultCountry);
            if (geocodableAddressFactoryClass == null) {
                throw new GeocodableAddressCreationException(2301, new String[]{defaultCountry});
            }
            if (geocodableAddressFactoryClass != null) {
                try {
                    geocodableAddressFactory = (GeocodableAddressFactory)geocodableAddressFactoryClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new GeocodableAddressCreationException(2301, new String[]{defaultCountry}, e);
                }
                catch (InstantiationException e) {
                    throw new GeocodableAddressCreationException(2301, new String[]{defaultCountry}, e);
                }
            }
        }
        if (geocodableAddressFactoryClass == null) {
            throw new GeocodableAddressCreationException(2301, new String[]{countryName});
        }
        geocodableAddressFactory.resetSpecificDataManager();
    }

    protected static void resolveAlternateCountryForWorldFallback(Address address, String countryName) {
        String alternateCountry;
        HashMap map;
        if (address != null && "XWG".equals(countryName) && (map = address.getAdditionalFields()) != null && !StringUtilities.isEmpty(alternateCountry = (String)map.get("ALTERNATE_COUNTRY"))) {
            address.setCountry(alternateCountry);
        }
    }

    protected abstract void resetSpecificDataManager() throws MMInternalFatalException;

    public boolean isCountrySupported(String country) {
        return false;
    }

    public boolean isCountryFallbackFilterSupported(String country) {
        return false;
    }

    static {
        String countryCode;
        int n;
        EX_NO_SETTINGS = "ex_GeocodableAddressFactory_no_settings_file";
        EX_INSTANTIATE_FACTORY = "ex_GeocodableAddressFactory_instantiate_factory";
        m_resourceBundleMap = new HashMap<Locale, ResourceBundle>();
        m_geocodableAddressFactoryMap = new HashMap<String, Class>();
        m_countryCodeToFilterClassMap = new HashMap<String, IGeocodeInputFilter>();
        m_exisitingLocalDataManagerSettingsCountryCodeSet = new HashSet<String>();
        m_bNoCountryGeocodingInitialized = false;
        m_availableLocalGeocodersCountryCodeList = new ArrayList<String>();
        countryDataMgrFileMap = new HashMap<String, String>();
        ISO3166[] countries = ISO3166.getISOCountries();
        try {
            Class<?> cggeFactoryClass = Class.forName("com.mapinfo.mapmarker.cgge.CGGEGeocodableAddressFactory");
            m_cggeGeocodableAddressFactory = (GeocodableAddressFactory)cggeFactoryClass.newInstance();
        }
        catch (Throwable t) {
            m_cggeGeocodableAddressFactory = null;
        }
        for (n = 0; n < countries.length; ++n) {
            countryCode = countries[n].getISO3Country();
            GeocodableAddressFactory.updateMapsForCountry(countryCode, GeocodableAddressFactory.getFactoryClass(countryCode));
        }
        for (n = 65; n <= 90; ++n) {
            for (int m = 65; m <= 90; ++m) {
                countryCode = "X" + (char)n + (char)m;
                GeocodableAddressFactory.updateMapsForCountry(countryCode, GeocodableAddressFactory.getFactoryClass(countryCode));
            }
        }
        m_versionDescriptor = new EngineVersionDescriptor((Map)m_geocodableAddressFactoryMap);
        multiCountryStaticSettings = new MultiCountryBasicSettings();
    }

    private static class EngineVersionDescriptor
    extends VersionDescriptor {
        private EngineVersionDescriptor(Map geocodableAddressFactoryMap) {
            super(EngineVersionDescriptor.getVersionsForCountries(geocodableAddressFactoryMap), VersionInfo.getFullVersion());
        }

        private static Map getVersionsForCountries(Map geocodableAddressFactoryMap) {
            HashMap<ISO3166, String> result = new HashMap<ISO3166, String>(geocodableAddressFactoryMap.size());
            Iterator i = geocodableAddressFactoryMap.keySet().iterator();
            while (i.hasNext()) {
                String version;
                ISO3166 country = ISO3166.findCountryByISO3((String)i.next());
                if (country == null || (version = VersionInfo.getFullVersion()) == null) continue;
                result.put(country, version);
            }
            return result;
        }
    }
}

