/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker;

import com.mapinfo.mapmarker.common.ParsedInputAddress;

public class GeocodeResult {
    public static final int NO_ERROR = 0;
    public static final int ERROR_PARSER_FORMATTING = 1;
    public static final int ERROR_UNSUPPORTED_FEATURE = 2;
    public static final int ERROR_UNABLE_TO_PARSE_ADDRESS = 3;
    public static final int ERROR_INCOMPLETE_INPUT = 4;
    public static final int ERROR_DATA_CORRUPTED = 5;
    public static final int ERROR_DATA_FILE_NOT_FOUND = 6;
    public static final int ERROR_GEOINFO_FILE_NOT_FOUND = 7;
    public static final int ERROR_POSTINFO_FILE_NOT_FOUND = 8;
    public static final int ERROR_CANNOT_CREATE_STREET_BASE = 9;
    public static final int ERROR_CANNOT_CREATE_GEO_BASE = 10;
    public static final int ERROR_CANNOT_CREATE_POSTAL_BASE = 11;
    public static final int ERROR_NO_DATA_FOR_LOCATION = 12;
    public static final int ERROR_FALLBACK_UNSUCCESSFUL = 13;
    public static final int ERROR_CANDIDATE_ACCESS_EXCEPTION = 14;
    public static final int ERROR_CANDIDATE_INSTANTIATION_EXCEPTION = 15;
    public static final int FATAL_ERROR_ENCOUNTERED = 100;
    public static final int ERROR_ENCOUNTERED = 200;
    public static final int ERROR_UNLICENSED_FEATURE = 300;
    public static final int LOCAL_CODE_BASE = 500;
    private int numCloseCandidates = 0;
    private int numCandidates = 0;
    private boolean m_bUniqueMatchFound;
    private boolean intersectionMatchingAttempted;
    private boolean dataFound;
    private boolean dataLicensed;
    private String errorMessage;
    private boolean isError;
    private int resultCode;
    private ParsedInputAddress parsedInput;

    public GeocodeResult() {
        this.setUniqueMatchFound(false);
        this.intersectionMatchingAttempted = false;
        this.dataFound = true;
        this.dataLicensed = true;
        this.errorMessage = null;
        this.isError = false;
        this.resultCode = 0;
        this.parsedInput = null;
    }

    public GeocodeResult(GeocodeResult copyFromResult) {
        this();
        this.copy(copyFromResult);
    }

    public int getNumberCloseCandidates() {
        return this.numCloseCandidates;
    }

    public void setNumberCloseCandidates(int numCloseCandidates) {
        this.numCloseCandidates = numCloseCandidates;
        if (numCloseCandidates == 1) {
            this.setUniqueMatchFound(true);
        } else {
            this.setUniqueMatchFound(false);
        }
    }

    public int getNumberCandidates() {
        return this.numCandidates;
    }

    public void setNumberCandidates(int numCandidates) {
        this.numCandidates = numCandidates;
    }

    public boolean getIntersectionStatus() {
        return this.intersectionMatchingAttempted;
    }

    public void setIntersectionStatus(boolean attemptedIntersection) {
        this.intersectionMatchingAttempted = attemptedIntersection;
    }

    public boolean getDataAvailable() {
        return this.dataFound;
    }

    public void setDataAvailable(boolean dataAvailable) {
        this.dataFound = dataAvailable;
    }

    public void setDataLicensed(boolean dataLicensed) {
        this.dataLicensed = dataLicensed;
    }

    public boolean getDataLicensed() {
        return this.dataLicensed;
    }

    public void setParsedInput(ParsedInputAddress parsed) {
        this.parsedInput = parsed;
    }

    public ParsedInputAddress getParsedInput() {
        return this.parsedInput;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setError() {
        this.isError = true;
        this.resultCode = 100;
    }

    public void setError(int resultCode) {
        if (resultCode != 0) {
            this.isError = true;
        }
        this.resultCode = resultCode;
    }

    public void copy(GeocodeResult copyFromResult) {
        if (copyFromResult != null) {
            this.setDataAvailable(copyFromResult.getDataAvailable());
            this.setDataLicensed(copyFromResult.getDataLicensed());
            this.setIntersectionStatus(copyFromResult.getIntersectionStatus());
            this.setNumberCandidates(copyFromResult.getNumberCandidates());
            this.setNumberCloseCandidates(copyFromResult.getNumberCloseCandidates());
            this.setUniqueMatchFound(copyFromResult.isUniqueMatchFound());
            this.setParsedInput(copyFromResult.getParsedInput());
            this.setErrorMessage(copyFromResult.getErrorMessage());
            this.setResultCode(copyFromResult.getResultCode());
            if (copyFromResult.isError()) {
                this.setError(copyFromResult.getResultCode());
            }
        }
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer(512);
        buf.append("The number of candidates is: ");
        buf.append(this.getNumberCandidates());
        buf.append(lineSeparator);
        buf.append("The number of close candidates is: ");
        buf.append(this.getNumberCloseCandidates());
        buf.append(lineSeparator);
        buf.append("Unique match status is: ");
        buf.append(this.isUniqueMatchFound());
        buf.append(lineSeparator);
        if (this.getIntersectionStatus()) {
            buf.append("The input was considered an intersection: ");
            buf.append(this.getIntersectionStatus());
            buf.append(lineSeparator);
        }
        buf.append("Data was found for this address: ");
        buf.append(this.getDataAvailable());
        buf.append(lineSeparator);
        buf.append("Data was licensed for this address: ");
        buf.append(this.getDataLicensed());
        buf.append(lineSeparator);
        buf.append("Result code: ");
        buf.append(this.getResultCode());
        buf.append(lineSeparator);
        if (this.isError()) {
            buf.append("IsError: ");
            buf.append(this.isError());
            buf.append(lineSeparator);
        }
        if (this.getErrorMessage() != null) {
            buf.append("Error Message for this address: ");
            buf.append(this.getErrorMessage());
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeocodeResult)) {
            return false;
        }
        GeocodeResult geocodeResult = (GeocodeResult)o;
        if (this.dataFound != geocodeResult.dataFound) {
            return false;
        }
        if (this.dataLicensed != geocodeResult.dataLicensed) {
            return false;
        }
        if (this.intersectionMatchingAttempted != geocodeResult.intersectionMatchingAttempted) {
            return false;
        }
        if (this.isError != geocodeResult.isError) {
            return false;
        }
        if (this.m_bUniqueMatchFound != geocodeResult.m_bUniqueMatchFound) {
            return false;
        }
        if (this.numCandidates != geocodeResult.numCandidates) {
            return false;
        }
        if (this.numCloseCandidates != geocodeResult.numCloseCandidates) {
            return false;
        }
        if (this.resultCode != geocodeResult.resultCode) {
            return false;
        }
        if (this.errorMessage != null ? !this.errorMessage.equals(geocodeResult.errorMessage) : geocodeResult.errorMessage != null) {
            return false;
        }
        if (this.getParsedInput() != null && geocodeResult.getParsedInput() == null) {
            return false;
        }
        if (this.getParsedInput() == null && geocodeResult.getParsedInput() != null) {
            return false;
        }
        return this.getParsedInput() == null || this.getParsedInput().equals(geocodeResult.getParsedInput());
    }

    public int hashCode() {
        int result = this.numCloseCandidates;
        result = 29 * result + this.numCandidates;
        result = 29 * result + (this.m_bUniqueMatchFound ? 1 : 0);
        result = 29 * result + (this.intersectionMatchingAttempted ? 1 : 0);
        result = 29 * result + (this.dataFound ? 1 : 0);
        result = 29 * result + (this.dataLicensed ? 1 : 0);
        result = 29 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        result = 29 * result + (this.isError ? 1 : 0);
        result = 29 * result + this.resultCode;
        return result;
    }

    public boolean isUniqueMatchFound() {
        return this.m_bUniqueMatchFound;
    }

    public void setUniqueMatchFound(boolean m_bUniqueMatchFound) {
        this.m_bUniqueMatchFound = m_bUniqueMatchFound;
    }
}

