/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.IReverseGeocodeCandidate;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.ParsedRangeScore;
import com.mapinfo.mapmarker.common.PointHouseRecord;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.core.interpolator.Interpolator;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeUtils;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MapMarkerResourceLoader;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.geometry.SegmentGeometryUtils;
import com.mapinfo.mapmarker.utils.geometry.SplitSegment;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class InternalCandidateAddress
implements Address,
ICandidate,
Comparable,
IReverseGeocodeCandidate {
    private ParsedNumber m_addressNumber;
    private StreetCandidateAddress m_address;
    private Segment m_Segment;
    private boolean m_closeMatchFlag;
    private int m_matchingFlags;
    private ParsedNumber m_inputNumber;
    private boolean m_bInputNumberNull;
    private ParsedNumber m_inputUnitId;
    private int m_matchedRangeNumber;
    private int m_cntAddressNumberFieldsMatched;
    private int m_segmentSide;
    private int m_closestRange;
    private int m_segmentClosestSide;
    private double m_combinedAddressScore;
    private double m_combinedAdditionalFieldScore;
    private double m_areaName1Score;
    private double m_areaName2Score;
    private double m_areaName3Score;
    private double m_areaName4Score;
    private double m_postCode1Score;
    private double m_postCode2Score;
    private double m_placeNameScore;
    private double m_additionalParserFieldsScore;
    private boolean m_houseNumberFromPlace;
    private boolean m_placeNameMatchToUnit;
    private double m_addressNumberScore;
    public String commonStrings = "com.mapinfo.mapmarker.common.CommonStrings";
    private double m_unitTypeScore;
    private boolean m_dictionaryBonus;
    private int m_userDictionaryPriority;
    private boolean m_bPointHouseSet;
    private boolean m_bIsPointHouse;
    private ParsedNumber m_pointHouseParsedNumber;
    private ParsedNumber m_secondHNRangedInput;
    private double m_distance = Double.MAX_VALUE;
    private static final double MISSING_PREFIX_SUFFIX_SCORE = 0.95;
    private AddressNumberDistance m_reverseGeocodeResultDistance;
    private String m_vendorCode;
    protected short inputMatchScore;
    public static String KEY_VENDOR_CODE = "StreetDataType";

    public InternalCandidateAddress() {
        this.setStreetCandidateAddress(new StreetCandidateAddress());
        this.init();
        this.m_Segment = new Segment();
    }

    public InternalCandidateAddress(Address addr) {
        if (addr instanceof InternalCandidateAddress) {
            this.setStreetCandidateAddress(((InternalCandidateAddress)addr).getStreetCandidateAddress());
            this.setAreaName1Score(((InternalCandidateAddress)addr).getAreaName1Score());
            this.setAreaName2Score(((InternalCandidateAddress)addr).getAreaName2Score());
            this.setAreaName3Score(((InternalCandidateAddress)addr).getAreaName3Score());
            this.setAreaName4Score(((InternalCandidateAddress)addr).getAreaName4Score());
            this.setPlaceNameScore(((InternalCandidateAddress)addr).getPlaceNameScore());
            this.setAdditionalParserFieldsScore(((InternalCandidateAddress)addr).getAdditionalParserFieldsScore());
            this.setPostCode1Score(((InternalCandidateAddress)addr).getPostCode1Score());
            this.setPostCode2Score(((InternalCandidateAddress)addr).getPostCode2Score());
            this.setCloseMatchFlag(((InternalCandidateAddress)addr).isCloseMatch());
            this.setMatchingFlags(((InternalCandidateAddress)addr).getMatchingFlags());
            this.setCombinedAddressScore(((InternalCandidateAddress)addr).getCombinedAddressScore());
            this.setCombinedAdditionalFieldScore(((InternalCandidateAddress)addr).getCombinedAdditionalFieldScore());
            this.setMatchedRangeNumber(((InternalCandidateAddress)addr).getMatchedRangeNumber());
            this.setCntAddressNumberFieldsMatched(((InternalCandidateAddress)addr).getCntAddressNumberFieldsMatched());
            this.setSegmentSide(((InternalCandidateAddress)addr).getSegmentSide());
            this.setClosestSegmentSide(((InternalCandidateAddress)addr).getClosestSegmentSide());
            this.setClosestRange(((InternalCandidateAddress)addr).getClosestRangeNumber());
            this.setSegment(this.makeSegment(((InternalCandidateAddress)addr).getSegment()));
        } else if (addr instanceof StreetCandidateAddress) {
            this.setStreetCandidateAddress((StreetCandidateAddress)addr);
            this.m_Segment = this.makeSegment();
            this.init();
        } else {
            this.setStreetCandidateAddress(new StreetCandidateAddress(addr));
            this.m_Segment = this.makeSegment();
            this.init();
        }
    }

    protected Segment makeSegment() {
        return new Segment();
    }

    protected Segment makeSegment(Segment orig) {
        return new Segment(orig);
    }

    protected void init() {
        this.m_matchedRangeNumber = -1;
        this.m_segmentSide = -1;
        this.m_closestRange = -1;
        this.m_segmentClosestSide = -1;
    }

    protected void setStreetCandidateAddress(StreetCandidateAddress address) {
        this.m_address = address;
        this.setMatchingFlags(address.getMatchingFlags());
    }

    protected StreetCandidateAddress getStreetCandidateAddress() {
        return this.m_address;
    }

    @Override
    public void setGenericField1(String genericField1) {
        this.m_address.setGenericField1(genericField1);
    }

    @Override
    public String getGenericField1() {
        return this.m_address.getGenericField1();
    }

    @Override
    public void setGenericField2(String genericField2) {
        this.m_address.setGenericField2(genericField2);
    }

    @Override
    public String getGenericField2() {
        return this.m_address.getGenericField2();
    }

    @Override
    public void setGenericField3(String genericField3) {
        this.m_address.setGenericField3(genericField3);
    }

    @Override
    public String getGenericField3() {
        return this.m_address.getGenericField3();
    }

    @Override
    public void setGenericField4(String genericField4) {
        this.m_address.setGenericField4(genericField4);
    }

    @Override
    public String getGenericField4() {
        return this.m_address.getGenericField4();
    }

    @Override
    public void setPlaceName(String placeName) {
        this.m_address.setPlaceName(placeName);
    }

    @Override
    public void setPreAddress(String preAddress) {
        this.m_address.setPreAddress(preAddress);
    }

    @Override
    public String getPreAddress() {
        return this.m_address.getPreAddress();
    }

    @Override
    public void setPreDirectional(String preDir) {
        this.m_address.setPreDirectional(preDir);
    }

    @Override
    public String getPreDirectional() {
        return this.m_address.getPreDirectional();
    }

    @Override
    public void setPreThoroughfareType(String preType) {
        this.m_address.setPreThoroughfareType(preType);
    }

    @Override
    public String getPreThoroughfareType() {
        return this.m_address.getPreThoroughfareType();
    }

    @Override
    public void setMainAddress(String mainAddress) {
        this.m_address.setMainAddress(mainAddress);
    }

    @Override
    public String getMainAddress() {
        return this.m_address.getMainAddress();
    }

    @Override
    public void setPostThoroughfareType(String postType) {
        this.m_address.setPostThoroughfareType(postType);
    }

    @Override
    public String getPostThoroughfareType() {
        return this.m_address.getPostThoroughfareType();
    }

    @Override
    public void setPostDirectional(String postDir) {
        this.m_address.setPostDirectional(postDir);
    }

    @Override
    public String getPostDirectional() {
        return this.m_address.getPostDirectional();
    }

    @Override
    public void setPostAddress(String postAddress) {
        this.m_address.setPostAddress(postAddress);
    }

    @Override
    public String getPostAddress() {
        return this.m_address.getPostAddress();
    }

    @Override
    public void setPostCode1(String postCode1) {
        this.m_address.setPostCode1(postCode1);
    }

    @Override
    public void setPostCode2(String postCode2) {
        this.m_address.setPostCode2(postCode2);
    }

    @Override
    public void setAreaName1(String areaName1) {
        this.m_address.setAreaName1(areaName1);
    }

    @Override
    public void setAreaName2(String areaName2) {
        this.m_address.setAreaName2(areaName2);
    }

    @Override
    public void setAreaName3(String areaName3) {
        this.m_address.setAreaName3(areaName3);
    }

    @Override
    public void setAreaName4(String areaName4) {
        this.m_address.setAreaName4(areaName4);
    }

    @Override
    public void setUnitValue(String unitValue) {
        this.m_address.setUnitValue(unitValue);
    }

    @Override
    public void setUnitType(String unitType) {
        this.m_address.setUnitType(unitType);
    }

    @Override
    public void flush() {
        this.m_address.flush();
    }

    @Override
    public void setAdditionalFields(HashMap additionalFields) {
        this.m_address.setAdditionalFields(additionalFields);
    }

    @Override
    public HashMap getAdditionalFields() {
        return this.m_address.getAdditionalFields();
    }

    public String getAdditionalFieldForKey(String key) {
        return this.m_address.getAdditionalFieldForKey(key);
    }

    @Override
    public void setAddressNumber(String number) {
        this.m_addressNumber = number != null ? new ParsedNumber(number) : null;
    }

    @Override
    public void setAddressNumber(ParsedNumber number) {
        this.m_addressNumber = number;
    }

    @Override
    public void setAddressID(String addressID) {
        this.m_address.setAddressID(addressID);
    }

    @Override
    public String getAddressID() {
        return this.m_address.getAddressID();
    }

    @Override
    public void setCountry(String country) {
        this.m_address.setCountry(country);
    }

    @Override
    public String getCountry() {
        return this.m_address.getCountry();
    }

    public int compareTo(Object o2) {
        double score2;
        InternalCandidateAddress cand2 = (InternalCandidateAddress)o2;
        boolean bCand1Match = this.isCloseMatch();
        boolean bCand2Match = cand2.isCloseMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        if (bCand1Match && bCand2Match && this.hasDictionaryBonus() != cand2.hasDictionaryBonus()) {
            if (this.hasDictionaryBonus()) {
                return 1;
            }
            return -1;
        }
        bCand1Match = this.isPerfectMatch();
        bCand2Match = cand2.isPerfectMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        double score1 = this.getCombinedAddressScore();
        if (score1 == (score2 = cand2.getCombinedAddressScore())) {
            score1 = this.getCombinedAdditionalFieldScore();
            if (score1 < (score2 = cand2.getCombinedAdditionalFieldScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getPostCode1Score();
            if (score1 < (score2 = cand2.getPostCode1Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getPlaceNameScore();
            if (score1 < (score2 = cand2.getPlaceNameScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getPostCode2Score();
            if (score1 < (score2 = cand2.getPostCode2Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getMainAddressScore();
            if (score1 < (score2 = cand2.getMainAddressScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            if (this.getAddressNumberScore() != 1.0 && cand2.getAddressNumberScore() != 1.0) {
                if (this.hasClosestRange() && cand2.hasClosestRange()) {
                    long cand2Offset;
                    Range cand1Closest = this.getSegment().getRangeAt(this.m_closestRange, this.m_segmentClosestSide);
                    Range cand2Closest = cand2.getSegment().getRangeAt(cand2.m_closestRange, cand2.m_segmentClosestSide);
                    long cand1Offset = cand1Closest.getRangeOffset();
                    if (cand1Offset < (cand2Offset = cand2Closest.getRangeOffset())) {
                        return 1;
                    }
                    if (cand1Offset > cand2Offset) {
                        return -1;
                    }
                    if (this.hasDictionaryBonus() != cand2.hasDictionaryBonus()) {
                        if (this.hasDictionaryBonus()) {
                            return 1;
                        }
                        return -1;
                    }
                    return cand2.getUserDictionaryPriority() - this.getUserDictionaryPriority();
                }
                if (this.hasClosestRange() ^ cand2.hasClosestRange()) {
                    if (this.hasClosestRange()) {
                        return 1;
                    }
                    return -1;
                }
                if (this.hasDictionaryBonus() != cand2.hasDictionaryBonus()) {
                    if (this.hasDictionaryBonus()) {
                        return 1;
                    }
                    return -1;
                }
                return cand2.getUserDictionaryPriority() - this.getUserDictionaryPriority();
            }
            if (this.hasMatchingRange() && cand2.hasMatchingRange()) {
                long cand2AddressesCount;
                Range cand1Matched = this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
                Range cand2Matched = cand2.getSegment().getRangeAt(cand2.getMatchedRangeNumber(), cand2.getSegmentSide());
                long cand1AddressesCount = cand1Matched.computeAddressesInRange();
                if (cand1AddressesCount < (cand2AddressesCount = cand2Matched.computeAddressesInRange())) {
                    return 1;
                }
                if (cand1AddressesCount > cand2AddressesCount) {
                    return -1;
                }
                if (this.hasDictionaryBonus() != cand2.hasDictionaryBonus()) {
                    if (this.hasDictionaryBonus()) {
                        return 1;
                    }
                    return -1;
                }
                return cand2.getUserDictionaryPriority() - this.getUserDictionaryPriority();
            }
            if (this.hasMatchingRange()) {
                return 1;
            }
            if (cand2.hasMatchingRange()) {
                return -1;
            }
            if (this.hasDictionaryBonus() != cand2.hasDictionaryBonus()) {
                if (this.hasDictionaryBonus()) {
                    return 1;
                }
                return -1;
            }
            return cand2.getUserDictionaryPriority() - this.getUserDictionaryPriority();
        }
        if (score1 < score2) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        boolean bThisClosest;
        boolean bCandClosest;
        InternalCandidateAddress cand = (InternalCandidateAddress)obj;
        if (cand.getCombinedAddressScore() != this.getCombinedAddressScore()) {
            return false;
        }
        if (cand.getCombinedAdditionalFieldScore() != this.getCombinedAdditionalFieldScore()) {
            return false;
        }
        if (cand.isCloseMatch() != this.isCloseMatch()) {
            return false;
        }
        if (cand.getRangeMatchedFlag() != this.getRangeMatchedFlag()) {
            return false;
        }
        if (cand.getMainAddressScore() != this.getMainAddressScore()) {
            return false;
        }
        if (cand.getAddressNumberScore() != this.getAddressNumberScore()) {
            return false;
        }
        if (cand.getPostCode1Score() != this.getPostCode1Score()) {
            return false;
        }
        if (cand.getPostCode2Score() != this.getPostCode2Score()) {
            return false;
        }
        if (cand.getPostThoroughfareTypeScore() != this.getPostThoroughfareTypeScore()) {
            return false;
        }
        if (cand.getPreThoroughfareTypeScore() != this.getPreThoroughfareTypeScore()) {
            return false;
        }
        if (cand.getPostAddressScore() != this.getPostAddressScore()) {
            return false;
        }
        if (cand.getPreAddressScore() != this.getPreAddressScore()) {
            return false;
        }
        if (cand.getAdditionalParserFieldsScore() != this.getAdditionalParserFieldsScore()) {
            return false;
        }
        if (cand.getCountryScore() != this.getCountryScore()) {
            return false;
        }
        if (cand.getAreaName1Score() != this.getAreaName1Score()) {
            return false;
        }
        if (cand.getAreaName2Score() != this.getAreaName2Score()) {
            return false;
        }
        if (cand.getAreaName3Score() != this.getAreaName3Score()) {
            return false;
        }
        if (cand.getAreaName4Score() != this.getAreaName4Score()) {
            return false;
        }
        if (cand.getGenericField1Score() != this.getGenericField1Score()) {
            return false;
        }
        if (cand.getGenericField2Score() != this.getGenericField2Score()) {
            return false;
        }
        if (cand.getGenericField3Score() != this.getGenericField3Score()) {
            return false;
        }
        if (cand.getGenericField4Score() != this.getGenericField4Score()) {
            return false;
        }
        if (cand.getPlaceNameScore() != this.getPlaceNameScore()) {
            return false;
        }
        if (this.hasMatchingRange() && cand.hasMatchingRange()) {
            long candAddressesCount;
            Range thisMatched = this.getSegment().getRangeAt(this.m_matchedRangeNumber, this.m_segmentSide);
            Range candMatched = cand.getSegment().getRangeAt(cand.m_matchedRangeNumber, cand.m_segmentSide);
            long thisAddressesCount = thisMatched.computeAddressesInRange();
            if (thisAddressesCount != (candAddressesCount = candMatched.computeAddressesInRange())) {
                return false;
            }
        } else if (this.hasMatchingRange() || cand.hasMatchingRange()) {
            return false;
        }
        if ((bCandClosest = cand.hasClosestRange()) != (bThisClosest = this.hasClosestRange())) {
            return false;
        }
        if (bCandClosest && bThisClosest) {
            long cand2Offset;
            Range cand1Closest = cand.getSegment().getRangeAt(cand.m_closestRange, cand.m_segmentClosestSide);
            Range cand2Closest = this.getSegment().getRangeAt(this.m_closestRange, this.m_segmentClosestSide);
            long cand1Offset = cand1Closest.getRangeOffset();
            if (cand1Offset != (cand2Offset = cand2Closest.getRangeOffset())) {
                return false;
            }
        }
        return true;
    }

    public void computeScores(ScoringAddress scoringAddress, String charsToIgnore) {
        this.m_address.setCharsToIgnore(charsToIgnore);
        this.scoreAddressNumber(scoringAddress);
        this.scorePlaceName(scoringAddress);
        this.scorePostalInformation(scoringAddress);
        this.scoreAreaNames(scoringAddress);
        if (!this.m_placeNameMatchToUnit) {
            this.scoreUnitType(scoringAddress);
        }
    }

    public void scoreAddressNumber(ScoringAddress parsedAddress) {
        Range range;
        this.m_inputNumber = parsedAddress.getParsedAddressNumber();
        if (this.m_inputNumber == null) {
            this.m_bInputNumberNull = true;
        }
        this.m_inputUnitId = parsedAddress.getParsedUnitValue();
        this.findBestRange(parsedAddress);
        if (!this.hasMatchingRange()) {
            if (this.hasClosestRange()) {
                range = this.getSegment().getRangeAt(this.m_closestRange, this.m_segmentClosestSide);
                range.findMatchingRangeUnit(this.m_inputUnitId, parsedAddress.getUnitType());
                if (!range.hasMatchingRangeUnit()) {
                    range.findClosestRangeUnit(parsedAddress);
                }
            }
        } else {
            range = this.getSegment().getRangeAt(this.m_matchedRangeNumber, this.m_segmentSide);
            if (range != null && !range.hasMatchingRangeUnit()) {
                range.findClosestRangeUnit(parsedAddress);
            }
        }
        int numFieldsMatched = this.getCntAddressNumberFieldsMatched();
        if (this.m_bInputNumberNull || this.m_inputNumber == null) {
            this.m_addressNumberScore = 0.0;
            return;
        }
        int numFields = this.m_inputNumber.getNumFields();
        if (numFields == 0) {
            this.m_addressNumberScore = 1.0;
        } else if (numFieldsMatched > numFields) {
            this.m_addressNumberScore = 1.0;
        } else if (numFields == 3 && this.m_inputNumber.isHyphenatedNumber() && numFieldsMatched == 1) {
            this.m_addressNumberScore = 1.0;
        } else if (this.m_inputNumber.hasSeparator() && numFieldsMatched == numFields - 1) {
            this.m_addressNumberScore = 1.0;
        } else {
            ParsedRangeScore prScore;
            Range range2;
            this.m_addressNumberScore = (double)numFieldsMatched / (double)numFields;
            if (this.hasMatchingRange() && (range2 = this.getSegment().getRangeAt(this.m_matchedRangeNumber, this.m_segmentSide)) != null && (prScore = range2.getParsedRangeScore()) != null) {
                if (numFieldsMatched == numFields) {
                    if (!StringUtilities.isEmpty(prScore.getAbsentStringForInputNumber()) && (prScore.isPrefixAbsentFromInputNumber() || prScore.isSuffixAbsentFromInputNumber())) {
                        this.m_addressNumberScore = 0.95;
                    }
                } else if (numFieldsMatched == numFields - 1) {
                    ParsedNumber scoringNumber = prScore.getScoringNumber();
                    if (this.m_inputNumber.hasAddressPrefix() && !scoringNumber.hasAddressPrefix() || this.m_inputNumber.hasAddressSuffix() && !scoringNumber.hasAddressSuffix()) {
                        this.m_addressNumberScore = 0.95;
                    }
                }
            }
        }
    }

    public void checkSegmentSides(ScoringAddress parsedAddress, int side) {
        if (this.m_bInputNumberNull || this.m_inputNumber == null) {
            return;
        }
        Segment segment = this.getSegment();
        Range bestRange = null;
        double bestRangePlaceNameScore = 0.0;
        double placeMinimum = this.getPlaceInRangeMinimum();
        if (segment == null) {
            return;
        }
        ParsedNumber unitNumber = new ParsedNumber(parsedAddress.getUnitValue());
        String unitType = parsedAddress.getUnitType();
        List rangeList = segment.getRanges(side);
        int inputOddEven = this.m_inputNumber.isRangeOddEvenBoth();
        int count = rangeList.size();
        for (int i = 0; i < count; ++i) {
            double rangePlaceNameScore;
            Range range = (Range)rangeList.get(i);
            int oddEven = range.getOddEven();
            if (oddEven != 0 && oddEven != inputOddEven && (oddEven != 5 || range.getIntermediateRecordArray() == null)) continue;
            int fieldsMatched = range.isNumberInRange(this.m_inputNumber);
            if (fieldsMatched > 0 && unitNumber != null) {
                range.findMatchingRangeUnit(unitNumber, unitType);
            }
            if ((rangePlaceNameScore = parsedAddress.scorePlaceName(range.getPlaceName())) < placeMinimum) {
                rangePlaceNameScore = 0.0;
            }
            if (fieldsMatched > this.getCntAddressNumberFieldsMatched()) {
                this.setCntAddressNumberFieldsMatched(fieldsMatched);
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (fieldsMatched <= 0 || fieldsMatched != this.getCntAddressNumberFieldsMatched()) continue;
            if (bestRange == null) {
                bestRange = (Range)segment.getRanges(this.getSegmentSide()).get(this.getMatchedRangeNumber());
                bestRangePlaceNameScore = parsedAddress.scorePlaceName(bestRange.getPlaceName());
            }
            if (range.computeAddressesInRange() < bestRange.computeAddressesInRange()) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (range.hasMatchingRangeUnit() && !bestRange.hasMatchingRangeUnit()) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (range.hasMatchingRangeUnit() && bestRange.hasMatchingRangeUnit() && range.getRangeUnitAt(range.getMatchingRangeUnit()).getTypeMatched() && !bestRange.getRangeUnitAt(range.getMatchingRangeUnit()).getTypeMatched()) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (!(rangePlaceNameScore > bestRangePlaceNameScore)) continue;
            this.setMatchedRangeNumber(i);
            bestRange = range;
            this.setSegmentSide(side);
            bestRangePlaceNameScore = rangePlaceNameScore;
        }
    }

    protected void findClosestPointHouseRangeForNoInputNumber() {
        Segment segment = this.getSegment();
        if (segment.getRangeCount(0) > 0) {
            this.setClosestSegmentSide(0);
            this.setClosestRange(0);
            this.setAddressNumber(segment.getRangeAt(0, 0).getParsedFrom());
        } else if (segment.getRangeCount(1) > 0) {
            this.setClosestSegmentSide(1);
            this.setClosestRange(0);
            this.setAddressNumber(segment.getRangeAt(0, 1).getParsedFrom());
        }
    }

    public void findClosestRange() {
        if (this.m_bInputNumberNull || this.m_inputNumber == null || this.m_inputNumber.isEmpty()) {
            if (this.getSegment().isHouseSegment()) {
                this.findClosestPointHouseRangeForNoInputNumber();
            }
            return;
        }
        long bestOffset = Long.MAX_VALUE;
        Segment segment = this.getSegment();
        int inputOddEven = this.m_inputNumber.isRangeOddEvenBoth();
        for (int side : Segment.SEGMENT_SIDES) {
            int numRanges = segment.getRangeCount(side);
            List ranges = segment.getRanges(side);
            for (int i = 0; i < numRanges; ++i) {
                long offset;
                Range range = (Range)ranges.get(i);
                int oddEven = range.getOddEven();
                if (oddEven != 0 && inputOddEven != oddEven && (oddEven != 5 || range.getIntermediateRecordArray() == null) && !this.getSegment().isHouseSegment() || (offset = range.computeOffsetFromRange(this.m_inputNumber)) >= bestOffset) continue;
                this.m_closestRange = i;
                this.m_segmentClosestSide = side;
                bestOffset = offset;
            }
        }
    }

    public boolean hasMatchingRange() {
        return (this.m_segmentSide == 0 || this.m_segmentSide == 1) && this.m_matchedRangeNumber >= 0;
    }

    public boolean hasClosestRange() {
        return (this.m_segmentClosestSide == 0 || this.m_segmentClosestSide == 1) && this.m_closestRange >= 0;
    }

    protected double getPlaceInRangeMinimum() {
        return 0.8;
    }

    protected double getPlaceMinimum() {
        return 0.5;
    }

    protected void findBestPlaceNameMatch(ScoringAddress inputAddress) {
        Segment segment = this.getSegment();
        double bestRangeScore = 0.0;
        double placeMinimum = this.getPlaceMinimum();
        if (segment == null) {
            return;
        }
        for (int side = 0; side < 2; ++side) {
            List rangeList = segment.getRanges(side);
            int rangeCount = rangeList.size();
            for (int i = 0; i < rangeCount; ++i) {
                Range range = (Range)rangeList.get(i);
                if (!range.getParsedFrom().equals(range.getParsedTo()) && !this.fromUserDictionary()) continue;
                double currentRangeScore = inputAddress.scorePlaceName(range.getPlaceName());
                if (currentRangeScore >= placeMinimum && currentRangeScore > bestRangeScore) {
                    bestRangeScore = currentRangeScore;
                    this.setSegmentSide(side);
                    this.setMatchedRangeNumber(i);
                    this.m_houseNumberFromPlace = true;
                    this.m_bInputNumberNull = false;
                    this.m_placeNameMatchToUnit = false;
                    if (this.fromUserDictionary() && StringUtilities.isEmpty(this.getAddressNumber())) {
                        this.findClosestPointHouseRangeForNoInputNumber();
                    }
                }
                if (range.getRangeUnitCount() <= 0) continue;
                List rangeUnitList = range.getRangeUnits();
                int count = rangeUnitList.size();
                for (int j = 0; j < count; ++j) {
                    RangeUnit unit = (RangeUnit)rangeUnitList.get(j);
                    double rangeScore = inputAddress.scorePlaceName(unit.getPlaceName());
                    if (!(rangeScore >= placeMinimum) || !(rangeScore > bestRangeScore)) continue;
                    bestRangeScore = rangeScore;
                    this.setSegmentSide(side);
                    this.setMatchedRangeNumber(i);
                    range.setMatchingRangeUnit(j);
                    this.m_houseNumberFromPlace = true;
                    this.m_placeNameMatchToUnit = true;
                    this.m_bInputNumberNull = false;
                    this.m_unitTypeScore = 1.0;
                }
            }
        }
        this.m_placeNameScore = bestRangeScore;
    }

    protected void scorePlaceName(ScoringAddress inputAddress) {
        String inputPlaceName = inputAddress.getPlaceName();
        if (inputPlaceName == null || inputPlaceName.length() == 0) {
            return;
        }
        if (this.hasMatchingRange()) {
            this.setPlaceNameScore(inputAddress.scorePlaceName(this.getPlaceName()));
            return;
        }
        this.findBestPlaceNameMatch(inputAddress);
    }

    public void scorePostalInformation(ScoringAddress scoringAddress) {
        this.m_postCode1Score = scoringAddress.scorePostCode1(this.getPostCode1());
        this.m_postCode2Score = scoringAddress.scorePostCode2(this.getPostCode2());
    }

    public void scoreAreaNames(ScoringAddress scoringAddress) {
        this.m_areaName1Score = scoringAddress.scoreAreaName1(this.getAreaName1());
        this.m_areaName2Score = scoringAddress.scoreAreaName2(this.getAreaName2());
        this.m_areaName3Score = scoringAddress.scoreAreaName3(this.getAreaName3());
        this.m_areaName4Score = scoringAddress.scoreAreaName4(this.getAreaName4());
    }

    public void scoreUnitType(ScoringAddress scoringAddress) {
        this.m_unitTypeScore = scoringAddress.scoreUnitType(this.getUnitType());
    }

    public boolean isMatchingFlagSet(int flag) {
        return (this.m_matchingFlags & flag) == flag;
    }

    public boolean isPerfectMatch() {
        return this.getCombinedAddressScore() == 1.0 && this.getCombinedAdditionalFieldScore() == 1.0;
    }

    public void setSegment(Segment segment) {
        this.m_Segment = segment;
    }

    public void setPreThoroughfareTypeScore(double score) {
        this.m_address.setPreThoroughfareTypeScore(score);
    }

    public void setPreAddressScore(double score) {
        this.m_address.setPreAddressScore(score);
    }

    public void setMainAddressScore(double score) {
        this.m_address.setMainAddressScore(score);
    }

    public void setPostAddressScore(double score) {
        this.m_address.setPostAddressScore(score);
    }

    public void setPostThoroughfareTypeScore(double score) {
        this.m_address.setPostThoroughfareTypeScore(score);
    }

    public void setAreaName1Score(double score) {
        this.m_areaName1Score = score;
    }

    public void setAreaName2Score(double score) {
        this.m_areaName2Score = score;
    }

    public void setAreaName3Score(double score) {
        this.m_areaName3Score = score;
    }

    public void setAreaName4Score(double score) {
        this.m_areaName4Score = score;
    }

    public void setCountryScore(double score) {
        this.m_address.setCountryScore(score);
    }

    public void setPostCode1Score(double score) {
        this.m_postCode1Score = score;
    }

    public void setPostCode2Score(double score) {
        this.m_postCode2Score = score;
    }

    public void setPlaceNameScore(double score) {
        this.m_placeNameScore = score;
    }

    public void setUnitTypeScore(double score) {
        this.m_unitTypeScore = score;
    }

    public void setCombinedAddressScore(double score) {
        this.m_combinedAddressScore = score;
    }

    public void setCombinedAdditionalFieldScore(double score) {
        this.m_combinedAdditionalFieldScore = score;
    }

    public void setCloseMatchFlag(boolean flag) {
        this.m_closeMatchFlag = flag;
    }

    public void setGenericField1Score(double score) {
        this.m_address.setGenericField1Score(score);
    }

    public void setGenericField2Score(double score) {
        this.m_address.setGenericField2Score(score);
    }

    public void setGenericField3Score(double score) {
        this.m_address.setGenericField3Score(score);
    }

    public void setGenericField4Score(double score) {
        this.m_address.setGenericField4Score(score);
    }

    public void setAdditionalParserFieldsScore(double score) {
        this.m_additionalParserFieldsScore = score;
    }

    @Override
    public boolean hasAdditionalFields() {
        if (this.m_additionalParserFieldsScore != 0.0) {
            return true;
        }
        return this.m_address.hasAdditionalFields();
    }

    public void setMatchedRangeNumber(int index) {
        this.m_matchedRangeNumber = index;
    }

    public void setCntAddressNumberFieldsMatched(int cnt) {
        this.m_cntAddressNumberFieldsMatched = cnt;
    }

    public void setSegmentSide(int side) {
        this.m_segmentSide = side;
    }

    public void setClosestRange(int rangeNumber) {
        this.m_closestRange = rangeNumber;
    }

    public void setClosestSegmentSide(int segmentSide) {
        this.m_segmentClosestSide = segmentSide;
    }

    public void setMatchingFlags(int flags) {
        this.m_matchingFlags = flags;
    }

    public void setMatchingFlag(int flag) {
        this.m_matchingFlags |= flag;
    }

    public void setInputNumber(ParsedNumber inputNumber) {
        this.m_inputNumber = inputNumber;
        this.m_bInputNumberNull = false;
    }

    public void setCharsToIgnore(String chars) {
        this.privateSetCharsToIgnore(chars);
    }

    public void setStreetOffset(long offset) {
        this.m_address.setStreetOffset(offset);
    }

    private void privateSetCharsToIgnore(String chars) {
        this.m_address.setCharsToIgnore(chars);
    }

    public Segment getSegment() {
        return this.m_Segment;
    }

    public double getAddressNumberScore() {
        return this.m_addressNumberScore;
    }

    protected void setAddressNumberScore(double addressNumberScore) {
        this.m_addressNumberScore = addressNumberScore;
    }

    public double getPreDirectionalScore() {
        return this.m_address.getPreDirectionalScore();
    }

    public void setPreDirectionalScore(double score) {
        this.m_address.setPreDirectionalScore(score);
    }

    public void setPostDirectionalScore(double score) {
        this.m_address.setPostDirectionalScore(score);
    }

    public double getPreThoroughfareTypeScore() {
        return this.m_address.getPreThoroughfareTypeScore();
    }

    public double getPreAddressScore() {
        return this.m_address.getPreAddressScore();
    }

    public double getMainAddressScore() {
        return this.m_address.getMainAddressScore();
    }

    public double getPostAddressScore() {
        return this.m_address.getPostAddressScore();
    }

    public double getPostThoroughfareTypeScore() {
        return this.m_address.getPostThoroughfareTypeScore();
    }

    public double getPostDirectionalScore() {
        return this.m_address.getPostDirectionalScore();
    }

    public double getAreaName1Score() {
        return this.m_areaName1Score;
    }

    public double getAreaName2Score() {
        return this.m_areaName2Score;
    }

    public double getAreaName3Score() {
        return this.m_areaName3Score;
    }

    public double getAreaName4Score() {
        return this.m_areaName4Score;
    }

    public double getCountryScore() {
        return this.m_address.getCountryScore();
    }

    public double getPlaceNameScore() {
        return this.m_placeNameScore;
    }

    public double getPostCode1Score() {
        return this.m_postCode1Score;
    }

    public double getPostCode2Score() {
        return this.m_postCode2Score;
    }

    public double getUnitTypeScore() {
        return this.m_unitTypeScore;
    }

    public double getCombinedAdditionalFieldScore() {
        return this.m_combinedAdditionalFieldScore;
    }

    public double getCombinedAddressScore() {
        return this.m_combinedAddressScore;
    }

    @Override
    public boolean isCloseMatch() {
        return this.m_closeMatchFlag;
    }

    public double getGenericField1Score() {
        return this.m_address.getGenericField1Score();
    }

    public double getGenericField2Score() {
        return this.m_address.getGenericField2Score();
    }

    public double getGenericField3Score() {
        return this.m_address.getGenericField3Score();
    }

    public double getGenericField4Score() {
        return this.m_address.getGenericField4Score();
    }

    public double getAdditionalParserFieldsScore() {
        return this.m_additionalParserFieldsScore;
    }

    public int getCntAddressNumberFieldsMatched() {
        return this.m_cntAddressNumberFieldsMatched;
    }

    public int getMatchedRangeNumber() {
        return this.m_matchedRangeNumber;
    }

    public int getClosestRangeNumber() {
        return this.m_closestRange;
    }

    public int getMatchingFlags() {
        return this.m_matchingFlags;
    }

    public ParsedNumber getInputNumber() {
        return this.m_inputNumber;
    }

    public int getSegmentSide() {
        return this.m_segmentSide;
    }

    public int getClosestSegmentSide() {
        return this.m_segmentClosestSide;
    }

    public boolean getRangeMatchedFlag() {
        return this.getMatchedRangeNumber() >= 0;
    }

    @Override
    public String getAddressNumber() {
        if (!this.m_bInputNumberNull && this.m_inputNumber != null && !this.m_inputNumber.isEmpty()) {
            if (this.hasMatchingRange()) {
                Range range = null;
                List rangeList = this.m_Segment.getRanges(this.m_segmentSide);
                if (rangeList != null && rangeList.size() > 0) {
                    range = (Range)rangeList.get(this.m_matchedRangeNumber);
                }
                if (range != null) {
                    if (this.m_houseNumberFromPlace) {
                        return range.getParsedFrom().getCombinedAddressNumber();
                    }
                    return range.getMatchedRangeNumber().getCombinedAddressNumber();
                }
            } else if (this.hasClosestRange()) {
                Range range = null;
                List rangeList = this.m_Segment.getRanges(this.m_segmentClosestSide);
                if (rangeList != null && rangeList.size() > 0) {
                    range = (Range)rangeList.get(this.m_closestRange);
                }
                if (range != null) {
                    return range.getClosestAddressNumber(this.m_inputNumber).getCombinedAddressNumber();
                }
            } else {
                return this.m_address.getAddressNumber();
            }
        }
        if (this.m_addressNumber != null) {
            return this.m_addressNumber.getCombinedAddressNumber();
        }
        return null;
    }

    @Override
    public ParsedNumber getParsedAddressNumber() {
        if (this.hasMatchingRange()) {
            Range range = null;
            List rangeList = this.m_Segment.getRanges(this.m_segmentSide);
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.m_matchedRangeNumber);
            }
            if (range != null) {
                if (this.m_houseNumberFromPlace) {
                    return range.getParsedFrom();
                }
                return range.getMatchedRangeNumber();
            }
        } else if (!this.m_bInputNumberNull && this.m_inputNumber != null && this.hasClosestRange()) {
            Range range = null;
            List rangeList = this.m_Segment.getRanges(this.m_segmentClosestSide);
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.m_closestRange);
            }
            if (range != null) {
                return range.getClosestAddressNumber(this.m_inputNumber);
            }
        }
        return this.m_addressNumber;
    }

    @Override
    public String getPostCode1() {
        if (this.m_segmentSide == 1) {
            return this.m_Segment.getRightPostCode1();
        }
        if (this.m_segmentSide == 0) {
            return this.m_Segment.getLeftPostCode1();
        }
        if (this.m_segmentClosestSide == 1) {
            return this.m_Segment.getRightPostCode1();
        }
        if (this.m_segmentClosestSide == 0) {
            return this.m_Segment.getLeftPostCode1();
        }
        return this.m_address.getPostCode1();
    }

    @Override
    public String getPostCode2() {
        if (this.m_segmentSide == 1) {
            return this.m_Segment.getRightPostCode2();
        }
        if (this.m_segmentSide == 0) {
            return this.m_Segment.getLeftPostCode2();
        }
        if (this.m_segmentClosestSide == 1) {
            return this.m_Segment.getRightPostCode2();
        }
        if (this.m_segmentClosestSide == 0) {
            return this.m_Segment.getLeftPostCode2();
        }
        return this.m_address.getPostCode2();
    }

    @Override
    public String getAreaName1() {
        String areaName = null;
        if (this.m_segmentSide == 1) {
            areaName = this.m_Segment.getRightAreaName1();
        } else if (this.m_segmentSide == 0) {
            areaName = this.m_Segment.getLeftAreaName1();
        } else if (this.m_segmentClosestSide == 1) {
            areaName = this.m_Segment.getRightAreaName1();
        } else if (this.m_segmentClosestSide == 0) {
            areaName = this.m_Segment.getLeftAreaName1();
        }
        if (areaName == null) {
            return this.m_address.getAreaName1();
        }
        return areaName;
    }

    @Override
    public String getAreaName2() {
        String areaName = null;
        if (this.m_segmentSide == 1) {
            areaName = this.m_Segment.getRightAreaName2();
        } else if (this.m_segmentSide == 0) {
            areaName = this.m_Segment.getLeftAreaName2();
        } else if (this.m_segmentClosestSide == 1) {
            areaName = this.m_Segment.getRightAreaName2();
        } else if (this.m_segmentClosestSide == 0) {
            areaName = this.m_Segment.getLeftAreaName2();
        }
        if (areaName == null) {
            return this.m_address.getAreaName2();
        }
        return areaName;
    }

    @Override
    public String getAreaName3() {
        String areaName = null;
        if (this.m_segmentSide == 1) {
            areaName = this.m_Segment.getRightAreaName3();
        } else if (this.m_segmentSide == 0) {
            areaName = this.m_Segment.getLeftAreaName3();
        } else if (this.m_segmentClosestSide == 1) {
            areaName = this.m_Segment.getRightAreaName3();
        } else if (this.m_segmentClosestSide == 0) {
            areaName = this.m_Segment.getLeftAreaName3();
        }
        if (areaName == null) {
            return this.m_address.getAreaName3();
        }
        return areaName;
    }

    @Override
    public String getAreaName4() {
        String areaName = null;
        if (this.m_segmentSide == 1) {
            areaName = this.m_Segment.getRightAreaName4();
        } else if (this.m_segmentSide == 0) {
            areaName = this.m_Segment.getLeftAreaName4();
        } else if (this.m_segmentClosestSide == 1) {
            areaName = this.m_Segment.getRightAreaName4();
        } else if (this.m_segmentClosestSide == 0) {
            areaName = this.m_Segment.getLeftAreaName4();
        }
        if (areaName == null) {
            return this.m_address.getAreaName4();
        }
        return areaName;
    }

    @Override
    public String getUnitValue() {
        if (this.hasMatchingRange()) {
            Range range = null;
            List rangeList = this.m_Segment.getRanges(this.m_segmentSide);
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.m_matchedRangeNumber);
            }
            if (range != null) {
                if (this.m_placeNameMatchToUnit) {
                    int rangeUnitNumber = range.getMatchingRangeUnit();
                    return ((RangeUnit)range.getRangeUnits().get(rangeUnitNumber)).getParsedHighUnit().getCombinedAddressNumber();
                }
                return range.getUnitValue(this.m_inputUnitId);
            }
        } else if (this.hasClosestRange()) {
            Range range = null;
            List rangeList = this.m_Segment.getRanges(this.m_segmentClosestSide);
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.m_closestRange);
            }
            if (range != null) {
                return range.getUnitValue(this.m_inputUnitId);
            }
        } else {
            return null;
        }
        return null;
    }

    @Override
    public String getUnitType() {
        if (this.hasMatchingRange()) {
            Range range = null;
            List rangeList = this.m_Segment.getRanges(this.m_segmentSide);
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.m_matchedRangeNumber);
            }
            if (range != null) {
                return range.getUnitType();
            }
        } else if (this.hasClosestRange()) {
            Range range = null;
            List rangeList = this.m_Segment.getRanges(this.m_segmentClosestSide);
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.m_closestRange);
            }
            if (range != null) {
                return range.getUnitType();
            }
        } else {
            return null;
        }
        return null;
    }

    @Override
    public String getPlaceName() {
        String placeName = null;
        if (this.hasMatchingRange()) {
            Range range = null;
            List rangeList = this.m_Segment.getRanges(this.m_segmentSide);
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.m_matchedRangeNumber);
            }
            if (range != null) {
                placeName = range.getPlaceName();
            }
        } else if (this.hasClosestRange()) {
            Range range = null;
            List rangeList = this.m_Segment.getRanges(this.m_segmentClosestSide);
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.m_closestRange);
            }
            if (range != null) {
                placeName = range.getPlaceName();
            }
        }
        if (placeName == null) {
            return this.m_address.getPlaceName();
        }
        return placeName;
    }

    protected ParsedNumber getInputUnitId() {
        return this.m_inputUnitId;
    }

    protected void setInputUnitId(ParsedNumber inputUnitId) {
        this.m_inputUnitId = inputUnitId;
    }

    protected boolean isInputNumberNull() {
        return this.m_bInputNumberNull;
    }

    protected void setInputNumberNull(boolean bInputNumberNull) {
        this.m_bInputNumberNull = bInputNumberNull;
    }

    public String getFormattedStreetAddress() {
        int len;
        String tmp;
        StringBuffer str = new StringBuffer();
        if (this.getAddressNumberScore() == 1.0 && !this.m_bInputNumberNull) {
            str.append(this.m_inputNumber.getCombinedAddressNumber());
            str.append(" ");
        } else {
            tmp = this.getAddressNumber();
            if (tmp != null) {
                str.append(tmp);
                str.append(" ");
            }
        }
        tmp = this.getPreAddress();
        if (tmp != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPreThoroughfareType()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getMainAddress()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostThoroughfareType()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostAddress()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getUnitValue()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getUnitType()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public String getFormattedLocationAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getAreaName3();
        if (tmp != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getAreaName1()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostCode1()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostCode2()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public String getCharsToIgnore() {
        return this.m_address.getCharsToIgnore();
    }

    public long getStreetOffset() {
        return this.m_address.getStreetOffset();
    }

    public void setDictionaryPriority(int priority) {
        this.m_address.setDictionaryNumber(priority);
    }

    public int getDictionaryPriority() {
        return this.m_address.getDictionaryNumber();
    }

    public void setUserDictionaryPriority(int priority) {
        this.m_userDictionaryPriority = priority;
    }

    @Override
    public int getUserDictionaryPriority() {
        return this.m_userDictionaryPriority;
    }

    public boolean fromUserDictionary() {
        return this.m_address.fromUserDictionary();
    }

    @Override
    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer str = new StringBuffer();
        str.append("InternalCandidateAddress strings:");
        str.append(lineSeparator);
        str.append(this.getStreetCandidateAddress().toString());
        str.append(lineSeparator);
        str.append("\taddressNUmberScore: ");
        str.append(this.getAddressNumberScore());
        str.append(lineSeparator);
        str.append("\tplaceNameScore=");
        str.append(this.getPlaceNameScore());
        str.append(lineSeparator);
        str.append("\tcombinedAddressScore=");
        str.append(this.getCombinedAddressScore());
        str.append(lineSeparator);
        str.append("\tadditionalParserFields=");
        str.append(this.m_additionalParserFieldsScore);
        str.append(lineSeparator);
        str.append("\tcombinedAdditionalFieldScore=");
        str.append(this.m_combinedAdditionalFieldScore);
        str.append(lineSeparator);
        str.append("\tareaNames:");
        str.append(lineSeparator);
        str.append("\t\t1=");
        str.append(this.m_areaName1Score);
        str.append(", 2=");
        str.append(this.m_areaName2Score);
        str.append(", 3=");
        str.append(this.m_areaName3Score);
        str.append(", 4=");
        str.append(this.m_areaName4Score);
        str.append(lineSeparator);
        str.append(lineSeparator);
        str.append("\tpostCode1=");
        str.append(this.m_postCode1Score);
        str.append(", postCode2=");
        str.append(this.m_postCode2Score);
        str.append(lineSeparator);
        str.append(lineSeparator);
        str.append(lineSeparator);
        str.append("formattedStreetAddress:=");
        str.append(this.getFormattedStreetAddress());
        str.append(lineSeparator);
        str.append(lineSeparator);
        str.append("formattedLocationAddress:=");
        str.append(this.getFormattedLocationAddress());
        str.append(lineSeparator);
        str.append(lineSeparator);
        str.append("segmentOffset: ");
        str.append(this.getSegmentOffset());
        str.append(lineSeparator);
        str.append("flags:");
        str.append(lineSeparator);
        str.append("\tcloseMatch=");
        str.append(this.m_closeMatchFlag);
        str.append(lineSeparator);
        str.append("\tmatchingFlags=");
        str.append(this.getMatchingFlags());
        str.append(lineSeparator);
        str.append("Range matching information:");
        str.append(lineSeparator);
        str.append("\tsegmentSide: ");
        str.append(this.m_segmentSide);
        str.append(lineSeparator);
        str.append("\tmatchedRange=");
        str.append(this.m_matchedRangeNumber);
        str.append(lineSeparator);
        str.append("\tclosest side: ");
        str.append(this.m_segmentClosestSide);
        str.append(lineSeparator);
        str.append("\tclosestRange=");
        str.append(this.m_closestRange);
        str.append(lineSeparator);
        if (this.m_Segment != null) {
            str.append(this.m_Segment.toString());
        }
        str.append(lineSeparator);
        str.append(lineSeparator);
        str.append("fromUserDictionary=");
        str.append(this.m_address.fromUserDictionary());
        str.append(lineSeparator);
        str.append("hasDictionaryBonus=");
        str.append(this.hasDictionaryBonus());
        str.append(lineSeparator);
        str.append("userDictionaryPriority=");
        str.append(this.getUserDictionaryPriority());
        str.append(lineSeparator);
        str.append("dictionaryPriority=");
        str.append(this.getDictionaryPriority());
        str.append(lineSeparator);
        return str.toString();
    }

    protected double calculateSegmentPercentage(long totalHousePositions, long targetHousePosition) {
        if (totalHousePositions == 0L) {
            return 0.5;
        }
        return (double)targetHousePosition / (double)totalHousePositions;
    }

    protected double getHouseNumberPercentage(int segmentSide, int rangeNumber, ParsedNumber targetHouse) {
        int rangeCount = this.getSegment().getRangeCount(segmentSide);
        List ranges = this.getSegment().getRanges(segmentSide);
        long totalAddresses = 0L;
        long targetAddressPosition = -1L;
        for (int i = 0; i < rangeCount; ++i) {
            Range r = (Range)ranges.get(i);
            if (i == rangeNumber) {
                targetAddressPosition = totalAddresses + r.computeOffsetInRange(targetHouse);
            }
            totalAddresses += r.computeAddressesInRange();
        }
        return this.calculateSegmentPercentage(totalAddresses - 1L, targetAddressPosition);
    }

    public void setGeocodedPoint(CandidateAddress candidate, int debugLevel, IConstraints constraints, ResourceBundle errorBundle) {
        Segment segment = this.getSegment();
        int segmentPointCount = segment.getSegmentPointCount();
        if (segment.isHouseSegment()) {
            DirectPosition housePoint = this.getAddressNumberHousePoint();
            if (housePoint != null) {
                DirectPosition centerlineOffsetPoint;
                DirectPosition directPosition = centerlineOffsetPoint = constraints.getUseCenterlineOffset() ? this.getCenterlineOffsetLocation(housePoint, constraints.getHandler().getMatchResults(), constraints) : null;
                if (centerlineOffsetPoint != null) {
                    candidate.setLocation(centerlineOffsetPoint);
                    candidate.setLocationPrecision(18);
                } else {
                    candidate.setLocation(housePoint);
                    candidate.setLocationPrecision(16);
                }
            }
        } else if (this.isPointHouseCandidate(constraints)) {
            DirectPosition pointHouseLocation = segment.getSegmentPointAt(0);
            if (this.hasMatchingRange() || this.hasClosestRange()) {
                DirectPosition centerlineOffsetPoint;
                DirectPosition directPosition = centerlineOffsetPoint = constraints.getUseCenterlineOffset() ? this.getCenterlineOffsetLocation(pointHouseLocation, constraints.getHandler().getMatchResults(), constraints) : null;
                if (centerlineOffsetPoint != null) {
                    candidate.setLocation(centerlineOffsetPoint);
                    candidate.setLocationPrecision(18);
                } else {
                    candidate.setLocation(pointHouseLocation);
                    candidate.setLocationPrecision(16);
                }
            } else {
                candidate.setLocation(pointHouseLocation);
                candidate.setLocationPrecision(2);
            }
        } else if (segmentPointCount == 1) {
            candidate.setLocation(segment.getSegmentPointAt(0));
            candidate.setLocationPrecision(1);
        } else if (segmentPointCount != 0) {
            int rangeNumber;
            int segmentSide = this.getSegmentSide();
            if (segmentSide < 0) {
                segmentSide = this.getClosestSegmentSide();
            }
            if ((rangeNumber = this.getMatchedRangeNumber()) < 0) {
                rangeNumber = this.getClosestRangeNumber();
            }
            if (segmentSide < 0 || rangeNumber < 0) {
                candidate.setLocation(Interpolator.interpolateShapePath(segment.getSegmentPoints()));
                if (candidate.getLocationPoint() != null) {
                    candidate.setLocationPrecision(2);
                }
            } else {
                List pointHouseCandidates = this.findAllPointHouseCandidates(constraints);
                if (pointHouseCandidates == null) {
                    double percentage = this.getHouseNumberPercentage(segmentSide, rangeNumber, this.getParsedAddressNumber());
                    if (this.getSecondHNRangedAddress() != null) {
                        double percentage2 = this.getHouseNumberPercentage(segmentSide, rangeNumber, this.getSecondHNRangedAddress());
                        percentage = (percentage + percentage2) / 2.0;
                    }
                    candidate.setLocation(Interpolator.interpolate(segment.getSegmentPoints(), segmentSide == 0, percentage, constraints.getCornerOffsetAsLength(), constraints.getStreetOffsetAsLength()));
                    if (candidate.getLocationPoint() != null) {
                        candidate.setLocationPrecision(1);
                    }
                } else {
                    DirectPosition exactPointHouse = this.findExactPointHouse(pointHouseCandidates);
                    if (exactPointHouse != null) {
                        candidate.setLocation(exactPointHouse);
                        candidate.setLocationPrecision(16);
                    } else {
                        this.filterPointCandidates(pointHouseCandidates, segmentSide);
                        this.interpolateUsingPointHouses(candidate, pointHouseCandidates, constraints, segmentSide, rangeNumber);
                    }
                }
            }
        } else {
            DirectPosition exactPointHouse;
            List pointCandidates = this.findAllPointHouseCandidates(constraints);
            if (pointCandidates != null && (exactPointHouse = this.findExactPointHouse(pointCandidates)) != null) {
                candidate.setLocation(exactPointHouse);
                candidate.setLocationPrecision(16);
            }
        }
        if (candidate.getLocationPrecision() != 0) {
            CoordSys clientCoordSys = constraints.getClientCoordinateSystemObject();
            candidate.setLocation(CoordConvertor.transformPointFromWGS84(clientCoordSys, candidate.getLocationPoint()));
            candidate.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)clientCoordSys));
        }
    }

    @Override
    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        boolean bPostTypeMatched;
        boolean bPreTypeMatched;
        boolean bPostDirMatched;
        boolean bPreDirMatched;
        boolean POB_MatchInProgress;
        int debugLevel = DebugLevel.getDebugLevel(1);
        ResourceBundle errorBundle = this.loadResourceBundleForLocale(constraints.getClientLocale());
        CandidateAddress candidate = new CandidateAddress(this);
        boolean bl = POB_MatchInProgress = Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false")) != false || this.getAdditionalFields().containsKey("PO_BOX_CAND");
        if (POB_MatchInProgress) {
            if (this.getMatchedRangeNumber() >= 0) {
                candidate.addKeyValueToAdditionalFields("PO_BOX_VALIDATED", "");
            } else {
                candidate.addKeyValueToAdditionalFields("PO_BOX_GENERAL", "");
            }
        }
        candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        candidate.setSourceStreetID(this.getStreetOffset());
        if (this.fromUserDictionary()) {
            candidate.setFromUserDictionary();
        }
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        ParsedNumber num = new ParsedNumber(input.getAddressNumber());
        ParsedNumber unitNum = new ParsedNumber(input.getUnitValue());
        if (num.isEmpty() || this.getAddressNumberScore() == 1.0 || this.getMatchFlagForAddressNumberMissingPrefixOrSuffix() && this.getAddressNumberScore() == 0.95) {
            candidate.setAddressNumberMatched();
        }
        boolean matchEmptyStreetFields = this.getMatchFlagForEmptyStreetFields();
        boolean matchEmptyLocationFields = this.getMatchFlagForEmptyLocationFields();
        boolean matchEmptyPlaceName = this.getMatchFlagForEmptyPlaceName();
        if ((this.fieldExists(input.getPostAddress()) ? this.getPostAddressScore() == 1.0 : matchEmptyStreetFields) && (this.fieldExists(input.getPreAddress()) ? this.getPreAddressScore() == 1.0 : matchEmptyStreetFields)) {
            candidate.setStreetPrefixAndSuffixMatched();
        }
        if (this.fieldExists(input.getMainAddress()) ? this.getMainAddressScore() == 1.0 : matchEmptyStreetFields) {
            candidate.setStreetNameMatched();
        }
        boolean bl2 = this.fieldExists(input.getPreDirectional()) ? this.getAdditionalParserFieldsScore() == 2.0 : (bPreDirMatched = matchEmptyStreetFields);
        boolean bl3 = this.fieldExists(input.getPostDirectional()) ? this.getAdditionalParserFieldsScore() == 2.0 : (bPostDirMatched = matchEmptyStreetFields);
        if (bPreDirMatched) {
            candidate.setPreDirectionalMatched();
        }
        if (bPostDirMatched) {
            candidate.setPostDirectionalMatched();
        }
        boolean bl4 = this.fieldExists(input.getPreThoroughfareType()) ? this.getPreThoroughfareTypeScore() == 1.0 : (bPreTypeMatched = matchEmptyStreetFields);
        boolean bl5 = this.fieldExists(input.getPostThoroughfareType()) ? this.getPostThoroughfareTypeScore() == 1.0 : (bPostTypeMatched = matchEmptyStreetFields);
        if (bPreTypeMatched && bPostTypeMatched) {
            candidate.setThoroughfareTypeMatched();
        }
        if (this.fieldExists(input.getPostCode1()) ? this.getPostCode1Score() == 1.0 : matchEmptyLocationFields) {
            candidate.setPostalCode1Matched();
        }
        if (this.fieldExists(input.getPostCode2()) ? this.getPostCode2Score() == 1.0 : matchEmptyLocationFields) {
            candidate.setPostalCode2Matched();
        }
        if (this.fieldExists(input.getAreaName1()) ? this.getAreaName1Score() == 1.0 : matchEmptyLocationFields) {
            candidate.setAreaName1Matched();
        }
        if (this.fieldExists(input.getAreaName2()) ? this.getAreaName2Score() == 1.0 : matchEmptyLocationFields) {
            candidate.setAreaName2Matched();
        }
        if (this.fieldExists(input.getAreaName3()) ? this.getAreaName3Score() == 1.0 : matchEmptyLocationFields) {
            candidate.setAreaName3Matched();
        }
        if (this.fieldExists(input.getAreaName4()) ? this.getAreaName4Score() == 1.0 : matchEmptyLocationFields) {
            candidate.setAreaName4Matched();
        }
        if (this.fieldExists(input.getPlaceName()) ? this.getPlaceNameScore() == 1.0 : matchEmptyPlaceName) {
            candidate.setPlaceNameMatched();
        }
        this.setGeocodedPoint(candidate, debugLevel, constraints, errorBundle);
        int maxRanges = constraints.getMaxRanges();
        candidate.setNumberOfReturnableRanges(maxRanges);
        if (maxRanges != 0) {
            CandidateRange candRange;
            Range range;
            int i;
            Segment segment = this.getSegment();
            int numLeftRanges = segment.getRangeCount(0);
            int numRightRanges = segment.getRangeCount(1);
            for (i = 0; i < numLeftRanges; ++i) {
                range = segment.getRangeAt(i, 0);
                candRange = range.toCandidateRange(num, 1, unitNum, constraints);
                candidate.addCandidateRange(candRange);
            }
            for (i = 0; i < numRightRanges; ++i) {
                range = segment.getRangeAt(i, 1);
                candRange = range.toCandidateRange(num, 2, unitNum, constraints);
                candidate.addCandidateRange(candRange);
            }
        }
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        this.populateSegmentId(candidate);
        this.populateWithRangeOrRangeUnitAdditionalFields(candidate);
        candidate.addKeyValueToAdditionalFields("INPUT_MATCH_SCORE", String.valueOf(this.inputMatchScore));
        return candidate;
    }

    protected boolean getMatchFlagForEmptyStreetFields() {
        return true;
    }

    protected boolean getMatchFlagForEmptyLocationFields() {
        return true;
    }

    protected boolean getMatchFlagForEmptyPlaceName() {
        return true;
    }

    protected boolean getMatchFlagForAddressNumberMissingPrefixOrSuffix() {
        return false;
    }

    protected final void populateSegmentId(Address candidate) {
        String segmentId;
        Segment segment = this.getSegment();
        if (segment != null && !StringUtilities.isEmpty(segmentId = segment.getSegmentId())) {
            HashMap<String, String> fields = candidate.getAdditionalFields();
            if (fields == null) {
                fields = new HashMap<String, String>();
                candidate.setAdditionalFields(fields);
            }
            fields.put("SEGMENT_ID", segmentId);
        }
    }

    protected void populateWithRangeOrRangeUnitAdditionalFields(Address candidate) {
        Range range = null;
        if (this.hasMatchingRange()) {
            range = this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
        } else if (this.hasClosestRange()) {
            range = this.getSegment().getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide());
        }
        if (range == null) {
            return;
        }
        Map<String, String> additionalFields = range.hasMatchingRangeUnit() ? range.getRangeUnitAt(range.getMatchingRangeUnit()).getAdditionalFields() : (range.hasClosestRangeUnit() ? range.getRangeUnitAt(range.getClosestRangeUnit()).getAdditionalFields() : range.getAdditionalFields());
        if (additionalFields.isEmpty()) {
            return;
        }
        candidate.getAdditionalFields().putAll(additionalFields);
    }

    public ResourceBundle loadResourceBundleForLocale(Locale loc) {
        return MapMarkerResourceLoader.loadForLocale(loc, this.commonStrings);
    }

    public boolean fieldExists(String field) {
        return field != null && field.trim().length() != 0;
    }

    public long getSegmentOffset() {
        if (this.m_Segment != null) {
            return this.m_Segment.getSegmentOffset();
        }
        return -1L;
    }

    public String buildPrecisionCode(CandidateAddress cand) {
        return InternalCandidateAddress.buildPrecisionCodeFromCandidate(cand);
    }

    private static String buildPrecisionCode(String precisionCode, String dictType, boolean appendDictType) {
        StringBuffer tempResult = new StringBuffer();
        tempResult.append(precisionCode);
        if (appendDictType) {
            tempResult.append(dictType);
        }
        return tempResult.toString();
    }

    public static String buildPrecisionCodeFromCandidate(CandidateAddress cand) {
        return InternalCandidateAddress.buildPrecisionCodeFromCandidateHandleStreetWithPostCentroid(cand, 0);
    }

    private static void buildPOBoxResultCode(CandidateAddress cand) {
        if (cand.getAdditionalFieldForKey("PO_BOX_GENERAL") != null) {
            cand.getAdditionalFields().put("PO_BOX_GENERAL", "B1");
        } else if (cand.getAdditionalFieldForKey("PO_BOX_VALIDATED") != null) {
            cand.getAdditionalFields().put("PO_BOX_VALIDATED", "B2");
        }
    }

    public static String buildPrecisionCodeFromCandidateHandleStreetWithPostCentroid(CandidateAddress cand, int geocodeType) {
        StringBuffer tempGeoResult = new StringBuffer();
        String dictionaryFlag = null;
        boolean isUserDictionary = false;
        boolean poboxGeneral = false;
        boolean poboxValidated = false;
        InternalCandidateAddress.buildPOBoxResultCode(cand);
        if (cand.getAdditionalFieldForKey("PO_BOX_GENERAL") != null) {
            poboxGeneral = true;
        } else if (cand.getAdditionalFieldForKey("PO_BOX_VALIDATED") != null) {
            poboxValidated = true;
        }
        if (cand.fromUserDictionary()) {
            isUserDictionary = true;
            dictionaryFlag = "U";
        } else {
            dictionaryFlag = "A";
        }
        if (cand.getLocationPrecision() == 6) {
            return "SX";
        }
        if (cand.getLocationPrecision() == 3 && geocodeType == 1) {
            return InternalCandidateAddress.buildPrecisionCode("Z1", dictionaryFlag, isUserDictionary);
        }
        if (cand.getLocationPrecision() == 4 && geocodeType == 1) {
            return InternalCandidateAddress.buildPrecisionCode("Z2", dictionaryFlag, isUserDictionary);
        }
        if (cand.getLocationPrecision() == 5 && geocodeType == 1) {
            return InternalCandidateAddress.buildPrecisionCode("Z3", dictionaryFlag, isUserDictionary);
        }
        if (cand.getLocationPrecision() == 8) {
            return InternalCandidateAddress.buildPrecisionCode("G1", dictionaryFlag, isUserDictionary);
        }
        if (cand.getLocationPrecision() == 9) {
            return InternalCandidateAddress.buildPrecisionCode("G2", dictionaryFlag, isUserDictionary);
        }
        if (cand.getLocationPrecision() == 10) {
            return InternalCandidateAddress.buildPrecisionCode("G3", dictionaryFlag, isUserDictionary);
        }
        if (cand.getLocationPrecision() == 11) {
            return InternalCandidateAddress.buildPrecisionCode("G4", dictionaryFlag, isUserDictionary);
        }
        if (cand.getLocationPrecision() == 1) {
            tempGeoResult.append("S5");
        } else if (cand.getLocationPrecision() == 2) {
            tempGeoResult.append("S4");
        } else if (cand.getLocationPrecision() == 17) {
            tempGeoResult.append("S7");
        } else if (cand.getLocationPrecision() == 16) {
            tempGeoResult.append("S8");
        } else if (cand.getLocationPrecision() == 18) {
            tempGeoResult.append("SC");
        } else if (cand.getLocationPrecision() == 3 && geocodeType == 0) {
            tempGeoResult.append("S1");
        } else if (cand.getLocationPrecision() == 4 && geocodeType == 0) {
            tempGeoResult.append("S2");
        } else if (cand.getLocationPrecision() == 5 && geocodeType == 0) {
            tempGeoResult.append("S3");
        } else if (cand.getLocationPrecision() == 0) {
            tempGeoResult.append("S0");
        }
        if (cand.doesAddressNumberMatch() && (geocodeType == 0 && cand.getLocationPrecision() != 2 || cand.getLocationPrecision() == 1 || cand.getLocationPrecision() == 16 || cand.getLocationPrecision() == 17 || cand.getLocationPrecision() == 18)) {
            tempGeoResult.append('H');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesPreDirectionalMatch()) {
            tempGeoResult.append('P');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesStreetNameMatch() && cand.doStreetPrefixAndSuffixMatch()) {
            tempGeoResult.append('N');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesThoroughfareTypeMatch()) {
            tempGeoResult.append('T');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesPostDirectionalMatch()) {
            tempGeoResult.append('S');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesAreaName3Match()) {
            tempGeoResult.append("C");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.doesPostalCode1Match()) {
            tempGeoResult.append("Z");
        } else {
            tempGeoResult.append("-");
        }
        tempGeoResult.append(dictionaryFlag);
        if (poboxGeneral || poboxValidated) {
            cand.getAdditionalFields().put("LEGACY_RESULT_CODE", tempGeoResult.toString());
            if (poboxGeneral) {
                cand.getAdditionalFields().remove("PO_BOX_GENERAL");
                return "B1";
            }
            cand.getAdditionalFields().remove("PO_BOX_VALIDATED");
            return "B2";
        }
        return tempGeoResult.toString();
    }

    public CandidateAddress reinterpolate(Address input, CandidateRange desiredRange, IConstraints constraints) throws MapMarkerInternalException {
        ParsedNumber high;
        ParsedNumber low;
        Range range;
        int i;
        ResourceBundle errorBundle = this.loadResourceBundleForLocale(constraints.getClientLocale());
        CandidateAddress candidate = new CandidateAddress();
        Segment segment = this.getSegment();
        ParsedNumber desiredLow = new ParsedNumber(desiredRange.getLowAddress());
        ParsedNumber desiredHigh = new ParsedNumber(desiredRange.getHighAddress());
        ParsedNumber desiredHouse = input.getParsedAddressNumber();
        if (desiredHouse == null) {
            desiredHouse = desiredLow;
        } else if (desiredHouse.isPureNumeric() && desiredHigh.isPureNumeric() && desiredLow.isPureNumeric()) {
            long low2;
            long num = desiredHouse.getAddressNumber();
            if (num <= (low2 = desiredLow.getAddressNumber())) {
                desiredHouse = desiredLow;
            } else {
                long high2 = desiredHigh.getAddressNumber();
                if (num >= high2) {
                    desiredHouse = desiredHigh;
                }
            }
        }
        int maxRanges = constraints.getMaxRanges();
        if (maxRanges == -1) {
            maxRanges = 0;
            Segment seg = this.getSegment();
            if (seg != null) {
                maxRanges = seg.getRangeCount(0) + seg.getRangeCount(1);
            }
        }
        int targetIndex = -1;
        int targetSide = 0;
        int numLeftRanges = Math.min(maxRanges, segment.getRangeCount(0));
        int numRightRanges = Math.min(maxRanges, segment.getRangeCount(1));
        Range targetRange = null;
        for (i = 0; i < numLeftRanges; ++i) {
            range = segment.getRangeAt(i, 0);
            low = range.getLowNumber();
            if (!low.equals(desiredLow) || !(high = range.getHighNumber()).equals(desiredHigh)) continue;
            targetRange = range;
            targetSide = 0;
            targetIndex = i;
            break;
        }
        if (targetIndex < 0) {
            for (i = 0; i < numRightRanges; ++i) {
                range = segment.getRangeAt(i, 1);
                low = range.getLowNumber();
                if (!low.equals(desiredLow) || !(high = range.getHighNumber()).equals(desiredHigh)) continue;
                targetRange = range;
                targetSide = 1;
                targetIndex = i;
                break;
            }
        }
        if (targetIndex < 0) {
            return null;
        }
        int origSegSide = this.getSegmentSide();
        int origMatchedRangeNum = this.getMatchedRangeNumber();
        ParsedNumber origRangeNum = targetRange.getMatchedRangeNumber();
        this.setSegmentSide(targetSide);
        this.setMatchedRangeNumber(targetIndex);
        ParsedNumber desiredParsedHouse = desiredHouse;
        if (targetRange.isNumberInRange(desiredParsedHouse) == 0) {
            targetRange.isNumberInRange(targetRange.getClosestAddressNumber(desiredParsedHouse));
        }
        this.setGeocodedPoint(candidate, 0, constraints, errorBundle);
        String geores = this.buildPrecisionCode(candidate);
        this.setSegmentSide(origSegSide);
        this.setMatchedRangeNumber(origMatchedRangeNum);
        if (origRangeNum != null) {
            targetRange.isNumberInRange(origRangeNum);
        }
        return candidate;
    }

    public void findBestRange(ScoringAddress parsedAddress) {
        this.checkSegmentSides(parsedAddress, 1);
        this.checkSegmentSides(parsedAddress, 0);
        if (!this.hasMatchingRange()) {
            this.findClosestRange();
        }
    }

    public void setDictionaryBonus() {
        this.m_dictionaryBonus = true;
    }

    public boolean hasDictionaryBonus() {
        return this.m_dictionaryBonus;
    }

    public boolean isHouseNumberFromPlaceMatch() {
        return this.m_houseNumberFromPlace;
    }

    protected void setPointHouseCondition(boolean bIsPointHouse) {
        this.m_bPointHouseSet = true;
        this.m_bIsPointHouse = bIsPointHouse;
    }

    protected boolean isPointHouseSet() {
        return this.m_bPointHouseSet;
    }

    protected boolean isPointHouse() {
        return this.m_bIsPointHouse;
    }

    protected ParsedNumber getPointHouseParsedNumber() {
        return this.m_pointHouseParsedNumber;
    }

    public boolean isPointHouseCandidate(IConstraints constraints) {
        if (this.m_bPointHouseSet) {
            return this.m_bIsPointHouse;
        }
        this.m_bPointHouseSet = true;
        this.m_bIsPointHouse = false;
        if (this.getParsedAddressNumber() == null) {
            return false;
        }
        Segment seg = this.getSegment();
        if (seg.isHouseSegment()) {
            this.m_pointHouseParsedNumber = this.getParsedAddressNumber();
            this.m_bIsPointHouse = true;
            return true;
        }
        int leftRangeCount = seg.getRangeCount(0);
        int rightRangeCount = seg.getRangeCount(1);
        if (leftRangeCount > 0 && rightRangeCount > 0) {
            return false;
        }
        if (leftRangeCount == 1 && rightRangeCount == 0) {
            if (seg.getRangeAt(0, 0).computeAddressesInRange() == 1L && this.checkForSingleSegmentPoint()) {
                this.m_pointHouseParsedNumber = this.getParsedAddressNumber();
                this.m_bIsPointHouse = true;
                return true;
            }
        } else if (leftRangeCount == 0 && rightRangeCount == 1 && seg.getRangeAt(0, 1).computeAddressesInRange() == 1L && this.checkForSingleSegmentPoint()) {
            this.m_pointHouseParsedNumber = seg.getRangeAt(0, 1).getLowNumber();
            this.m_bIsPointHouse = true;
            return true;
        }
        return false;
    }

    public void setSecondHNRangedAddress(ParsedNumber houseNumber) {
        this.m_secondHNRangedInput = houseNumber;
    }

    public ParsedNumber getSecondHNRangedAddress() {
        return this.m_secondHNRangedInput;
    }

    protected boolean checkForSingleSegmentPoint() {
        if (this.getSegment().getSegmentPointCount() == 0) {
            return false;
        }
        List points = this.getSegment().getSegmentPoints();
        if (points == null || points.isEmpty()) {
            return false;
        }
        Iterator pointsIterator = points.iterator();
        if (pointsIterator.hasNext()) {
            int pointCount = 1;
            DirectPosition lastPoint = (DirectPosition)pointsIterator.next();
            while (pointsIterator.hasNext() && pointCount <= 1) {
                DirectPosition point = (DirectPosition)pointsIterator.next();
                if (!point.equals((Object)lastPoint)) {
                    ++pointCount;
                }
                lastPoint = point;
            }
            return pointCount == 1;
        }
        return false;
    }

    protected DirectPosition findExactPointHouse(List pointHouseRecords) {
        ParsedNumber addressNumber = this.getParsedAddressNumber();
        if (addressNumber != null) {
            for (PointHouseRecord record : pointHouseRecords) {
                ParsedNumber candidateNumber = record.getAddressNumber();
                if (candidateNumber == null || !addressNumber.equals(candidateNumber)) continue;
                return record.getPoint();
            }
        }
        return null;
    }

    protected List findAllPointHouseCandidates(IConstraints constraints) {
        if (!constraints.getUseAddressPointInterpolation() || this.getParsedAddressNumber() == null) {
            return null;
        }
        ArrayList pointHouses = null;
        if (constraints.getHandler() == null || constraints.getHandler().getMatchResults() == null) {
            return pointHouses;
        }
        List currentMatches = constraints.getHandler().getMatchResults();
        if (currentMatches.size() > 1) {
            for (InternalCandidateAddress candidate : currentMatches) {
                if (!candidate.isPointHouseCandidate(constraints) || !this.sameStreet(candidate) || !this.sameTown(candidate)) continue;
                if (pointHouses == null) {
                    pointHouses = new ArrayList();
                }
                pointHouses.addAll(this.buildPointHouseRecords(candidate));
            }
        }
        return pointHouses;
    }

    private List buildPointHouseRecords(InternalCandidateAddress candidate) {
        LinkedList<PointHouseRecord> records = new LinkedList<PointHouseRecord>();
        Segment segment = candidate.getSegment();
        if (segment.isHouseSegment()) {
            int oddEven = this.getParsedAddressNumber().isRangeOddEvenBoth();
            int leftRanges = segment.getRangeCount(0);
            for (int i = 0; i < leftRanges; ++i) {
                Range range = segment.getRangeAt(i, 0);
                if (range.getOddEven() != 0 && range.getOddEven() != oddEven) continue;
                records.add(new PointHouseRecord(range.getParsedFrom(), segment.getHousePoint(range.getRangeNumber())));
            }
            int rightRanges = segment.getRangeCount(1);
            for (int i = 0; i < rightRanges; ++i) {
                Range range = segment.getRangeAt(i, 1);
                if (range.getOddEven() != 0 && range.getOddEven() != oddEven) continue;
                records.add(new PointHouseRecord(range.getParsedFrom(), segment.getHousePoint(range.getRangeNumber())));
            }
        } else {
            records.add(new PointHouseRecord(candidate.getParsedAddressNumber(), segment.getSegmentPointAt(0)));
        }
        return records;
    }

    protected void filterPointCandidates(List pointCandidates, int segmentSide) {
        ParsedNumber addressNumber = this.getParsedAddressNumber();
        if (addressNumber == null) {
            pointCandidates.clear();
            return;
        }
        List segment = this.getSegment().getSegmentPoints();
        Iterator pointHouseIterator = pointCandidates.iterator();
        while (pointHouseIterator.hasNext()) {
            PointHouseRecord record = (PointHouseRecord)pointHouseIterator.next();
            ParsedNumber candidateNumber = record.getAddressNumber();
            if (candidateNumber == null) {
                pointHouseIterator.remove();
                continue;
            }
            if (addressNumber.isRangeOddEvenBoth() != candidateNumber.isRangeOddEvenBoth()) {
                pointHouseIterator.remove();
                continue;
            }
            List ranges = this.getSegment().getRanges(segmentSide);
            Iterator rangeIterator = ranges.iterator();
            boolean bKeep = false;
            while (rangeIterator.hasNext()) {
                Range range = (Range)rangeIterator.next();
                ParsedNumber low = range.getLowNumber();
                ParsedNumber high = range.getHighNumber();
                if (low.compareTo(candidateNumber) > 0 || high.compareTo(candidateNumber) < 0) continue;
                bKeep = true;
                break;
            }
            if (!bKeep) {
                pointHouseIterator.remove();
                continue;
            }
            if (SegmentGeometryUtils.intersects(segment, record.getPoint())) continue;
            pointHouseIterator.remove();
        }
    }

    protected boolean sameStreet(InternalCandidateAddress that) {
        return this.getStreetCandidateAddress().sameStreet(that.getStreetCandidateAddress());
    }

    protected boolean sameTown(InternalCandidateAddress that) {
        double diff = this.m_areaName3Score - that.m_areaName3Score;
        return Math.abs(diff) < 0.01;
    }

    protected void interpolateUsingPointHouses(CandidateAddress candidate, List pointHouses, IConstraints constraints, int segmentSide, int rangeNumber) {
        long currentHighDiff = Long.MAX_VALUE;
        long currentLowDiff = Long.MAX_VALUE;
        ParsedNumber addressNumber = this.getParsedAddressNumber();
        ParsedNumber lowestHigh = null;
        ParsedNumber highestLow = null;
        DirectPosition newLow = null;
        DirectPosition newHigh = null;
        for (PointHouseRecord record : pointHouses) {
            long currentDiff;
            ParsedNumber recordNumber = record.getAddressNumber();
            if (recordNumber.compareTo(addressNumber) > 0) {
                currentDiff = recordNumber.computeDifference(addressNumber, 1);
                if (currentDiff >= currentHighDiff) continue;
                currentHighDiff = currentDiff;
                lowestHigh = recordNumber;
                newHigh = record.getPoint();
                continue;
            }
            currentDiff = recordNumber.computeDifference(addressNumber, 1);
            if (currentDiff >= currentLowDiff) continue;
            currentLowDiff = currentDiff;
            highestLow = recordNumber;
            newLow = record.getPoint();
        }
        if (highestLow == null && lowestHigh == null) {
            candidate.setLocation(Interpolator.interpolate(this.getSegment().getSegmentPoints(), segmentSide == 0, this.getHouseNumberPercentage(segmentSide, rangeNumber, this.getParsedAddressNumber()), constraints.getCornerOffsetAsLength(), constraints.getStreetOffsetAsLength()));
            if (candidate.getLocationPoint() != null) {
                candidate.setLocationPrecision(1);
            }
        } else {
            List finalSegmentPoints;
            ParsedNumber to;
            ParsedNumber from;
            boolean ascendingRanges = this.checkAscending(this.getSegment().getRanges(segmentSide));
            List segmentPoints = this.getSegment().getSegmentPoints();
            Length cornerOffset = constraints.getCornerOffsetAsLength();
            if (highestLow == null) {
                SplitSegment split = SegmentGeometryUtils.split(segmentPoints, newHigh);
                if (ascendingRanges) {
                    from = this.findLowestHouseOnSide(segmentSide);
                    to = lowestHigh;
                    finalSegmentPoints = split.getSegment1();
                    SegmentGeometryUtils.applyCornerOffset(finalSegmentPoints, cornerOffset, true, false);
                    cornerOffset = null;
                } else {
                    to = this.findLowestHouseOnSide(segmentSide);
                    from = lowestHigh;
                    finalSegmentPoints = split.getSegment2();
                    SegmentGeometryUtils.applyCornerOffset(finalSegmentPoints, cornerOffset, false, true);
                    cornerOffset = null;
                }
            } else if (lowestHigh == null) {
                SplitSegment split = SegmentGeometryUtils.split(segmentPoints, newLow);
                if (ascendingRanges) {
                    from = highestLow;
                    to = this.findHighestHouseOnSide(segmentSide);
                    finalSegmentPoints = split.getSegment2();
                    SegmentGeometryUtils.applyCornerOffset(finalSegmentPoints, cornerOffset, false, true);
                    cornerOffset = null;
                } else {
                    to = highestLow;
                    from = this.findHighestHouseOnSide(segmentSide);
                    finalSegmentPoints = split.getSegment1();
                    SegmentGeometryUtils.applyCornerOffset(finalSegmentPoints, cornerOffset, true, false);
                    cornerOffset = null;
                }
            } else {
                SplitSegment split1 = SegmentGeometryUtils.split(segmentPoints, newLow);
                if (ascendingRanges) {
                    from = highestLow;
                    SplitSegment split2 = SegmentGeometryUtils.split(split1.getSegment2(), newHigh);
                    finalSegmentPoints = split2.getSegment1();
                    if (finalSegmentPoints == null) {
                        finalSegmentPoints = split1.getSegment2();
                        to = this.findHighestHouseOnSide(segmentSide);
                        SegmentGeometryUtils.applyCornerOffset(finalSegmentPoints, cornerOffset, false, true);
                    } else {
                        to = lowestHigh;
                    }
                    cornerOffset = null;
                } else {
                    to = highestLow;
                    SplitSegment split2 = SegmentGeometryUtils.split(split1.getSegment1(), newHigh);
                    finalSegmentPoints = split2.getSegment2();
                    if (finalSegmentPoints == null) {
                        finalSegmentPoints = split1.getSegment1();
                        from = this.findHighestHouseOnSide(segmentSide);
                        SegmentGeometryUtils.applyCornerOffset(finalSegmentPoints, cornerOffset, true, false);
                    } else {
                        from = lowestHigh;
                    }
                    cornerOffset = null;
                }
            }
            candidate.setLocation(Interpolator.interpolate(finalSegmentPoints, segmentSide == 0, this.computeHousePercentage(from, to, addressNumber), cornerOffset, constraints.getStreetOffsetAsLength()));
            if (candidate.getLocationPoint() != null) {
                candidate.setLocationPrecision(17);
            }
        }
    }

    protected boolean checkAscending(List ranges) {
        for (Range rng : ranges) {
            if (rng.getRangeDirection() == 0) continue;
            return false;
        }
        return true;
    }

    protected ParsedNumber findLowestHouseOnSide(int segmentSide) {
        List ranges = this.getSegment().getRanges(segmentSide);
        Iterator rangeIterator = ranges.iterator();
        ParsedNumber low = null;
        while (rangeIterator.hasNext()) {
            Range rng = (Range)rangeIterator.next();
            if (low == null) {
                low = rng.getLowNumber();
                continue;
            }
            if (low.compareTo(rng.getLowNumber()) <= 0) continue;
            low = rng.getLowNumber();
        }
        return low;
    }

    protected ParsedNumber findHighestHouseOnSide(int segmentSide) {
        List ranges = this.getSegment().getRanges(segmentSide);
        Iterator rangeIterator = ranges.iterator();
        ParsedNumber high = null;
        while (rangeIterator.hasNext()) {
            Range rng = (Range)rangeIterator.next();
            if (high == null) {
                high = rng.getHighNumber();
                continue;
            }
            if (high.compareTo(rng.getHighNumber()) >= 0) continue;
            high = rng.getHighNumber();
        }
        return high;
    }

    protected double computeHousePercentage(ParsedNumber from, ParsedNumber to, ParsedNumber number) {
        double houseDiff = number.computeDifference(from, 1);
        double fromToDiff = from.computeDifference(to, 1);
        return houseDiff / fromToDiff;
    }

    protected DirectPosition getAddressNumberHousePoint() {
        Segment segment = this.getSegment();
        if (!segment.isHouseSegment()) {
            return null;
        }
        int rangeNumber = this.hasMatchingRange() ? segment.getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide()).getRangeNumber() : (this.hasClosestRange() ? segment.getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide()).getRangeNumber() : -1);
        if (rangeNumber >= 0) {
            return segment.getHousePoint(rangeNumber);
        }
        return null;
    }

    public void setDistance(double distance) {
        this.m_distance = distance;
    }

    @Override
    public double getDistance() {
        return this.m_distance;
    }

    public void computeDistance(DirectPosition position) {
        this.setDistance(Double.MAX_VALUE);
        Segment segment = this.getSegment();
        if (segment != null) {
            if (!segment.isHouseSegment()) {
                List points = segment.getSegmentPoints();
                if (points != null) {
                    this.setDistance(ReverseGeocodeUtils.getDistance(position, points));
                }
            } else {
                int rangeNumber;
                DirectPosition point;
                boolean bLeft;
                Range range;
                int rangeCount = segment.getRangeCount(0) + segment.getRangeCount(1);
                if (rangeCount == 1 && (range = segment.getRangeAt(0, (bLeft = segment.getRangeCount(0) == 1) ? 0 : 1)) != null && (point = segment.getHousePoint(rangeNumber = range.getRangeNumber())) != null) {
                    this.setDistance(ReverseGeocodeUtils.getDistance(position, point));
                }
            }
        }
    }

    @Override
    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        ReverseGeocodeCandidateAddress candidate = new ReverseGeocodeCandidateAddress((Address)this, this.getDictionaryPriority() + 1, new Length(this.getDistance(), LinearUnit.METER));
        candidate.setPrecisionCode(this.buildRGResultCode(location, constraints));
        this.setReverseGeocodedPoint(candidate, location.getCoordSysObject(), (ReverseGeocodeInternalConstraints)constraints);
        candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        HashMap vendor_code = candidate.getAdditionalFields();
        vendor_code.put(KEY_VENDOR_CODE, this.getVendorCode());
        candidate.setAdditionalFields(vendor_code);
        if (this.fromUserDictionary()) {
            candidate.setFromUserDictionary();
        }
        this.populateRGRanges(candidate, location, constraints);
        this.populateSegmentId(candidate);
        this.populateWithRangeOrRangeUnitAdditionalFields(candidate);
        return candidate;
    }

    protected void setReverseGeocodedPoint(ReverseGeocodeCandidateAddress candidate, CoordSys requestCoordSys, ReverseGeocodeInternalConstraints constraints) {
        IConstraints geocodeConstraints = constraints.getHandler().getConstraints();
        geocodeConstraints.setClientCoordinateSystem(requestCoordSys);
        geocodeConstraints.setCornerOffset(constraints.getCornerOffset().getScalarValue());
        geocodeConstraints.setCornerOffsetUnits(constraints.getCornerOffset().getUnit().getAbbreviation());
        geocodeConstraints.setStreetOffset(constraints.getStreetOffset().getScalarValue());
        geocodeConstraints.setStreetOffsetUnits(constraints.getStreetOffset().getUnit().getAbbreviation());
        this.adjustReverseGeocodePointConstraints(geocodeConstraints);
        CandidateAddress candidateForLocation = new CandidateAddress();
        this.setGeocodedPoint(candidateForLocation, DebugLevel.getDebugLevel(1), geocodeConstraints, this.loadResourceBundleForLocale(constraints.getClientLocale()));
        candidate.setLocation(candidateForLocation.getLocationPoint());
        candidate.setLocationPrecision(candidateForLocation.getLocationPrecision());
        candidate.setCoordSysString(candidateForLocation.getCoordSysString());
    }

    protected void adjustReverseGeocodePointConstraints(IConstraints constraints) {
    }

    protected void populateRGRanges(ReverseGeocodeCandidateAddress candidate, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        if (this.getMatchedRangeNumber() >= 0) {
            candidate.setNumberOfReturnableRanges(1);
            Range range = this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
            CandidateRange candRange = range.toCandidateRange(this.getParsedAddressNumber(), this.getSegmentSide());
            candRange.setNumberOfReturnableRangeUnits(constraints.getMaxRangeUnits());
            candidate.addCandidateRange(candRange);
        }
    }

    protected String buildRGResultCode(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        String dictionaryFlag = this.fromUserDictionary() ? "U" : "A";
        StringBuilder builder = new StringBuilder();
        if (this.getSegment().isHouseSegment()) {
            builder.append("RS8").append(dictionaryFlag);
        } else if (this.getMatchedRangeNumber() >= 0) {
            builder.append("RS5").append(dictionaryFlag);
        } else {
            builder.append("RS4").append(dictionaryFlag);
        }
        return builder.toString();
    }

    @Override
    public void matchAddressNumber(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        Segment segment = this.getSegment();
        if (segment.isHouseSegment()) {
            int side = segment.getRangeCount(0) == 1 ? 0 : 1;
            this.setSegmentSide(side);
            this.setMatchedRangeNumber(0);
            Range range = segment.getRangeAt(0, side);
            range.setMatchedRangeNumber(range.getParsedFrom());
            this.setAddressNumber(range.getParsedFrom());
        } else {
            ReverseGeocodeLocation localLocation = new ReverseGeocodeLocation(CoordConvertor.transformPointToWGS84(location.getCoordSysObject(), location.getPositionPoint()), CoordSysConstants.longLatWGS84, location.getDistanceAsLength());
            if (segment.getRangeCount(0) > 0 || segment.getRangeCount(1) > 0) {
                this.m_reverseGeocodeResultDistance = this.calcClosestHN(localLocation, constraints);
                this.setSegmentSide(this.m_reverseGeocodeResultDistance.getSegmentSide());
                this.setMatchedRangeNumber(this.m_reverseGeocodeResultDistance.getRangeNumber());
                Range range = segment.getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
                range.setMatchedRangeNumber(this.m_reverseGeocodeResultDistance.getAddressNumber());
                this.setAddressNumber(this.m_reverseGeocodeResultDistance.getAddressNumber());
            } else {
                DirectPosition leftPoint = Interpolator.interpolate(this.getSegment().getSegmentPoints(), true, 0.5, constraints.getStreetOffsetAsLength(), constraints.getStreetOffsetAsLength());
                if (ReverseGeocodeUtils.pointsOnSameSideOfSegment(localLocation.getPositionPoint(), leftPoint, this.getSegment().getSegmentPoints())) {
                    this.m_reverseGeocodeResultDistance = new AddressNumberDistance(0, -1, null, 0.0, 0.5, leftPoint);
                    this.setSegmentSide(0);
                } else {
                    DirectPosition rightPoint = Interpolator.interpolate(this.getSegment().getSegmentPoints(), false, 0.5, constraints.getStreetOffsetAsLength(), constraints.getStreetOffsetAsLength());
                    this.m_reverseGeocodeResultDistance = new AddressNumberDistance(1, -1, null, 0.0, 0.5, rightPoint);
                    this.setSegmentSide(1);
                }
            }
        }
    }

    private AddressNumberDistance calcClosestHN(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        AddressNumberDistance closestL = this.calcClosestHN(0, location, constraints);
        AddressNumberDistance closestR = this.calcClosestHN(1, location, constraints);
        if (closestL != null && closestR != null) {
            if (closestL.getDistance() == closestR.getDistance()) {
                return closestL;
            }
            if (closestL.getDistance() < closestR.getDistance()) {
                return ReverseGeocodeUtils.pointsOnSameSideOfSegment(location.getPositionPoint(), closestL.getInterpolatedPoint(), this.getSegment().getSegmentPoints()) ? closestL : closestR;
            }
            return ReverseGeocodeUtils.pointsOnSameSideOfSegment(location.getPositionPoint(), closestR.getInterpolatedPoint(), this.getSegment().getSegmentPoints()) ? closestR : closestL;
        }
        return closestL == null ? closestR : closestL;
    }

    private AddressNumberDistance calcClosestHN(int side, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        AddressNumberDistance result = null;
        List ranges = this.getSegment().getRanges(side);
        for (int rngNum = 0; rngNum < ranges.size(); ++rngNum) {
            Range range = (Range)ranges.get(rngNum);
            List<ParsedNumber> addresses = range.computeAddressNumbers();
            for (ParsedNumber addrNum : addresses) {
                double housePercentage = this.getHouseNumberPercentage(side, rngNum, addrNum);
                DirectPosition addrPnt = Interpolator.interpolate(this.getSegment().getSegmentPoints(), side == 0, housePercentage, constraints.getCornerOffsetAsLength(), constraints.getStreetOffsetAsLength());
                double dist = ReverseGeocodeUtils.getDistance(location.getPositionPoint(), addrPnt);
                if (result != null && !(dist < result.getDistance())) continue;
                result = new AddressNumberDistance(side, rngNum, addrNum, dist, housePercentage, addrPnt);
            }
        }
        return result;
    }

    protected DirectPosition getCenterlineOffsetLocation(DirectPosition point, List<InternalCandidateAddress> candidates, IConstraints constraints) {
        if (!constraints.getUseCenterlineOffset()) {
            return null;
        }
        Length centerlineOffset = constraints.getCenterlineOffsetAsLength();
        if (centerlineOffset == null) {
            return null;
        }
        InternalCandidateAddress closestCandidate = this.findClosestSegmentGeometryCandidate(point, candidates);
        if (closestCandidate == null) {
            return null;
        }
        return Interpolator.projectFromSegment(closestCandidate.getSegment().getSegmentPoints(), point, centerlineOffset);
    }

    protected InternalCandidateAddress findClosestSegmentGeometryCandidate(DirectPosition point, List<InternalCandidateAddress> candidates) {
        double closestDistance = Double.MAX_VALUE;
        InternalCandidateAddress closestCandidate = null;
        for (InternalCandidateAddress candidate : candidates) {
            double distance;
            if (candidate == this || !this.isSegmentGeometryCandidate(candidate) || !this.sameStreet(candidate) || !((distance = ReverseGeocodeUtils.getDistance(point, candidate.getSegment().getSegmentPoints())) < closestDistance)) continue;
            closestDistance = distance;
            closestCandidate = candidate;
        }
        return closestCandidate;
    }

    private boolean isSegmentGeometryCandidate(InternalCandidateAddress candidate) {
        int rightRanges;
        int leftRanges;
        int totalRanges;
        Segment segment = candidate.getSegment();
        if (segment.getSegmentPointCount() == 0) {
            return false;
        }
        return !candidate.checkForSingleSegmentPoint() || (totalRanges = (leftRanges = segment.getRangeCount(0)) + (rightRanges = segment.getRangeCount(1))) != 1 || !(leftRanges == 1 ? segment.getRangeAt(0, 0).computeAddressesInRange() == 1L : rightRanges == 1 && segment.getRangeAt(0, 1).computeAddressesInRange() == 1L);
    }

    @Override
    public boolean isFromCorrectStreetSide(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        if (this.m_reverseGeocodeResultDistance == null || this.m_distance == 0.0) {
            return true;
        }
        return ReverseGeocodeUtils.pointsOnSameSideOfSegment(CoordConvertor.transformPointToWGS84(location.getCoordSysObject(), location.getPositionPoint()), this.m_reverseGeocodeResultDistance.getInterpolatedPoint(), this.getSegment().getSegmentPoints());
    }

    @Override
    public boolean matchesLocale(Locale loc) {
        return false;
    }

    @Override
    public boolean isDefaultLocale() {
        return false;
    }

    public void setVendorCode(String vendor_code) {
        this.m_vendorCode = vendor_code;
    }

    public String getVendorCode() {
        return this.m_vendorCode;
    }

    public void buildInputMatchScore(Address input, FieldScores matchedConstants) {
        double weight;
        double baseConfidence = 0.0;
        double calculatedConfidence = 0.0;
        if (!StringUtilities.isEmpty(input.getPostCode1())) {
            weight = matchedConstants.getPostalCode1();
            baseConfidence += weight;
            calculatedConfidence += this.getPostCode1Score() * weight;
        }
        if (!StringUtilities.isEmpty(input.getPostCode2())) {
            weight = matchedConstants.getPostalCode2();
            baseConfidence += weight;
            calculatedConfidence += this.getPostCode2Score() * weight;
        }
        if (!StringUtilities.isEmpty(input.getAreaName1())) {
            weight = matchedConstants.getAreaName1();
            baseConfidence += weight;
            calculatedConfidence += this.getAreaName1Score() * weight;
        }
        if (!StringUtilities.isEmpty(input.getAreaName2())) {
            weight = matchedConstants.getAreaName2();
            baseConfidence += weight;
            calculatedConfidence += this.getAreaName2Score() * weight;
        }
        if (!StringUtilities.isEmpty(input.getAreaName3())) {
            weight = matchedConstants.getAreaName3();
            baseConfidence += weight;
            calculatedConfidence += this.getAreaName3Score() * weight;
        }
        if (!StringUtilities.isEmpty(input.getAreaName4())) {
            weight = matchedConstants.getAreaName4();
            baseConfidence += weight;
            calculatedConfidence += this.getAreaName4Score() * weight;
        }
        if (!StringUtilities.isEmpty(input.getMainAddress())) {
            weight = matchedConstants.getMainAddress();
            baseConfidence += weight;
            calculatedConfidence += this.getMainAddressScore() * weight;
        }
        if (!StringUtilities.isEmpty(input.getAddressNumber())) {
            weight = matchedConstants.getAddressNumber();
            baseConfidence += weight;
            calculatedConfidence += this.getAddressNumberScore() * weight;
        }
        this.inputMatchScore = (short)Math.round(calculatedConfidence * 100.0 / baseConfidence);
    }

    private static class AddressNumberDistance {
        private final int m_segmentSide;
        private final int m_rangeNumber;
        private final ParsedNumber m_addressNumber;
        private final double m_distance;
        private final double m_housePercentage;
        private final DirectPosition m_interpolatedPoint;

        private AddressNumberDistance(int segmentSide, int rangeNumber, ParsedNumber addressNumber, double distance, double housePercentage, DirectPosition interpolatedPoint) {
            this.m_segmentSide = segmentSide;
            this.m_rangeNumber = rangeNumber;
            this.m_addressNumber = addressNumber;
            this.m_distance = distance;
            this.m_housePercentage = housePercentage;
            this.m_interpolatedPoint = interpolatedPoint;
        }

        public double getDistance() {
            return this.m_distance;
        }

        public ParsedNumber getAddressNumber() {
            return this.m_addressNumber;
        }

        public int getRangeNumber() {
            return this.m_rangeNumber;
        }

        public int getSegmentSide() {
            return this.m_segmentSide;
        }

        public double getHousePercentage() {
            return this.m_housePercentage;
        }

        public DirectPosition getInterpolatedPoint() {
            return this.m_interpolatedPoint;
        }
    }

    public static class ReverseGeococodeCandidateComparator
    implements Comparator<InternalCandidateAddress> {
        @Override
        public int compare(InternalCandidateAddress candidate1, InternalCandidateAddress candidate2) {
            return Double.compare(candidate1.getDistance(), candidate2.getDistance());
        }
    }
}

