/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.geometry.DirectPosition;

public class InternalGeographicCandidate
implements ICandidate,
Comparable {
    private String m_country = null;
    private String m_vendorCode;
    private double m_areaName1Score = 0.0;
    private double m_areaName2Score = 0.0;
    private double m_areaName3Score = 0.0;
    private double m_areaName4Score = 0.0;
    private double m_countryScore = 0.0;
    private double m_combinedScore = 0.0;
    private boolean m_closeMatch = true;
    private boolean m_fromUserDictionary;
    private GeoInfoRecord m_record = null;
    private StringScorer m_scorer;
    private boolean m_dictionaryBonus;
    private int m_configDictionaryNumber;
    private int m_userDictionaryPriority;

    public String getAreaName1() {
        return this.m_record.getAreaName1();
    }

    public String getAreaName2() {
        return this.m_record.getAreaName2();
    }

    public String getAreaName3() {
        return this.m_record.getAreaName3();
    }

    public String getAreaName4() {
        return this.m_record.getAreaName4();
    }

    public void setCountry(String country) {
        this.m_country = country;
    }

    public String getCountry() {
        return this.m_country;
    }

    public DirectPosition getCentroid() {
        return this.m_record.getPoint();
    }

    public int getPrecision() {
        return this.m_record.getPrecision();
    }

    public void setAreaName1Score(double areaName1Score) {
        this.m_areaName1Score = areaName1Score;
    }

    public double getAreaName1Score() {
        return this.m_areaName1Score;
    }

    public void setAreaName2Score(double areaName2Score) {
        this.m_areaName2Score = areaName2Score;
    }

    public double getAreaName2Score() {
        return this.m_areaName2Score;
    }

    public void setAreaName3Score(double areaName3Score) {
        this.m_areaName3Score = areaName3Score;
    }

    public double getAreaName3Score() {
        return this.m_areaName3Score;
    }

    public void setAreaName4Score(double areaName4Score) {
        this.m_areaName4Score = areaName4Score;
    }

    public double getAreaName4Score() {
        return this.m_areaName4Score;
    }

    public void setCountryScore(double countryScore) {
        this.m_countryScore = countryScore;
    }

    public double getCountryScore() {
        return this.m_countryScore;
    }

    public void setCombinedScore(double score) {
        this.m_combinedScore = score;
    }

    public double getCombinedScore() {
        return this.m_combinedScore;
    }

    public void setCloseMatchStatus(boolean status) {
        this.m_closeMatch = status;
    }

    @Override
    public boolean isCloseMatch() {
        return this.m_closeMatch;
    }

    public boolean fromUserDictionary() {
        return this.m_fromUserDictionary;
    }

    public void setFromUserDictionary() {
        this.m_fromUserDictionary = true;
    }

    public void setGeoInfoRecord(GeoInfoRecord record) {
        this.m_record = record;
    }

    public GeoInfoRecord getGeoInfoRecord() {
        return this.m_record;
    }

    public void scoreCandidate(Address inputAddress, String charsToIgnore) {
        this.scoreAreaName1(inputAddress);
        this.scoreAreaName2(inputAddress);
        this.scoreAreaName3(inputAddress);
        this.scoreAreaName4(inputAddress);
        this.scoreCountry(inputAddress);
    }

    public void scoreAreaName1(Address inputAddress) {
        double tempScore;
        this.setAreaName1Score(this.getStringScorer().scoreString(this.getAreaName1(), inputAddress.getAreaName1()));
        if (this.getAreaName1Score() != 1.0 && this.m_record != null && this.m_record.getAltAreaName1() != null && (tempScore = this.getStringScorer().scoreString(this.m_record.getAltAreaName1(), inputAddress.getAreaName1())) > this.getAreaName1Score()) {
            this.setAreaName1Score(tempScore);
        }
    }

    public void scoreAreaName2(Address inputAddress) {
        double tempScore;
        this.setAreaName2Score(this.getStringScorer().scoreString(this.getAreaName2(), inputAddress.getAreaName2()));
        if (this.getAreaName2Score() != 1.0 && this.m_record != null && this.m_record.getAltAreaName2() != null && (tempScore = this.getStringScorer().scoreString(this.m_record.getAltAreaName2(), inputAddress.getAreaName2())) > this.getAreaName2Score()) {
            this.setAreaName2Score(tempScore);
        }
    }

    public void scoreAreaName3(Address inputAddress) {
        double tempScore;
        this.setAreaName3Score(this.getStringScorer().scoreString(this.getAreaName3(), inputAddress.getAreaName3()));
        if (this.getAreaName3Score() != 1.0 && this.m_record != null && this.m_record.getAltAreaName3() != null && (tempScore = this.getStringScorer().scoreString(this.m_record.getAltAreaName3(), inputAddress.getAreaName3())) > this.getAreaName3Score()) {
            this.setAreaName3Score(tempScore);
        }
    }

    public void scoreAreaName4(Address inputAddress) {
        double tempScore;
        this.setAreaName4Score(this.getStringScorer().scoreString(this.getAreaName4(), inputAddress.getAreaName4()));
        if (this.getAreaName4Score() != 1.0 && this.m_record != null && this.m_record.getAltAreaName4() != null && (tempScore = this.getStringScorer().scoreString(this.m_record.getAltAreaName4(), inputAddress.getAreaName4())) > this.getAreaName4Score()) {
            this.setAreaName4Score(tempScore);
        }
    }

    public void scoreCountry(Address inputAddress) {
        this.setCountryScore(this.getStringScorer().scoreString(this.getCountry(), inputAddress.getCountry()));
    }

    public int compareTo(Object o2) {
        InternalGeographicCandidate candidate2 = (InternalGeographicCandidate)o2;
        if (this.isCloseMatch() != candidate2.isCloseMatch()) {
            if (this.isCloseMatch()) {
                return 1;
            }
            return -1;
        }
        if (this.isCloseMatch() && candidate2.isCloseMatch() && this.hasDictionaryBonus() != candidate2.hasDictionaryBonus()) {
            if (this.hasDictionaryBonus()) {
                return 1;
            }
            return -1;
        }
        if (this.getCombinedScore() > candidate2.getCombinedScore()) {
            return 1;
        }
        if (this.getCombinedScore() < candidate2.getCombinedScore()) {
            return -1;
        }
        if (this.getAreaName1Score() > candidate2.getAreaName1Score()) {
            return 1;
        }
        if (this.getAreaName1Score() < candidate2.getAreaName1Score()) {
            return -1;
        }
        if (this.getAreaName2Score() > candidate2.getAreaName2Score()) {
            return 1;
        }
        if (this.getAreaName2Score() < candidate2.getAreaName2Score()) {
            return -1;
        }
        if (this.getAreaName3Score() > candidate2.getAreaName3Score()) {
            return 1;
        }
        if (this.getAreaName3Score() < candidate2.getAreaName3Score()) {
            return -1;
        }
        if (this.getAreaName4Score() > candidate2.getAreaName4Score()) {
            return 1;
        }
        if (this.getAreaName4Score() < candidate2.getAreaName4Score()) {
            return -1;
        }
        if (this.getCountryScore() > candidate2.getCountryScore()) {
            return 1;
        }
        if (this.getCountryScore() > candidate2.getCountryScore()) {
            return -1;
        }
        if (this.getPrecision() > candidate2.getPrecision()) {
            return 1;
        }
        if (this.getPrecision() < candidate2.getPrecision()) {
            return -1;
        }
        if (this.hasDictionaryBonus() != candidate2.hasDictionaryBonus()) {
            if (this.hasDictionaryBonus()) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) {
        CandidateAddress candidate = new CandidateAddress();
        candidate.setAreaName1(this.getAreaName1());
        candidate.setAreaName2(this.getAreaName2());
        candidate.setAreaName3(this.getAreaName3());
        candidate.setAreaName4(this.getAreaName4());
        candidate.setCountry(this.getCountry());
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (this.getAreaName1Score() == 1.0) {
            candidate.setAreaName1Matched();
        }
        if (this.getAreaName2Score() == 1.0) {
            candidate.setAreaName2Matched();
        }
        if (this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (this.getAreaName4Score() == 1.0) {
            candidate.setAreaName4Matched();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (this.getCentroid() != null) {
            candidate.setLocation(CoordConvertor.transformPointFromWGS84(constraints.getClientCoordinateSystemObject(), this.getCentroid()));
        } else {
            candidate.setLocation(new DirectPosition());
        }
        candidate.setLocationPrecision(this.getPrecision());
        if (constraints.getClientCoordinateSystemObject() != null) {
            candidate.setCoordSysString(MidevConversionUtils.getSRSname(constraints.getClientCoordinateSystemObject()));
        }
        if (this.fromUserDictionary()) {
            candidate.setFromUserDictionary();
        }
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        return candidate;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nInternalGeographicCandidate:");
        buffer.append("\n\tCountry: ");
        buffer.append(this.getCountry());
        buffer.append("\n\tAreaName1: ");
        buffer.append(this.getAreaName1());
        buffer.append("\n\tAreaName2: ");
        buffer.append(this.getAreaName2());
        buffer.append("\n\tAreaName3: ");
        buffer.append(this.getAreaName3());
        buffer.append("\n\tAreaName4: ");
        buffer.append(this.getAreaName4());
        buffer.append("\n\tScores: ");
        buffer.append("\n\t\tCombinedScore: ");
        buffer.append(this.getCombinedScore());
        buffer.append("\n\t\t\tAreaName1Score: ");
        buffer.append(this.getAreaName1Score());
        buffer.append("\n\t\t\tAreaName2Score: ");
        buffer.append(this.getAreaName2Score());
        buffer.append("\n\t\t\tAreaName3Score: ");
        buffer.append(this.getAreaName3Score());
        buffer.append("\n\t\t\tAreaName4Score: ");
        buffer.append(this.getAreaName4Score());
        buffer.append("\n\t\t\tCountryScore: ");
        buffer.append(this.getCountryScore());
        buffer.append("\n\tCloseMatch? ");
        buffer.append(this.isCloseMatch());
        buffer.append("\n\tCentroid: ");
        buffer.append(this.getCentroid() == null ? "No centroid" : this.getCentroid().toString());
        buffer.append("\n\tPrecision: ");
        buffer.append(this.getPrecision());
        buffer.append("\n\tFromUserDictionary? ");
        buffer.append(this.fromUserDictionary());
        buffer.append("\n\tHasDictionaryBonus? ");
        buffer.append(this.hasDictionaryBonus());
        buffer.append("\n\tdictionary priority ");
        buffer.append(this.getDictionaryPriority());
        return buffer.toString();
    }

    public void setStringScorer(StringScorer scorer) {
        this.m_scorer = scorer;
    }

    public StringScorer getStringScorer() {
        if (this.m_scorer == null) {
            this.m_scorer = new StringScorer();
        }
        return this.m_scorer;
    }

    public String buildPrecisionCode(CandidateAddress cand) {
        int precision = cand.getLocationPrecision();
        if (precision == 8) {
            return "G1";
        }
        if (precision == 9) {
            return "G2";
        }
        if (precision == 10) {
            return "G3";
        }
        if (precision == 11) {
            return "G4";
        }
        return "";
    }

    public void setDictionaryBonus() {
        this.m_dictionaryBonus = true;
    }

    public boolean hasDictionaryBonus() {
        return this.m_dictionaryBonus;
    }

    public void setDictionaryPriority(int dictNumber) {
        this.m_configDictionaryNumber = dictNumber;
    }

    public int getDictionaryPriority() {
        return this.m_configDictionaryNumber;
    }

    public void setUserDictionaryPriority(int priority) {
        this.m_userDictionaryPriority = priority;
    }

    public int getUserDictionaryPriority() {
        return this.m_userDictionaryPriority;
    }

    public void setVendorCode(String vendor_Code) {
        this.m_vendorCode = vendor_Code;
    }

    public String getVendorCode() {
        return this.m_vendorCode;
    }
}

